/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesCapacitySched
extends JerseyTest {
    private static MockRM rm;
    private CapacitySchedulerConfiguration csConf;
    private YarnConfiguration conf;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            TestRMWebServicesCapacitySched.this.csConf = new CapacitySchedulerConfiguration();
            TestRMWebServicesCapacitySched.setupQueueConfiguration(TestRMWebServicesCapacitySched.this.csConf);
            TestRMWebServicesCapacitySched.this.conf = new YarnConfiguration((Configuration)TestRMWebServicesCapacitySched.this.csConf);
            TestRMWebServicesCapacitySched.this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            rm = new MockRM((Configuration)TestRMWebServicesCapacitySched.this.conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }});

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.5f);
        conf.setMaximumCapacity("root.a", 50.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 89.5f);
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 50.0f);
        conf.setUserLimitFactor("root.a.a1", 100.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setUserLimitFactor("root.a.a2", 100.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 60.0f);
        conf.setUserLimitFactor("root.b.b1", 100.0f);
        conf.setCapacity("root.b.b2", 39.5f);
        conf.setUserLimitFactor("root.b.b2", 100.0f);
        conf.setCapacity("root.b.b3", 0.5f);
        conf.setUserLimitFactor("root.b.b3", 100.0f);
        conf.setQueues("root.a.a1", new String[]{"a1a", "a1b"});
        String A1A = "root.a.a1.a1a";
        conf.setCapacity("root.a.a1.a1a", 85.0f);
        String A1B = "root.a.a1.a1b";
        conf.setCapacity("root.a.a1.a1b", 15.0f);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesCapacitySched() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testClusterScheduler() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifyClusterScheduler(json);
    }

    @Test
    public void testClusterSchedulerXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList scheduler = dom.getElementsByTagName("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)scheduler.getLength());
        NodeList schedulerInfo = dom.getElementsByTagName("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)schedulerInfo.getLength());
        this.verifyClusterSchedulerXML(schedulerInfo);
    }

    public void verifyClusterSchedulerXML(NodeList nodes) throws Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyClusterSchedulerGeneric(WebServicesTestUtils.getXmlAttrString((Element)element, (String)"xsi:type"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"usedCapacity"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"capacity"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"maxCapacity"), WebServicesTestUtils.getXmlString((Element)element, (String)"queueName"));
            NodeList children = element.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Element qElem = (Element)children.item(j);
                if (!qElem.getTagName().equals("queues")) continue;
                NodeList qListInfos = qElem.getChildNodes();
                for (int k = 0; k < qListInfos.getLength(); ++k) {
                    Element qElem2 = (Element)qListInfos.item(k);
                    String qName2 = WebServicesTestUtils.getXmlString((Element)qElem2, (String)"queueName");
                    String q2 = "root." + qName2;
                    this.verifySubQueueXML(qElem2, q2, 100.0f, 100.0f);
                }
            }
        }
    }

    public void verifySubQueueXML(Element qElem, String q, float parentAbsCapacity, float parentAbsMaxCapacity) throws Exception {
        NodeList children = qElem.getChildNodes();
        boolean hasSubQueues = false;
        for (int j = 0; j < children.getLength(); ++j) {
            NodeList qListInfos;
            Element qElem2 = (Element)children.item(j);
            if (!qElem2.getTagName().equals("queues") || (qListInfos = qElem2.getChildNodes()).getLength() <= 0) continue;
            hasSubQueues = true;
        }
        QueueInfo qi = hasSubQueues ? new QueueInfo() : new LeafQueueInfo();
        qi.capacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"capacity");
        qi.usedCapacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"usedCapacity");
        qi.maxCapacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"maxCapacity");
        qi.absoluteCapacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"absoluteCapacity");
        qi.absoluteMaxCapacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"absoluteMaxCapacity");
        qi.absoluteUsedCapacity = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"absoluteUsedCapacity");
        qi.numApplications = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"numApplications");
        qi.queueName = WebServicesTestUtils.getXmlString((Element)qElem, (String)"queueName");
        qi.state = WebServicesTestUtils.getXmlString((Element)qElem, (String)"state");
        this.verifySubQueueGeneric(q, qi, parentAbsCapacity, parentAbsMaxCapacity);
        if (hasSubQueues) {
            for (int j = 0; j < children.getLength(); ++j) {
                Element qElem2 = (Element)children.item(j);
                if (!qElem2.getTagName().equals("queues")) continue;
                NodeList qListInfos = qElem2.getChildNodes();
                for (int k = 0; k < qListInfos.getLength(); ++k) {
                    Element qElem3 = (Element)qListInfos.item(k);
                    String qName3 = WebServicesTestUtils.getXmlString((Element)qElem3, (String)"queueName");
                    String q3 = q + "." + qName3;
                    this.verifySubQueueXML(qElem3, q3, qi.absoluteCapacity, qi.absoluteMaxCapacity);
                }
            }
        } else {
            LeafQueueInfo lqi = (LeafQueueInfo)qi;
            lqi.numActiveApplications = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"numActiveApplications");
            lqi.numPendingApplications = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"numPendingApplications");
            lqi.numContainers = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"numContainers");
            lqi.maxApplications = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"maxApplications");
            lqi.maxApplicationsPerUser = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"maxApplicationsPerUser");
            lqi.userLimit = WebServicesTestUtils.getXmlInt((Element)qElem, (String)"userLimit");
            lqi.userLimitFactor = WebServicesTestUtils.getXmlFloat((Element)qElem, (String)"userLimitFactor");
            this.verifyLeafQueueGeneric(q, lqi);
        }
    }

    private void verifyClusterScheduler(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)info.length());
        this.verifyClusterSchedulerGeneric(info.getString("type"), (float)info.getDouble("usedCapacity"), (float)info.getDouble("capacity"), (float)info.getDouble("maxCapacity"), info.getString("queueName"));
        JSONArray arr = info.getJSONObject("queues").getJSONArray("queue");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            String q = "root." + obj.getString("queueName");
            this.verifySubQueue(obj, q, 100.0f, 100.0f);
        }
    }

    private void verifyClusterSchedulerGeneric(String type, float usedCapacity, float capacity, float maxCapacity, String queueName) throws Exception {
        Assert.assertTrue((String)"type doesn't match", (boolean)"capacityScheduler".matches(type));
        Assert.assertEquals((String)"usedCapacity doesn't match", (float)0.0f, (float)usedCapacity, (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)100.0f, (float)capacity, (float)0.001f);
        Assert.assertEquals((String)"maxCapacity doesn't match", (float)100.0f, (float)maxCapacity, (float)0.001f);
        Assert.assertTrue((String)"queueName doesn't match", (boolean)"root".matches(queueName));
    }

    private void verifySubQueue(JSONObject info, String q, float parentAbsCapacity, float parentAbsMaxCapacity) throws JSONException, Exception {
        int numExpectedElements = 13;
        boolean isParentQueue = true;
        if (!info.has("queues")) {
            numExpectedElements = 23;
            isParentQueue = false;
        }
        Assert.assertEquals((String)"incorrect number of elements", (long)numExpectedElements, (long)info.length());
        QueueInfo qi = isParentQueue ? new QueueInfo() : new LeafQueueInfo();
        qi.capacity = (float)info.getDouble("capacity");
        qi.usedCapacity = (float)info.getDouble("usedCapacity");
        qi.maxCapacity = (float)info.getDouble("maxCapacity");
        qi.absoluteCapacity = (float)info.getDouble("absoluteCapacity");
        qi.absoluteMaxCapacity = (float)info.getDouble("absoluteMaxCapacity");
        qi.absoluteUsedCapacity = (float)info.getDouble("absoluteUsedCapacity");
        qi.numApplications = info.getInt("numApplications");
        qi.queueName = info.getString("queueName");
        qi.state = info.getString("state");
        this.verifySubQueueGeneric(q, qi, parentAbsCapacity, parentAbsMaxCapacity);
        if (isParentQueue) {
            JSONArray arr = info.getJSONObject("queues").getJSONArray("queue");
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String q2 = q + "." + obj.getString("queueName");
                this.verifySubQueue(obj, q2, qi.absoluteCapacity, qi.absoluteMaxCapacity);
            }
        } else {
            Assert.assertEquals((String)"\"type\" field is incorrect", (Object)"capacitySchedulerLeafQueueInfo", (Object)info.getString("type"));
            LeafQueueInfo lqi = (LeafQueueInfo)qi;
            lqi.numActiveApplications = info.getInt("numActiveApplications");
            lqi.numPendingApplications = info.getInt("numPendingApplications");
            lqi.numContainers = info.getInt("numContainers");
            lqi.maxApplications = info.getInt("maxApplications");
            lqi.maxApplicationsPerUser = info.getInt("maxApplicationsPerUser");
            lqi.userLimit = info.getInt("userLimit");
            lqi.userLimitFactor = (float)info.getDouble("userLimitFactor");
            this.verifyLeafQueueGeneric(q, lqi);
        }
    }

    private void verifySubQueueGeneric(String q, QueueInfo info, float parentAbsCapacity, float parentAbsMaxCapacity) throws Exception {
        String[] qArr = q.split("\\.");
        Assert.assertTrue((String)("q name invalid: " + q), (qArr.length > 1 ? 1 : 0) != 0);
        String qshortName = qArr[qArr.length - 1];
        Assert.assertEquals((String)"usedCapacity doesn't match", (float)0.0f, (float)info.usedCapacity, (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)this.csConf.getNonLabeledQueueCapacity(q), (float)info.capacity, (float)0.001f);
        float expectCapacity = this.csConf.getNonLabeledQueueMaximumCapacity(q);
        float expectAbsMaxCapacity = parentAbsMaxCapacity * (info.maxCapacity / 100.0f);
        if (-1.0f == expectCapacity) {
            expectCapacity = 100.0f;
            expectAbsMaxCapacity = 100.0f;
        }
        Assert.assertEquals((String)"maxCapacity doesn't match", (float)expectCapacity, (float)info.maxCapacity, (float)0.001f);
        Assert.assertEquals((String)"absoluteCapacity doesn't match", (float)(parentAbsCapacity * (info.capacity / 100.0f)), (float)info.absoluteCapacity, (float)0.001f);
        Assert.assertEquals((String)"absoluteMaxCapacity doesn't match", (float)expectAbsMaxCapacity, (float)info.absoluteMaxCapacity, (float)0.001f);
        Assert.assertEquals((String)"absoluteUsedCapacity doesn't match", (float)0.0f, (float)info.absoluteUsedCapacity, (float)0.001f);
        Assert.assertEquals((String)"numApplications doesn't match", (long)0L, (long)info.numApplications);
        Assert.assertTrue((String)("queueName doesn't match, got: " + info.queueName + " expected: " + q), (boolean)qshortName.matches(info.queueName));
        Assert.assertTrue((String)"state doesn't match", (boolean)this.csConf.getState(q).toString().matches(info.state));
    }

    private void verifyLeafQueueGeneric(String q, LeafQueueInfo info) throws Exception {
        Assert.assertEquals((String)"numActiveApplications doesn't match", (long)0L, (long)info.numActiveApplications);
        Assert.assertEquals((String)"numPendingApplications doesn't match", (long)0L, (long)info.numPendingApplications);
        Assert.assertEquals((String)"numContainers doesn't match", (long)0L, (long)info.numContainers);
        int maxSystemApps = this.csConf.getMaximumSystemApplications();
        int expectedMaxApps = (int)((float)maxSystemApps * (info.absoluteCapacity / 100.0f));
        int expectedMaxAppsPerUser = (int)((float)expectedMaxApps * ((float)info.userLimit / 100.0f) * info.userLimitFactor);
        Assert.assertEquals((String)"maxApplications doesn't match", (float)expectedMaxApps, (float)info.maxApplications, (float)1.0f);
        Assert.assertEquals((String)"maxApplicationsPerUser doesn't match", (float)expectedMaxAppsPerUser, (float)info.maxApplicationsPerUser, (float)info.userLimitFactor);
        Assert.assertEquals((String)"userLimit doesn't match", (long)this.csConf.getUserLimit(q), (long)info.userLimit);
        Assert.assertEquals((String)"userLimitFactor doesn't match", (float)this.csConf.getUserLimitFactor(q), (float)info.userLimitFactor, (float)0.001f);
    }

    private Node getChildNodeByName(Node node, String tagname) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(tagname)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerUserResourcesXML() throws Exception {
        rm.start();
        try {
            rm.submitApp(10, "app1", "user1", null, "b1");
            rm.submitApp(20, "app2", "user2", null, "b1");
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws/v1/cluster/scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList allUsers = dom.getElementsByTagName("users");
            for (int i = 0; i < allUsers.getLength(); ++i) {
                Node perUserResources = allUsers.item(i);
                String queueName = this.getChildNodeByName(perUserResources.getParentNode(), "queueName").getTextContent();
                if (queueName.equals("b1")) {
                    Assert.assertEquals((long)2L, (long)perUserResources.getChildNodes().getLength());
                    NodeList users = perUserResources.getChildNodes();
                    for (int j = 0; j < users.getLength(); ++j) {
                        Node user = users.item(j);
                        String username = this.getChildNodeByName(user, "username").getTextContent();
                        Assert.assertTrue((username.equals("user1") || username.equals("user2") ? 1 : 0) != 0);
                        Integer.parseInt(this.getChildNodeByName(this.getChildNodeByName(user, "resourcesUsed"), "memory").getTextContent());
                        Integer.parseInt(this.getChildNodeByName(user, "numActiveApplications").getTextContent());
                        Integer.parseInt(this.getChildNodeByName(user, "numPendingApplications").getTextContent());
                    }
                    continue;
                }
                Assert.assertEquals((long)0L, (long)perUserResources.getChildNodes().getLength());
            }
            NodeList allResourcesUsed = dom.getElementsByTagName("resourcesUsed");
            for (int i = 0; i < allResourcesUsed.getLength(); ++i) {
                Node resourcesUsed = allResourcesUsed.item(i);
                Integer.parseInt(this.getChildNodeByName(resourcesUsed, "memory").getTextContent());
                Integer.parseInt(this.getChildNodeByName(resourcesUsed, "vCores").getTextContent());
            }
        }
        finally {
            rm.stop();
        }
    }

    private void checkResourcesUsed(JSONObject queue) throws JSONException {
        queue.getJSONObject("resourcesUsed").getInt("memory");
        queue.getJSONObject("resourcesUsed").getInt("vCores");
    }

    private JSONObject getSubQueue(JSONObject queue, String subQueue) throws JSONException {
        JSONArray queues = queue.getJSONObject("queues").getJSONArray("queue");
        for (int i = 0; i < queues.length(); ++i) {
            this.checkResourcesUsed(queues.getJSONObject(i));
            if (!queues.getJSONObject(i).getString("queueName").equals(subQueue)) continue;
            return queues.getJSONObject(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerUserResourcesJSON() throws Exception {
        rm.start();
        try {
            rm.submitApp(10, "app1", "user1", null, "b1");
            rm.submitApp(20, "app2", "user2", null, "b1");
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject schedulerInfo = json.getJSONObject("scheduler").getJSONObject("schedulerInfo");
            JSONObject b1 = this.getSubQueue(this.getSubQueue(schedulerInfo, "b"), "b1");
            JSONArray users = b1.getJSONObject("users").getJSONArray("user");
            for (int i = 0; i < 2; ++i) {
                JSONObject user = users.getJSONObject(i);
                Assert.assertTrue((String)"User isn't user1 or user2", (user.getString("username").equals("user1") || user.getString("username").equals("user2") ? 1 : 0) != 0);
                user.getInt("numActiveApplications");
                user.getInt("numPendingApplications");
                this.checkResourcesUsed(user);
            }
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testResourceInfo() {
        Resource res = Resources.createResource((int)10, (int)1);
        Assert.assertEquals((Object)"<memory:10, vCores:1>", (Object)res.toString());
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWebServicesCapacitySched.this.injector;
        }
    }

    private class LeafQueueInfo
    extends QueueInfo {
        int numActiveApplications;
        int numPendingApplications;
        int numContainers;
        int maxApplications;
        int maxApplicationsPerUser;
        int userLimit;
        float userLimitFactor;

        private LeafQueueInfo() {
        }
    }

    private class QueueInfo {
        float capacity;
        float usedCapacity;
        float maxCapacity;
        float absoluteCapacity;
        float absoluteMaxCapacity;
        float absoluteUsedCapacity;
        int numApplications;
        String queueName;
        String state;

        private QueueInfo() {
        }
    }
}

