/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfoList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;

@XmlRootElement(name="capacityScheduler")
@XmlType(name="capacityScheduler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerInfo
extends SchedulerInfo {
    protected float capacity;
    protected float usedCapacity;
    protected float maxCapacity;
    protected String queueName;
    protected CapacitySchedulerQueueInfoList queues;
    @XmlTransient
    static final float EPSILON = 1.0E-8f;

    public CapacitySchedulerInfo() {
    }

    public CapacitySchedulerInfo(CSQueue parent) {
        this.queueName = parent.getQueueName();
        this.usedCapacity = parent.getUsedCapacity() * 100.0f;
        this.capacity = parent.getCapacity() * 100.0f;
        float max = parent.getMaximumCapacity();
        if (max < 1.0E-8f || max > 1.0f) {
            max = 1.0f;
        }
        this.maxCapacity = max * 100.0f;
        this.queues = this.getQueues(parent);
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getUsedCapacity() {
        return this.usedCapacity;
    }

    public float getMaxCapacity() {
        return this.maxCapacity;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public CapacitySchedulerQueueInfoList getQueues() {
        return this.queues;
    }

    protected CapacitySchedulerQueueInfoList getQueues(CSQueue parent) {
        CapacitySchedulerQueueInfoList queuesInfo = new CapacitySchedulerQueueInfoList();
        ArrayList childQueues = new ArrayList();
        ArrayList<CSQueue> childLeafQueues = new ArrayList<CSQueue>();
        ArrayList<CSQueue> childNonLeafQueues = new ArrayList<CSQueue>();
        for (CSQueue queue : parent.getChildQueues()) {
            if (queue instanceof LeafQueue) {
                childLeafQueues.add(queue);
                continue;
            }
            childNonLeafQueues.add(queue);
        }
        childQueues.addAll(childLeafQueues);
        childQueues.addAll(childNonLeafQueues);
        for (CSQueue queue : childQueues) {
            CapacitySchedulerQueueInfo info;
            if (queue instanceof LeafQueue) {
                info = new CapacitySchedulerLeafQueueInfo((LeafQueue)queue);
            } else {
                info = new CapacitySchedulerQueueInfo(queue);
                info.queues = this.getQueues(queue);
            }
            queuesInfo.addToQueueInfoList(info);
        }
        return queuesInfo;
    }
}

