/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public class FairReservationSystem
extends AbstractReservationSystem {
    private FairScheduler fairScheduler;

    public FairReservationSystem() {
        super(FairReservationSystem.class.getName());
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws YarnException {
        ResourceScheduler scheduler = rmContext.getScheduler();
        if (!(scheduler instanceof FairScheduler)) {
            throw new YarnRuntimeException("Class " + scheduler.getClass().getCanonicalName() + " not instance of " + FairScheduler.class.getCanonicalName());
        }
        this.fairScheduler = (FairScheduler)scheduler;
        this.conf = conf;
        super.reinitialize(conf, rmContext);
    }

    @Override
    protected ReservationSchedulerConfiguration getReservationSchedulerConfiguration() {
        return this.fairScheduler.getAllocationConfiguration();
    }

    @Override
    protected ResourceCalculator getResourceCalculator() {
        return this.fairScheduler.getResourceCalculator();
    }

    @Override
    protected QueueMetrics getRootQueueMetrics() {
        return this.fairScheduler.getRootQueueMetrics();
    }

    @Override
    protected Resource getMinAllocation() {
        return this.fairScheduler.getMinimumResourceCapability();
    }

    @Override
    protected Resource getMaxAllocation() {
        return this.fairScheduler.getMaximumResourceCapability();
    }

    @Override
    protected String getPlanQueuePath(String planQueueName) {
        return planQueueName;
    }

    @Override
    protected Resource getPlanQueueCapacity(String planQueueName) {
        return this.fairScheduler.getQueueManager().getParentQueue(planQueueName, false).getSteadyFairShare();
    }
}

