/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.util.Set;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEventType;

public class ApplicationCreatedEvent
extends SystemMetricsEvent {
    private ApplicationId appId;
    private String name;
    private String type;
    private String user;
    private String queue;
    private long submittedTime;
    private Set<String> appTags;
    private boolean unmanagedApplication;
    private Priority applicationPriority;
    private String appNodeLabelsExpression;
    private String amNodeLabelsExpression;
    private final CallerContext callerContext;
    private ContainerLaunchContext amContainerSpec;

    public ApplicationCreatedEvent(ApplicationId appId, String name, String type, String user, String queue, long submittedTime, long createdTime, Set<String> appTags, boolean unmanagedApplication, Priority applicationPriority, String appNodeLabelsExpression, String amNodeLabelsExpression, CallerContext callerContext, ContainerLaunchContext amContainerSpec) {
        super(SystemMetricsEventType.APP_CREATED, createdTime);
        this.appId = appId;
        this.name = name;
        this.type = type;
        this.user = user;
        this.queue = queue;
        this.submittedTime = submittedTime;
        this.appTags = appTags;
        this.unmanagedApplication = unmanagedApplication;
        this.applicationPriority = applicationPriority;
        this.appNodeLabelsExpression = appNodeLabelsExpression;
        this.amNodeLabelsExpression = amNodeLabelsExpression;
        this.callerContext = callerContext;
        this.amContainerSpec = amContainerSpec;
    }

    public int hashCode() {
        return this.appId.hashCode();
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public String getApplicationName() {
        return this.name;
    }

    public String getApplicationType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public long getSubmittedTime() {
        return this.submittedTime;
    }

    public Set<String> getAppTags() {
        return this.appTags;
    }

    public boolean isUnmanagedApp() {
        return this.unmanagedApplication;
    }

    public Priority getApplicationPriority() {
        return this.applicationPriority;
    }

    public String getAppNodeLabelsExpression() {
        return this.appNodeLabelsExpression;
    }

    public String getAmNodeLabelsExpression() {
        return this.amNodeLabelsExpression;
    }

    public CallerContext getCallerContext() {
        return this.callerContext;
    }

    public ContainerLaunchContext getAmContainerSpec() {
        return this.amContainerSpec;
    }
}

