/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorTransaction;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMZKUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ZKRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(ZKRMStateStore.class);
    private final SecureRandom random = new SecureRandom();
    protected static final String ROOT_ZNODE_NAME = "ZKRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)3);
    private static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    private static final String RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME = "RMDTSequentialNumber";
    private static final String RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "RMDTMasterKeysRoot";
    private String zkRootNodePath;
    private String rmAppRoot;
    private String rmDTSecretManagerRoot;
    private String dtMasterKeysRootPath;
    private String delegationTokensRootPath;
    private String dtSequenceNumberPath;
    private String amrmTokenSecretManagerRoot;
    private String reservationRoot;
    @VisibleForTesting
    protected String znodeWorkingPath;
    private static final String FENCING_LOCK = "RM_ZK_FENCING_LOCK";
    private String fencingNodePath;
    private Thread verifyActiveStatusThread;
    private int zkSessionTimeout;
    private List<ACL> zkAcl;
    @VisibleForTesting
    List<ACL> zkRootNodeAcl;
    private String zkRootNodeUsername;
    public static final int CREATE_DELETE_PERMS = 12;
    private final String zkRootNodeAuthScheme = new DigestAuthenticationProvider().getScheme();
    @VisibleForTesting
    protected CuratorFramework curatorFramework;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    protected List<ACL> constructZkRootNodeACL(Configuration conf, List<ACL> sourceACLs) throws NoSuchAlgorithmException {
        ArrayList<ACL> zkRootNodeAcl = new ArrayList<ACL>();
        for (ACL acl : sourceACLs) {
            zkRootNodeAcl.add(new ACL(ZKUtil.removeSpecificPerms((int)acl.getPerms(), (int)12), acl.getId()));
        }
        this.zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
        Id rmId = new Id(this.zkRootNodeAuthScheme, DigestAuthenticationProvider.generateDigest((String)(this.zkRootNodeUsername + ":" + this.resourceManager.getZkRootNodePassword())));
        zkRootNodeAcl.add(new ACL(12, rmId));
        return zkRootNodeAcl;
    }

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.znodeWorkingPath = conf.get("yarn.resourcemanager.zk-state-store.parent-path", "/rmstore");
        this.zkRootNodePath = this.getNodePath(this.znodeWorkingPath, ROOT_ZNODE_NAME);
        this.fencingNodePath = this.getNodePath(this.zkRootNodePath, FENCING_LOCK);
        this.rmAppRoot = this.getNodePath(this.zkRootNodePath, "RMAppRoot");
        this.zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        this.zkAcl = RMZKUtils.getZKAcls(conf);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            String zkRootNodeAclConf = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf);
            if (zkRootNodeAclConf != null) {
                zkRootNodeAclConf = ZKUtil.resolveConfIndirection((String)zkRootNodeAclConf);
                try {
                    this.zkRootNodeAcl = ZKUtil.parseACLs((String)zkRootNodeAclConf);
                }
                catch (ZKUtil.BadAclFormatException bafe) {
                    LOG.error((Object)"Invalid format for yarn.resourcemanager.zk-state-store.root-node.acl");
                    throw bafe;
                }
            } else {
                this.zkRootNodeAcl = this.constructZkRootNodeACL(conf, this.zkAcl);
            }
        }
        this.rmDTSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "RMDTSecretManagerRoot");
        this.dtMasterKeysRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME);
        this.delegationTokensRootPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME);
        this.dtSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, RM_DT_SEQUENTIAL_NUMBER_ZNODE_NAME);
        this.amrmTokenSecretManagerRoot = this.getNodePath(this.zkRootNodePath, "AMRMTokenSecretManagerRoot");
        this.reservationRoot = this.getNodePath(this.zkRootNodePath, "ReservationSystemRoot");
        this.curatorFramework = this.resourceManager.getCurator();
        if (this.curatorFramework == null) {
            this.curatorFramework = this.resourceManager.createAndStartCurator(conf);
        }
    }

    @Override
    public synchronized void startInternal() throws Exception {
        this.createRootDirRecursively(this.znodeWorkingPath);
        this.create(this.zkRootNodePath);
        this.setRootNodeAcls();
        this.delete(this.fencingNodePath);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig()) && !HAUtil.isAutomaticFailoverEnabled((Configuration)this.getConfig())) {
            this.verifyActiveStatusThread = new VerifyActiveStatusThread();
            this.verifyActiveStatusThread.start();
        }
        this.create(this.rmAppRoot);
        this.create(this.rmDTSecretManagerRoot);
        this.create(this.dtMasterKeysRootPath);
        this.create(this.delegationTokensRootPath);
        this.create(this.dtSequenceNumberPath);
        this.create(this.amrmTokenSecretManagerRoot);
        this.create(this.reservationRoot);
    }

    private void logRootNodeAcls(String prefix) throws Exception {
        Stat getStat = new Stat();
        List<ACL> getAcls = this.getACL(this.zkRootNodePath);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (ACL acl : getAcls) {
            builder.append(acl.toString());
        }
        builder.append(getStat.toString());
        LOG.debug((Object)builder.toString());
    }

    private void setRootNodeAcls() throws Exception {
        if (LOG.isDebugEnabled()) {
            this.logRootNodeAcls("Before setting ACLs'\n");
        }
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            ((BackgroundPathable)this.curatorFramework.setACL().withACL(this.zkRootNodeAcl)).forPath(this.zkRootNodePath);
        } else {
            ((BackgroundPathable)this.curatorFramework.setACL().withACL(this.zkAcl)).forPath(this.zkRootNodePath);
        }
        if (LOG.isDebugEnabled()) {
            this.logRootNodeAcls("After setting ACLs'\n");
        }
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        if (this.verifyActiveStatusThread != null) {
            this.verifyActiveStatusThread.interrupt();
            this.verifyActiveStatusThread.join(1000L);
        }
        if (!HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            IOUtils.closeStream((Closeable)this.curatorFramework);
        }
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.exists(versionNodePath)) {
            this.safeSetData(versionNodePath, data, -1);
        } else {
            this.safeCreate(versionNodePath, data, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        String versionNodePath = this.getNodePath(this.zkRootNodePath, "RMVersionNode");
        if (this.exists(versionNodePath)) {
            byte[] data = this.getData(versionNodePath);
            return new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        }
        return null;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        String epochNodePath = this.getNodePath(this.zkRootNodePath, "EpochNode");
        long currentEpoch = 0L;
        if (this.exists(epochNodePath)) {
            byte[] data = this.getData(epochNodePath);
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.safeSetData(epochNodePath, storeData, -1);
        } else {
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.safeCreate(epochNodePath, storeData, this.zkAcl, CreateMode.PERSISTENT);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        this.loadReservationSystemState(rmState);
        return rmState;
    }

    private void loadReservationSystemState(RMStateStore.RMState rmState) throws Exception {
        List<String> planNodes = this.getChildren(this.reservationRoot);
        for (String planName : planNodes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading plan from znode: " + planName));
            }
            String planNodePath = this.getNodePath(this.reservationRoot, planName);
            List<String> reservationNodes = this.getChildren(planNodePath);
            for (String reservationNodeName : reservationNodes) {
                String reservationNodePath = this.getNodePath(planNodePath, reservationNodeName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading reservation from znode: " + reservationNodePath));
                }
                byte[] reservationData = this.getData(reservationNodePath);
                YarnProtos.ReservationAllocationStateProto allocationState = YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])reservationData);
                if (!rmState.getReservationState().containsKey(planName)) {
                    rmState.getReservationState().put(planName, new HashMap());
                }
                ReservationId reservationId = ReservationId.parseReservationId((String)reservationNodeName);
                rmState.getReservationState().get(planName).put(reservationId, allocationState);
            }
        }
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        byte[] data = this.getData(this.amrmTokenSecretManagerRoot);
        if (data == null) {
            LOG.warn((Object)"There is no data saved");
            return;
        }
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private synchronized void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.loadRMDelegationKeyState(rmState);
        this.loadRMSequentialNumberState(rmState);
        this.loadRMDelegationTokenState(rmState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationKeyState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildren(this.dtMasterKeysRootPath);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.dtMasterKeysRootPath, childNodeName);
            byte[] childData = this.getData(childNodePath);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("DelegationKey_")) continue;
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded delegation key: keyId=" + key.getKeyId() + ", expirationDate=" + key.getExpiryDate()));
            }
            finally {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMSequentialNumberState(RMStateStore.RMState rmState) throws Exception {
        byte[] seqData = this.getData(this.dtSequenceNumberPath);
        if (seqData != null) {
            ByteArrayInputStream seqIs = new ByteArrayInputStream(seqData);
            try (DataInputStream seqIn = new DataInputStream(seqIs);){
                rmState.rmSecretManagerState.dtSequenceNumber = seqIn.readInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDelegationTokenState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildren(this.delegationTokensRootPath);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.delegationTokensRootPath, childNodeName);
            byte[] childData = this.getData(childNodePath);
            if (childData == null) {
                LOG.warn((Object)("Content of " + childNodePath + " is broken."));
                continue;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            try {
                if (!childNodeName.startsWith("RMDelegationToken_")) continue;
                RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData();
                identifierData.readFields(fsIn);
                RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
                long renewDate = identifierData.getRenewDate();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded RMDelegationTokenIdentifier: " + identifier + " renewDate=" + renewDate));
            }
            finally {
                is.close();
            }
        }
    }

    private synchronized void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        List<String> childNodes = this.getChildren(this.rmAppRoot);
        for (String childNodeName : childNodes) {
            String childNodePath = this.getNodePath(this.rmAppRoot, childNodeName);
            byte[] childData = this.getData(childNodePath);
            if (childNodeName.startsWith("application")) {
                ApplicationStateDataPBImpl appState;
                ApplicationId appId;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading application from znode: " + childNodeName));
                }
                if (!(appId = ApplicationId.fromString((String)childNodeName)).equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData))).getApplicationSubmissionContext().getApplicationId())) {
                    throw new YarnRuntimeException("The child node name is different from the application id");
                }
                rmState.appState.put(appId, appState);
                this.loadApplicationAttemptState(appState, appId);
                continue;
            }
            LOG.info((Object)("Unknown child node with name: " + childNodeName));
        }
    }

    private void loadApplicationAttemptState(ApplicationStateData appState, ApplicationId appId) throws Exception {
        String appPath = this.getNodePath(this.rmAppRoot, appId.toString());
        List<String> attempts = this.getChildren(appPath);
        for (String attemptIDStr : attempts) {
            if (!attemptIDStr.startsWith("appattempt")) continue;
            String attemptPath = this.getNodePath(appPath, attemptIDStr);
            byte[] attemptData = this.getData(attemptPath);
            ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(attemptData));
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        LOG.debug((Object)"Done loading applications from ZK state store");
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeCreatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        this.safeCreate(nodeCreatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String nodeUpdatePath = this.getNodePath(this.rmAppRoot, appId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for app: " + appId + " at: " + nodeUpdatePath));
        }
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        if (this.exists(nodeUpdatePath)) {
            this.safeSetData(nodeUpdatePath, appStateData, -1);
        } else {
            this.safeCreate(nodeUpdatePath, appStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug((Object)(appId + " znode didn't exist. Created a new znode to" + " update the application state."));
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appDirPath = this.getNodePath(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        String nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        this.safeCreate(nodeCreatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        String appIdStr = appAttemptId.getApplicationId().toString();
        String appAttemptIdStr = appAttemptId.toString();
        String appDirPath = this.getNodePath(this.rmAppRoot, appIdStr);
        String nodeUpdatePath = this.getNodePath(appDirPath, appAttemptIdStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing final state info for attempt: " + appAttemptIdStr + " at: " + nodeUpdatePath));
        }
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        if (this.exists(nodeUpdatePath)) {
            this.safeSetData(nodeUpdatePath, attemptStateData, -1);
        } else {
            this.safeCreate(nodeUpdatePath, attemptStateData, this.zkAcl, CreateMode.PERSISTENT);
            LOG.debug((Object)(appAttemptId + " znode didn't exist. Created a new znode to" + " update the application attempt state."));
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        String appId = appState.getApplicationSubmissionContext().getApplicationId().toString();
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing info for app: " + appId + " at: " + appIdRemovePath + " and its attempts."));
        }
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            String attemptRemovePath = this.getNodePath(appIdRemovePath, attemptId.toString());
            this.safeDelete(attemptRemovePath);
        }
        this.safeDelete(appIdRemovePath);
    }

    @Override
    protected synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        SafeTransaction trx = new SafeTransaction();
        this.addStoreOrUpdateOps(trx, rmDTIdentifier, renewDate, false);
        trx.commit();
    }

    @Override
    protected synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
        }
        this.safeDelete(nodeRemovePath);
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        SafeTransaction trx = new SafeTransaction();
        String nodeRemovePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        if (this.exists(nodeRemovePath)) {
            this.addStoreOrUpdateOps(trx, rmDTIdentifier, renewDate, true);
        } else {
            this.addStoreOrUpdateOps(trx, rmDTIdentifier, renewDate, false);
            LOG.debug((Object)("Attempted to update a non-existing znode " + nodeRemovePath));
        }
        trx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoreOrUpdateOps(SafeTransaction trx, RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, boolean isUpdate) throws Exception {
        String nodeCreatePath = this.getNodePath(this.delegationTokensRootPath, "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber());
        ByteArrayOutputStream seqOs = new ByteArrayOutputStream();
        DataOutputStream seqOut = new DataOutputStream(seqOs);
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)rmDTIdentifier, renewDate);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((isUpdate ? "Storing " : "Updating ") + "RMDelegationToken_" + rmDTIdentifier.getSequenceNumber()));
            }
            if (isUpdate) {
                trx.setData(nodeCreatePath, identifierData.toByteArray(), -1);
            } else {
                trx.create(nodeCreatePath, identifierData.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
                seqOut.writeInt(rmDTIdentifier.getSequenceNumber());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)((isUpdate ? "Storing " : "Updating ") + this.dtSequenceNumberPath + ". SequenceNumber: " + rmDTIdentifier.getSequenceNumber()));
                }
                trx.setData(this.dtSequenceNumberPath, seqOs.toByteArray(), -1);
            }
        }
        finally {
            seqOs.close();
        }
    }

    @Override
    protected synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeCreatePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            delegationKey.write((DataOutput)fsOut);
            this.safeCreate(nodeCreatePath, os.toByteArray(), this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    @Override
    protected synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        String nodeRemovePath = this.getNodePath(this.dtMasterKeysRootPath, "DelegationKey_" + delegationKey.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing RMDelegationKey_" + delegationKey.getKeyId()));
        }
        this.safeDelete(nodeRemovePath);
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        this.delete(this.zkRootNodePath);
    }

    @Override
    public synchronized void removeApplication(ApplicationId removeAppId) throws Exception {
        String appIdRemovePath = this.getNodePath(this.rmAppRoot, removeAppId.toString());
        this.delete(appIdRemovePath);
    }

    @VisibleForTesting
    String getNodePath(String root, String nodeName) {
        return root + "/" + nodeName;
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        this.safeSetData(this.amrmTokenSecretManagerRoot, stateData, -1);
    }

    @Override
    protected synchronized void removeReservationState(String planName, String reservationIdName) throws Exception {
        String planNodePath = this.getNodePath(this.reservationRoot, planName);
        String reservationPath = this.getNodePath(planNodePath, reservationIdName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing reservationallocation " + reservationIdName + " for" + " plan " + planName));
        }
        this.safeDelete(reservationPath);
        List<String> reservationNodes = this.getChildren(planNodePath);
        if (reservationNodes.isEmpty()) {
            this.safeDelete(planNodePath);
        }
    }

    @Override
    protected synchronized void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        SafeTransaction trx = new SafeTransaction();
        this.addOrUpdateReservationState(reservationAllocation, planName, reservationIdName, trx, false);
        trx.commit();
    }

    private void addOrUpdateReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName, SafeTransaction trx, boolean isUpdate) throws Exception {
        String planCreatePath = this.getNodePath(this.reservationRoot, planName);
        String reservationPath = this.getNodePath(planCreatePath, reservationIdName);
        byte[] reservationData = reservationAllocation.toByteArray();
        if (!this.exists(planCreatePath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating plan node: " + planName + " at: " + planCreatePath));
            }
            trx.create(planCreatePath, null, this.zkAcl, CreateMode.PERSISTENT);
        }
        if (isUpdate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating reservation: " + reservationIdName + " in plan:" + planName + " at: " + reservationPath));
            }
            trx.setData(reservationPath, reservationData, -1);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing reservation: " + reservationIdName + " in plan:" + planName + " at: " + reservationPath));
            }
            trx.create(reservationPath, reservationData, this.zkAcl, CreateMode.PERSISTENT);
        }
    }

    private void createRootDirRecursively(String path) throws Exception {
        String[] pathParts = path.split("/");
        Preconditions.checkArgument((pathParts.length >= 1 && pathParts[0].isEmpty() ? 1 : 0) != 0, (String)"Invalid path: %s", (Object[])new Object[]{path});
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append("/").append(pathParts[i]);
            this.create(sb.toString());
        }
    }

    @VisibleForTesting
    byte[] getData(String path) throws Exception {
        return (byte[])this.curatorFramework.getData().forPath(path);
    }

    @VisibleForTesting
    List<ACL> getACL(String path) throws Exception {
        return (List)this.curatorFramework.getACL().forPath(path);
    }

    private List<String> getChildren(String path) throws Exception {
        return (List)this.curatorFramework.getChildren().forPath(path);
    }

    private boolean exists(String path) throws Exception {
        return this.curatorFramework.checkExists().forPath(path) != null;
    }

    @VisibleForTesting
    void create(String path) throws Exception {
        if (!this.exists(path)) {
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.PERSISTENT)).withACL(this.zkAcl)).forPath(path, null);
        }
    }

    @VisibleForTesting
    void delete(String path) throws Exception {
        if (this.exists(path)) {
            this.curatorFramework.delete().deletingChildrenIfNeeded().forPath(path);
        }
    }

    private void safeCreate(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
        if (!this.exists(path)) {
            SafeTransaction transaction = new SafeTransaction();
            transaction.create(path, data, acl, mode);
            transaction.commit();
        }
    }

    private void safeDelete(String path) throws Exception {
        if (this.exists(path)) {
            SafeTransaction transaction = new SafeTransaction();
            transaction.delete(path);
            transaction.commit();
        }
    }

    private void safeSetData(String path, byte[] data, int version) throws Exception {
        SafeTransaction transaction = new SafeTransaction();
        transaction.setData(path, data, version);
        transaction.commit();
    }

    private class VerifyActiveStatusThread
    extends Thread {
        VerifyActiveStatusThread() {
            super(VerifyActiveStatusThread.class.getName());
        }

        @Override
        public void run() {
            try {
                while (!ZKRMStateStore.this.isFencedState()) {
                    new SafeTransaction().commit();
                    Thread.sleep(ZKRMStateStore.this.zkSessionTimeout);
                }
            }
            catch (InterruptedException ie) {
                LOG.info((Object)(VerifyActiveStatusThread.class.getName() + " thread " + "interrupted! Exiting!"));
            }
            catch (Exception e) {
                ZKRMStateStore.this.notifyStoreOperationFailed((Exception)((Object)new StoreFencedException()));
            }
        }
    }

    private class SafeTransaction {
        private CuratorTransactionFinal transactionFinal;

        SafeTransaction() throws Exception {
            CuratorTransaction transaction = ZKRMStateStore.this.curatorFramework.inTransaction();
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).withACL(ZKRMStateStore.this.zkAcl)).forPath(ZKRMStateStore.this.fencingNodePath, new byte[0])).and();
        }

        public void commit() throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)this.transactionFinal.delete().forPath(ZKRMStateStore.this.fencingNodePath)).and();
            this.transactionFinal.commit();
        }

        public void create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)((ACLPathAndBytesable)this.transactionFinal.create().withMode(mode)).withACL(acl)).forPath(path, data)).and();
        }

        public void delete(String path) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)this.transactionFinal.delete().forPath(path)).and();
        }

        public void setData(String path, byte[] data, int version) throws Exception {
            this.transactionFinal = ((CuratorTransactionBridge)((PathAndBytesable)this.transactionFinal.setData().withVersion(version)).forPath(path, data)).and();
        }
    }
}

