/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class CapacityReservationSystem
extends AbstractReservationSystem {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityReservationSystem.class);
    private CapacityScheduler capScheduler;

    public CapacityReservationSystem() {
        super(CapacityReservationSystem.class.getName());
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws YarnException {
        ResourceScheduler scheduler = rmContext.getScheduler();
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + scheduler.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.capScheduler = (CapacityScheduler)scheduler;
        this.conf = conf;
        super.reinitialize(conf, rmContext);
    }

    @Override
    protected Resource getMinAllocation() {
        return this.capScheduler.getMinimumResourceCapability();
    }

    @Override
    protected Resource getMaxAllocation() {
        return this.capScheduler.getMaximumResourceCapability();
    }

    @Override
    protected ResourceCalculator getResourceCalculator() {
        return this.capScheduler.getResourceCalculator();
    }

    @Override
    protected QueueMetrics getRootQueueMetrics() {
        return this.capScheduler.getRootQueueMetrics();
    }

    @Override
    protected String getPlanQueuePath(String planQueueName) {
        return this.capScheduler.getQueue(planQueueName).getQueuePath();
    }

    @Override
    protected Resource getPlanQueueCapacity(String planQueueName) {
        Resource minAllocation = this.getMinAllocation();
        ResourceCalculator rescCalc = this.getResourceCalculator();
        CSQueue planQueue = this.capScheduler.getQueue(planQueueName);
        return rescCalc.multiplyAndNormalizeDown(this.capScheduler.getClusterResource(), (double)planQueue.getAbsoluteCapacity(), minAllocation);
    }

    @Override
    protected ReservationSchedulerConfiguration getReservationSchedulerConfiguration() {
        return this.capScheduler.getConfiguration();
    }
}

