/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ResourceUsage {
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, UsageByLabel> usages;
    private static final String NL = "";

    public ResourceUsage() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.usages = new HashMap<String, UsageByLabel>();
        this.usages.put(NL, new UsageByLabel(NL));
    }

    public Resource getUsed() {
        return this.getUsed(NL);
    }

    public Resource getUsed(String label) {
        return this._get(label, ResourceType.USED);
    }

    public Resource getCachedUsed() {
        return this._get(NL, ResourceType.CACHED_USED);
    }

    public Resource getCachedUsed(String label) {
        return this._get(label, ResourceType.CACHED_USED);
    }

    public Resource getCachedPending() {
        return this._get(NL, ResourceType.CACHED_PENDING);
    }

    public Resource getCachedPending(String label) {
        return this._get(label, ResourceType.CACHED_PENDING);
    }

    public void incUsed(String label, Resource res) {
        this._inc(label, ResourceType.USED, res);
    }

    public void incUsed(Resource res) {
        this.incUsed(NL, res);
    }

    public void decUsed(Resource res) {
        this.decUsed(NL, res);
    }

    public void decUsed(String label, Resource res) {
        this._dec(label, ResourceType.USED, res);
    }

    public void setUsed(Resource res) {
        this.setUsed(NL, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAllUsed(ResourceUsage other) {
        try {
            this.writeLock.lock();
            for (Map.Entry<String, UsageByLabel> entry : other.usages.entrySet()) {
                this.setUsed(entry.getKey(), Resources.clone((Resource)entry.getValue().getUsed()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setUsed(String label, Resource res) {
        this._set(label, ResourceType.USED, res);
    }

    public void setCachedUsed(String label, Resource res) {
        this._set(label, ResourceType.CACHED_USED, res);
    }

    public void setCachedUsed(Resource res) {
        this._set(NL, ResourceType.CACHED_USED, res);
    }

    public void setCachedPending(String label, Resource res) {
        this._set(label, ResourceType.CACHED_PENDING, res);
    }

    public void setCachedPending(Resource res) {
        this._set(NL, ResourceType.CACHED_PENDING, res);
    }

    public Resource getPending() {
        return this.getPending(NL);
    }

    public Resource getPending(String label) {
        return this._get(label, ResourceType.PENDING);
    }

    public void incPending(String label, Resource res) {
        this._inc(label, ResourceType.PENDING, res);
    }

    public void incPending(Resource res) {
        this.incPending(NL, res);
    }

    public void decPending(Resource res) {
        this.decPending(NL, res);
    }

    public void decPending(String label, Resource res) {
        this._dec(label, ResourceType.PENDING, res);
    }

    public void setPending(Resource res) {
        this.setPending(NL, res);
    }

    public void setPending(String label, Resource res) {
        this._set(label, ResourceType.PENDING, res);
    }

    public Resource getReserved() {
        return this.getReserved(NL);
    }

    public Resource getReserved(String label) {
        return this._get(label, ResourceType.RESERVED);
    }

    public void incReserved(String label, Resource res) {
        this._inc(label, ResourceType.RESERVED, res);
    }

    public void incReserved(Resource res) {
        this.incReserved(NL, res);
    }

    public void decReserved(Resource res) {
        this.decReserved(NL, res);
    }

    public void decReserved(String label, Resource res) {
        this._dec(label, ResourceType.RESERVED, res);
    }

    public void setReserved(Resource res) {
        this.setReserved(NL, res);
    }

    public void setReserved(String label, Resource res) {
        this._set(label, ResourceType.RESERVED, res);
    }

    public Resource getAMUsed() {
        return this.getAMUsed(NL);
    }

    public Resource getAMUsed(String label) {
        return this._get(label, ResourceType.AMUSED);
    }

    public void incAMUsed(String label, Resource res) {
        this._inc(label, ResourceType.AMUSED, res);
    }

    public void incAMUsed(Resource res) {
        this.incAMUsed(NL, res);
    }

    public void decAMUsed(Resource res) {
        this.decAMUsed(NL, res);
    }

    public void decAMUsed(String label, Resource res) {
        this._dec(label, ResourceType.AMUSED, res);
    }

    public void setAMUsed(Resource res) {
        this.setAMUsed(NL, res);
    }

    public void setAMUsed(String label, Resource res) {
        this._set(label, ResourceType.AMUSED, res);
    }

    public Resource getAMLimit() {
        return this.getAMLimit(NL);
    }

    public Resource getAMLimit(String label) {
        return this._get(label, ResourceType.AMLIMIT);
    }

    public void incAMLimit(String label, Resource res) {
        this._inc(label, ResourceType.AMLIMIT, res);
    }

    public void incAMLimit(Resource res) {
        this.incAMLimit(NL, res);
    }

    public void decAMLimit(Resource res) {
        this.decAMLimit(NL, res);
    }

    public void decAMLimit(String label, Resource res) {
        this._dec(label, ResourceType.AMLIMIT, res);
    }

    public void setAMLimit(Resource res) {
        this.setAMLimit(NL, res);
    }

    public void setAMLimit(String label, Resource res) {
        this._set(label, ResourceType.AMLIMIT, res);
    }

    private static Resource normalize(Resource res) {
        if (res == null) {
            return Resources.none();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource _get(String label, ResourceType type) {
        if (label == null) {
            label = NL;
        }
        try {
            this.readLock.lock();
            UsageByLabel usage = this.usages.get(label);
            if (null == usage) {
                Resource resource = Resources.none();
                return resource;
            }
            Resource resource = ResourceUsage.normalize(usage.resArr[type.idx]);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource _getAll(ResourceType type) {
        try {
            this.readLock.lock();
            Resource allOfType = Resources.createResource((int)0);
            for (Map.Entry<String, UsageByLabel> usageEntry : this.usages.entrySet()) {
                Resources.addTo((Resource)allOfType, (Resource)usageEntry.getValue().resArr[type.idx]);
            }
            Resource resource = allOfType;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getAllPending() {
        return this._getAll(ResourceType.PENDING);
    }

    public Resource getAllUsed() {
        return this._getAll(ResourceType.USED);
    }

    private UsageByLabel getAndAddIfMissing(String label) {
        if (label == null) {
            label = NL;
        }
        if (!this.usages.containsKey(label)) {
            UsageByLabel u = new UsageByLabel(label);
            this.usages.put(label, u);
            return u;
        }
        return this.usages.get(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _set(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            ((UsageByLabel)usage).resArr[((ResourceType)type).idx] = res;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _inc(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            Resources.addTo((Resource)usage.resArr[type.idx], (Resource)res);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dec(String label, ResourceType type, Resource res) {
        try {
            this.writeLock.lock();
            UsageByLabel usage = this.getAndAddIfMissing(label);
            Resources.subtractFrom((Resource)usage.resArr[type.idx], (Resource)res);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getCachedDemand(String label) {
        try {
            this.readLock.lock();
            Resource demand = Resources.createResource((int)0);
            Resources.addTo((Resource)demand, (Resource)this.getCachedUsed(label));
            Resources.addTo((Resource)demand, (Resource)this.getCachedPending(label));
            Resource resource = demand;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            this.readLock.lock();
            String string = this.usages.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNodePartitionsSet() {
        try {
            this.readLock.lock();
            Set<String> set = this.usages.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class UsageByLabel {
        private Resource[] resArr = new Resource[ResourceType.values().length];

        public UsageByLabel(String label) {
            for (int i = 0; i < this.resArr.length; ++i) {
                this.resArr[i] = Resource.newInstance((int)0, (int)0);
            }
        }

        public Resource getUsed() {
            return this.resArr[ResourceType.USED.idx];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{used=" + this.resArr[0] + "%, ");
            sb.append("pending=" + this.resArr[1] + "%, ");
            sb.append("am_used=" + this.resArr[2] + "%, ");
            sb.append("reserved=" + this.resArr[3] + "%}");
            sb.append("am_limit=" + this.resArr[6] + "%, ");
            return sb.toString();
        }
    }

    private static enum ResourceType {
        USED(0),
        PENDING(1),
        AMUSED(2),
        RESERVED(3),
        CACHED_USED(4),
        CACHED_PENDING(5),
        AMLIMIT(6);

        private int idx;

        private ResourceType(int value) {
            this.idx = value;
        }
    }
}

