/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RegularContainerAllocator
extends AbstractContainerAllocator {
    private static final Log LOG = LogFactory.getLog(RegularContainerAllocator.class);
    private ResourceRequest lastResourceRequest = null;

    public RegularContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext) {
        super(application, rc, rmContext);
    }

    private boolean checkHeadroom(Resource clusterResource, ResourceLimits currentResourceLimits, Resource required, FiCaSchedulerNode node) {
        Resource resourceCouldBeUnReserved = this.application.getCurrentReservation();
        if (!this.application.getCSLeafQueue().getReservationContinueLooking() || !node.getPartition().equals("")) {
            resourceCouldBeUnReserved = Resources.none();
        }
        return Resources.greaterThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.add((Resource)currentResourceLimits.getHeadroom(), (Resource)resourceCouldBeUnReserved), (Resource)required);
    }

    private ContainerAllocation preCheckForNewContainer(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, Priority priority) {
        if (SchedulerAppUtils.isPlaceBlacklisted(this.application, node, LOG)) {
            this.application.updateAppSkipNodeDiagnostics("Skipped scheduling for this Node as its black listed. ");
            return ContainerAllocation.APP_SKIPPED;
        }
        ResourceRequest anyRequest = this.application.getResourceRequest(priority, "*");
        if (null == anyRequest) {
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        Resource required = anyRequest.getCapability();
        if (this.application.getTotalRequiredResources(priority) <= 0) {
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY && this.application.isWaitingForAMContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip allocating AM container to app_attempt=" + this.application.getApplicationAttemptId() + ", don't allow to allocate AM container in non-exclusive mode"));
            }
            this.application.updateAppSkipNodeDiagnostics("Skipping assigning to Node in Ignore Exclusivity mode. ");
            return ContainerAllocation.APP_SKIPPED;
        }
        if (!SchedulerUtils.checkResourceRequestMatchingNodePartition(anyRequest.getNodeLabelExpression(), node.getPartition(), schedulingMode)) {
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (!this.application.getCSLeafQueue().getReservationContinueLooking() && !this.shouldAllocOrReserveNewContainer(priority, required)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"doesn't need containers based on reservation algo!");
            }
            return ContainerAllocation.PRIORITY_SKIPPED;
        }
        if (!this.checkHeadroom(clusterResource, resourceLimits, required, node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cannot allocate required resource=" + required + " because of headroom"));
            }
            return ContainerAllocation.QUEUE_SKIPPED;
        }
        this.application.addSchedulingOpportunity(priority);
        int missedNonPartitionedRequestSchedulingOpportunity = 0;
        if (anyRequest.getNodeLabelExpression().equals("")) {
            missedNonPartitionedRequestSchedulingOpportunity = this.application.addMissedNonPartitionedRequestSchedulingOpportunity(priority);
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY && missedNonPartitionedRequestSchedulingOpportunity < this.rmContext.getScheduler().getNumClusterNodes()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip app_attempt=" + this.application.getApplicationAttemptId() + " priority=" + priority + " because missed-non-partitioned-resource-request" + " opportunity under requred:" + " Now=" + missedNonPartitionedRequestSchedulingOpportunity + " required=" + this.rmContext.getScheduler().getNumClusterNodes()));
            }
            return ContainerAllocation.APP_SKIPPED;
        }
        return null;
    }

    ContainerAllocation preAllocation(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, Priority priority, RMContainer reservedContainer) {
        ContainerAllocation result;
        if (null == reservedContainer) {
            result = this.preCheckForNewContainer(clusterResource, node, schedulingMode, resourceLimits, priority);
            if (null != result) {
                return result;
            }
        } else if (this.application.getTotalRequiredResources(priority) == 0) {
            return new ContainerAllocation(reservedContainer, null, AllocationState.QUEUE_SKIPPED);
        }
        result = this.assignContainersOnNode(clusterResource, node, priority, reservedContainer, schedulingMode, resourceLimits);
        if (null == reservedContainer && result.state == AllocationState.PRIORITY_SKIPPED) {
            this.application.subtractSchedulingOpportunity(priority);
        }
        return result;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.application.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    private int getActualNodeLocalityDelay() {
        return Math.min(this.rmContext.getScheduler().getNumClusterNodes(), this.application.getCSLeafQueue().getNodeLocalityDelay());
    }

    private boolean canAssign(Priority priority, FiCaSchedulerNode node, NodeType type, RMContainer reservedContainer) {
        ResourceRequest nodeLocalRequest;
        if (type == NodeType.OFF_SWITCH) {
            if (reservedContainer != null) {
                return true;
            }
            ResourceRequest offSwitchRequest = this.application.getResourceRequest(priority, "*");
            long missedOpportunities = this.application.getSchedulingOpportunities(priority);
            long requiredContainers = offSwitchRequest.getNumContainers();
            float localityWaitFactor = this.getLocalityWaitFactor(priority, this.rmContext.getScheduler().getNumClusterNodes());
            return Math.min((float)this.rmContext.getScheduler().getNumClusterNodes(), (float)requiredContainers * localityWaitFactor) < (float)missedOpportunities;
        }
        ResourceRequest rackLocalRequest = this.application.getResourceRequest(priority, node.getRackName());
        if (rackLocalRequest == null || rackLocalRequest.getNumContainers() <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            long missedOpportunities = this.application.getSchedulingOpportunities(priority);
            return (long)this.getActualNodeLocalityDelay() < missedOpportunities;
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = this.application.getResourceRequest(priority, node.getNodeName())) != null) {
            return nodeLocalRequest.getNumContainers() > 0;
        }
        return false;
    }

    private ContainerAllocation assignNodeLocalContainers(Resource clusterResource, ResourceRequest nodeLocalResourceRequest, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(priority, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, priority, nodeLocalResourceRequest, NodeType.NODE_LOCAL, reservedContainer, schedulingMode, currentResoureLimits);
        }
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    private ContainerAllocation assignRackLocalContainers(Resource clusterResource, ResourceRequest rackLocalResourceRequest, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(priority, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, priority, rackLocalResourceRequest, NodeType.RACK_LOCAL, reservedContainer, schedulingMode, currentResoureLimits);
        }
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    private ContainerAllocation assignOffSwitchContainers(Resource clusterResource, ResourceRequest offSwitchResourceRequest, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        if (this.canAssign(priority, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, priority, offSwitchResourceRequest, NodeType.OFF_SWITCH, reservedContainer, schedulingMode, currentResoureLimits);
        }
        this.application.updateAppSkipNodeDiagnostics("Skipping assigning to Node as request locality is not matching. ");
        return ContainerAllocation.APP_SKIPPED;
    }

    private ContainerAllocation assignContainersOnNode(Resource clusterResource, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        ResourceRequest offSwitchResourceRequest;
        ResourceRequest rackLocalResourceRequest;
        ContainerAllocation allocation;
        NodeType requestType = null;
        ResourceRequest nodeLocalResourceRequest = this.application.getResourceRequest(priority, node.getNodeName());
        if (nodeLocalResourceRequest != null) {
            requestType = NodeType.NODE_LOCAL;
            allocation = this.assignNodeLocalContainers(clusterResource, nodeLocalResourceRequest, node, priority, reservedContainer, schedulingMode, currentResoureLimits);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)allocation.getResourceToBeAllocated(), (Resource)Resources.none())) {
                allocation.requestNodeType = requestType;
                return allocation;
            }
        }
        if ((rackLocalResourceRequest = this.application.getResourceRequest(priority, node.getRackName())) != null) {
            if (!rackLocalResourceRequest.getRelaxLocality()) {
                return ContainerAllocation.PRIORITY_SKIPPED;
            }
            if (requestType != NodeType.NODE_LOCAL) {
                requestType = NodeType.RACK_LOCAL;
            }
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)(allocation = this.assignRackLocalContainers(clusterResource, rackLocalResourceRequest, node, priority, reservedContainer, schedulingMode, currentResoureLimits)).getResourceToBeAllocated(), (Resource)Resources.none())) {
                allocation.requestNodeType = requestType;
                return allocation;
            }
        }
        if ((offSwitchResourceRequest = this.application.getResourceRequest(priority, "*")) != null) {
            if (!offSwitchResourceRequest.getRelaxLocality()) {
                return ContainerAllocation.PRIORITY_SKIPPED;
            }
            if (requestType != NodeType.NODE_LOCAL && requestType != NodeType.RACK_LOCAL) {
                requestType = NodeType.OFF_SWITCH;
            }
            allocation = this.assignOffSwitchContainers(clusterResource, offSwitchResourceRequest, node, priority, reservedContainer, schedulingMode, currentResoureLimits);
            allocation.requestNodeType = requestType;
            if (allocation.state == AllocationState.LOCALITY_SKIPPED) {
                allocation.state = AllocationState.APP_SKIPPED;
            }
            return allocation;
        }
        return ContainerAllocation.PRIORITY_SKIPPED;
    }

    private ContainerAllocation assignContainer(Resource clusterResource, FiCaSchedulerNode node, Priority priority, ResourceRequest request, NodeType type, RMContainer rmContainer, SchedulingMode schedulingMode, ResourceLimits currentResoureLimits) {
        ContainerAllocation result;
        this.lastResourceRequest = request;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getNodeName() + " application=" + this.application.getApplicationId() + " priority=" + priority.getPriority() + " request=" + request + " type=" + (Object)((Object)type)));
        }
        if (!SchedulerUtils.checkResourceRequestMatchingNodePartition(request.getNodeLabelExpression(), node.getPartition(), schedulingMode)) {
            return new ContainerAllocation(rmContainer, null, AllocationState.LOCALITY_SKIPPED);
        }
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Resource totalResource = node.getTotalResource();
        if (!Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)capability, (Resource)totalResource)) {
            LOG.warn((Object)("Node : " + node.getNodeID() + " does not have sufficient resource for request : " + request + " node total capability : " + node.getTotalResource()));
            return ContainerAllocation.LOCALITY_SKIPPED;
        }
        boolean shouldAllocOrReserveNewContainer = this.shouldAllocOrReserveNewContainer(priority, capability);
        long availableContainers = this.rc.computeAvailableContainers(available, capability);
        Resource resourceNeedToUnReserve = Resources.max((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.subtract((Resource)capability, (Resource)currentResoureLimits.getHeadroom()), (Resource)currentResoureLimits.getAmountNeededUnreserve());
        boolean needToUnreserve = Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)resourceNeedToUnReserve, (Resource)Resources.none());
        RMContainer unreservedContainer = null;
        boolean reservationsContinueLooking = this.application.getCSLeafQueue().getReservationContinueLooking();
        ArrayList<RMContainer> toKillContainers = null;
        if (availableContainers == 0L && currentResoureLimits.isAllowPreemption()) {
            Resource availableAndKillable = Resources.clone((Resource)available);
            for (RMContainer killableContainer : node.getKillableContainers().values()) {
                if (null == toKillContainers) {
                    toKillContainers = new ArrayList<RMContainer>();
                }
                toKillContainers.add(killableContainer);
                Resources.addTo((Resource)availableAndKillable, (Resource)killableContainer.getAllocatedResource());
                if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)capability, (Resource)availableAndKillable)) continue;
                availableContainers = 1L;
                break;
            }
        }
        if (availableContainers > 0L) {
            if (rmContainer == null && reservationsContinueLooking && node.getLabels().isEmpty() && (!shouldAllocOrReserveNewContainer || needToUnreserve)) {
                if (!needToUnreserve) {
                    resourceNeedToUnReserve = capability;
                }
                if (null == (unreservedContainer = this.application.findNodeToUnreserve(clusterResource, node, priority, resourceNeedToUnReserve))) {
                    return ContainerAllocation.LOCALITY_SKIPPED;
                }
            }
            result = new ContainerAllocation(unreservedContainer, request.getCapability(), AllocationState.ALLOCATED);
            result.containerNodeType = type;
            result.setToKillContainers(toKillContainers);
            return result;
        }
        if (shouldAllocOrReserveNewContainer || rmContainer != null) {
            if (reservationsContinueLooking && rmContainer == null && needToUnreserve) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"we needed to unreserve to be able to allocate");
                }
                return ContainerAllocation.LOCALITY_SKIPPED;
            }
            result = new ContainerAllocation(null, request.getCapability(), AllocationState.RESERVED);
            result.containerNodeType = type;
            result.setToKillContainers(null);
            return result;
        }
        return ContainerAllocation.LOCALITY_SKIPPED;
    }

    boolean shouldAllocOrReserveNewContainer(Priority priority, Resource required) {
        int requiredContainers = this.application.getTotalRequiredResources(priority);
        int reservedContainers = this.application.getNumReservedContainers(priority);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = Resources.ratio((ResourceCalculator)this.rc, (Resource)required, (Resource)this.application.getCSLeafQueue().getMaximumAllocation());
            starvation = (int)((float)this.application.getReReservations(priority) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.application.getCSLeafQueue().getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + this.application.getReReservations(priority) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.application.getCSLeafQueue().getMinimumAllocationFactor() + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private Container getContainer(RMContainer rmContainer, FiCaSchedulerNode node, Resource capability, Priority priority) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(node, capability, priority);
    }

    private Container createContainer(FiCaSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)this.application.getApplicationAttemptId(), (long)this.application.getNewContainerId());
        return BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
    }

    private ContainerAllocation handleNewContainerAllocation(ContainerAllocation allocationResult, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer, Container container) {
        RMContainer allocatedContainer;
        if (reservedContainer != null) {
            this.application.unreserve(priority, node, reservedContainer);
        }
        if ((allocatedContainer = this.application.allocate(allocationResult.containerNodeType, node, priority, this.lastResourceRequest, container)) == null) {
            ContainerAllocation ret = new ContainerAllocation(allocationResult.containerToBeUnreserved, null, AllocationState.APP_SKIPPED);
            return ret;
        }
        node.allocateContainer(allocatedContainer);
        this.application.incNumAllocatedContainers(allocationResult.containerNodeType, allocationResult.requestNodeType);
        return allocationResult;
    }

    ContainerAllocation doAllocation(ContainerAllocation allocationResult, FiCaSchedulerNode node, Priority priority, RMContainer reservedContainer) {
        Container container = this.getContainer(reservedContainer, node, allocationResult.getResourceToBeAllocated(), priority);
        if (container == null) {
            this.application.updateAppSkipNodeDiagnostics("Scheduling of container failed. ");
            LOG.warn((Object)"Couldn't get container for allocation!");
            return ContainerAllocation.APP_SKIPPED;
        }
        if (allocationResult.getAllocationState() == AllocationState.ALLOCATED) {
            allocationResult = this.handleNewContainerAllocation(allocationResult, node, priority, reservedContainer, container);
        } else {
            this.application.reserve(priority, node, reservedContainer, container);
        }
        allocationResult.updatedContainer = container;
        if (reservedContainer == null) {
            if (allocationResult.containerNodeType != NodeType.OFF_SWITCH) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Resetting scheduling opportunities");
                }
                if (allocationResult.containerNodeType == NodeType.NODE_LOCAL || this.application.getCSLeafQueue().getRackLocalityFullReset()) {
                    this.application.resetSchedulingOpportunities(priority);
                }
            }
            if (StringUtils.equals((String)node.getPartition(), (String)"")) {
                this.application.resetMissedNonPartitionedRequestSchedulingOpportunity(priority);
            }
        }
        return allocationResult;
    }

    private ContainerAllocation allocate(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, Priority priority, RMContainer reservedContainer) {
        ContainerAllocation result = this.preAllocation(clusterResource, node, schedulingMode, resourceLimits, priority, reservedContainer);
        if (AllocationState.ALLOCATED == result.state || AllocationState.RESERVED == result.state) {
            result = this.doAllocation(result, node, priority, reservedContainer);
        }
        return result;
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, RMContainer reservedContainer) {
        if (reservedContainer == null) {
            if (!this.application.hasPendingResourceRequest(this.rc, node.getPartition(), clusterResource, schedulingMode)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip app_attempt=" + this.application.getApplicationAttemptId() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-label=" + node.getPartition()));
                }
                return CSAssignment.SKIP_ASSIGNMENT;
            }
            for (Priority priority : this.application.getPriorities()) {
                ContainerAllocation result = this.allocate(clusterResource, node, schedulingMode, resourceLimits, priority, null);
                AllocationState allocationState = result.getAllocationState();
                if (allocationState == AllocationState.PRIORITY_SKIPPED) continue;
                return this.getCSAssignmentFromAllocateResult(clusterResource, result, null);
            }
            return CSAssignment.SKIP_ASSIGNMENT;
        }
        ContainerAllocation result = this.allocate(clusterResource, node, schedulingMode, resourceLimits, reservedContainer.getReservedPriority(), reservedContainer);
        return this.getCSAssignmentFromAllocateResult(clusterResource, result, reservedContainer);
    }
}

