/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AssignmentInformation {
    private final Map<Operation, Integer> operationCounts = new HashMap<Operation, Integer>();
    private final Map<Operation, Resource> operationResources = new HashMap<Operation, Resource>();
    private final Map<Operation, List<AssignmentDetails>> operationDetails = new HashMap<Operation, List<AssignmentDetails>>();

    public AssignmentInformation() {
        for (Operation op : Operation.values()) {
            this.operationCounts.put(op, 0);
            this.operationResources.put(op, Resource.newInstance((int)0, (int)0));
            this.operationDetails.put(op, new ArrayList());
        }
    }

    public int getNumAllocations() {
        return this.operationCounts.get((Object)Operation.ALLOCATION);
    }

    public void incrAllocations() {
        this.increment(Operation.ALLOCATION, 1);
    }

    public void incrAllocations(int by) {
        this.increment(Operation.ALLOCATION, by);
    }

    public int getNumReservations() {
        return this.operationCounts.get((Object)Operation.RESERVATION);
    }

    public void incrReservations() {
        this.increment(Operation.RESERVATION, 1);
    }

    public void incrReservations(int by) {
        this.increment(Operation.RESERVATION, by);
    }

    private void increment(Operation op, int by) {
        this.operationCounts.put(op, this.operationCounts.get((Object)op) + by);
    }

    public Resource getAllocated() {
        return this.operationResources.get((Object)Operation.ALLOCATION);
    }

    public Resource getReserved() {
        return this.operationResources.get((Object)Operation.RESERVATION);
    }

    private void addAssignmentDetails(Operation op, ContainerId containerId, String queue) {
        this.operationDetails.get((Object)op).add(new AssignmentDetails(containerId, queue));
    }

    public void addAllocationDetails(ContainerId containerId, String queue) {
        this.addAssignmentDetails(Operation.ALLOCATION, containerId, queue);
    }

    public void addReservationDetails(ContainerId containerId, String queue) {
        this.addAssignmentDetails(Operation.RESERVATION, containerId, queue);
    }

    public List<AssignmentDetails> getAllocationDetails() {
        return this.operationDetails.get((Object)Operation.ALLOCATION);
    }

    public List<AssignmentDetails> getReservationDetails() {
        return this.operationDetails.get((Object)Operation.RESERVATION);
    }

    private ContainerId getFirstContainerIdFromOperation(Operation op) {
        List<AssignmentDetails> assignDetails;
        if (null != this.operationDetails.get((Object)op) && !(assignDetails = this.operationDetails.get((Object)op)).isEmpty()) {
            return assignDetails.get((int)0).containerId;
        }
        return null;
    }

    public ContainerId getFirstAllocatedOrReservedContainerId() {
        ContainerId containerId = this.getFirstContainerIdFromOperation(Operation.ALLOCATION);
        if (null != containerId) {
            return containerId;
        }
        return this.getFirstContainerIdFromOperation(Operation.RESERVATION);
    }

    public static class AssignmentDetails {
        public ContainerId containerId;
        public String queue;

        public AssignmentDetails(ContainerId containerId, String queue) {
            this.containerId = containerId;
            this.queue = queue;
        }
    }

    public static enum Operation {
        ALLOCATION,
        RESERVATION;

    }
}

