/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSParentQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSParentQueue.class.getName());
    private final List<FSQueue> childQueues = new ArrayList<FSQueue>();
    private Resource demand = Resources.createResource((int)0);
    private int runnableApps;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private Lock readLock = this.rwLock.readLock();
    private Lock writeLock = this.rwLock.writeLock();

    public FSParentQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildQueue(FSQueue child) {
        this.writeLock.lock();
        try {
            this.childQueues.add(child);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildQueue(FSQueue child) {
        this.writeLock.lock();
        try {
            this.childQueues.remove(child);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recomputeShares() {
        this.readLock.lock();
        try {
            this.policy.computeShares(this.childQueues, this.getFairShare());
            for (FSQueue childQueue : this.childQueues) {
                childQueue.getMetrics().setFairShare(childQueue.getFairShare());
                childQueue.recomputeShares();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputeSteadyShares() {
        this.readLock.lock();
        try {
            this.policy.computeSteadyShares(this.childQueues, this.getSteadyFairShare());
            for (FSQueue childQueue : this.childQueues) {
                childQueue.getMetrics().setSteadyFairShare(childQueue.getSteadyFairShare());
                if (!(childQueue instanceof FSParentQueue)) continue;
                ((FSParentQueue)childQueue).recomputeSteadyShares();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePreemptionVariables() {
        super.updatePreemptionVariables();
        this.readLock.lock();
        try {
            for (FSQueue childQueue : this.childQueues) {
                childQueue.updatePreemptionVariables();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getDemand() {
        this.readLock.lock();
        try {
            Resource resource = Resource.newInstance((long)this.demand.getMemorySize(), (int)this.demand.getVirtualCores());
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        this.readLock.lock();
        try {
            for (FSQueue child : this.childQueues) {
                Resources.addTo((Resource)usage, (Resource)child.getResourceUsage());
            }
        }
        finally {
            this.readLock.unlock();
        }
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        Resource maxRes = this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
        this.writeLock.lock();
        try {
            this.demand = Resources.createResource((int)0);
            for (FSQueue childQueue : this.childQueues) {
                childQueue.updateDemand();
                Resource toAdd = childQueue.getDemand();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Counting resource from " + childQueue.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
                }
                this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
                this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
                if (!Resources.equals((Resource)this.demand, (Resource)maxRes)) continue;
                break;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        return QueueUserACLInfo.newInstance((String)this.getQueueName(), operations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        this.readLock.lock();
        try {
            for (FSQueue child : this.childQueues) {
                userAcls.addAll(child.getQueueUserAclInfo(user));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return userAcls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        Resource assigned = Resources.none();
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        this.writeLock.lock();
        try {
            Collections.sort(this.childQueues, this.policy.getComparator());
        }
        finally {
            this.writeLock.unlock();
        }
        this.readLock.lock();
        try {
            for (FSQueue child : this.childQueues) {
                assigned = child.assignContainer(node);
                if (Resources.equals((Resource)assigned, (Resource)Resources.none())) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return assigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMContainer preemptContainer() {
        RMContainer toBePreempted = null;
        FSQueue candidateQueue = null;
        Comparator<Schedulable> comparator = this.policy.getComparator();
        this.readLock.lock();
        try {
            for (FSQueue queue : this.childQueues) {
                if (candidateQueue != null && comparator.compare(queue, candidateQueue) <= 0) continue;
                candidateQueue = queue;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (candidateQueue != null) {
            toBePreempted = candidateQueue.preemptContainer();
        }
        return toBePreempted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FSQueue> getChildQueues() {
        this.readLock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.childQueues);
            return immutableList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        boolean allowed = SchedulingPolicy.isApplicableTo(policy, this.parent == null ? (byte)4 : 2);
        if (!allowed) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRunnableApps() {
        this.writeLock.lock();
        try {
            ++this.runnableApps;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRunnableApps() {
        this.writeLock.lock();
        try {
            --this.runnableApps;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumRunnableApps() {
        this.readLock.lock();
        try {
            int n = this.runnableApps;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        this.readLock.lock();
        try {
            for (FSQueue childQueue : this.childQueues) {
                childQueue.collectSchedulerApplications(apps);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return null;
    }

    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
    }
}

