/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMServerUtils {
    private static final String UPDATE_OUTSTANDING_ERROR = "UPDATE_OUTSTANDING_ERROR";
    private static final String INCORRECT_CONTAINER_VERSION_ERROR = "INCORRECT_CONTAINER_VERSION_ERROR";
    private static final String INVALID_CONTAINER_ID = "INVALID_CONTAINER_ID";
    private static final String RESOURCE_OUTSIDE_ALLOWED_RANGE = "RESOURCE_OUTSIDE_ALLOWED_RANGE";
    protected static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    public static final ApplicationResourceUsageReport DUMMY_APPLICATION_RESOURCE_USAGE_REPORT = BuilderUtils.newApplicationResourceUsageReport((int)-1, (int)-1, (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), (long)0L, (long)0L, (long)0L, (long)0L);

    public static List<RMNode> queryRMNodes(RMContext context, EnumSet<NodeState> acceptedStates) {
        ArrayList<RMNode> results = new ArrayList<RMNode>();
        if (acceptedStates.contains(NodeState.NEW) || acceptedStates.contains(NodeState.RUNNING) || acceptedStates.contains(NodeState.DECOMMISSIONING) || acceptedStates.contains(NodeState.UNHEALTHY)) {
            for (RMNode rmNode : context.getRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        if (acceptedStates.contains(NodeState.DECOMMISSIONED) || acceptedStates.contains(NodeState.LOST) || acceptedStates.contains(NodeState.REBOOTED)) {
            for (RMNode rmNode : context.getInactiveRMNodes().values()) {
                if (rmNode == null || !acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        return results;
    }

    public static List<UpdateContainerError> validateAndSplitUpdateResourceRequests(RMContext rmContext, AllocateRequest request, Resource maximumAllocation, List<UpdateContainerRequest> increaseResourceReqs, List<UpdateContainerRequest> decreaseResourceReqs) {
        ArrayList<UpdateContainerError> errors = new ArrayList<UpdateContainerError>();
        HashSet<ContainerId> outstandingUpdate = new HashSet<ContainerId>();
        for (UpdateContainerRequest updateReq : request.getUpdateRequests()) {
            RMContainer rmContainer = rmContext.getScheduler().getRMContainer(updateReq.getContainerId());
            String msg = null;
            if (rmContainer == null) {
                msg = INVALID_CONTAINER_ID;
            }
            if (msg == null && updateReq.getContainerVersion() != rmContainer.getContainer().getVersion()) {
                msg = "INCORRECT_CONTAINER_VERSION_ERROR|" + updateReq.getContainerVersion() + "|" + rmContainer.getContainer().getVersion();
            }
            if (msg == null && outstandingUpdate.contains(updateReq.getContainerId())) {
                msg = UPDATE_OUTSTANDING_ERROR;
            }
            if (msg == null) {
                Resource original = rmContainer.getContainer().getResource();
                Resource target = updateReq.getCapability();
                if (Resources.fitsIn((Resource)target, (Resource)original)) {
                    if (RMServerUtils.validateIncreaseDecreaseRequest(rmContext, updateReq, maximumAllocation, false)) {
                        decreaseResourceReqs.add(updateReq);
                        outstandingUpdate.add(updateReq.getContainerId());
                    } else {
                        msg = RESOURCE_OUTSIDE_ALLOWED_RANGE;
                    }
                } else if (RMServerUtils.validateIncreaseDecreaseRequest(rmContext, updateReq, maximumAllocation, true)) {
                    increaseResourceReqs.add(updateReq);
                    outstandingUpdate.add(updateReq.getContainerId());
                } else {
                    msg = RESOURCE_OUTSIDE_ALLOWED_RANGE;
                }
            }
            if (msg == null) continue;
            UpdateContainerError updateError = (UpdateContainerError)RECORD_FACTORY.newRecordInstance(UpdateContainerError.class);
            updateError.setReason(msg);
            updateError.setUpdateContainerRequest(updateReq);
            errors.add(updateError);
        }
        return errors;
    }

    public static void normalizeAndValidateRequests(List<ResourceRequest> ask, Resource maximumResource, String queueName, YarnScheduler scheduler, RMContext rmContext) throws InvalidResourceRequestException {
        QueueInfo queueInfo = null;
        try {
            queueInfo = scheduler.getQueueInfo(queueName, false, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ResourceRequest resReq : ask) {
            SchedulerUtils.normalizeAndvalidateRequest(resReq, maximumResource, queueName, scheduler, rmContext, queueInfo);
        }
    }

    public static void checkSchedContainerChangeRequest(SchedContainerChangeRequest request, boolean increase) throws InvalidResourceRequestException {
        RMContext rmContext = request.getRmContext();
        ContainerId containerId = request.getContainerId();
        RMContainer rmContainer = request.getRMContainer();
        Resource targetResource = request.getTargetCapacity();
        Resource originalResource = rmContainer.getAllocatedResource();
        if (increase) {
            if (originalResource.getMemorySize() > targetResource.getMemorySize() || originalResource.getVirtualCores() > targetResource.getVirtualCores()) {
                String msg = "Trying to increase a container, but target resource has some resource < original resource, target=" + targetResource + " original=" + originalResource + " containerId=" + containerId;
                throw new InvalidResourceRequestException(msg);
            }
        } else if (originalResource.getMemorySize() < targetResource.getMemorySize() || originalResource.getVirtualCores() < targetResource.getVirtualCores()) {
            String msg = "Trying to decrease a container, but target resource has some resource > original resource, target=" + targetResource + " original=" + originalResource + " containerId=" + containerId;
            throw new InvalidResourceRequestException(msg);
        }
        ResourceScheduler scheduler = rmContext.getScheduler();
        RMNode rmNode = request.getSchedulerNode().getRMNode();
        if (!Resources.fitsIn((ResourceCalculator)scheduler.getResourceCalculator(), (Resource)scheduler.getClusterResource(), (Resource)targetResource, (Resource)rmNode.getTotalCapability())) {
            String msg = "Target resource=" + targetResource + " of containerId=" + containerId + " is more than node's total resource=" + rmNode.getTotalCapability();
            throw new InvalidResourceRequestException(msg);
        }
    }

    public static void validateBlacklistRequest(ResourceBlacklistRequest blacklistRequest) throws InvalidResourceBlacklistRequestException {
        List plus;
        if (blacklistRequest != null && (plus = blacklistRequest.getBlacklistAdditions()) != null && plus.contains("*")) {
            throw new InvalidResourceBlacklistRequestException("Cannot add * to the blacklist!");
        }
    }

    private static boolean validateIncreaseDecreaseRequest(RMContext rmContext, UpdateContainerRequest request, Resource maximumAllocation, boolean increase) {
        if (request.getCapability().getMemorySize() < 0L || request.getCapability().getMemorySize() > maximumAllocation.getMemorySize()) {
            return false;
        }
        if (request.getCapability().getVirtualCores() < 0 || request.getCapability().getVirtualCores() > maximumAllocation.getVirtualCores()) {
            return false;
        }
        ResourceScheduler scheduler = rmContext.getScheduler();
        ResourceCalculator rc = scheduler.getResourceCalculator();
        Resource targetResource = Resources.normalize((ResourceCalculator)rc, (Resource)request.getCapability(), (Resource)scheduler.getMinimumResourceCapability(), (Resource)scheduler.getMaximumResourceCapability(), (Resource)scheduler.getMinimumResourceCapability());
        request.setCapability(targetResource);
        return true;
    }

    public static void validateContainerReleaseRequest(List<ContainerId> containerReleaseList, ApplicationAttemptId appAttemptId) throws InvalidContainerReleaseException {
        for (ContainerId cId : containerReleaseList) {
            if (appAttemptId.equals((Object)cId.getApplicationAttemptId())) continue;
            throw new InvalidContainerReleaseException("Cannot release container : " + cId.toString() + " not belonging to this application attempt : " + appAttemptId);
        }
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, Log LOG) throws IOException {
        return RMServerUtils.verifyAdminAccess(authorizer, method, "AdminService", LOG);
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, String module, Log LOG) throws IOException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Couldn't get current user", (Throwable)ioe);
            RMAuditLogger.logFailure("UNKNOWN", method, "", "AdminService", "Couldn't get current user");
            throw ioe;
        }
        if (!authorizer.isAdmin(user)) {
            LOG.warn((Object)("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
            RMAuditLogger.logFailure(user.getShortUserName(), method, "", module, "Unauthorized user");
            throw new AccessControlException("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(method + " invoked by user " + user.getShortUserName()));
        }
        return user;
    }

    public static YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (rmAppState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case NEW_SAVING: {
                return YarnApplicationState.NEW_SAVING;
            }
            case SUBMITTED: {
                return YarnApplicationState.SUBMITTED;
            }
            case ACCEPTED: {
                return YarnApplicationState.ACCEPTED;
            }
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case FINISHING: 
            case FINISHED: {
                return YarnApplicationState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static YarnApplicationAttemptState createApplicationAttemptState(RMAppAttemptState rmAppAttemptState) {
        switch (rmAppAttemptState) {
            case NEW: {
                return YarnApplicationAttemptState.NEW;
            }
            case SUBMITTED: {
                return YarnApplicationAttemptState.SUBMITTED;
            }
            case SCHEDULED: {
                return YarnApplicationAttemptState.SCHEDULED;
            }
            case ALLOCATED: {
                return YarnApplicationAttemptState.ALLOCATED;
            }
            case LAUNCHED: {
                return YarnApplicationAttemptState.LAUNCHED;
            }
            case ALLOCATED_SAVING: 
            case LAUNCHED_UNMANAGED_SAVING: {
                return YarnApplicationAttemptState.ALLOCATED_SAVING;
            }
            case RUNNING: {
                return YarnApplicationAttemptState.RUNNING;
            }
            case FINISHING: {
                return YarnApplicationAttemptState.FINISHING;
            }
            case FINISHED: {
                return YarnApplicationAttemptState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationAttemptState.KILLED;
            }
            case FAILED: {
                return YarnApplicationAttemptState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static void processRMProxyUsersConf(Configuration conf) {
        HashMap rmProxyUsers = new HashMap();
        for (Map.Entry entry : conf) {
            String propName = (String)entry.getKey();
            if (!propName.startsWith("yarn.resourcemanager.proxyuser.")) continue;
            rmProxyUsers.put("hadoop.proxyuser." + propName.substring("yarn.resourcemanager.proxyuser.".length()), entry.getValue());
        }
        for (Map.Entry entry : rmProxyUsers.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

