/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;

public class RMNodeStatusEvent
extends RMNodeEvent {
    private final NodeStatus nodeStatus;
    private final NodeHeartbeatResponse latestResponse;
    private List<LogAggregationReport> logAggregationReportsForApps;

    public RMNodeStatusEvent(NodeId nodeId, NodeStatus nodeStatus, NodeHeartbeatResponse latestResponse) {
        this(nodeId, nodeStatus, latestResponse, null);
    }

    public RMNodeStatusEvent(NodeId nodeId, NodeStatus nodeStatus, NodeHeartbeatResponse latestResponse, List<LogAggregationReport> logAggregationReportsForApps) {
        super(nodeId, RMNodeEventType.STATUS_UPDATE);
        this.nodeStatus = nodeStatus;
        this.latestResponse = latestResponse;
        this.logAggregationReportsForApps = logAggregationReportsForApps;
    }

    public NodeHealthStatus getNodeHealthStatus() {
        return this.nodeStatus.getNodeHealthStatus();
    }

    public List<ContainerStatus> getContainers() {
        return this.nodeStatus.getContainersStatuses();
    }

    public NodeHeartbeatResponse getLatestResponse() {
        return this.latestResponse;
    }

    public List<ApplicationId> getKeepAliveAppIds() {
        return this.nodeStatus.getKeepAliveApplications();
    }

    public ResourceUtilization getAggregatedContainersUtilization() {
        return this.nodeStatus.getContainersUtilization();
    }

    public ResourceUtilization getNodeUtilization() {
        return this.nodeStatus.getNodeUtilization();
    }

    public List<LogAggregationReport> getLogAggregationReportsForApps() {
        return this.logAggregationReportsForApps;
    }

    public void setLogAggregationReportsForApps(List<LogAggregationReport> logAggregationReportsForApps) {
        this.logAggregationReportsForApps = logAggregationReportsForApps;
    }

    public List<Container> getNMReportedIncreasedContainers() {
        return this.nodeStatus.getIncreasedContainers() == null ? Collections.EMPTY_LIST : this.nodeStatus.getIncreasedContainers();
    }
}

