/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppSchedulingInfo {
    private static final Log LOG = LogFactory.getLog(AppSchedulingInfo.class);
    private static final Comparator<Priority> COMPARATOR = new Priority.Comparator();
    private static final int EPOCH_BIT_SHIFT = 40;
    private final ApplicationId applicationId;
    private final ApplicationAttemptId applicationAttemptId;
    private final AtomicLong containerIdCounter;
    private final String user;
    private Queue queue;
    private ActiveUsersManager activeUsersManager;
    private boolean pending = true;
    private ResourceUsage appResourceUsage;
    private AtomicBoolean userBlacklistChanged = new AtomicBoolean(false);
    private final Set<String> placesBlacklistedBySystem = new HashSet<String>();
    private Set<String> placesBlacklistedByApp = new HashSet<String>();
    private Set<String> requestedPartitions = new HashSet<String>();
    private final ConcurrentSkipListMap<Priority, Integer> priorities = new ConcurrentSkipListMap(COMPARATOR);
    final Map<Priority, Map<String, ResourceRequest>> resourceRequestMap = new ConcurrentHashMap<Priority, Map<String, ResourceRequest>>();
    final Map<NodeId, Map<Priority, Map<ContainerId, SchedContainerChangeRequest>>> containerIncreaseRequestMap = new ConcurrentHashMap<NodeId, Map<Priority, Map<ContainerId, SchedContainerChangeRequest>>>();

    public AppSchedulingInfo(ApplicationAttemptId appAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, long epoch, ResourceUsage appResourceUsage) {
        this.applicationAttemptId = appAttemptId;
        this.applicationId = appAttemptId.getApplicationId();
        this.queue = queue;
        this.user = user;
        this.activeUsersManager = activeUsersManager;
        this.containerIdCounter = new AtomicLong(epoch << 40);
        this.appResourceUsage = appResourceUsage;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public long getNewContainerId() {
        return this.containerIdCounter.incrementAndGet();
    }

    public synchronized String getQueueName() {
        return this.queue.getQueueName();
    }

    public synchronized boolean isPending() {
        return this.pending;
    }

    public Set<String> getRequestedPartitions() {
        return this.requestedPartitions;
    }

    private synchronized void clearRequests() {
        this.priorities.clear();
        this.resourceRequestMap.clear();
        LOG.info((Object)("Application " + this.applicationId + " requests cleared"));
    }

    public synchronized boolean hasIncreaseRequest(NodeId nodeId) {
        Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
        return requestsOnNode == null ? false : requestsOnNode.size() > 0;
    }

    public synchronized Map<ContainerId, SchedContainerChangeRequest> getIncreaseRequests(NodeId nodeId, Priority priority) {
        Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
        return requestsOnNode == null ? null : requestsOnNode.get(priority);
    }

    public synchronized boolean updateIncreaseRequests(List<SchedContainerChangeRequest> increaseRequests) {
        boolean resourceUpdated = false;
        for (SchedContainerChangeRequest r : increaseRequests) {
            SchedContainerChangeRequest prevChangeRequest;
            if (r.getRMContainer().getState() != RMContainerState.RUNNING) {
                LOG.warn((Object)("rmContainer's state is not RUNNING, for increase request with container-id=" + r.getContainerId()));
                continue;
            }
            try {
                RMServerUtils.checkSchedContainerChangeRequest(r, true);
            }
            catch (YarnException e) {
                LOG.warn((Object)"Error happens when checking increase request, Ignoring.. exception=", (Throwable)e);
                continue;
            }
            NodeId nodeId = r.getRMContainer().getAllocatedNode();
            Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
            if (null == requestsOnNode) {
                requestsOnNode = new TreeMap<Priority, Map<ContainerId, SchedContainerChangeRequest>>();
                this.containerIncreaseRequestMap.put(nodeId, requestsOnNode);
            }
            if (null != (prevChangeRequest = this.getIncreaseRequest(nodeId, r.getPriority(), r.getContainerId()))) {
                if (Resources.equals((Resource)prevChangeRequest.getTargetCapacity(), (Resource)r.getTargetCapacity())) continue;
                this.removeIncreaseRequest(nodeId, prevChangeRequest.getPriority(), prevChangeRequest.getContainerId());
            }
            if (Resources.equals((Resource)r.getTargetCapacity(), (Resource)r.getRMContainer().getAllocatedResource())) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Trying to increase container " + r.getContainerId() + ", target capacity = previous capacity = " + prevChangeRequest + ". Will ignore this increase request."));
                continue;
            }
            resourceUpdated = true;
            this.insertIncreaseRequest(r);
        }
        return resourceUpdated;
    }

    private void insertIncreaseRequest(SchedContainerChangeRequest request) {
        Map<ContainerId, SchedContainerChangeRequest> requestsOnNodeWithPriority;
        NodeId nodeId = request.getNodeId();
        Priority priority = request.getPriority();
        ContainerId containerId = request.getContainerId();
        Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
        if (null == requestsOnNode) {
            requestsOnNode = new HashMap<Priority, Map<ContainerId, SchedContainerChangeRequest>>();
            this.containerIncreaseRequestMap.put(nodeId, requestsOnNode);
        }
        if (null == (requestsOnNodeWithPriority = requestsOnNode.get(priority))) {
            requestsOnNodeWithPriority = new TreeMap<ContainerId, SchedContainerChangeRequest>();
            requestsOnNode.put(priority, requestsOnNodeWithPriority);
            this.incrementPriorityReference(priority);
        }
        requestsOnNodeWithPriority.put(containerId, request);
        String partition = request.getRMContainer().getNodeLabelExpression();
        Resource delta = request.getDeltaCapacity();
        this.appResourceUsage.incPending(partition, delta);
        this.queue.incPendingResource(partition, delta);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added increase request:" + request.getContainerId() + " delta=" + delta));
        }
    }

    private void incrementPriorityReference(Priority priority) {
        Integer priorityCount = this.priorities.get(priority);
        if (priorityCount == null) {
            this.priorities.put(priority, 1);
        } else {
            this.priorities.put(priority, priorityCount + 1);
        }
    }

    private void decrementPriorityReference(Priority priority) {
        Integer priorityCount = this.priorities.get(priority);
        if (priorityCount != null) {
            if (priorityCount > 1) {
                this.priorities.put(priority, priorityCount - 1);
            } else {
                this.priorities.remove(priority);
            }
        }
    }

    public synchronized boolean removeIncreaseRequest(NodeId nodeId, Priority priority, ContainerId containerId) {
        Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
        if (null == requestsOnNode) {
            return false;
        }
        Map<ContainerId, SchedContainerChangeRequest> requestsOnNodeWithPriority = requestsOnNode.get(priority);
        if (null == requestsOnNodeWithPriority) {
            return false;
        }
        SchedContainerChangeRequest request = requestsOnNodeWithPriority.remove(containerId);
        if (requestsOnNodeWithPriority.isEmpty()) {
            requestsOnNode.remove(priority);
            this.decrementPriorityReference(priority);
        }
        if (requestsOnNode.isEmpty()) {
            this.containerIncreaseRequestMap.remove(nodeId);
        }
        if (request == null) {
            return false;
        }
        String partition = request.getRMContainer().getNodeLabelExpression();
        Resource delta = request.getDeltaCapacity();
        this.appResourceUsage.decPending(partition, delta);
        this.queue.decPendingResource(partition, delta);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remove increase request:" + request));
        }
        return true;
    }

    public SchedContainerChangeRequest getIncreaseRequest(NodeId nodeId, Priority priority, ContainerId containerId) {
        Map<Priority, Map<ContainerId, SchedContainerChangeRequest>> requestsOnNode = this.containerIncreaseRequestMap.get(nodeId);
        if (null == requestsOnNode) {
            return null;
        }
        Map<ContainerId, SchedContainerChangeRequest> requestsOnNodeWithPriority = requestsOnNode.get(priority);
        return requestsOnNodeWithPriority == null ? null : requestsOnNodeWithPriority.get(containerId);
    }

    public synchronized boolean updateResourceRequests(List<ResourceRequest> requests, boolean recoverPreemptedRequestForAContainer) {
        boolean anyResourcesUpdated = false;
        for (ResourceRequest request : requests) {
            Priority priority = request.getPriority();
            String resourceName = request.getResourceName();
            this.updateNodeLabels(request);
            Map<String, ResourceRequest> asks = this.resourceRequestMap.get(priority);
            if (asks == null) {
                asks = new ConcurrentHashMap<String, ResourceRequest>();
                this.resourceRequestMap.put(priority, asks);
            }
            ResourceRequest lastRequest = asks.get(resourceName);
            if (recoverPreemptedRequestForAContainer && lastRequest != null) {
                request.setNumContainers(lastRequest.getNumContainers() + 1);
            }
            asks.put(resourceName, request);
            if (!resourceName.equals("*")) continue;
            this.requestedPartitions.add(request.getNodeLabelExpression() == null ? "" : request.getNodeLabelExpression());
            anyResourcesUpdated = true;
            this.updatePendingResources(lastRequest, request, this.queue.getMetrics());
        }
        return anyResourcesUpdated;
    }

    private void updatePendingResources(ResourceRequest lastRequest, ResourceRequest request, QueueMetrics metrics) {
        int lastRequestContainers;
        int n = lastRequestContainers = lastRequest != null ? lastRequest.getNumContainers() : 0;
        if (request.getNumContainers() <= 0) {
            if (lastRequestContainers >= 0) {
                this.decrementPriorityReference(request.getPriority());
            }
            LOG.info((Object)("checking for deactivate of application :" + this.applicationId));
            this.checkForDeactivation();
        } else if (lastRequestContainers <= 0) {
            this.incrementPriorityReference(request.getPriority());
            this.activeUsersManager.activateApplication(this.user, this.applicationId);
        }
        Resource lastRequestCapability = lastRequest != null ? lastRequest.getCapability() : Resources.none();
        metrics.incrPendingResources(request.getNodeLabelExpression(), this.user, request.getNumContainers(), request.getCapability());
        if (lastRequest != null) {
            metrics.decrPendingResources(lastRequest.getNodeLabelExpression(), this.user, lastRequestContainers, lastRequestCapability);
        }
        Resource increasedResource = Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers());
        this.queue.incPendingResource(request.getNodeLabelExpression(), increasedResource);
        this.appResourceUsage.incPending(request.getNodeLabelExpression(), increasedResource);
        if (lastRequest != null) {
            Resource decreasedResource = Resources.multiply((Resource)lastRequestCapability, (double)lastRequestContainers);
            this.queue.decPendingResource(lastRequest.getNodeLabelExpression(), decreasedResource);
            this.appResourceUsage.decPending(lastRequest.getNodeLabelExpression(), decreasedResource);
        }
    }

    private void updateNodeLabels(ResourceRequest request) {
        Priority priority = request.getPriority();
        String resourceName = request.getResourceName();
        if (resourceName.equals("*")) {
            Map<String, ResourceRequest> resourceRequest;
            ResourceRequest previousAnyRequest = this.getResourceRequest(priority, resourceName);
            if ((null == previousAnyRequest || this.hasRequestLabelChanged(previousAnyRequest, request)) && (resourceRequest = this.getResourceRequests(priority)) != null) {
                for (ResourceRequest r : resourceRequest.values()) {
                    if (r.getResourceName().equals("*")) continue;
                    r.setNodeLabelExpression(request.getNodeLabelExpression());
                }
            }
        } else {
            ResourceRequest anyRequest = this.getResourceRequest(priority, "*");
            if (anyRequest != null) {
                request.setNodeLabelExpression(anyRequest.getNodeLabelExpression());
            }
        }
    }

    private boolean hasRequestLabelChanged(ResourceRequest requestOne, ResourceRequest requestTwo) {
        String requestOneLabelExp = requestOne.getNodeLabelExpression();
        String requestTwoLabelExp = requestTwo.getNodeLabelExpression();
        if (null == requestOneLabelExp && null != requestTwoLabelExp) {
            return true;
        }
        return null != requestOneLabelExp && !requestOneLabelExp.equals(requestTwoLabelExp);
    }

    public void updatePlacesBlacklistedByApp(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedByApp, blacklistAdditions, blacklistRemovals)) {
            this.userBlacklistChanged.set(true);
        }
    }

    public void updatePlacesBlacklistedBySystem(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        AppSchedulingInfo.updateBlacklistedPlaces(this.placesBlacklistedBySystem, blacklistAdditions, blacklistRemovals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateBlacklistedPlaces(Set<String> blacklist, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        boolean changed = false;
        Set<String> set = blacklist;
        synchronized (set) {
            if (blacklistAdditions != null) {
                changed = blacklist.addAll(blacklistAdditions);
            }
            if (blacklistRemovals != null) {
                changed = blacklist.removeAll(blacklistRemovals) || changed;
            }
        }
        return changed;
    }

    public boolean getAndResetBlacklistChanged() {
        return this.userBlacklistChanged.getAndSet(false);
    }

    public synchronized Collection<Priority> getPriorities() {
        return this.priorities.keySet();
    }

    public synchronized Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.resourceRequestMap.get(priority);
    }

    public synchronized List<ResourceRequest> getAllResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        for (Map<String, ResourceRequest> r : this.resourceRequestMap.values()) {
            ret.addAll(r.values());
        }
        return ret;
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        Map<String, ResourceRequest> nodeRequests = this.resourceRequestMap.get(priority);
        return nodeRequests == null ? null : nodeRequests.get(resourceName);
    }

    public synchronized Resource getResource(Priority priority) {
        ResourceRequest request = this.getResourceRequest(priority, "*");
        return request == null ? null : request.getCapability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaceBlacklisted(String resourceName, boolean blacklistedBySystem) {
        if (blacklistedBySystem) {
            Set<String> set = this.placesBlacklistedBySystem;
            synchronized (set) {
                return this.placesBlacklistedBySystem.contains(resourceName);
            }
        }
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return this.placesBlacklistedByApp.contains(resourceName);
        }
    }

    public synchronized void increaseContainer(SchedContainerChangeRequest increaseRequest) {
        NodeId nodeId = increaseRequest.getNodeId();
        Priority priority = increaseRequest.getPriority();
        ContainerId containerId = increaseRequest.getContainerId();
        Resource deltaCapacity = increaseRequest.getDeltaCapacity();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocated increase request : applicationId=" + this.applicationId + " container=" + containerId + " host=" + increaseRequest.getNodeId() + " user=" + this.user + " resource=" + deltaCapacity));
        }
        this.queue.getMetrics().allocateResources(increaseRequest.getNodePartition(), this.user, deltaCapacity);
        this.removeIncreaseRequest(nodeId, priority, containerId);
        this.appResourceUsage.incUsed(increaseRequest.getNodePartition(), deltaCapacity);
    }

    public synchronized void decreaseContainer(SchedContainerChangeRequest decreaseRequest) {
        Resource absDelta = Resources.negate((Resource)decreaseRequest.getDeltaCapacity());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Decrease container : applicationId=" + this.applicationId + " container=" + decreaseRequest.getContainerId() + " host=" + decreaseRequest.getNodeId() + " user=" + this.user + " resource=" + absDelta));
        }
        this.queue.getMetrics().releaseResources(decreaseRequest.getNodePartition(), this.user, absDelta);
        this.appResourceUsage.decUsed(decreaseRequest.getNodePartition(), absDelta);
    }

    public synchronized List<ResourceRequest> allocate(NodeType type, SchedulerNode node, Priority priority, ResourceRequest request, Container containerAllocated) {
        ArrayList<ResourceRequest> resourceRequests = new ArrayList<ResourceRequest>();
        if (type == NodeType.NODE_LOCAL) {
            this.allocateNodeLocal(node, priority, request, resourceRequests);
        } else if (type == NodeType.RACK_LOCAL) {
            this.allocateRackLocal(node, priority, request, resourceRequests);
        } else {
            this.allocateOffSwitch(request, resourceRequests);
        }
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationId=" + this.applicationId + " container=" + containerAllocated.getId() + " host=" + containerAllocated.getNodeId().toString() + " user=" + this.user + " resource=" + request.getCapability() + " type=" + (Object)((Object)type)));
        }
        metrics.allocateResources(node.getPartition(), this.user, 1, request.getCapability(), true);
        metrics.incrNodeTypeAggregations(this.user, type);
        return resourceRequests;
    }

    private synchronized void allocateNodeLocal(SchedulerNode node, Priority priority, ResourceRequest nodeLocalRequest, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getNodeName(), priority, nodeLocalRequest);
        ResourceRequest rackLocalRequest = this.resourceRequestMap.get(priority).get(node.getRackName());
        this.decResourceRequest(node.getRackName(), priority, rackLocalRequest);
        ResourceRequest offRackRequest = this.resourceRequestMap.get(priority).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(nodeLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private void decResourceRequest(String resourceName, Priority priority, ResourceRequest request) {
        request.setNumContainers(request.getNumContainers() - 1);
        if (request.getNumContainers() == 0) {
            this.resourceRequestMap.get(priority).remove(resourceName);
        }
    }

    private synchronized void allocateRackLocal(SchedulerNode node, Priority priority, ResourceRequest rackLocalRequest, List<ResourceRequest> resourceRequests) {
        this.decResourceRequest(node.getRackName(), priority, rackLocalRequest);
        ResourceRequest offRackRequest = this.resourceRequestMap.get(priority).get("*");
        this.decrementOutstanding(offRackRequest);
        resourceRequests.add(this.cloneResourceRequest(rackLocalRequest));
        resourceRequests.add(this.cloneResourceRequest(offRackRequest));
    }

    private synchronized void allocateOffSwitch(ResourceRequest offSwitchRequest, List<ResourceRequest> resourceRequests) {
        this.decrementOutstanding(offSwitchRequest);
        resourceRequests.add(this.cloneResourceRequest(offSwitchRequest));
    }

    private synchronized void decrementOutstanding(ResourceRequest offSwitchRequest) {
        int numOffSwitchContainers = offSwitchRequest.getNumContainers() - 1;
        offSwitchRequest.setNumContainers(numOffSwitchContainers);
        if (numOffSwitchContainers == 0) {
            this.decrementPriorityReference(offSwitchRequest.getPriority());
            this.checkForDeactivation();
        }
        this.appResourceUsage.decPending(offSwitchRequest.getNodeLabelExpression(), offSwitchRequest.getCapability());
        this.queue.decPendingResource(offSwitchRequest.getNodeLabelExpression(), offSwitchRequest.getCapability());
    }

    private synchronized void checkForDeactivation() {
        if (this.priorities.isEmpty()) {
            this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        }
    }

    public synchronized void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        for (Map<String, ResourceRequest> asks : this.resourceRequestMap.values()) {
            ResourceRequest request = asks.get("*");
            if (request == null) continue;
            oldMetrics.decrPendingResources(request.getNodeLabelExpression(), this.user, request.getNumContainers(), request.getCapability());
            newMetrics.incrPendingResources(request.getNodeLabelExpression(), this.user, request.getNumContainers(), request.getCapability());
            Resource delta = Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers());
            this.queue.decPendingResource(request.getNodeLabelExpression(), delta);
            newQueue.incPendingResource(request.getNodeLabelExpression(), delta);
        }
        oldMetrics.moveAppFrom(this);
        newMetrics.moveAppTo(this);
        this.activeUsersManager.deactivateApplication(this.user, this.applicationId);
        this.activeUsersManager = newQueue.getActiveUsersManager();
        if (!this.priorities.isEmpty()) {
            this.activeUsersManager.activateApplication(this.user, this.applicationId);
        }
        this.queue = newQueue;
    }

    public synchronized void stop() {
        QueueMetrics metrics = this.queue.getMetrics();
        for (Map<String, ResourceRequest> asks : this.resourceRequestMap.values()) {
            ResourceRequest request = asks.get("*");
            if (request == null) continue;
            metrics.decrPendingResources(request.getNodeLabelExpression(), this.user, request.getNumContainers(), request.getCapability());
            this.queue.decPendingResource(request.getNodeLabelExpression(), Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        metrics.finishAppAttempt(this.applicationId, this.pending, this.user);
        this.clearRequests();
    }

    public synchronized void setQueue(Queue queue) {
        this.queue = queue;
    }

    public Set<String> getBlackList() {
        return this.placesBlacklistedByApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBlackListCopy() {
        Set<String> set = this.placesBlacklistedByApp;
        synchronized (set) {
            return new HashSet<String>(this.placesBlacklistedByApp);
        }
    }

    public synchronized void transferStateFromPreviousAppSchedulingInfo(AppSchedulingInfo appInfo) {
        this.placesBlacklistedByApp = appInfo.getBlackList();
    }

    public synchronized void recoverContainer(RMContainer rmContainer, String partition) {
        QueueMetrics metrics = this.queue.getMetrics();
        if (this.pending) {
            this.pending = false;
            metrics.runAppAttempt(this.applicationId, this.user);
        }
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        metrics.allocateResources(partition, this.user, 1, rmContainer.getAllocatedResource(), false);
    }

    public ResourceRequest cloneResourceRequest(ResourceRequest request) {
        ResourceRequest newRequest = ResourceRequest.newInstance((Priority)request.getPriority(), (String)request.getResourceName(), (Resource)request.getCapability(), (int)1, (boolean)request.getRelaxLocality(), (String)request.getNodeLabelExpression());
        return newRequest;
    }
}

