/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ParameterizedSchedulerTestBase {
    protected static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static final String FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    private SchedulerType schedulerType;
    private YarnConfiguration conf = new YarnConfiguration();
    private AbstractYarnScheduler scheduler = null;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> getParameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public YarnConfiguration getConf() {
        return this.conf;
    }

    public ParameterizedSchedulerTestBase(SchedulerType type) throws IOException {
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        this.schedulerType = type;
        switch (this.schedulerType) {
            case FAIR: {
                this.configureFairScheduler(this.conf);
                this.scheduler = new FairScheduler();
                this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
                break;
            }
            case CAPACITY: {
                this.scheduler = new CapacityScheduler();
                ((CapacityScheduler)this.scheduler).setConf((Configuration)this.conf);
                this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
            }
        }
    }

    protected void configureFairScheduler(YarnConfiguration conf) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queueMaxAMShareDefault>-1.0</queueMaxAMShareDefault>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <weight>1.0</weight>");
        out.println("  <fairSharePreemptionTimeout>100</fairSharePreemptionTimeout>");
        out.println("  <minSharePreemptionTimeout>120</minSharePreemptionTimeout>");
        out.println("  <fairSharePreemptionThreshold>.5</fairSharePreemptionThreshold>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
        conf.setLong("yarn.scheduler.fair.update-interval-ms", 10L);
    }

    public SchedulerType getSchedulerType() {
        return this.schedulerType;
    }

    public AbstractYarnScheduler getScheduler() {
        return this.scheduler;
    }

    public static enum SchedulerType {
        CAPACITY,
        FAIR;

    }
}

