/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.blacklist;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.DisabledBlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.SimpleBlacklistManager;
import org.junit.Assert;
import org.junit.Test;

public class TestBlacklistManager {
    @Test
    public void testSimpleBlacklistBelowFailureThreshold() {
        int numberOfNodeManagerHosts = 3;
        double blacklistDisableFailureThreshold = 0.8;
        SimpleBlacklistManager manager = new SimpleBlacklistManager(3, 0.8);
        String anyNode = "foo";
        String anyNode2 = "bar";
        manager.addNode(anyNode);
        manager.addNode(anyNode2);
        ResourceBlacklistRequest blacklist = manager.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getBlacklistAdditions();
        Collections.sort(blacklistAdditions);
        List blacklistRemovals = blacklist.getBlacklistRemovals();
        Object[] expectedBlacklistAdditions = new String[]{anyNode2, anyNode};
        Assert.assertArrayEquals((String)"Blacklist additions was not as expected", (Object[])expectedBlacklistAdditions, (Object[])blacklistAdditions.toArray());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
    }

    @Test
    public void testSimpleBlacklistAboveFailureThreshold() {
        SimpleBlacklistManager manager = new SimpleBlacklistManager(3, 0.5);
        String anyNode = "foo";
        String anyNode2 = "bar";
        manager.addNode(anyNode);
        ResourceBlacklistRequest blacklist = manager.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getBlacklistAdditions();
        Collections.sort(blacklistAdditions);
        List blacklistRemovals = blacklist.getBlacklistRemovals();
        Object[] expectedBlacklistAdditions = new String[]{anyNode};
        Assert.assertArrayEquals((String)"Blacklist additions was not as expected", (Object[])expectedBlacklistAdditions, (Object[])blacklistAdditions.toArray());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
        manager.addNode(anyNode2);
        blacklist = manager.getBlacklistUpdates();
        blacklistAdditions = blacklist.getBlacklistAdditions();
        Collections.sort(blacklistAdditions);
        blacklistRemovals = blacklist.getBlacklistRemovals();
        Collections.sort(blacklistRemovals);
        Object[] expectedBlacklistRemovals = new String[]{anyNode2, anyNode};
        Assert.assertTrue((String)("Blacklist additions should be empty but was " + blacklistAdditions), (boolean)blacklistAdditions.isEmpty());
        Assert.assertArrayEquals((String)"Blacklist removals was not as expected", (Object[])expectedBlacklistRemovals, (Object[])blacklistRemovals.toArray());
    }

    @Test
    public void testDisabledBlacklist() {
        DisabledBlacklistManager disabled = new DisabledBlacklistManager();
        String anyNode = "foo";
        disabled.addNode(anyNode);
        ResourceBlacklistRequest blacklist = disabled.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getBlacklistAdditions();
        List blacklistRemovals = blacklist.getBlacklistRemovals();
        Assert.assertTrue((String)("Blacklist additions should be empty but was " + blacklistAdditions), (boolean)blacklistAdditions.isEmpty());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
    }
}

