/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestPreemptionForQueueWithPriorities
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testPreemptionForHighestPriorityUnderutilizedQueue() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 40 50]){priority=1};-b(=[30 100 59 50]){priority=2};-c(=[40 100 1 25]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,40,false);b\t(1,1,n1,,59,false);c\t(1,1,n1,,1,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testPreemptionForLowestPriorityUnderutilizedQueue() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 40 50]){priority=1};-b(=[30 100 59 50]){priority=2};-c(=[40 100 1 25]){priority=0}";
        String appsConfig = "a\t(1,1,n1,,40,false);b\t(1,1,n1,,59,false);c\t(1,1,n1,,1,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testPreemptionWontHappenBetweenSatisfiedQueues() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 0 0]){priority=1};-b(=[30 100 40 50]){priority=1};-c(=[40 100 60 25]){priority=2}";
        String appsConfig = "b\t(1,1,n1,,40,false);c\t(1,1,n1,,60,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testPreemptionForMultipleQueuesInTheSamePriorityBuckets() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[10 100 35 50]){priority=1};-b(=[15 100 25 50]){priority=1};-c(=[20 100 39 50]){priority=2};-d(=[25 100 0 0]){priority=2};-e(=[30 100 1 99]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,35,false);b\t(1,1,n1,,25,false);c\t(1,1,n1,,39,false);e\t(1,1,n1,,1,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)23))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)6))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPreemptionForPriorityAndDisablePreemption() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[10 100 35 50]){priority=1,disable_preemption=true};-b(=[15 100 25 50]){priority=1};-c(=[20 100 39 50]){priority=2};-d(=[25 100 0 0]){priority=2};-e(=[30 100 1 99]){priority=2}";
        String appsConfig = "a\t(1,1,n1,,35,false);b\t(1,1,n1,,25,false);c\t(1,1,n1,,39,false);e\t(1,1,n1,,1,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testPriorityPreemptionForHierarchicalOfQueues() throws IOException {
        String labelsConfig = "=100,true";
        String nodesConfig = "n1=";
        String queuesConfig = "root(=[100 100 100 100]);-a(=[30 100 40 50]){priority=1};--a1(=[12 100 20 50]){priority=1};--a2(=[18 100 20 50]){priority=1};-b(=[30 100 59 50]){priority=1};--b1(=[15 100 30 50]){priority=1};--b2(=[15 100 29 50]){priority=2};-c(=[40 100 1 30]){priority=1}";
        String appsConfig = "a1\t(1,1,n1,,20,false);a2\t(1,1,n1,,20,false);b1\t(1,1,n1,,30,false);b2\t(1,1,n1,,29,false);c\t(1,1,n1,,29,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }
}

