/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyForNodePartitions
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testNodePartitionPreemptionRespectGuaranteedCapacity() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 20 50],x=[50 100 80 50]);-b(=[50 100 80 50],x=[50 100 20 50])";
        String appsConfig = "a\t(1,1,n1,x,80,false);a\t(1,1,n2,,20,false);b\t(1,1,n1,x,20,false);b\t(1,1,n2,,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNodePartitionPreemptionNotHappenBetweenSatisfiedQueues() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[80 80 0 0],x=[80 80 0 0]);-b(=[10 100 0 0],x=[10 100 90 50]);-c(=[10 100 0 0],x=[10 30 10 50])";
        String appsConfig = "b\t(1,1,n1,x,90,false);c\t(1,1,n1,x,10,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionOfIgnoreExclusivityAndRespectCapacity() throws IOException {
        String labelsConfig = "=100,true;x=100,false";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[50 100 100 50]);-b(=[50 100 0 0],x=[50 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,1,false)(1,1,n1,,20,false);a\t(1,1,n1,x,79,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionOfSkippingAMContainer() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[20 100 100 50]);-b(=[50 100 0 0],x=[80 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }

    @Test
    public void testNodePartitionPreemptionOfAMContainer() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[3 100 100 50]);-b(=[50 100 0 0],x=[97 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }

    @Test
    public void testNodePartitionDisablePreemptionForSingleLevelQueue() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[80 80 0 0],x=[40 100 50 50]);-b(=[10 100 0 0],x=[20 100 30 0]);-c(=[10 100 0 0],x=[40 100 20 50])";
        String appsConfig = "a\t(1,1,n1,x,50,false);b\t(1,1,n1,x,30,false);c\t(1,1,n1,x,20,false)";
        this.conf.setPreemptionDisabled("root.b", true);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNodePartitionNonAccessibleQueuesSharePartitionedResource() throws IOException {
        String labelsConfig = "=100,true;x=100,false";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[25 100 0 0],x=[50 100 0 30]);-b(=[25 100 0 0],x=[50 100 30 0]);-c(=[25 100 1 0],x=[0 0 35 50]);-d(=[25 100 1 0],x=[0 0 35 50])";
        String appsConfig = "b\t(1,1,n1,x,30,false);c\t(1,1,n2,,1,false)(1,1,n1,,30,false);d\t(1,1,n2,,1,false)(1,1,n1,,30,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testHierarchyPreemptionForMultiplePartitions() throws IOException {
        String labelsConfig = "=100,true;x=100,true;y=100,true";
        String nodesConfig = "n1=x;n2=y;n3=";
        String queuesConfig = "root(=[100 100 0 0],x=[100 100 100 100],y=[100 100 100 100]);-a(=[50 100 0 0],x=[50 100 60 40],y=[50 100 40 40]);--a1(=[25 100 0 0],x=[25 100 35 20],y=[25 100 25 20]);--a2(=[25 100 0 0],x=[25 100 25 20],y=[25 100 15 20]);-b(=[50 100 0 0],x=[50 100 40 40],y=[50 100 60 40]);--b1(=[25 100 0 0],x=[25 100 15 20],y=[25 100 25 20]);--b2(=[25 100 0 0],x=[25 100 25 20],y=[25 100 35 20])";
        String appsConfig = "a1\t(1,1,n1,x,35,false)(1,1,n2,y,25,false);a2\t(1,1,n1,x,25,false)(1,1,n2,y,15,false);b1\t(1,1,n1,x,15,false)(1,1,n2,y,25,false);b2\t(1,1,n1,x,25,false)(1,1,n2,y,35,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testHierarchyPreemptionForDifferenceAcessibility() throws IOException {
        String labelsConfig = "=100,true;x=100,true;y=100,true";
        String nodesConfig = "n1=x;n2=y;n3=";
        String queuesConfig = "root(=[100 100 0 0],x=[100 100 100 100],y=[100 100 100 100]);-a(=[50 100 0 0],x=[100 100 100 100]);--a1(=[25 100 0 0],x=[50 100 100 0]);--a2(=[25 100 0 0],x=[50 100 0 100]);-b(=[50 100 0 0],y=[100 100 80 100]);--b1(=[25 100 0 0],y=[50 100 80 0]);--b2(=[25 100 0 0],y=[50 100 0 100])";
        String appsConfig = "a1\t(1,1,n1,x,100,false);b1\t(1,1,n2,y,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)50))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionWithVCoreResource() throws IOException {
        String labelsConfig = "=100:200,true;x=100:200,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100:200 100:200 100:200 100:200],x=[100:200 100:200 100:200 100:200]);-a(=[50:100 100:200 20:40 50:100],x=[50:100 100:200 80:160 50:100]);-b(=[50:100 100:200 80:160 50:100],x=[50:100 100:200 20:40 50:100])";
        String appsConfig = "a\t(1,1:2,n1,x,80,false);a\t(1,1:2,n2,,20,false);b\t(1,1:2,n1,x,20,false);b\t(1,1:2,n2,,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }
}

