/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUserGroupMappingPlacementRule {
    YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setup() {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    private void verifyQueueMapping(UserGroupMappingPlacementRule.QueueMapping queueMapping, String inputUser, String expectedQueue) throws YarnException {
        this.verifyQueueMapping(queueMapping, inputUser, "default", expectedQueue, false);
    }

    private void verifyQueueMapping(UserGroupMappingPlacementRule.QueueMapping queueMapping, String inputUser, String inputQueue, String expectedQueue, boolean overwrite) throws YarnException {
        Groups groups = new Groups((Configuration)this.conf);
        UserGroupMappingPlacementRule rule = new UserGroupMappingPlacementRule(overwrite, Arrays.asList(queueMapping), groups);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asc.setQueue(inputQueue);
        String queue = rule.getQueueForApp(asc, inputUser);
        Assert.assertEquals((Object)expectedQueue, (Object)queue);
    }

    @Test
    public void testMapping() throws YarnException {
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "a", "q1"), "a", "q1");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.GROUP, "agroup", "q1"), "a", "q1");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "%user", "q2"), "a", "q2");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "%user", "%user"), "a", "a");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "%user", "%primary_group"), "a", "agroup");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.GROUP, "asubgroup1", "q1"), "a", "q1");
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "user", "q1"), "user", "q2", "q1", true);
        this.verifyQueueMapping(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, "user", "q1"), "user", "q2", "q2", false);
    }
}

