/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKRMStateStoreZKClientConnections {
    private Log LOG = LogFactory.getLog(TestZKRMStateStoreZKClientConnections.class);
    private static final int ZK_TIMEOUT_MS = 1000;
    private static final String DIGEST_USER_PASS = "test-user:test-password";
    private static final String TEST_AUTH_GOOD = "digest:test-user:test-password";
    private static final String DIGEST_USER_HASH;
    private static final String TEST_ACL;
    private TestingServer testingServer;

    @Before
    public void setupZKServer() throws Exception {
        this.testingServer = new TestingServer();
        this.testingServer.start();
    }

    @After
    public void cleanupZKServer() throws Exception {
        this.testingServer.stop();
    }

    @Test(timeout=20000L)
    public void testZKClientRetry() throws Exception {
        TestZKClient zkClientTester = new TestZKClient();
        String path = "/test";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.setLong("yarn.resourcemanager.zk-retry-interval-ms", 100L);
        final ZKRMStateStore store = (ZKRMStateStore)zkClientTester.getRMStateStore((Configuration)conf);
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        final AtomicBoolean assertionFailedInThread = new AtomicBoolean(false);
        this.testingServer.stop();
        Thread clientThread = new Thread(){

            @Override
            public void run() {
                try {
                    store.getData("/test");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    assertionFailedInThread.set(true);
                }
            }
        };
        Thread.sleep(2000L);
        this.testingServer.start();
        clientThread.join();
        Assert.assertFalse((boolean)assertionFailedInThread.get());
    }

    @Test(timeout=20000L)
    public void testSetZKAcl() {
        TestZKClient zkClientTester = new TestZKClient();
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.zk-acl", "world:anyone:rwca");
        try {
            zkClientTester.store.delete(zkClientTester.store.znodeWorkingPath);
            Assert.fail((String)"Shouldn't be able to delete path");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=20000L)
    public void testInvalidZKAclConfiguration() {
        TestZKClient zkClientTester = new TestZKClient();
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.zk-acl", "randomstring&*");
        try {
            zkClientTester.getRMStateStore((Configuration)conf);
            Assert.fail((String)"ZKRMStateStore created with bad ACL");
        }
        catch (ZKUtil.BadAclFormatException badAclFormatException) {
        }
        catch (Exception e) {
            String error = "Incorrect exception on BadAclFormat";
            this.LOG.error((Object)error, (Throwable)e);
            Assert.fail((String)error);
        }
    }

    @Test
    public void testZKAuths() throws Exception {
        TestZKClient zkClientTester = new TestZKClient();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-num-retries", 1);
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.set("yarn.resourcemanager.zk-acl", TEST_ACL);
        conf.set("yarn.resourcemanager.zk-auth", TEST_AUTH_GOOD);
        zkClientTester.getRMStateStore((Configuration)conf);
    }

    static {
        try {
            DIGEST_USER_HASH = DigestAuthenticationProvider.generateDigest((String)DIGEST_USER_PASS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        TEST_ACL = "digest:" + DIGEST_USER_HASH + ":rwcda";
    }

    class TestZKClient {
        ZKRMStateStore store;

        TestZKClient() {
        }

        public RMStateStore getRMStateStore(Configuration conf) throws Exception {
            String workingZnode = "/Test";
            conf.set("yarn.resourcemanager.zk-address", TestZKRMStateStoreZKClientConnections.this.testingServer.getConnectString());
            conf.set("yarn.resourcemanager.zk-state-store.parent-path", workingZnode);
            this.store = new TestZKRMStateStore(conf, workingZnode);
            return this.store;
        }

        protected class TestZKRMStateStore
        extends ZKRMStateStore {
            public TestZKRMStateStore(Configuration conf, String workingZnode) throws Exception {
                this.setResourceManager(new ResourceManager());
                this.init(conf);
                this.start();
                Assert.assertTrue((boolean)this.znodeWorkingPath.equals(workingZnode));
            }
        }
    }
}

