/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PriorityQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacitySchedulerPerf {
    private final int GB = 1024;

    private String getResourceName(int idx) {
        return "resource-" + idx;
    }

    private void testUserLimitThroughputWithNumberOfResourceTypes(int numOfResourceTypes) throws Exception {
        if (numOfResourceTypes > 2) {
            HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
            riMap.put("memory-mb", ResourceInformation.MEMORY_MB);
            riMap.put("vcores", ResourceInformation.VCORES);
            for (int i = 2; i < numOfResourceTypes; ++i) {
                String resourceName = this.getResourceName(i);
                riMap.put(resourceName, ResourceInformation.newInstance((String)resourceName, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Integer.MAX_VALUE));
            }
            ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        }
        Assume.assumeTrue((boolean)Boolean.valueOf(System.getProperty("RunCapacitySchedulerPerfTests")));
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root", "", 100.0f);
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root.default", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root.default", "", 100.0f);
        csconf.setResourceComparator(DominantResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue qb = (LeafQueue)cs.getQueue("default");
        qb.setUserLimitFactor(100.0f);
        qb.setupConfigurableCapacities();
        Container container = (Container)Mockito.mock(Container.class);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        int appCount = 100;
        ApplicationId[] appids = new ApplicationId[100];
        RMAppAttemptImpl[] attempts = new RMAppAttemptImpl[100];
        ApplicationAttemptId[] appAttemptIds = new ApplicationAttemptId[100];
        RMAppImpl[] apps = new RMAppImpl[100];
        RMAppAttemptMetrics[] attemptMetrics = new RMAppAttemptMetrics[100];
        for (int i = 0; i < 100; ++i) {
            appids[i] = BuilderUtils.newApplicationId((long)100L, (int)i);
            appAttemptIds[i] = BuilderUtils.newApplicationAttemptId((ApplicationId)appids[i], (int)1);
            attemptMetrics[i] = new RMAppAttemptMetrics(appAttemptIds[i], rm.getRMContext());
            apps[i] = (RMAppImpl)Mockito.mock(RMAppImpl.class);
            Mockito.when((Object)apps[i].getApplicationId()).thenReturn((Object)appids[i]);
            attempts[i] = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
            Mockito.when((Object)attempts[i].getMasterContainer()).thenReturn((Object)container);
            Mockito.when((Object)attempts[i].getSubmissionContext()).thenReturn((Object)submissionContext);
            Mockito.when((Object)attempts[i].getAppAttemptId()).thenReturn((Object)appAttemptIds[i]);
            Mockito.when((Object)attempts[i].getRMAppAttemptMetrics()).thenReturn((Object)attemptMetrics[i]);
            Mockito.when((Object)apps[i].getCurrentAppAttempt()).thenReturn((Object)attempts[i]);
            rm.getRMContext().getRMApps().put(appids[i], apps[i]);
            AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appids[i], "default", "user1");
            cs.handle((SchedulerEvent)addAppEvent);
            AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptIds[i], false);
            cs.handle((SchedulerEvent)addAttemptEvent);
        }
        Resource nodeResource = Resource.newInstance((int)10240, (int)10);
        if (numOfResourceTypes > 2) {
            for (int i = 2; i < numOfResourceTypes; ++i) {
                nodeResource.setResourceValue(this.getResourceName(i), 10L);
            }
        }
        RMNode node = MockNodes.newNodeInfo(0, nodeResource, 1, "127.0.0.1");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        RMNode node2 = MockNodes.newNodeInfo(0, nodeResource, 1, "127.0.0.2");
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node2));
        Priority u0Priority = TestUtils.createMockPriority(1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        FiCaSchedulerApp[] fiCaApps = new FiCaSchedulerApp[100];
        for (int i = 0; i < 100; ++i) {
            fiCaApps[i] = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(apps[i].getApplicationId())).getCurrentAppAttempt();
            ResourceRequest resourceRequest = TestUtils.createResourceRequest("*", 1024, 1, true, u0Priority, recordFactory);
            if (numOfResourceTypes > 2) {
                for (int j = 2; j < numOfResourceTypes; ++j) {
                    resourceRequest.getCapability().setResourceValue(this.getResourceName(j), 10L);
                }
            }
            fiCaApps[i].updateResourceRequests(Collections.singletonList(resourceRequest));
        }
        qb.setUserLimitFactor(0.0f);
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            logger.setLevel(Level.WARN);
        }
        int topn = 20;
        int iterations = 2000000;
        int printInterval = 20000;
        float numerator = 2.0E7f;
        PriorityQueue queue = new PriorityQueue(20, Collections.reverseOrder());
        long n = Time.monotonicNow();
        long timespent = 0L;
        for (int i = 0; i < 2000000; i += 2) {
            if (i > 0 && i % 20000 == 0) {
                long ts = Time.monotonicNow() - n;
                if (queue.size() < 20) {
                    queue.offer(ts);
                } else {
                    Long last = (Long)queue.peek();
                    if (last > ts) {
                        queue.poll();
                        queue.offer(ts);
                    }
                }
                System.out.println(i + " " + 2.0E7f / (float)ts);
                n = Time.monotonicNow();
            }
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(node2));
        }
        timespent = 0L;
        int entries = queue.size();
        while (queue.size() > 0) {
            long l = (Long)queue.poll();
            timespent += l;
        }
        System.out.println("#ResourceTypes = " + numOfResourceTypes + ". Avg of fastest " + entries + ": " + 2.0E7f / (float)(timespent / (long)entries));
        rm.stop();
    }

    @Test(timeout=300000L)
    public void testUserLimitThroughputForTwoResources() throws Exception {
        this.testUserLimitThroughputWithNumberOfResourceTypes(2);
    }

    @Test(timeout=300000L)
    public void testUserLimitThroughputForThreeResources() throws Exception {
        this.testUserLimitThroughputWithNumberOfResourceTypes(3);
    }

    @Test(timeout=300000L)
    public void testUserLimitThroughputForFourResources() throws Exception {
        this.testUserLimitThroughputWithNumberOfResourceTypes(4);
    }

    @Test(timeout=300000L)
    public void testUserLimitThroughputForFiveResources() throws Exception {
        this.testUserLimitThroughputWithNumberOfResourceTypes(5);
    }
}

