/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueStateManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FairOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestLeafQueue {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final Log LOG = LogFactory.getLog(TestLeafQueue.class);
    RMContext rmContext;
    RMContext spyRMContext;
    ResourceRequest amResourceRequest;
    CapacityScheduler cs;
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    CSQueue root;
    Map<String, CSQueue> queues;
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private final ResourceCalculator dominantResourceCalculator = new DominantResourceCalculator();
    private static final String A = "a";
    private static final String B = "b";
    private static final String C = "c";
    private static final String C1 = "c1";
    private static final String D = "d";
    private static final String E = "e";

    @Before
    public void setUp() throws Exception {
        this.setUpInternal(this.resourceCalculator);
    }

    private void setUpWithDominantResourceCalculator() throws Exception {
        this.setUpInternal(this.dominantResourceCalculator);
    }

    private void setUpInternal(ResourceCalculator rC) throws Exception {
        CapacityScheduler spyCs = new CapacityScheduler();
        this.queues = new HashMap<String, CSQueue>();
        this.cs = (CapacityScheduler)Mockito.spy((Object)spyCs);
        this.rmContext = TestUtils.getMockRMContext();
        this.spyRMContext = (RMContext)Mockito.spy((Object)this.rmContext);
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)Matchers.any())).thenReturn(null);
        this.amResourceRequest = (ResourceRequest)Mockito.mock(ResourceRequest.class);
        Mockito.when((Object)this.amResourceRequest.getCapability()).thenReturn((Object)Resources.createResource((int)0, (int)0));
        Mockito.when((Object)rmApp.getAMResourceRequests()).thenReturn(Collections.singletonList(this.amResourceRequest));
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        Mockito.when((Object)this.spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.csConf.setBoolean("yarn.scheduler.capacity.reservations-continue-look-all-nodes", false);
        String newRoot = "root" + System.currentTimeMillis();
        this.setupQueueConfiguration(this.csConf, newRoot);
        YarnConfiguration conf = new YarnConfiguration();
        this.cs.setConf((Configuration)conf);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)this.csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)rC);
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)this.rmContext);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)this.csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        this.root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", this.queues, this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        ResourceUsage queueResUsage = this.root.getQueueResourceUsage();
        Mockito.when((Object)this.csContext.getClusterResourceUsage()).thenReturn((Object)queueResUsage);
        this.cs.setRMContext(this.spyRMContext);
        this.cs.init((Configuration)this.csConf);
        this.cs.setResourceCalculator(rC);
        this.cs.start();
        Mockito.when((Object)this.spyRMContext.getScheduler()).thenReturn((Object)this.cs);
        Mockito.when((Object)this.spyRMContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        Mockito.when((Object)this.cs.getNumClusterNodes()).thenReturn((Object)3);
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf, String newRoot) {
        conf.setQueues("root", new String[]{newRoot});
        conf.setMaximumCapacity("root", 100.0f);
        conf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_newRoot = "root." + newRoot;
        conf.setQueues(Q_newRoot, new String[]{A, B, C, D, E});
        conf.setCapacity(Q_newRoot, 100.0f);
        conf.setMaximumCapacity(Q_newRoot, 100.0f);
        conf.setAcl(Q_newRoot, QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_A = Q_newRoot + "." + A;
        conf.setCapacity(Q_A, 8.5f);
        conf.setMaximumCapacity(Q_A, 20.0f);
        conf.setAcl(Q_A, QueueACL.SUBMIT_APPLICATIONS, "*");
        String Q_B = Q_newRoot + "." + B;
        conf.setCapacity(Q_B, 80.0f);
        conf.setMaximumCapacity(Q_B, 99.0f);
        conf.setAcl(Q_B, QueueACL.SUBMIT_APPLICATIONS, "*");
        String Q_C = Q_newRoot + "." + C;
        conf.setCapacity(Q_C, 1.5f);
        conf.setMaximumCapacity(Q_C, 10.0f);
        conf.setAcl(Q_C, QueueACL.SUBMIT_APPLICATIONS, " ");
        conf.setQueues(Q_C, new String[]{C1});
        String Q_C1 = Q_C + "." + C1;
        conf.setCapacity(Q_C1, 100.0f);
        String Q_D = Q_newRoot + "." + D;
        conf.setCapacity(Q_D, 9.0f);
        conf.setMaximumCapacity(Q_D, 11.0f);
        conf.setAcl(Q_D, QueueACL.SUBMIT_APPLICATIONS, "user_d");
        String Q_E = Q_newRoot + "." + E;
        conf.setCapacity(Q_E, 1.0f);
        conf.setMaximumCapacity(Q_E, 1.0f);
        conf.setAcl(Q_E, QueueACL.SUBMIT_APPLICATIONS, "user_e");
    }

    static LeafQueue stubLeafQueue(LeafQueue queue) {
        CSQueue parent = queue.getParent();
        ((CSQueue)Mockito.doNothing().when((Object)parent)).completedContainer((Resource)Matchers.any(Resource.class), (FiCaSchedulerApp)Matchers.any(FiCaSchedulerApp.class), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), (RMContainer)Matchers.any(RMContainer.class), (ContainerStatus)Matchers.any(ContainerStatus.class), (RMContainerEventType)Matchers.any(RMContainerEventType.class), (CSQueue)Matchers.any(CSQueue.class), Matchers.anyBoolean());
        ((CSQueue)Mockito.doReturn((Object)true).when((Object)parent)).accept((Resource)Matchers.any(Resource.class), (ResourceCommitRequest)Matchers.any(ResourceCommitRequest.class));
        ((CSQueue)Mockito.doNothing().when((Object)parent)).apply((Resource)Matchers.any(Resource.class), (ResourceCommitRequest)Matchers.any(ResourceCommitRequest.class));
        return queue;
    }

    @Test
    public void testInitializeQueue() throws Exception {
        float epsilon = 1.0E-5f;
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        Assert.assertEquals((double)0.085, (double)a.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.085, (double)a.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.2, (double)a.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.2, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        Assert.assertEquals((double)0.8, (double)b.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.8, (double)b.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.99, (double)b.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.99, (double)b.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
        ParentQueue c = (ParentQueue)this.queues.get(C);
        Assert.assertEquals((double)0.015, (double)c.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.015, (double)c.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.1, (double)c.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.1, (double)c.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
        Resource clusterResource = Resource.newInstance((int)51200, (int)50);
        a.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)a.calculateAndGetAMResourceLimit());
        b.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((Object)Resource.newInstance((int)5120, (int)1), (Object)b.calculateAndGetAMResourceLimit());
    }

    @Test
    public void testSingleQueueOneUserMetrics() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)((int)((float)node_0.getTotalResource().getMemorySize() * a.getCapacity()) - 1024), (long)a.getMetrics().getAvailableMB());
    }

    @Test
    public void testUserQueueAcl() throws Exception {
        LeafQueue d = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(D));
        String user_d = "user_d";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 1);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_d", (Queue)d, null, this.spyRMContext);
        d.submitApplicationAttempt(app_0, "user_d");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(0, 2);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_d", (Queue)d, null, this.spyRMContext);
        d.submitApplicationAttempt(app_1, "user_d");
    }

    @Test
    public void testPolicyConfiguration() throws Exception {
        CapacitySchedulerConfiguration testConf = new CapacitySchedulerConfiguration();
        String tproot = "root.testPolicyRoot" + System.currentTimeMillis();
        OrderingPolicy comPol = testConf.getAppOrderingPolicy(tproot);
    }

    @Test
    public void testAppAttemptMetrics() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appAttemptId_0.getApplicationId(), a.getQueueName(), "user_0");
        this.cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId_0, false);
        this.cs.handle((SchedulerEvent)addAttemptEvent);
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.FAILED, false);
        this.cs.handle((SchedulerEvent)event);
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsPending());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsFailed());
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(0, 2);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, null, this.spyRMContext);
        app_1.setAMResource(Resource.newInstance((int)100, (int)1));
        a.submitApplicationAttempt(app_1, "user_0");
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsSubmitted());
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsPending());
        Assert.assertEquals((long)1L, (long)a.getUser("user_0").getActiveApplications());
        Assert.assertEquals((long)app_1.getAMResource().getMemorySize(), (long)a.getMetrics().getUsedAMResourceMB());
        Assert.assertEquals((long)app_1.getAMResource().getVirtualCores(), (long)a.getMetrics().getUsedAMResourceVCores());
        event = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(appAttemptId_0.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsSubmitted());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsPending());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsFailed());
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsCompleted());
        QueueMetrics userMetrics = a.getMetrics().getUserMetrics("user_0");
        Assert.assertEquals((long)1L, (long)userMetrics.getAppsSubmitted());
    }

    @Test
    public void testFairConfiguration() throws Exception {
        CapacitySchedulerConfiguration testConf = new CapacitySchedulerConfiguration();
        String tproot = "root.testPolicyRoot" + System.currentTimeMillis();
        OrderingPolicy schedOrder = testConf.getAppOrderingPolicy(tproot);
        String policyType = "yarn.scheduler.capacity." + tproot + "." + "ordering-policy";
        testConf.set(policyType, "fair");
        schedOrder = testConf.getAppOrderingPolicy(tproot);
        FairOrderingPolicy fop = (FairOrderingPolicy)schedOrder;
        Assert.assertFalse((boolean)fop.getSizeBasedWeight());
        String sbwConfig = "yarn.scheduler.capacity." + tproot + "." + "ordering-policy" + "." + "fair.enable-size-based-weight";
        testConf.set(sbwConfig, "true");
        schedOrder = testConf.getAppOrderingPolicy(tproot);
        fop = (FairOrderingPolicy)schedOrder;
        Assert.assertTrue((boolean)fop.getSizeBasedWeight());
    }

    @Test
    public void testSingleQueueWithOneUser() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        AbstractUsersManager activeUserManager = a.getAbstractUsersManager();
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, activeUserManager, this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, activeUserManager, this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAvailableMB());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        a.setUserLimitFactor(10.0f);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAllocatedMB());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        a.setMaxCapacity(0.5f);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        for (RMContainer rmContainer : app_1.getLiveContainers()) {
            a.completedContainer(clusterResource, app_1, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        Assert.assertEquals((long)0L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)((int)(a.getCapacity() * (float)node_0.getTotalResource().getMemorySize())), (long)a.getMetrics().getAvailableMB());
    }

    @Test
    public void testDRFUsageRatioRounding() throws Exception {
        this.setUpWithDominantResourceCalculator();
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        String user0 = "user_0";
        ApplicationAttemptId appAttemptId0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app0 = new FiCaSchedulerApp(appAttemptId0, "user_0", (Queue)b, b.getAbstractUsersManager(), this.spyRMContext);
        b.submitApplicationAttempt(app0, "user_0");
        String host0 = "127.0.0.1";
        FiCaSchedulerNode node0 = TestUtils.getMockNode(host0, DEFAULT_RACK, 0, 81920, 100);
        int numNodes = 1000;
        Resource clusterResource = Resources.createResource((int)(numNodes * 81920), (int)(numNodes * 100));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        b.setUserLimit(50);
        b.setUserLimitFactor(1000000.0f);
        b.setMaxCapacity(1.0f);
        b.setAbsoluteCapacity(1.0E-5f);
        Priority priority2 = TestUtils.createMockPriority(1);
        app0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 20480, 29, 1, true, priority2, this.recordFactory, "")));
        CSAssignment assign = b.assignContainers(clusterResource, node0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        app0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 10240, 29, 2, true, priority2, this.recordFactory, "")));
        assign = b.assignContainers(clusterResource, node0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        Assert.assertTrue((String)"Still within limits, should assign", (assign.getResource().getMemorySize() > 0L ? 1 : 0) != 0);
    }

    private void applyCSAssignment(Resource clusterResource, CSAssignment assign, LeafQueue q, Map<NodeId, FiCaSchedulerNode> nodes, Map<ApplicationAttemptId, FiCaSchedulerApp> apps) throws IOException {
        TestUtils.applyResourceCommitRequest(clusterResource, assign, nodes, apps);
    }

    @Test
    public void testDRFUserLimits() throws Exception {
        CSAssignment assign;
        this.setUpWithDominantResourceCalculator();
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        b.setMaxCapacity(1.0f);
        String user0 = "user_0";
        String user1 = "user_1";
        ApplicationAttemptId appAttemptId0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app0 = new FiCaSchedulerApp(appAttemptId0, "user_0", (Queue)b, b.getAbstractUsersManager(), this.spyRMContext);
        b.submitApplicationAttempt(app0, "user_0");
        ApplicationAttemptId appAttemptId2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app2 = new FiCaSchedulerApp(appAttemptId2, "user_1", (Queue)b, b.getAbstractUsersManager(), this.spyRMContext);
        b.submitApplicationAttempt(app2, "user_1");
        String host0 = "127.0.0.1";
        FiCaSchedulerNode node0 = TestUtils.getMockNode(host0, DEFAULT_RACK, 0, 8192, 100);
        String host1 = "127.0.0.2";
        FiCaSchedulerNode node1 = TestUtils.getMockNode(host1, DEFAULT_RACK, 0, 8192, 100);
        ImmutableMap nodes = ImmutableMap.of((Object)node0.getNodeID(), (Object)node0, (Object)node1.getNodeID(), (Object)node1);
        ImmutableMap apps = ImmutableMap.of((Object)app0.getApplicationAttemptId(), (Object)app0, (Object)app2.getApplicationAttemptId(), (Object)app2);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)(numNodes * 8192), (int)(numNodes * 100));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Priority priority2 = TestUtils.createMockPriority(1);
        app0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 40, 10, true, priority2, this.recordFactory, "")));
        app2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 10, 10, true, priority2, this.recordFactory, "")));
        b.setUserLimit(50);
        b.setUserLimitFactor(2.0f);
        UsersManager.User queueUser0 = b.getUser("user_0");
        UsersManager.User queueUser1 = b.getUser("user_1");
        Assert.assertEquals((String)"There should 2 active users!", (long)2L, (long)b.getAbstractUsersManager().getNumActiveUsers());
        do {
            assign = b.assignContainers(clusterResource, node0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            LOG.info((Object)assign.toString());
            this.applyCSAssignment(clusterResource, assign, b, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        } while (assign.getResource().getMemorySize() > 0L && assign.getAssignmentInformation().getNumReservations() == 0);
        do {
            assign = b.assignContainers(clusterResource, node1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            this.applyCSAssignment(clusterResource, assign, b, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        } while (assign.getResource().getMemorySize() > 0L && assign.getAssignmentInformation().getNumReservations() == 0);
        Assert.assertTrue((String)"Verify user_0 got resources ", (queueUser0.getUsed().getMemorySize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Verify user_1 got resources ", (queueUser1.getUsed().getMemorySize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected AbsoluteUsedCapacity > 0.95, got: " + b.getAbsoluteUsedCapacity()), ((double)b.getAbsoluteUsedCapacity() > 0.95 ? 1 : 0) != 0);
        float expectedRatio = (float)queueUser0.getUsed().getVirtualCores() / ((float)numNodes * 100.0f) + (float)queueUser1.getUsed().getMemorySize() / ((float)numNodes * 8.0f * 1024.0f);
        Assert.assertEquals((double)expectedRatio, (double)b.getUsersManager().getUsageRatio(""), (double)0.001);
        numNodes = 3;
        clusterResource = Resources.createResource((int)(numNodes * 8192), (int)(numNodes * 100));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        expectedRatio = (float)queueUser0.getUsed().getVirtualCores() / ((float)numNodes * 100.0f) + (float)queueUser1.getUsed().getMemorySize() / ((float)numNodes * 8.0f * 1024.0f);
        Assert.assertEquals((double)expectedRatio, (double)b.getUsersManager().getUsageRatio(""), (double)0.001);
    }

    @Test
    public void testUserLimits() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 2, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        a.setUserLimit(50);
        a.setUserLimitFactor(2.0f);
        Assert.assertEquals((long)2L, (long)a.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)7168L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)6144L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((String)"There should only be 1 active user!", (long)1L, (long)a.getAbstractUsersManager().getNumActiveUsers());
    }

    @Test
    public void testUserSpecificUserLimits() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        this.csConf.setUserLimit(a.getQueuePath(), 50);
        this.csConf.setFloat("yarn.scheduler.capacity." + a.getQueuePath() + ".user-settings.user_0." + "weight", 1.5f);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Assert.assertNull(a.getUserWeights().get("user_0"));
        a.reinitialize((CSQueue)a, this.csContext.getClusterResource());
        Assert.assertEquals((double)1.5, (double)((Float)a.getUserWeights().get("user_0")).floatValue(), (double)0.0);
        a.setMaxCapacity(1.0f);
        a.setUserLimit(50);
        a.setUserLimitFactor(2.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        a.getUsersManager().getUserAndAddIfAbsent("user_0").setWeight(1.5f);
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 4096, 3, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        Assert.assertEquals((long)2L, (long)a.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)9216L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)((Resource)app_0.getTotalPendingRequestsPerPartition().get("")).getMemorySize());
        Assert.assertEquals((long)1024L, (long)((Resource)app_1.getTotalPendingRequestsPerPartition().get("")).getMemorySize());
    }

    @Test
    public void testComputeUserLimitAndSetHeadroom() throws IOException {
        LeafQueue qb = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        qb.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        CapacitySchedulerQueueManager mockCapacitySchedulerQueueManager = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        QueueStateManager mockQueueStateManager = (QueueStateManager)Mockito.mock(QueueStateManager.class);
        Mockito.when((Object)mockCapacitySchedulerQueueManager.getQueueStateManager()).thenReturn((Object)mockQueueStateManager);
        Mockito.when((Object)this.csContext.getCapacitySchedulerQueueManager()).thenReturn((Object)mockCapacitySchedulerQueueManager);
        qb.setUserLimit(100);
        qb.setUserLimitFactor(1.0f);
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)qb, qb.getAbstractUsersManager(), this.spyRMContext);
        HashMap<ApplicationAttemptId, FiCaSchedulerApp> apps = new HashMap<ApplicationAttemptId, FiCaSchedulerApp>();
        apps.put(app_0.getApplicationAttemptId(), app_0);
        qb.submitApplicationAttempt(app_0, "user_0");
        Priority u0Priority = TestUtils.createMockPriority(1);
        SchedulerRequestKey u0SchedKey = TestUtils.toSchedulerKey(u0Priority);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 4096, 1, true, u0Priority, this.recordFactory)));
        Assert.assertEquals((String)"There should only be 1 active user!", (long)1L, (long)qb.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, qb.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), qb, (Map<NodeId, FiCaSchedulerNode>)nodes, apps);
        qb.computeUserLimitAndSetHeadroom(app_0, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        Assert.assertEquals((long)9216L, (long)app_0.getHeadroom().getMemorySize());
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)qb, qb.getAbstractUsersManager(), this.spyRMContext);
        apps.put(app_2.getApplicationAttemptId(), app_2);
        Priority u1Priority = TestUtils.createMockPriority(2);
        SchedulerRequestKey u1SchedKey = TestUtils.toSchedulerKey(u1Priority);
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 4096, 1, true, u1Priority, this.recordFactory)));
        qb.submitApplicationAttempt(app_2, "user_1");
        this.applyCSAssignment(clusterResource, qb.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), qb, (Map<NodeId, FiCaSchedulerNode>)nodes, apps);
        qb.computeUserLimitAndSetHeadroom(app_0, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        Assert.assertEquals((long)8192L, (long)qb.getUsedResources().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)8192L, (long)app_2.getHeadroom().getMemorySize());
        qb.finishApplication(app_0.getApplicationId(), "user_0");
        qb.finishApplication(app_2.getApplicationId(), "user_1");
        qb.releaseResource(clusterResource, app_0, Resource.newInstance((int)4096, (int)1), null, null);
        qb.releaseResource(clusterResource, app_2, Resource.newInstance((int)4096, (int)1), null, null);
        qb.setUserLimit(50);
        qb.setUserLimitFactor(1.0f);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)qb, qb.getAbstractUsersManager(), this.spyRMContext);
        apps.put(app_1.getApplicationAttemptId(), app_1);
        ApplicationAttemptId appAttemptId_3 = TestUtils.getMockApplicationAttemptId(3, 0);
        FiCaSchedulerApp app_3 = new FiCaSchedulerApp(appAttemptId_3, "user_1", (Queue)qb, qb.getAbstractUsersManager(), this.spyRMContext);
        apps.put(app_3.getApplicationAttemptId(), app_3);
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, u0Priority, this.recordFactory)));
        app_3.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, u1Priority, this.recordFactory)));
        qb.submitApplicationAttempt(app_1, "user_0");
        qb.submitApplicationAttempt(app_3, "user_1");
        this.applyCSAssignment(clusterResource, qb.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), qb, (Map<NodeId, FiCaSchedulerNode>)nodes, apps);
        this.applyCSAssignment(clusterResource, qb.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), qb, (Map<NodeId, FiCaSchedulerNode>)nodes, apps);
        qb.computeUserLimitAndSetHeadroom(app_3, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        Assert.assertEquals((long)4096L, (long)qb.getUsedResources().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_3.getHeadroom().getMemorySize());
        Assert.assertEquals((long)5120L, (long)app_1.getHeadroom().getMemorySize());
        ApplicationAttemptId appAttemptId_4 = TestUtils.getMockApplicationAttemptId(4, 0);
        FiCaSchedulerApp app_4 = new FiCaSchedulerApp(appAttemptId_4, "user_0", (Queue)qb, qb.getAbstractUsersManager(), this.spyRMContext);
        apps.put(app_4.getApplicationAttemptId(), app_4);
        qb.submitApplicationAttempt(app_4, "user_0");
        app_4.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 6144, 1, true, u0Priority, this.recordFactory)));
        this.applyCSAssignment(clusterResource, qb.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), qb, (Map<NodeId, FiCaSchedulerNode>)nodes, apps);
        qb.computeUserLimitAndSetHeadroom(app_4, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        qb.computeUserLimitAndSetHeadroom(app_3, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, null);
        Assert.assertEquals((long)6144L, (long)app_3.getHeadroom().getMemorySize());
        Assert.assertEquals((long)10240L, (long)qb.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_4.getHeadroom().getMemorySize());
    }

    @Test
    public void testUserHeadroomMultiApp() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_2, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 16384);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 16384);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1, (Object)app_2.getApplicationAttemptId(), (Object)app_2);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)32768, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getHeadroom().getMemorySize());
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getHeadroom().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getHeadroom().getMemorySize());
        RMContainer rmContainer = (RMContainer)app_0.getLiveContainers().iterator().next();
        a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        Assert.assertEquals((long)2048L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getHeadroom().getMemorySize());
    }

    @Test
    public void testHeadroomWithMaxCap() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_2, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1, (Object)app_2.getApplicationAttemptId(), (Object)app_2);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 2048, 1, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        a.setUserLimit(50);
        a.setUserLimitFactor(2.0f);
        Assert.assertEquals((String)"There should only be 1 active user!", (long)1L, (long)a.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getHeadroom().getMemorySize());
        a.setMaxCapacity(0.1f);
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory)));
        Assert.assertEquals((long)2L, (long)a.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getHeadroom().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemorySize());
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 0, true, priority2, this.recordFactory)));
        Assert.assertEquals((long)1L, (long)a.getAbstractUsersManager().getNumActiveUsers());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)app_2.getHeadroom().getMemorySize());
    }

    @Test
    public void testSingleQueueWithMultipleUsers() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        String user_2 = "user_2";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_2, "user_1");
        ApplicationAttemptId appAttemptId_3 = TestUtils.getMockApplicationAttemptId(3, 0);
        FiCaSchedulerApp app_3 = new FiCaSchedulerApp(appAttemptId_3, "user_2", (Queue)a, a.getAbstractUsersManager(), this.spyRMContext);
        a.submitApplicationAttempt(app_3, "user_2");
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1, (Object)app_2.getApplicationAttemptId(), (Object)app_2, (Object)app_3.getApplicationAttemptId(), (Object)app_3);
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 10, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 10, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        a.setUserLimit(25);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 3072, 1, true, priority2, this.recordFactory)));
        app_3.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        a.setUserLimitFactor(10.0f);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        a.setMaxCapacity(0.5f);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        a.setMaxCapacity(1.0f);
        a.setUserLimitFactor(1.0f);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)7168L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemorySize());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemorySize());
        for (RMContainer rmContainer : app_2.getLiveContainers()) {
            a.completedContainer(clusterResource, app_2, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemorySize());
        for (RMContainer rmContainer : app_3.getLiveContainers()) {
            a.completedContainer(clusterResource, app_3, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        Assert.assertEquals((long)0L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
    }

    @Test
    public void testReservation() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 4096);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)8192, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 4096, 1, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAvailableMB());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        RMContainer rmContainer = (RMContainer)app_0.getLiveContainers().iterator().next();
        a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)1024L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        rmContainer = (RMContainer)app_0.getLiveContainers().iterator().next();
        a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)4096L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
    }

    @Test
    public void testReservationExchange() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setMaxCapacity(1.0f);
        a.setUserLimitFactor(10.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 4096);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, DEFAULT_RACK, 0, 4096);
        Mockito.when((Object)this.csContext.getNode(node_0.getNodeID())).thenReturn((Object)node_0);
        Mockito.when((Object)this.csContext.getNode(node_1.getNodeID())).thenReturn((Object)node_1);
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resource.newInstance((int)8, (int)1));
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)12288, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)4096, (int)16));
        Mockito.when((Object)a.getMaximumAllocation()).thenReturn((Object)Resources.createResource((int)4096, (int)16));
        Mockito.when((Object)Float.valueOf(a.getMinimumAllocationFactor())).thenReturn((Object)Float.valueOf(0.25f));
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 4096, 1, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)2048L, (long)node_0.getAllocatedResource().getMemorySize());
        RMContainer rmContainer = (RMContainer)app_0.getLiveContainers().iterator().next();
        a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)1024L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)1L, (long)app_1.getReReservations(TestUtils.toSchedulerKey(priority2)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)1024L, (long)node_0.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_1.getReReservations(TestUtils.toSchedulerKey(priority2)));
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)9216L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)4096L, (long)node_1.getAllocatedResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)app_1.getReReservations(TestUtils.toSchedulerKey(priority2)));
        rmContainer = (RMContainer)app_0.getLiveContainers().iterator().next();
        a.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentReservation().getMemorySize());
        Assert.assertEquals((long)0L, (long)node_0.getAllocatedResource().getMemorySize());
    }

    private void verifyContainerAllocated(CSAssignment assignment, NodeType nodeType) {
        Assert.assertTrue((boolean)Resources.greaterThan((ResourceCalculator)this.resourceCalculator, null, (Resource)assignment.getResource(), (Resource)Resources.none()));
        Assert.assertTrue((assignment.getAssignmentInformation().getNumAllocations() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)nodeType, (Object)assignment.getType());
    }

    private void verifyNoContainerAllocated(CSAssignment assignment) {
        Assert.assertTrue((boolean)Resources.equals((Resource)assignment.getResource(), (Resource)Resources.none()));
        Assert.assertTrue((assignment.getAssignmentInformation().getNumAllocations() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLocalityScheduling() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, user_0);
        String host_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, rack_0, 0, 8192);
        String host_1 = "127.0.0.2";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, rack_1, 0, 8192);
        String host_2 = "127.0.0.3";
        String rack_2 = "rack_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, rack_2, 0, 8192);
        String host_3 = "127.0.0.4";
        FiCaSchedulerNode node_3 = TestUtils.getMockNode(host_3, rack_1, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2, (Object)node_3.getNodeID(), (Object)node_3);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority2 = TestUtils.createMockPriority(1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        CSAssignment assignment = null;
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)2L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)3L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.OFF_SWITCH);
        Assert.assertEquals((long)4L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 3, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 4, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        Assert.assertEquals((long)4L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        ((LeafQueue)Mockito.doReturn((Object)true).when((Object)a)).getRackLocalityFullReset();
        ((LeafQueue)Mockito.doReturn((Object)1).when((Object)a)).getNodeLocalityDelay();
        assignment = a.assignContainers(clusterResource, node_3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)4L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.RACK_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        ((LeafQueue)Mockito.doReturn((Object)false).when((Object)a)).getRackLocalityFullReset();
        assignment = a.assignContainers(clusterResource, node_3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.RACK_LOCAL);
        Assert.assertEquals((long)2L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.RACK_LOCAL);
        Assert.assertEquals((long)3L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        app_0.resetSchedulingOpportunities(schedulerKey);
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0, 1024, 100, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_0, 1024, 100, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 100, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        for (int i = 0; i < 3; ++i) {
            assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
            this.verifyNoContainerAllocated(assignment);
            Assert.assertEquals((long)(i + 1), (long)app_0.getSchedulingOpportunities(schedulerKey));
        }
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.OFF_SWITCH);
        Assert.assertEquals((long)4L, (long)app_0.getSchedulingOpportunities(schedulerKey));
    }

    @Test
    public void testRackLocalityDelayScheduling() throws Exception {
        this.csConf.setInt("yarn.scheduler.capacity.node-locality-delay", 2);
        this.csConf.setInt("yarn.scheduler.capacity.rack-locality-additional-delay", 1);
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", newQueues, this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.cs.getClusterResource());
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        Assert.assertEquals((long)2L, (long)a.getNodeLocalityDelay());
        Assert.assertEquals((long)1L, (long)a.getRackLocalityAdditionalDelay());
        String user1 = "user_1";
        ApplicationAttemptId appAttemptId1 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app1 = new FiCaSchedulerApp(appAttemptId1, user1, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app1, user1);
        String host1 = "127.0.0.1";
        String host2 = "127.0.0.2";
        String host3 = "127.0.0.3";
        String host4 = "127.0.0.4";
        String rack1 = "rack_1";
        String rack2 = "rack_2";
        String rack3 = "rack_3";
        FiCaSchedulerNode node2 = TestUtils.getMockNode(host3, rack2, 0, 8192);
        FiCaSchedulerNode node3 = TestUtils.getMockNode(host4, rack3, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app1.getApplicationAttemptId(), (Object)app1);
        ImmutableMap nodes = ImmutableMap.of((Object)node2.getNodeID(), (Object)node2, (Object)node3.getNodeID(), (Object)node3);
        int numNodes = 5;
        Resource clusterResource = Resources.createResource((int)40960, (int)80);
        Mockito.when((Object)this.spyRMContext.getScheduler().getNumClusterNodes()).thenReturn((Object)5);
        Priority priority2 = TestUtils.createMockPriority(1);
        ArrayList<ResourceRequest> app1Requests1 = new ArrayList<ResourceRequest>();
        app1Requests1.add(TestUtils.createResourceRequest(host1, 1024, 1, true, priority2, this.recordFactory));
        app1Requests1.add(TestUtils.createResourceRequest(rack1, 1024, 1, true, priority2, this.recordFactory));
        app1Requests1.add(TestUtils.createResourceRequest(host2, 1024, 1, true, priority2, this.recordFactory));
        app1Requests1.add(TestUtils.createResourceRequest(rack2, 1024, 1, true, priority2, this.recordFactory));
        app1Requests1.add(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory));
        app1.updateResourceRequests(app1Requests1);
        CSAssignment assignment = null;
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        Assert.assertEquals((long)3L, (long)app1.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)1L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)2L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)assignment.getType());
        a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        assignment = a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)2L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)4L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)assignment.getType());
        ((LeafQueue)Mockito.doReturn((Object)10).when((Object)a)).getRackLocalityAdditionalDelay();
        assignment = a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)5L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node3, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)6L, (long)app1.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app1.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)assignment.getType());
    }

    @Test
    public void testApplicationPriorityScheduling() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, user_0);
        String host_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, rack_0, 0, 8192);
        String host_1 = "127.0.0.2";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, rack_1, 0, 8192);
        String host_2 = "127.0.0.3";
        String rack_2 = "rack_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, rack_2, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        Priority priority_1 = TestUtils.createMockPriority(1);
        SchedulerRequestKey schedulerKey1 = TestUtils.toSchedulerKey(priority_1);
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0, 1024, 1, true, priority_1, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_0, 1024, 1, true, priority_1, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1, 1024, 1, true, priority_1, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, true, priority_1, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 2, true, priority_1, this.recordFactory));
        Priority priority_2 = TestUtils.createMockPriority(2);
        SchedulerRequestKey schedulerKey2 = TestUtils.toSchedulerKey(priority_2);
        app_0_requests_0.add(TestUtils.createResourceRequest(host_2, 2048, 1, true, priority_2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_2, 2048, 1, true, priority_2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 2048, 1, true, priority_2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        CSAssignment assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey1));
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey2));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey2));
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)2L, (long)app_0.getSchedulingOpportunities(schedulerKey1));
        Assert.assertEquals((long)2L, (long)app_0.getOutstandingAsksCount(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey2));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey2));
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.OFF_SWITCH);
        Assert.assertEquals((long)3L, (long)app_0.getSchedulingOpportunities(schedulerKey1));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey2));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey2));
        assignment = a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey2));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey2));
        assignment = a.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.OFF_SWITCH);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey1));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey1));
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey2));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey2));
    }

    @Test
    public void testSchedulingConstraints() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, user_0);
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0_0 = TestUtils.getMockNode(host_0_0, rack_0, 0, 8192);
        String host_0_1 = "127.0.0.2";
        FiCaSchedulerNode node_0_1 = TestUtils.getMockNode(host_0_1, rack_0, 0, 8192);
        String host_1_0 = "127.0.0.3";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1_0 = TestUtils.getMockNode(host_1_0, rack_1, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0_0.getNodeID(), (Object)node_0_0, (Object)node_0_1.getNodeID(), (Object)node_0_1, (Object)node_1_0.getNodeID(), (Object)node_1_0);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority2 = TestUtils.createMockPriority(1);
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        CSAssignment assignment = a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_1_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        assignment = a.assignContainers(clusterResource, node_0_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_1_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey));
    }

    @Test(timeout=30000L)
    public void testActivateApplicationAfterQueueRefresh() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        String user_e = "user_e";
        Mockito.when((Object)this.amResourceRequest.getCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)0));
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_0, "user_e");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_1, "user_e");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_2, "user_e");
        Assert.assertEquals((long)2L, (long)e.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)e.getNumPendingApplications());
        this.csConf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", (double)0.2f);
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", newQueues, this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.csContext.getClusterResource());
        Assert.assertEquals((long)3L, (long)e.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)e.getNumPendingApplications());
    }

    @Test(timeout=30000L)
    public void testLocalityDelaysAfterQueueRefresh() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        Assert.assertEquals((long)40L, (long)e.getNodeLocalityDelay());
        Assert.assertEquals((long)-1L, (long)e.getRackLocalityAdditionalDelay());
        this.csConf.setInt("yarn.scheduler.capacity.node-locality-delay", 60);
        this.csConf.setInt("yarn.scheduler.capacity.rack-locality-additional-delay", 600);
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", newQueues, this.queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.cs.getClusterResource());
        Assert.assertEquals((long)60L, (long)e.getNodeLocalityDelay());
        Assert.assertEquals((long)600L, (long)e.getRackLocalityAdditionalDelay());
    }

    @Test(timeout=30000L)
    public void testActivateApplicationByUpdatingClusterResource() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        String user_e = "user_e";
        Mockito.when((Object)this.amResourceRequest.getCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)0));
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_0, "user_e");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_1, "user_e");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_e", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_2, "user_e");
        Assert.assertEquals((long)2L, (long)e.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)e.getNumPendingApplications());
        Resource clusterResource = Resources.createResource((int)0x320000, (int)3200);
        e.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)3L, (long)e.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)e.getNumPendingApplications());
    }

    public boolean hasQueueACL(List<QueueUserACLInfo> aclInfos, QueueACL acl) {
        for (QueueUserACLInfo aclInfo : aclInfos) {
            if (!aclInfo.getUserAcls().contains(acl)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testInheritedQueueAcls() throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        ParentQueue c = (ParentQueue)this.queues.get(C);
        LeafQueue c1 = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(C1));
        Assert.assertFalse((boolean)this.root.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)a.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)b.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)c.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)c1.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(a.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertTrue((boolean)this.hasQueueACL(b.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertFalse((boolean)this.hasQueueACL(c.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertFalse((boolean)this.hasQueueACL(c1.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
    }

    @Test
    public void testLocalityConstraints() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, user_0);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, user_0);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        String host_0_1 = "127.0.0.2";
        FiCaSchedulerNode node_0_1 = TestUtils.getMockNode(host_0_1, rack_0, 0, 8192);
        String host_1_0 = "127.0.0.3";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1_0 = TestUtils.getMockNode(host_1_0, rack_1, 0, 8192);
        String host_1_1 = "127.0.0.4";
        FiCaSchedulerNode node_1_1 = TestUtils.getMockNode(host_1_1, rack_1, 0, 8192);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0_1.getNodeID(), (Object)node_0_1, (Object)node_1_0.getNodeID(), (Object)node_1_0, (Object)node_1_1.getNodeID(), (Object)node_1_1);
        int numNodes = 4;
        Resource clusterResource = Resources.createResource((int)32768, (int)4);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)4);
        Priority priority2 = TestUtils.createMockPriority(1);
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, false, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, false, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(host_0_0), null);
        app_0_requests_0.clear();
        CSAssignment assignment = a.assignContainers(clusterResource, node_0_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        assignment = a.assignContainers(clusterResource, node_1_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(host_1_1), null);
        app_0_requests_0.clear();
        assignment = a.assignContainers(clusterResource, node_1_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(rack_1), Collections.singletonList(host_1_1));
        app_0_requests_0.clear();
        assignment = a.assignContainers(clusterResource, node_1_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(null, Collections.singletonList(rack_1));
        app_0_requests_0.clear();
        assignment = a.assignContainers(clusterResource, node_1_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyNoContainerAllocated(assignment);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)1L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, false, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, false, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0_requests_0.clear();
        assignment = a.assignContainers(clusterResource, node_1_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getOutstandingAsksCount(schedulerKey));
    }

    @Test
    public void testMaxAMResourcePerQueuePercentAfterQueueRefresh() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Resource clusterResource = Resources.createResource((int)0x190000, (int)3200);
        CapacitySchedulerContext csContext = this.mockCSContext(csConf, clusterResource);
        Mockito.when((Object)csContext.getRMContext()).thenReturn((Object)this.rmContext);
        csConf.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 0.1f);
        ParentQueue root = new ParentQueue(csContext, "root", null, null);
        csConf.setCapacity("root.a", 80.0f);
        LeafQueue a = new LeafQueue(csContext, A, (CSQueue)root, null);
        Assert.assertEquals((float)0.1f, (float)a.getMaxAMResourcePerQueuePercent(), (float)0.001f);
        Assert.assertEquals((Object)a.calculateAndGetAMResourceLimit(), (Object)Resources.createResource((int)163840, (int)1));
        csConf.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 0.2f);
        LeafQueue newA = new LeafQueue(csContext, A, (CSQueue)root, null);
        a.reinitialize((CSQueue)newA, clusterResource);
        Assert.assertEquals((float)0.2f, (float)a.getMaxAMResourcePerQueuePercent(), (float)0.001f);
        Assert.assertEquals((Object)a.calculateAndGetAMResourceLimit(), (Object)Resources.createResource((int)327680, (int)1));
        Resource newClusterResource = Resources.createResource((int)2048000, (int)3200);
        a.updateClusterResource(newClusterResource, new ResourceLimits(newClusterResource));
        Assert.assertEquals((Object)a.calculateAndGetAMResourceLimit(), (Object)Resources.createResource((int)409600, (int)1));
    }

    @Test
    public void testAllocateContainerOnNodeWithoutOffSwitchSpecified() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(B));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Arrays.asList(TestUtils.createResourceRequest("127.0.0.1", 1024, 3, true, priority2, this.recordFactory), TestUtils.createResourceRequest(DEFAULT_RACK, 1024, 3, true, priority2, this.recordFactory)));
        try {
            this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NPE when allocating container on node but forget to set off-switch request should be handled");
        }
    }

    @Test
    public void testFifoAssignment() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        a.setOrderingPolicy((OrderingPolicy)new FifoOrderingPolicy());
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0_0 = TestUtils.getMockNode(host_0_0, rack_0, 0, 16384);
        int numNodes = 4;
        Resource clusterResource = Resources.createResource((int)65536, (int)64);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)4);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext, Priority.newInstance((int)3), false));
        a.submitApplicationAttempt(app_0, user_0);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_1, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext, Priority.newInstance((int)5), false));
        a.submitApplicationAttempt(app_1, user_0);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0_0.getNodeID(), (Object)node_0_0);
        Priority priority2 = TestUtils.createMockPriority(1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        ArrayList<ResourceRequest> app_1_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 2048, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_1_requests_0.clear();
        app_1_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_1.updateResourceRequests(app_1_requests_0);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_1_requests_0.clear();
        app_1_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_1.updateResourceRequests(app_1_requests_0);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
    }

    @Test
    public void testConcurrentAccess() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM();
        rm.init((Configuration)conf);
        rm.start();
        String queue = "default";
        String user = "user";
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        final LeafQueue defaultQueue = (LeafQueue)cs.getQueue("default");
        final List<FiCaSchedulerApp> listOfApps = this.createListOfApps(10000, "user", defaultQueue);
        final CyclicBarrier cb = new CyclicBarrier(2);
        final ArrayList conException = new ArrayList();
        Thread submitAndRemove = new Thread(new Runnable(){

            @Override
            public void run() {
                for (FiCaSchedulerApp fiCaSchedulerApp : listOfApps) {
                    defaultQueue.submitApplicationAttempt(fiCaSchedulerApp, "user");
                }
                try {
                    cb.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (FiCaSchedulerApp fiCaSchedulerApp : listOfApps) {
                    defaultQueue.finishApplicationAttempt(fiCaSchedulerApp, "default");
                }
            }
        }, "SubmitAndRemoveApplicationAttempt Thread");
        Thread getAppsInQueue = new Thread(new Runnable(){
            List<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();

            @Override
            public void run() {
                try {
                    try {
                        cb.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    defaultQueue.collectSchedulerApplications(this.apps);
                }
                catch (ConcurrentModificationException e) {
                    conException.add(e);
                }
            }
        }, "GetAppsInQueue Thread");
        submitAndRemove.start();
        getAppsInQueue.start();
        submitAndRemove.join();
        getAppsInQueue.join();
        Assert.assertTrue((String)"ConcurrentModificationException is thrown", (boolean)conException.isEmpty());
        rm.stop();
    }

    @Test
    public void testFairAssignment() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        FairOrderingPolicy schedulingOrder = new FairOrderingPolicy();
        a.setOrderingPolicy((OrderingPolicy)schedulingOrder);
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0_0 = TestUtils.getMockNode(host_0_0, rack_0, 0, 16384);
        int numNodes = 4;
        Resource clusterResource = Resources.createResource((int)65536, (int)64);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)4);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext));
        a.submitApplicationAttempt(app_0, user_0);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_1, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext));
        a.submitApplicationAttempt(app_1, user_0);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0_0.getNodeID(), (Object)node_0_0);
        Priority priority2 = TestUtils.createMockPriority(1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        ArrayList<ResourceRequest> app_1_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 2048, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_1_requests_0.clear();
        app_1_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_1.updateResourceRequests(app_1_requests_0);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_1_requests_0.clear();
        app_1_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_1.updateResourceRequests(app_1_requests_0);
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, a.assignContainers(clusterResource, node_0_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
    }

    @Test
    public void testLocalityDelaySkipsApplication() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(A));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_0, user_0);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, user_0, (Queue)a, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        a.submitApplicationAttempt(app_1, user_0);
        String host_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, rack_0, 0, 8192);
        String host_1 = "127.0.0.2";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode(host_1, rack_1, 0, 8192);
        String host_2 = "127.0.0.3";
        String rack_2 = "rack_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode(host_2, rack_2, 0, 8192);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0, (Object)node_1.getNodeID(), (Object)node_1, (Object)node_2.getNodeID(), (Object)node_2);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority2 = TestUtils.createMockPriority(1);
        SchedulerRequestKey schedulerKey = TestUtils.toSchedulerKey(priority2);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest(host_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_0, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(host_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest(rack_1, 1024, 1, true, priority2, this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        ArrayList<ResourceRequest> app_1_requests_0 = new ArrayList<ResourceRequest>();
        app_1_requests_0.add(TestUtils.createResourceRequest(host_2, 1024, 1, true, priority2, this.recordFactory));
        app_1_requests_0.add(TestUtils.createResourceRequest(rack_2, 1024, 1, true, priority2, this.recordFactory));
        app_1_requests_0.add(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory));
        app_1.updateResourceRequests(app_1_requests_0);
        CSAssignment assignment = null;
        assignment = a.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyCSAssignment(clusterResource, assignment, a, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.verifyContainerAllocated(assignment, NodeType.NODE_LOCAL);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(schedulerKey));
        Assert.assertEquals((long)3L, (long)app_0.getOutstandingAsksCount(schedulerKey));
        Assert.assertEquals((long)0L, (long)app_0.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app_1.getLiveContainers().size());
    }

    @Test
    public void testGetTotalPendingResourcesConsideringUserLimitOneUser() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        e.setMaxCapacity(1.0f);
        e.setUserLimit(1000);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 102400);
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)102400, (int)128);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 3, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        e.setUserLimitFactor(10.0f);
        Assert.assertEquals((long)3072L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            e.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        for (RMContainer rmContainer : app_1.getLiveContainers()) {
            e.completedContainer(clusterResource, app_1, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
    }

    @Test
    public void testGetTotalPendingResourcesConsideringUserLimitTwoUsers() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)this.queues.get(E));
        e.setMaxCapacity(1.0f);
        e.setUserLimit(1000);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(0, 0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId(1, 0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId(2, 0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_2, "user_1");
        ApplicationAttemptId appAttemptId_3 = TestUtils.getMockApplicationAttemptId(3, 0);
        FiCaSchedulerApp app_3 = new FiCaSchedulerApp(appAttemptId_3, "user_1", (Queue)e, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
        e.submitApplicationAttempt(app_3, "user_1");
        ImmutableMap apps = ImmutableMap.of((Object)app_0.getApplicationAttemptId(), (Object)app_0, (Object)app_1.getApplicationAttemptId(), (Object)app_1, (Object)app_2.getApplicationAttemptId(), (Object)app_2, (Object)app_3.getApplicationAttemptId(), (Object)app_3);
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode(host_0, DEFAULT_RACK, 0, 102400);
        ImmutableMap nodes = ImmutableMap.of((Object)node_0.getNodeID(), (Object)node_0);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)102400, (int)128);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority2 = TestUtils.createMockPriority(1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        priority2 = TestUtils.createMockPriority(1);
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 2, true, priority2, this.recordFactory)));
        app_3.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest("*", 1024, 1, true, priority2, this.recordFactory)));
        Assert.assertEquals((long)2048L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        long app_0_consumption = app_0.getCurrentConsumption().getMemorySize();
        Assert.assertEquals((long)1024L, (long)app_0_consumption);
        long app_1_consumption = app_1.getCurrentConsumption().getMemorySize();
        Assert.assertEquals((long)1024L, (long)app_1_consumption);
        long app_2_consumption = app_2.getCurrentConsumption().getMemorySize();
        Assert.assertEquals((long)2048L, (long)app_2_consumption);
        long app_3_consumption = app_3.getCurrentConsumption().getMemorySize();
        Assert.assertEquals((long)0L, (long)app_3_consumption);
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)app_0_consumption, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)app_1_consumption, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)app_2_consumption, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)app_3_consumption, (long)app_3.getCurrentConsumption().getMemorySize());
        e.setUserLimitFactor(10.0f);
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)1024L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemorySize());
        this.applyCSAssignment(clusterResource, e.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), e, (Map<NodeId, FiCaSchedulerNode>)nodes, (Map<ApplicationAttemptId, FiCaSchedulerApp>)apps);
        Assert.assertEquals((long)0L, (long)e.getTotalPendingResourcesConsideringUserLimit(clusterResource, "", false).getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)2048L, (long)app_2.getCurrentConsumption().getMemorySize());
        Assert.assertEquals((long)1024L, (long)app_3.getCurrentConsumption().getMemorySize());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            e.completedContainer(clusterResource, app_0, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
        for (RMContainer rmContainer : app_1.getLiveContainers()) {
            e.completedContainer(clusterResource, app_1, node_0, rmContainer, ContainerStatus.newInstance((ContainerId)rmContainer.getContainerId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)-106), RMContainerEventType.KILL, null, true);
        }
    }

    private List<FiCaSchedulerApp> createListOfApps(int noOfApps, String user, LeafQueue defaultQueue) {
        ArrayList<FiCaSchedulerApp> appsLists = new ArrayList<FiCaSchedulerApp>();
        for (int i = 0; i < noOfApps; ++i) {
            ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId(i, 0);
            FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, user, (Queue)defaultQueue, (AbstractUsersManager)Mockito.mock(ActiveUsersManager.class), this.spyRMContext);
            appsLists.add(app_0);
        }
        return appsLists;
    }

    private CapacitySchedulerContext mockCSContext(CapacitySchedulerConfiguration csConf, Resource clusterResource) {
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)new YarnConfiguration());
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)2048, (int)2));
        Mockito.when((Object)csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        return csContext;
    }

    @Test
    public void testApplicationQueuePercent() throws Exception {
        Resource res = Resource.newInstance((int)10240, (int)10);
        CapacityScheduler scheduler = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)scheduler.getClusterResource()).thenReturn((Object)res);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        ApplicationAttemptId appAttId = this.createAppAttemptId(0, 0);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getEpoch()).thenReturn((Object)3L);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)scheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        RMNodeLabelsManager nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)nlm.getResourceByLabel((String)Matchers.any(), (Resource)Matchers.any())).thenReturn((Object)res);
        Mockito.when((Object)rmContext.getNodeLabelManager()).thenReturn((Object)nlm);
        AbstractCSQueue queue = this.createQueue("test", null, 1.0f, 1.0f);
        String user = "user1";
        FiCaSchedulerApp app = new FiCaSchedulerApp(appAttId, "user1", (Queue)queue, queue.getAbstractUsersManager(), rmContext);
        Resource requestedResource = Resource.newInstance((int)1536, (int)2);
        app.getAppAttemptResourceUsage().incUsed(requestedResource);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
        queue = this.createQueue("test2", null, 0.5f, 0.5f);
        app = new FiCaSchedulerApp(appAttId, "user1", (Queue)queue, queue.getAbstractUsersManager(), rmContext);
        app.getAppAttemptResourceUsage().incUsed(requestedResource);
        Assert.assertEquals((float)30.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
        AbstractCSQueue qChild = this.createQueue("test2.1", (Queue)queue, 0.5f, 0.25f);
        app = new FiCaSchedulerApp(appAttId, "user1", (Queue)qChild, qChild.getAbstractUsersManager(), rmContext);
        app.getAppAttemptResourceUsage().incUsed(requestedResource);
        Assert.assertEquals((float)60.0f, (float)app.getResourceUsageReport().getQueueUsagePercentage(), (float)0.01f);
        Assert.assertEquals((float)15.0f, (float)app.getResourceUsageReport().getClusterUsagePercentage(), (float)0.01f);
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    private AbstractCSQueue createQueue(String name, Queue parent, float capacity, float absCap) {
        CSQueueMetrics metrics = CSQueueMetrics.forQueue((String)name, (Queue)parent, (boolean)false, (Configuration)this.cs.getConf());
        QueueInfo queueInfo = QueueInfo.newInstance((String)name, (float)capacity, (float)1.0f, (float)0.0f, null, null, (QueueState)QueueState.RUNNING, null, (String)"", null, (boolean)false, null, (boolean)false);
        ActiveUsersManager activeUsersManager = new ActiveUsersManager((QueueMetrics)metrics);
        AbstractCSQueue queue = (AbstractCSQueue)Mockito.mock(AbstractCSQueue.class);
        Mockito.when((Object)queue.getMetrics()).thenReturn((Object)metrics);
        Mockito.when((Object)queue.getAbstractUsersManager()).thenReturn((Object)activeUsersManager);
        Mockito.when((Object)queue.getQueueInfo(false, false)).thenReturn((Object)queueInfo);
        QueueCapacities qCaps = (QueueCapacities)Mockito.mock(QueueCapacities.class);
        Mockito.when((Object)Float.valueOf(qCaps.getAbsoluteCapacity((String)Matchers.any()))).thenReturn((Object)Float.valueOf(absCap));
        Mockito.when((Object)queue.getQueueCapacities()).thenReturn((Object)qCaps);
        return queue;
    }

    @After
    public void tearDown() throws Exception {
        if (this.cs != null) {
            this.cs.stop();
        }
    }
}

