/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestUtils {
    private static final Log LOG = LogFactory.getLog(TestUtils.class);
    public static SpyHook spyHook = new SpyHook();
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static RMContext getMockRMContext() {
        Dispatcher nullDispatcher = new Dispatcher(){
            private final EventHandler handler = new EventHandler(){

                public void handle(Event event) {
                }
            };

            public void register(Class<? extends Enum> eventType, EventHandler handler) {
            }

            public EventHandler<Event> getEventHandler() {
                return this.handler;
            }
        };
        ContainerAllocationExpirer cae = new ContainerAllocationExpirer(nullDispatcher);
        Configuration conf = new Configuration();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl(nullDispatcher, cae, null, null, null, new AMRMTokenSecretManager(conf, null), new RMContainerTokenSecretManager(conf), new NMTokenSecretManagerInRM(conf), new ClientToAMTokenSecretManagerInRM());
        RMNodeLabelsManager nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        Mockito.when((Object)nlm.getQueueResource((String)Matchers.any(String.class), (Set)Matchers.any(Set.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[2];
            }
        });
        Mockito.when((Object)nlm.getResourceByLabel((String)Matchers.any(String.class), (Resource)Matchers.any(Resource.class))).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (Resource)args[1];
            }
        });
        rmContext.setNodeLabelManager(nlm);
        rmContext.setSystemMetricsPublisher((SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class));
        rmContext.setRMApplicationHistoryWriter((RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class));
        ResourceScheduler mockScheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)mockScheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        rmContext.setScheduler(mockScheduler);
        return rmContext;
    }

    public static Priority createMockPriority(int priority2) {
        Priority p = (Priority)recordFactory.newRecordInstance(Priority.class);
        p.setPriority(priority2);
        return p;
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory, String labelExpression) {
        return TestUtils.createResourceRequest(resourceName, memory, 1, numContainers, relaxLocality, priority2, recordFactory, labelExpression);
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int vcores, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory, String labelExpression) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        Resource capability = Resources.createResource((int)memory, (int)vcores);
        request.setNumContainers(numContainers);
        request.setResourceName(resourceName);
        request.setCapability(capability);
        request.setRelaxLocality(relaxLocality);
        request.setPriority(priority2);
        request.setNodeLabelExpression(labelExpression);
        return request;
    }

    public static ResourceRequest createResourceRequest(String resourceName, int memory, int numContainers, boolean relaxLocality, Priority priority2, RecordFactory recordFactory) {
        return TestUtils.createResourceRequest(resourceName, memory, numContainers, relaxLocality, priority2, recordFactory, "");
    }

    public static ApplicationId getMockApplicationId(int appId) {
        return ApplicationId.newInstance((long)0L, (int)appId);
    }

    public static ApplicationAttemptId getMockApplicationAttemptId(int appId, int attemptId) {
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)0L, (int)appId);
        return ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)attemptId);
    }

    public static FiCaSchedulerNode getMockNode(String host, String rack, int port, int memory) {
        return TestUtils.getMockNode(host, rack, port, memory, 1);
    }

    public static FiCaSchedulerNode getMockNode(String host, String rack, int port, int memory, int vcores) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)port);
        RMNode rmNode = (RMNode)Mockito.mock(RMNode.class);
        Mockito.when((Object)rmNode.getNodeID()).thenReturn((Object)nodeId);
        Mockito.when((Object)rmNode.getTotalCapability()).thenReturn((Object)Resources.createResource((int)memory, (int)vcores));
        Mockito.when((Object)rmNode.getNodeAddress()).thenReturn((Object)(host + ":" + port));
        Mockito.when((Object)rmNode.getHostName()).thenReturn((Object)host);
        Mockito.when((Object)rmNode.getRackName()).thenReturn((Object)rack);
        FiCaSchedulerNode node = (FiCaSchedulerNode)Mockito.spy((Object)new FiCaSchedulerNode(rmNode, false));
        LOG.info((Object)("node = " + host + " avail=" + node.getUnallocatedResource()));
        Mockito.when((Object)node.getNodeID()).thenReturn((Object)nodeId);
        return node;
    }

    public static ContainerId getMockContainerId(FiCaSchedulerApp application) {
        ContainerId containerId = (ContainerId)Mockito.mock(ContainerId.class);
        ((ContainerId)Mockito.doReturn((Object)application.getApplicationAttemptId()).when((Object)containerId)).getApplicationAttemptId();
        long id = application.getNewContainerId();
        ((ContainerId)Mockito.doReturn((Object)((int)id)).when((Object)containerId)).getId();
        ((ContainerId)Mockito.doReturn((Object)id).when((Object)containerId)).getContainerId();
        return containerId;
    }

    public static Container getMockContainer(ContainerId containerId, NodeId nodeId, Resource resource, Priority priority2) {
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nodeId);
        Mockito.when((Object)container.getResource()).thenReturn((Object)resource);
        Mockito.when((Object)container.getPriority()).thenReturn((Object)priority2);
        return container;
    }

    public static <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    public static Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b", "c"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", TestUtils.toSet("x"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        conf.setAccessibleNodeLabels("root.b", TestUtils.toSet("y"));
        conf.setCapacityByLabel("root.b", "y", 100.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.setAccessibleNodeLabels("root.c", RMNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        String B1 = "root.b.b1";
        conf.setQueues("root.b", new String[]{"b1"});
        conf.setCapacity("root.b.b1", 100.0f);
        conf.setMaximumCapacity("root.b.b1", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "y", 100.0f);
        conf.setMaximumApplicationMasterResourcePerQueuePercent("root.b.b1", 1.0f);
        String C1 = "root.c.c1";
        conf.setQueues("root.c", new String[]{"c1"});
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setMaximumCapacity("root.c.c1", 100.0f);
        return conf;
    }

    public static Configuration getComplexConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 10.0f);
        conf.setAccessibleNodeLabels("root.a", TestUtils.toSet("x", "y"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        conf.setCapacityByLabel("root.a", "y", 50.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 90.0f);
        conf.setMaximumCapacity("root.b", 100.0f);
        conf.setAccessibleNodeLabels("root.b", TestUtils.toSet("y", "z"));
        conf.setCapacityByLabel("root.b", "y", 50.0f);
        conf.setCapacityByLabel("root.b", "z", 100.0f);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setAccessibleNodeLabels("root.a.a1", TestUtils.toSet("x", "y"));
        conf.setDefaultNodeLabelExpression("root.a.a1", "x");
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "y", 100.0f);
        conf.setQueues("root.b", new String[]{"b1", "b2"});
        String B1 = "root.b.b1";
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 50.0f);
        conf.setAccessibleNodeLabels("root.b.b1", RMNodeLabelsManager.EMPTY_STRING_SET);
        String B2 = "root.b.b2";
        conf.setCapacity("root.b.b2", 50.0f);
        conf.setMaximumCapacity("root.b.b2", 50.0f);
        conf.setAccessibleNodeLabels("root.b.b2", TestUtils.toSet("y", "z"));
        conf.setCapacityByLabel("root.b.b2", "y", 100.0f);
        conf.setCapacityByLabel("root.b.b2", "z", 100.0f);
        return conf;
    }

    public static Configuration getConfigurationWithDefaultQueueLabels(Configuration config) {
        String A = "root.a";
        String B = "root.b";
        CapacitySchedulerConfiguration conf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels(config);
        new CapacitySchedulerConfiguration(config);
        conf.setDefaultNodeLabelExpression("root.a", "x");
        conf.setDefaultNodeLabelExpression("root.b", "y");
        return conf;
    }

    public static FiCaSchedulerApp getFiCaSchedulerApp(MockRM rm, ApplicationId appId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        return (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(appId)).getCurrentAppAttempt();
    }

    public static Configuration getConfigurationWithMultipleQueues(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 100.0f);
        conf.setUserLimitFactor("root.a", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        conf.setMaximumCapacity("root.b", 100.0f);
        conf.setUserLimitFactor("root.b", 100.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 100.0f);
        conf.setUserLimitFactor("root.c", 100.0f);
        return conf;
    }

    public static SchedulerRequestKey toSchedulerKey(Priority pri) {
        return SchedulerRequestKey.create((ResourceRequest)ResourceRequest.newInstance((Priority)pri, null, null, (int)0));
    }

    public static SchedulerRequestKey toSchedulerKey(int pri) {
        return SchedulerRequestKey.create((ResourceRequest)ResourceRequest.newInstance((Priority)Priority.newInstance((int)pri), null, null, (int)0));
    }

    public static SchedulerRequestKey toSchedulerKey(Priority pri, long allocationRequestId) {
        ResourceRequest req = ResourceRequest.newInstance((Priority)pri, null, null, (int)0);
        req.setAllocationRequestId(allocationRequestId);
        return SchedulerRequestKey.create((ResourceRequest)req);
    }

    public static void applyResourceCommitRequest(Resource clusterResource, CSAssignment csAssignment, final Map<NodeId, FiCaSchedulerNode> nodes, final Map<ApplicationAttemptId, FiCaSchedulerApp> apps) throws IOException {
        CapacityScheduler cs = new CapacityScheduler(){

            public FiCaSchedulerNode getNode(NodeId nodeId) {
                return (FiCaSchedulerNode)nodes.get(nodeId);
            }

            public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
                return (FiCaSchedulerApp)apps.get(applicationAttemptId);
            }
        };
        cs.setResourceCalculator((ResourceCalculator)new DefaultResourceCalculator());
        cs.submitResourceCommitRequest(clusterResource, csAssignment);
    }

    static class SpyHook
    extends CapacitySchedulerQueueManager.QueueHook {
        SpyHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return (CSQueue)Mockito.spy((Object)queue);
        }
    }
}

