/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMutableCSConfigurationProvider {
    private MutableCSConfigurationProvider confProvider;
    private RMContext rmContext;
    private SchedConfUpdateInfo goodUpdate;
    private SchedConfUpdateInfo badUpdate;
    private CapacityScheduler cs;
    private AdminService adminService;
    private static final UserGroupInformation TEST_USER = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);

    @Before
    public void setUp() {
        this.cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)this.cs);
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)new CapacitySchedulerConfiguration());
        this.adminService = (AdminService)Mockito.mock(AdminService.class);
        Mockito.when((Object)this.rmContext.getRMAdminService()).thenReturn((Object)this.adminService);
        this.confProvider = new MutableCSConfigurationProvider(this.rmContext);
        this.goodUpdate = new SchedConfUpdateInfo();
        HashMap<String, String> goodUpdateMap = new HashMap<String, String>();
        goodUpdateMap.put("goodKey", "goodVal");
        QueueConfigInfo goodUpdateInfo = new QueueConfigInfo("root.a", goodUpdateMap);
        this.goodUpdate.getUpdateQueueInfo().add(goodUpdateInfo);
        this.badUpdate = new SchedConfUpdateInfo();
        HashMap<String, String> badUpdateMap = new HashMap<String, String>();
        badUpdateMap.put("badKey", "badVal");
        QueueConfigInfo badUpdateInfo = new QueueConfigInfo("root.a", badUpdateMap);
        this.badUpdate.getUpdateQueueInfo().add(badUpdateInfo);
    }

    @Test
    public void testInMemoryBackedProvider() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.configuration.store.class", "memory");
        this.confProvider.init(conf);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        this.confProvider.logAndApplyMutation(TEST_USER, this.goodUpdate);
        this.confProvider.confirmPendingMutation(true);
        Assert.assertEquals((Object)"goodVal", (Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.goodKey"));
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
        this.confProvider.logAndApplyMutation(TEST_USER, this.badUpdate);
        this.confProvider.confirmPendingMutation(false);
        Assert.assertNull((Object)this.confProvider.loadConfiguration(conf).get("yarn.scheduler.capacity.root.a.badKey"));
    }
}

