/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPriorityUtilizationQueueOrderingPolicy {
    private List<CSQueue> mockCSQueues(String[] queueNames, int[] priorities, float[] utilizations, String partition) {
        assert (queueNames != null && priorities != null && utilizations != null && queueNames.length > 0 && queueNames.length == priorities.length && priorities.length == utilizations.length);
        ArrayList<CSQueue> list = new ArrayList<CSQueue>();
        for (int i = 0; i < queueNames.length; ++i) {
            CSQueue q = (CSQueue)Mockito.mock(CSQueue.class);
            Mockito.when((Object)q.getQueueName()).thenReturn((Object)queueNames[i]);
            QueueCapacities qc = new QueueCapacities(false);
            qc.setUsedCapacity(partition, utilizations[i]);
            Mockito.when((Object)q.getQueueCapacities()).thenReturn((Object)qc);
            Mockito.when((Object)q.getPriority()).thenReturn((Object)Priority.newInstance((int)priorities[i]));
            list.add(q);
        }
        return list;
    }

    private void verifyOrder(QueueOrderingPolicy orderingPolicy, String partition, String[] expectedOrder) {
        Iterator iter = orderingPolicy.getAssignmentIterator(partition);
        int i = 0;
        while (iter.hasNext()) {
            CSQueue q = (CSQueue)iter.next();
            Assert.assertEquals((Object)expectedOrder[i], (Object)q.getQueueName());
            ++i;
        }
        assert (i == expectedOrder.length);
    }

    @Test
    public void testUtilizationOrdering() {
        PriorityUtilizationQueueOrderingPolicy policy = new PriorityUtilizationQueueOrderingPolicy(false);
        policy.setQueues(this.mockCSQueues(new String[]{"a"}, new int[]{0}, new float[]{0.1f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{0, 0}, new float[]{0.1f, 0.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{0, 0, 0}, new float[]{0.1f, 0.0f, 0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"b", "a", "c"});
        List<CSQueue> queues = this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, "x");
        Mockito.when((Object)queues.get(0).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x", (Object)"y"));
        Mockito.when((Object)queues.get(2).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x", (Object)"y"));
        policy.setQueues(queues);
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"a", "c", "b"});
    }

    @Test
    public void testPriorityUtilizationOrdering() {
        PriorityUtilizationQueueOrderingPolicy policy = new PriorityUtilizationQueueOrderingPolicy(true);
        policy.setQueues(this.mockCSQueues(new String[]{"a"}, new int[]{1}, new float[]{0.1f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.2f, 0.1f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{1.1f, 1.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{1.1f, 1.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 1.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{2, 1}, new float[]{0.1f, 1.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 1.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{2, 1}, new float[]{0.1f, 1.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{1.0f, 1.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"e", "c", "b", "a", "d"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"e", "b", "a", "c", "d"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"e", "c", "b", "a", "d"});
        List<CSQueue> queues = this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, "x");
        Mockito.when((Object)queues.get(0).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x"));
        Mockito.when((Object)queues.get(3).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x"));
        policy.setQueues(queues);
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"a", "d", "e", "c", "b"});
    }
}

