/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestRMAuthenticationFilter {
    @Test
    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.foo", "bar");
        conf.set("hadoop.proxyuser.user.foo", "bar1");
        conf.set("bind.address", "barhost");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                Assert.assertEquals((Object)"RMAuthenticationFilter", (Object)args[0]);
                Assert.assertEquals((Object)RMAuthenticationFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                Assert.assertEquals((Object)"/", conf.get("cookie.path"));
                Assert.assertEquals((Object)"simple", conf.get("type"));
                Assert.assertEquals((Object)"36000", conf.get("token.validity"));
                Assert.assertNull(conf.get("cookie.domain"));
                Assert.assertEquals((Object)"true", conf.get("simple.anonymous.allowed"));
                Assert.assertEquals((Object)"HTTP/barhost@LOCALHOST", conf.get("kerberos.principal"));
                Assert.assertEquals((Object)(System.getProperty("user.home") + "/hadoop.keytab"), conf.get("kerberos.keytab"));
                Assert.assertEquals((Object)"bar", conf.get("foo"));
                Assert.assertEquals((Object)"bar1", conf.get("proxyuser.user.foo"));
                return null;
            }
        }).when((Object)container)).addFilter((String)Mockito.anyObject(), (String)Mockito.anyObject(), (Map)Mockito.anyObject());
        new RMAuthenticationFilterInitializer().initFilter(container, conf);
    }
}

