/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMWebServiceAppsNodelabel
extends JerseyTestBase {
    private static final int AM_CONTAINER_MB = 1024;
    private static RMNodeLabelsManager nodeLabelManager;
    private static MockRM rm;
    private static CapacitySchedulerConfiguration csConf;
    private static YarnConfiguration conf;

    public TestRMWebServiceAppsNodelabel() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.setQueues("root", new String[]{"a", "default"});
        String queueA = "root.a";
        config.setCapacity("root.a", 50.0f);
        config.setMaximumCapacity("root.a", 50.0f);
        String defaultQueue = "root.default";
        config.setCapacity("root.default", 50.0f);
        config.setCapacityByLabel("root", "X", 100.0f);
        config.setMaximumCapacityByLabel("root", "X", 100.0f);
        config.setCapacityByLabel("root.default", "X", 100.0f);
        config.setMaximumCapacityByLabel("root.default", "X", 100.0f);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    @Test
    public void testAppsFinished() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        RMApp killedApp = rm.submitApp(1024);
        rm.killApp(killedApp.getApplicationId());
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        try {
            apps.getJSONArray("app").getJSONObject(0).getJSONObject("resourceInfo");
            Assert.fail((String)"resourceInfo object shouldn't be available for finished apps");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"resourceInfo shouldn't be available for finished apps", (boolean)true);
        }
        rm.stop();
    }

    @Test
    public void testAppsRunning() throws JSONException, Exception {
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 2048);
        MockNM nm2 = rm.registerNode("h2:1235", 2048);
        nodeLabelManager.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)1235), this.toSet("X")));
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        nm1.nodeHeartbeat(true);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "X");
        nm2.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").accept(new String[]{"application/json"}).get(ClientResponse.class);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONObject jsonObject = apps.getJSONArray("app").getJSONObject(0).getJSONObject("resourceInfo");
        JSONArray jsonArray = jsonObject.getJSONArray("resourceUsagesByPartition");
        Assert.assertEquals((String)"Partition expected is 2", (long)2L, (long)jsonArray.length());
        JSONObject defaultPartition = jsonArray.getJSONObject(0);
        this.verifyResource(defaultPartition, "", this.getResource(1024, 1), this.getResource(1024, 1), this.getResource(0, 0));
        JSONObject paritionX = jsonArray.getJSONObject(1);
        this.verifyResource(paritionX, "X", this.getResource(0, 0), this.getResource(1024, 1), this.getResource(0, 0));
        rm.stop();
    }

    private String getResource(int memory, int vcore) {
        return "{\"memory\":" + memory + ",\"vCores\":" + vcore + "}";
    }

    private void verifyResource(JSONObject partition, String partitionName, String amused, String used, String reserved) throws JSONException {
        Assert.assertEquals((String)"Partition expected", (Object)partitionName, (Object)partition.get("partitionName"));
        Assert.assertEquals((String)"partition amused", (Object)amused, (Object)partition.get("amUsed").toString());
        Assert.assertEquals((String)"partition used", (Object)used, (Object)partition.get("used").toString());
        Assert.assertEquals((String)"partition reserved", (Object)reserved, (Object)partition.get("reserved").toString());
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    private static class WebServletModule
    extends ServletModule {
        private static final String LABEL_X = "X";

        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            csConf = new CapacitySchedulerConfiguration();
            TestRMWebServiceAppsNodelabel.setupQueueConfiguration(csConf);
            conf = new YarnConfiguration((Configuration)csConf);
            conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
            rm = new MockRM((Configuration)conf);
            HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
            labels.add(NodeLabel.newInstance((String)LABEL_X));
            try {
                nodeLabelManager = rm.getRMContext().getNodeLabelManager();
                nodeLabelManager.addToCluserNodeLabels(labels);
            }
            catch (Exception e) {
                Assert.fail();
            }
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

