/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.http.XFrameOptionsFilter;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMWithXFSFilter
extends JerseyTestBase {
    private static MockRM rm;

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWithXFSFilter() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testDefaultBehavior() throws Exception {
        this.createInjector();
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((String)"Should have received DENY x-frame options header", (Object)"DENY", ((List)response.getHeaders().get((Object)"X-Frame-Options")).get(0));
    }

    protected void createInjector(String headerValue) {
        this.createInjector(headerValue, false);
    }

    protected void createInjector() {
        this.createInjector(null, false);
    }

    protected void createInjector(final String headerValue, final boolean explicitlyDisabled) {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new ServletModule(){

            protected void configureServlets() {
                this.bind(JAXBContextResolver.class);
                this.bind(RMWebServices.class);
                this.bind(GenericExceptionHandler.class);
                Configuration conf = new Configuration();
                conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
                rm = new MockRM(conf);
                this.bind(ResourceManager.class).toInstance((Object)rm);
                this.serve("/*", new String[0]).with(GuiceContainer.class);
                XFrameOptionsFilter xfsFilter = new XFrameOptionsFilter();
                HashMap<String, String> initParams = new HashMap<String, String>();
                if (headerValue != null) {
                    initParams.put("xframe-options", headerValue);
                }
                if (explicitlyDisabled) {
                    initParams.put("xframe-options-enabled", "false");
                }
                this.filter("/*", new String[0]).through((Filter)xfsFilter, initParams);
            }
        }}));
    }

    @Test
    public void testSameOrigin() throws Exception {
        this.createInjector("SAMEORIGIN");
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((String)"Should have received SAMEORIGIN x-frame options header", (Object)"SAMEORIGIN", ((List)response.getHeaders().get((Object)"X-Frame-Options")).get(0));
    }

    @Test
    public void testExplicitlyDisabled() throws Exception {
        this.createInjector(null, true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("info").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertFalse((String)"Should have not received x-frame options header", (response.getHeaders().get((Object)"X-Frame-Options") == null ? 1 : 0) != 0);
    }
}

