/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitorManager;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.FifoCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicy {
    static final long TS = 3141592653L;
    int appAlloc = 0;
    boolean setAMContainer = false;
    boolean setLabeledContainer = false;
    float setAMResourcePercent = 0.0f;
    Random rand = null;
    Clock mClock = null;
    CapacitySchedulerConfiguration conf = null;
    CapacityScheduler mCS = null;
    RMContext rmContext = null;
    RMNodeLabelsManager lm = null;
    EventHandler<Event> mDisp = null;
    ResourceCalculator rc = new DefaultResourceCalculator();
    Resource clusterResources = null;
    final ApplicationAttemptId appA = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)0), (int)0);
    final ApplicationAttemptId appB = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)1), (int)0);
    final ApplicationAttemptId appC = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)2), (int)0);
    final ApplicationAttemptId appD = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)3), (int)0);
    final ApplicationAttemptId appE = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)4), (int)0);
    final ApplicationAttemptId appF = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)4), (int)0);
    final ArgumentCaptor<ContainerPreemptEvent> evtCaptor = ArgumentCaptor.forClass(ContainerPreemptEvent.class);
    @Rule
    public TestName name = new TestName();
    private static final int[][] Q_DATA_FOR_IGNORE = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};

    @Before
    public void setup() {
        this.conf = new CapacitySchedulerConfiguration(new Configuration(false));
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.conf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getCanonicalName());
        this.conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mCS = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.mCS.getResourceCalculator()).thenReturn((Object)this.rc);
        this.lm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        try {
            Mockito.when((Object)this.lm.isExclusiveNodeLabel(Matchers.anyString())).thenReturn((Object)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Mockito.when((Object)this.mCS.getConfiguration()).thenReturn((Object)this.conf);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.mCS.getRMContext()).thenReturn((Object)this.rmContext);
        Mockito.when((Object)this.mCS.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.rmContext.getNodeLabelManager()).thenReturn((Object)this.lm);
        this.mDisp = (EventHandler)Mockito.mock(EventHandler.class);
        Dispatcher disp = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)this.rmContext.getDispatcher()).thenReturn((Object)disp);
        Mockito.when((Object)disp.getEventHandler()).thenReturn(this.mDisp);
        this.rand = new Random();
        long seed = this.rand.nextLong();
        System.out.println(this.name.getMethodName() + " SEED: " + seed);
        this.rand.setSeed(seed);
        this.appAlloc = 0;
    }

    @Test
    public void testIgnore() {
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(Q_DATA_FOR_IGNORE);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testProportionalPreemption() {
        int[][] qData = new int[][]{{100, 10, 40, 20, 30}, {100, 100, 100, 100, 100}, {100, 30, 60, 10, 0}, {45, 20, 5, 20, 0}, {0, 0, 0, 0, 0}, {3, 1, 1, 1, 0}, {-1, 1, 1, 1, 1}, {4, 0, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testMaxCap() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 45, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testPreemptCycle() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testExpireKill() {
        long killTime = 10000L;
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)0L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)5000L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)10001L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)this.evtCaptor.capture());
        List events = this.evtCaptor.getAllValues();
        for (ContainerPreemptEvent e : events.subList(20, 20)) {
            Assert.assertEquals((Object)this.appC, (Object)e.getAppId());
            Assert.assertEquals((Object)SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE, (Object)e.getType());
        }
    }

    @Test
    public void testDeadzone() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 39, 43, 21}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testPerQueueDisablePreemption() {
        int[][] qData = new int[][]{{100, 55, 25, 20}, {100, 100, 100, 100}, {100, 0, 54, 46}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setPreemptionDisabled("root.queueB", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        this.setup();
        this.conf.setPreemptionDisabled("root.queueB", false);
        ProportionalCapacityPreemptionPolicy policy2 = this.buildPolicy(qData);
        policy2.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)6))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testPerQueueDisablePreemptionHierarchical() {
        int[][] qData = new int[][]{{200, 100, 50, 50, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {200, 110, 60, 50, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ApplicationAttemptId expectedAttemptOnQueueB = ApplicationAttemptId.newInstance((ApplicationId)this.appA.getApplicationId(), (int)this.appA.getAttemptId());
        Assert.assertTrue((String)"appA should be running on queueB", (boolean)this.mCS.getAppsInQueue("queueB").contains(expectedAttemptOnQueueB));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setup();
        this.conf.setPreemptionDisabled("root.queueA.queueB", true);
        ProportionalCapacityPreemptionPolicy policy2 = this.buildPolicy(qData);
        policy2.editSchedule();
        ApplicationAttemptId expectedAttemptOnQueueC = ApplicationAttemptId.newInstance((ApplicationId)this.appB.getApplicationId(), (int)this.appB.getAttemptId());
        ApplicationAttemptId expectedAttemptOnQueueE = ApplicationAttemptId.newInstance((ApplicationId)this.appC.getApplicationId(), (int)this.appC.getAttemptId());
        Assert.assertTrue((String)"appB should be running on queueC", (boolean)this.mCS.getAppsInQueue("queueC").contains(expectedAttemptOnQueueC));
        Assert.assertTrue((String)"appC should be running on queueE", (boolean)this.mCS.getAppsInQueue("queueE").contains(expectedAttemptOnQueueE));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testPerQueueDisablePreemptionBroadHierarchical() {
        int[][] qData = new int[][]{{1000, 350, 150, 200, 400, 200, 200, 250, 100, 150}, {1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000}, {1000, 400, 200, 200, 400, 250, 150, 200, 150, 50}, {50, 0, 0, 0, 50, 0, 50, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)27))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)23))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        this.setup();
        this.conf.setPreemptionDisabled("root.queueA.queueB", true);
        ProportionalCapacityPreemptionPolicy policy2 = this.buildPolicy(qData);
        policy2.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)50))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setup();
        this.conf.setPreemptionDisabled("root.queueD.queueE", true);
        this.conf.setPreemptionDisabled("root.queueA.queueB", true);
        ProportionalCapacityPreemptionPolicy policy3 = this.buildPolicy(qData);
        policy3.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appF)));
    }

    @Test
    public void testPerQueueDisablePreemptionInheritParent() {
        int[][] qData = new int[][]{{1000, 500, 200, 200, 100, 500, 200, 200, 100}, {1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000}, {1000, 700, 0, 350, 350, 300, 0, 200, 100}, {200, 0, 0, 0, 0, 200, 200, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 2, 0, 1, 1, 3, 1, 1, 1}, {-1, -1, 1, 1, 1, -1, 1, 1, 1}, {2, 3, 0, 0, 0, 3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)17))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)183))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        this.setup();
        this.conf.setPreemptionDisabled("root.queueA", true);
        ProportionalCapacityPreemptionPolicy policy2 = this.buildPolicy(qData);
        policy2.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
    }

    @Test
    public void testPerQueuePreemptionNotAllUntouchable() {
        int[][] qData = new int[][]{{2000, 1000, 800, 100, 100, 1000, 500, 300, 200}, {2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000}, {2000, 1300, 300, 800, 200, 700, 500, 0, 200}, {300, 0, 0, 0, 0, 300, 0, 300, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 3, 1, 1, 1, 3, 1, 1, 1}, {-1, -1, 1, 1, 1, -1, 1, 1, 1}, {2, 3, 0, 0, 0, 3, 0, 0, 0}};
        this.conf.setPreemptionDisabled("root.queueA.queueC", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)100))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testPerQueueDisablePreemptionRootDisablesAll() {
        int[][] qData = new int[][]{{1000, 500, 250, 250, 250, 100, 150, 250, 100, 150}, {1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000}, {1000, 20, 0, 20, 490, 240, 250, 490, 240, 250}, {200, 200, 200, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        this.conf.setPreemptionDisabled("root", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appF)));
    }

    @Test
    public void testPerQueueDisablePreemptionOverAbsMaxCapacity() {
        int[][] qData = new int[][]{{1000, 725, 360, 365, 275, 17, 258}, {1000, 1000, 1000, 1000, 550, 109, 1000}, {1000, 741, 396, 345, 259, 110, 149}, {40, 20, 0, 20, 20, 20, 0}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        this.conf.setPreemptionDisabled("root.queueD", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testOverCapacityImbalance() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testNaturalTermination() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testObserveOnly() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 90, 10, 0}, {80, 10, 20, 50}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", true);
        Mockito.when((Object)this.mCS.getConfiguration()).thenReturn((Object)new CapacitySchedulerConfiguration((Configuration)this.conf));
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testHierarchical() {
        int[][] qData = new int[][]{{200, 100, 50, 50, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {200, 110, 60, 50, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testHierarchicalWithReserved() {
        int[][] qData = new int[][]{{200, 100, 50, 50, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {200, 110, 60, 50, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {40, 25, 15, 10, 15, 15, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuar() {
        int[][] qData = new int[][]{{200, 100, 0, 99, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {170, 80, 60, 20, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuarOverCap() {
        int[][] qData = new int[][]{{200, 100, 0, 100, 0, 100, 100}, {200, 200, 200, 200, 200, 200, 200}, {170, 170, 60, 20, 90, 0, 0}, {85, 50, 30, 10, 10, 20, 20}, {0, 0, 0, 0, 0, 0, 0}, {4, 3, 1, 1, 1, 1, 1}, {-1, -1, 1, 1, 1, -1, 1}, {2, 3, 0, 0, 0, 1, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
    }

    @Test
    public void testHierarchicalLarge() {
        int[][] qData = new int[][]{{400, 200, 60, 140, 100, 70, 30, 100, 10, 90}, {400, 400, 400, 400, 400, 400, 400, 400, 400, 400}, {400, 210, 70, 140, 100, 50, 50, 90, 90, 0}, {15, 0, 0, 0, 0, 0, 0, 0, 0, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)6))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
    }

    @Test
    public void testContainerOrdering() {
        ArrayList<RMContainer> containers = new ArrayList<RMContainer>();
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)10), (int)0);
        RMContainer rm1 = this.mockContainer(appAttId, 5, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm2 = this.mockContainer(appAttId, 3, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm3 = this.mockContainer(appAttId, 2, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm4 = this.mockContainer(appAttId, 1, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm5 = this.mockContainer(appAttId, 4, (Resource)Mockito.mock(Resource.class), 1);
        containers.add(rm3);
        containers.add(rm2);
        containers.add(rm1);
        containers.add(rm5);
        containers.add(rm4);
        FifoCandidatesSelector.sortContainers(containers);
        assert (((RMContainer)containers.get(0)).equals(rm1));
        assert (((RMContainer)containers.get(1)).equals(rm2));
        assert (((RMContainer)containers.get(2)).equals(rm3));
        assert (((RMContainer)containers.get(3)).equals(rm4));
        assert (((RMContainer)containers.get(4)).equals(rm5));
    }

    @Test
    public void testPolicyInitializeAfterSchedulerInitialized() {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.init((Configuration)this.conf);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        SchedulingMonitorManager smm = cs.getSchedulingMonitorManager();
        SchedulingMonitor service = smm.getAvailableSchedulingMonitor();
        if (service instanceof SchedulingMonitor) {
            ProportionalCapacityPreemptionPolicy policy = (ProportionalCapacityPreemptionPolicy)service.getSchedulingEditPolicy();
            Assert.assertNotNull((Object)policy.getResourceCalculator());
            return;
        }
        Assert.fail((String)"Failed to find SchedulingMonitor service, please check what happened");
    }

    @Test
    public void testSkipAMContainer() {
        int[][] qData = new int[][]{{100, 50, 50}, {100, 100, 100}, {100, 100, 0}, {70, 20, 50}, {0, 0, 0}, {5, 4, 1}, {-1, 1, 1}, {2, 0, 0}};
        this.setAMContainer = true;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)24))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)24))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        this.setAMContainer = false;
    }

    @Test
    public void testPreemptSkippedAMContainers() {
        int[][] qData = new int[][]{{100, 10, 90}, {100, 100, 100}, {100, 100, 0}, {70, 20, 90}, {0, 0, 0}, {5, 4, 1}, {-1, 5, 5}, {2, 0, 0}};
        this.setAMContainer = true;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setAMContainer = false;
    }

    @Test
    public void testAMResourcePercentForSkippedAMContainers() {
        int[][] qData = new int[][]{{100, 10, 90}, {100, 100, 100}, {100, 100, 0}, {70, 20, 90}, {0, 0, 0}, {5, 4, 1}, {-1, 5, 5}, {2, 0, 0}};
        this.setAMContainer = true;
        this.setAMResourcePercent = 0.5f;
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appD)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appB)));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        this.setAMContainer = false;
    }

    @Test
    public void testPreemptionWithVCoreResource() {
        int[][] qData = new int[][]{{100, 100, 100}, {5, 1, 1}, {2, 0, 0}};
        String[][] resData = new String[][]{{"100:100", "50:50", "50:50"}, {"10:100", "10:100", "0"}, {"70:20", "70:20", "10:100"}, {"0", "0", "0"}, {"-1", "1:10", "1:10"}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData, resData, true);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testHierarchicalLarge3Levels() {
        int[][] qData = new int[][]{{400, 200, 60, 140, 100, 40, 100, 70, 30, 100, 10, 90}, {400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400}, {400, 210, 60, 150, 100, 50, 100, 50, 50, 90, 10, 80}, {10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {7, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Assert.assertEquals((long)10L, (long)((TempQueuePerPartition)((Map)policy.getQueuePartitions().get((Object)"queueE")).get((Object)"")).preemptableExtra.getMemorySize());
        TempQueuePerPartition tempQueueAPartition = (TempQueuePerPartition)((Map)policy.getQueuePartitions().get("queueA")).get("");
        Assert.assertEquals((long)0L, (long)tempQueueAPartition.untouchableExtra.getMemorySize());
        long extraForQueueA = tempQueueAPartition.getUsed().getMemorySize() - tempQueueAPartition.getGuaranteed().getMemorySize();
        Assert.assertEquals((long)extraForQueueA, (long)tempQueueAPartition.preemptableExtra.getMemorySize());
    }

    @Test
    public void testHierarchicalLarge3LevelsWithReserved() {
        int[][] qData = new int[][]{{400, 200, 60, 140, 100, 40, 100, 70, 30, 100, 10, 90}, {400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400, 400}, {400, 210, 60, 150, 100, 50, 100, 50, 50, 90, 10, 80}, {10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {50, 30, 20, 10, 5, 5, 0, 0, 0, 10, 10, 0}, {7, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Assert.assertEquals((long)10L, (long)((TempQueuePerPartition)((Map)policy.getQueuePartitions().get((Object)"queueE")).get((Object)"")).preemptableExtra.getMemorySize());
        TempQueuePerPartition tempQueueAPartition = (TempQueuePerPartition)((Map)policy.getQueuePartitions().get("queueA")).get("");
        Assert.assertEquals((long)0L, (long)tempQueueAPartition.untouchableExtra.getMemorySize());
        long extraForQueueA = tempQueueAPartition.getUsed().getMemorySize() - tempQueueAPartition.getGuaranteed().getMemorySize();
        Assert.assertEquals((long)extraForQueueA, (long)tempQueueAPartition.preemptableExtra.getMemorySize());
    }

    @Test
    public void testPreemptionNotHappenForSingleReservedQueue() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 70, 0, 0}, {10, 30, 0, 0}, {0, 50, 0, 0}, {1, 1, 0, 0}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testRefreshPreemptionProperties() throws Exception {
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy(Q_DATA_FOR_IGNORE);
        Assert.assertEquals((long)3000L, (long)policy.getMonitoringInterval());
        Assert.assertEquals((Object)false, (Object)policy.isObserveOnly());
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        long newMonitoringInterval = 5000L;
        boolean newObserveOnly = true;
        newConf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", newMonitoringInterval);
        newConf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", newObserveOnly);
        Mockito.when((Object)this.mCS.getConfiguration()).thenReturn((Object)newConf);
        policy.editSchedule();
        Assert.assertEquals((long)newMonitoringInterval, (long)policy.getMonitoringInterval());
        Assert.assertEquals((Object)newObserveOnly, (Object)policy.isObserveOnly());
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData) {
        ProportionalCapacityPreemptionPolicy policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.mCS, this.mClock);
        this.clusterResources = Resource.newInstance((int)TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(qData[0], qData[7]), (int)0);
        ParentQueue mRoot = this.buildMockRootQueue(this.rand, qData);
        Mockito.when((Object)this.mCS.getRootQueue()).thenReturn((Object)mRoot);
        this.setResourceAndNodeDetails();
        return policy;
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData, String[][] resData, boolean useDominantResourceCalculator) {
        if (useDominantResourceCalculator) {
            Mockito.when((Object)this.mCS.getResourceCalculator()).thenReturn((Object)new DominantResourceCalculator());
        }
        ProportionalCapacityPreemptionPolicy policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.mCS, this.mClock);
        this.clusterResources = TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(this.parseResourceDetails(resData[0]), qData[2]);
        ParentQueue mRoot = this.buildMockRootQueue(this.rand, resData, qData);
        Mockito.when((Object)this.mCS.getRootQueue()).thenReturn((Object)mRoot);
        this.setResourceAndNodeDetails();
        return policy;
    }

    private void setResourceAndNodeDetails() {
        Mockito.when((Object)this.mCS.getClusterResource()).thenReturn((Object)this.clusterResources);
        Mockito.when((Object)this.lm.getResourceByLabel(Matchers.anyString(), (Resource)Matchers.any(Resource.class))).thenReturn((Object)this.clusterResources);
        FiCaSchedulerNode mNode = (FiCaSchedulerNode)Mockito.mock(FiCaSchedulerNode.class);
        Mockito.when((Object)mNode.getPartition()).thenReturn((Object)"");
        Mockito.when((Object)this.mCS.getSchedulerNode((NodeId)Matchers.any(NodeId.class))).thenReturn((Object)mNode);
    }

    ParentQueue buildMockRootQueue(Random r, int[] ... queueData) {
        Resource[] abs = this.generateResourceList(queueData[0]);
        Resource[] used = this.generateResourceList(queueData[2]);
        Resource[] pending = this.generateResourceList(queueData[3]);
        Resource[] reserved = this.generateResourceList(queueData[4]);
        Resource[] gran = this.generateResourceList(queueData[6]);
        int[] maxCap = queueData[1];
        int[] apps = queueData[5];
        int[] queues = queueData[7];
        return this.mockNested(abs, maxCap, used, pending, reserved, apps, gran, queues);
    }

    ParentQueue buildMockRootQueue(Random r, String[][] resData, int[] ... queueData) {
        Resource[] abs = this.parseResourceDetails(resData[0]);
        Resource[] used = this.parseResourceDetails(resData[1]);
        Resource[] pending = this.parseResourceDetails(resData[2]);
        Resource[] reserved = this.parseResourceDetails(resData[3]);
        Resource[] gran = this.parseResourceDetails(resData[4]);
        int[] maxCap = queueData[0];
        int[] apps = queueData[1];
        int[] queues = queueData[2];
        return this.mockNested(abs, maxCap, used, pending, reserved, apps, gran, queues);
    }

    Resource[] parseResourceDetails(String[] resData) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i = 0; i < resData.length; ++i) {
            String[] resource = resData[i].split(":");
            if (resource.length == 1) {
                resourceList.add(Resource.newInstance((int)Integer.parseInt(resource[0]), (int)0));
                continue;
            }
            resourceList.add(Resource.newInstance((int)Integer.parseInt(resource[0]), (int)Integer.parseInt(resource[1])));
        }
        return resourceList.toArray(new Resource[resourceList.size()]);
    }

    Resource[] generateResourceList(int[] qData) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (int i = 0; i < qData.length; ++i) {
            resourceList.add(Resource.newInstance((int)qData[i], (int)0));
        }
        return resourceList.toArray(new Resource[resourceList.size()]);
    }

    ParentQueue mockNested(Resource[] abs, int[] maxCap, Resource[] used, Resource[] pending, Resource[] reserved, int[] apps, Resource[] gran, int[] queues) {
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        Resource tot = TestProportionalCapacityPreemptionPolicy.leafAbsCapacities(abs, queues);
        LinkedList<ParentQueue> pqs = new LinkedList<ParentQueue>();
        ParentQueue root = this.mockParentQueue(null, queues[0], pqs);
        ResourceUsage resUsage = new ResourceUsage();
        resUsage.setUsed(used[0]);
        resUsage.setReserved(reserved[0]);
        Mockito.when((Object)root.getQueueName()).thenReturn((Object)"root");
        Mockito.when((Object)Float.valueOf(root.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[0], (Resource)tot)));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[0], (Resource)tot)));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[0] / (float)tot.getMemorySize()));
        Mockito.when((Object)root.getQueueResourceUsage()).thenReturn((Object)resUsage);
        QueueCapacities rootQc = new QueueCapacities(true);
        rootQc.setAbsoluteUsedCapacity(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[0], (Resource)tot));
        rootQc.setAbsoluteCapacity(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[0], (Resource)tot));
        rootQc.setAbsoluteMaximumCapacity((float)maxCap[0] / (float)tot.getMemorySize());
        Mockito.when((Object)root.getQueueCapacities()).thenReturn((Object)rootQc);
        Mockito.when((Object)root.getQueuePath()).thenReturn((Object)"root");
        boolean preemptionDisabled = this.mockPreemptionStatus("root");
        Mockito.when((Object)root.getPreemptionDisabled()).thenReturn((Object)preemptionDisabled);
        QueueResourceQuotas rootQr = new QueueResourceQuotas();
        rootQr.setEffectiveMaxResource(Resource.newInstance((int)maxCap[0], (int)0));
        rootQr.setEffectiveMinResource(abs[0]);
        rootQr.setEffectiveMaxResource("", Resource.newInstance((int)maxCap[0], (int)0));
        rootQr.setEffectiveMinResource("", abs[0]);
        Mockito.when((Object)root.getQueueResourceQuotas()).thenReturn((Object)rootQr);
        Mockito.when((Object)root.getEffectiveCapacity("")).thenReturn((Object)abs[0]);
        Mockito.when((Object)root.getEffectiveMaxCapacity("")).thenReturn((Object)Resource.newInstance((int)maxCap[0], (int)0));
        for (int i = 1; i < queues.length; ++i) {
            ParentQueue q;
            ParentQueue p = (ParentQueue)pqs.removeLast();
            String queueName = "queue" + (char)(65 + i - 1);
            if (queues[i] > 0) {
                q = this.mockParentQueue(p, queues[i], pqs);
                ResourceUsage resUsagePerQueue = new ResourceUsage();
                resUsagePerQueue.setUsed(used[i]);
                resUsagePerQueue.setReserved(reserved[i]);
                Mockito.when((Object)q.getQueueResourceUsage()).thenReturn((Object)resUsagePerQueue);
            } else {
                q = this.mockLeafQueue(p, tot, i, abs, used, pending, reserved, apps, gran);
            }
            Mockito.when((Object)q.getParent()).thenReturn((Object)p);
            Mockito.when((Object)q.getQueueName()).thenReturn((Object)queueName);
            Mockito.when((Object)Float.valueOf(q.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[i], (Resource)tot)));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[i], (Resource)tot)));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[i] / (float)tot.getMemorySize()));
            QueueCapacities qc = new QueueCapacities(false);
            qc.setAbsoluteUsedCapacity(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)used[i], (Resource)tot));
            qc.setAbsoluteCapacity(Resources.divide((ResourceCalculator)rc, (Resource)tot, (Resource)abs[i], (Resource)tot));
            qc.setAbsoluteMaximumCapacity((float)maxCap[i] / (float)tot.getMemorySize());
            Mockito.when((Object)q.getQueueCapacities()).thenReturn((Object)qc);
            QueueResourceQuotas qr = new QueueResourceQuotas();
            qr.setEffectiveMaxResource(Resource.newInstance((int)maxCap[i], (int)0));
            qr.setEffectiveMinResource(abs[i]);
            qr.setEffectiveMaxResource("", Resource.newInstance((int)maxCap[i], (int)0));
            qr.setEffectiveMinResource("", abs[i]);
            Mockito.when((Object)q.getQueueResourceQuotas()).thenReturn((Object)qr);
            Mockito.when((Object)q.getEffectiveCapacity("")).thenReturn((Object)abs[i]);
            Mockito.when((Object)q.getEffectiveMaxCapacity("")).thenReturn((Object)Resource.newInstance((int)maxCap[i], (int)0));
            String parentPathName = p.getQueuePath();
            parentPathName = parentPathName == null ? "root" : parentPathName;
            String queuePathName = (parentPathName + "." + queueName).replace("/", "root");
            Mockito.when((Object)q.getQueuePath()).thenReturn((Object)queuePathName);
            preemptionDisabled = this.mockPreemptionStatus(queuePathName);
            Mockito.when((Object)q.getPreemptionDisabled()).thenReturn((Object)preemptionDisabled);
        }
        assert (0 == pqs.size());
        return root;
    }

    private boolean mockPreemptionStatus(String queuePathName) {
        boolean preemptionDisabled = false;
        StringTokenizer tokenizer = new StringTokenizer(queuePathName, ".");
        String qName = "";
        while (tokenizer.hasMoreTokens()) {
            qName = qName + tokenizer.nextToken();
            preemptionDisabled = this.conf.getPreemptionDisabled(qName, preemptionDisabled);
            qName = qName + ".";
        }
        return preemptionDisabled;
    }

    ParentQueue mockParentQueue(ParentQueue p, int subqueues, Deque<ParentQueue> pqs) {
        ParentQueue pq = (ParentQueue)Mockito.mock(ParentQueue.class);
        ArrayList cqs = new ArrayList();
        Mockito.when((Object)pq.getChildQueues()).thenReturn(cqs);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Mockito.when((Object)pq.getReadLock()).thenReturn((Object)lock.readLock());
        QueueOrderingPolicy policy = (QueueOrderingPolicy)Mockito.mock(QueueOrderingPolicy.class);
        Mockito.when((Object)policy.getConfigName()).thenReturn((Object)"priority-utilization");
        Mockito.when((Object)pq.getQueueOrderingPolicy()).thenReturn((Object)policy);
        Mockito.when((Object)pq.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        for (int i = 0; i < subqueues; ++i) {
            pqs.add(pq);
        }
        if (p != null) {
            p.getChildQueues().add(pq);
        }
        return pq;
    }

    LeafQueue mockLeafQueue(ParentQueue p, Resource tot, int i, Resource[] abs, Resource[] used, Resource[] pending, Resource[] reserved, int[] apps, Resource[] gran) {
        LeafQueue lq = (LeafQueue)Mockito.mock(LeafQueue.class);
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        ArrayList<ApplicationAttemptId> appAttemptIdList = new ArrayList<ApplicationAttemptId>();
        Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)Matchers.isA(Resource.class), (String)Matchers.isA(String.class), Matchers.eq((boolean)false))).thenReturn((Object)pending[i]);
        Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)Matchers.isA(Resource.class), (String)Matchers.isA(String.class), Matchers.eq((boolean)true))).thenReturn((Object)Resources.componentwiseMax((Resource)Resources.subtract((Resource)pending[i], (Resource)(reserved[i] == null ? Resources.none() : reserved[i])), (Resource)Resources.none()));
        ResourceUsage ru = new ResourceUsage();
        ru.setPending(pending[i]);
        ru.setUsed(used[i]);
        ru.setReserved(reserved[i]);
        Mockito.when((Object)lq.getQueueResourceUsage()).thenReturn((Object)ru);
        final TreeSet<FiCaSchedulerApp> qApps = new TreeSet<FiCaSchedulerApp>(new Comparator<FiCaSchedulerApp>(){

            @Override
            public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
                return a1.getApplicationAttemptId().compareTo(a2.getApplicationAttemptId());
            }
        });
        if (apps[i] != 0) {
            Resource aUsed = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)used[i], (int)apps[i]);
            Resource aPending = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)pending[i], (int)apps[i]);
            Resource aReserve = Resources.divideAndCeil((ResourceCalculator)rc, (Resource)reserved[i], (int)apps[i]);
            for (int a = 0; a < apps[i]; ++a) {
                FiCaSchedulerApp mockFiCaApp = this.mockApp(i, this.appAlloc, aUsed, aPending, aReserve, gran[i]);
                qApps.add(mockFiCaApp);
                ++this.appAlloc;
                appAttemptIdList.add(mockFiCaApp.getApplicationAttemptId());
            }
            Mockito.when((Object)this.mCS.getAppsInQueue("queue" + (char)(65 + i - 1))).thenReturn(appAttemptIdList);
        }
        Mockito.when((Object)lq.getApplications()).thenReturn(qApps);
        OrderingPolicy so = (OrderingPolicy)Mockito.mock(OrderingPolicy.class);
        Mockito.when((Object)so.getPreemptionIterator()).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocation) {
                return qApps.descendingIterator();
            }
        });
        Mockito.when((Object)lq.getOrderingPolicy()).thenReturn((Object)so);
        if (this.setAMResourcePercent != 0.0f) {
            Mockito.when((Object)Float.valueOf(lq.getMaxAMResourcePerQueuePercent())).thenReturn((Object)Float.valueOf(this.setAMResourcePercent));
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Mockito.when((Object)lq.getReadLock()).thenReturn((Object)lock.readLock());
        Mockito.when((Object)lq.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        p.getChildQueues().add(lq);
        return lq;
    }

    FiCaSchedulerApp mockApp(int qid, int id, Resource used, Resource pending, Resource reserved, Resource gran) {
        FiCaSchedulerApp app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ResourceCalculator rc = this.mCS.getResourceCalculator();
        ApplicationId appId = ApplicationId.newInstance((long)3141592653L, (int)id);
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)appAttId);
        int cAlloc = 0;
        Resource unit = gran;
        ArrayList<RMContainer> cReserved = new ArrayList<RMContainer>();
        Resource resIter = Resource.newInstance((int)0, (int)0);
        while (Resources.lessThan((ResourceCalculator)rc, (Resource)this.clusterResources, (Resource)resIter, (Resource)reserved)) {
            cReserved.add(this.mockContainer(appAttId, cAlloc, unit, priority.CONTAINER.getValue()));
            ++cAlloc;
            Resources.addTo((Resource)resIter, (Resource)gran);
        }
        Mockito.when((Object)app.getReservedContainers()).thenReturn(cReserved);
        ArrayList<RMContainer> cLive = new ArrayList<RMContainer>();
        Resource usedIter = Resource.newInstance((int)0, (int)0);
        int i = 0;
        while (Resources.lessThan((ResourceCalculator)rc, (Resource)this.clusterResources, (Resource)usedIter, (Resource)used)) {
            if (this.setAMContainer && i == 0) {
                cLive.add(this.mockContainer(appAttId, cAlloc, unit, priority.AMCONTAINER.getValue()));
            } else if (this.setLabeledContainer && i == 1) {
                cLive.add(this.mockContainer(appAttId, cAlloc, unit, priority.LABELEDCONTAINER.getValue()));
                Resources.addTo((Resource)used, (Resource)Resource.newInstance((int)1, (int)1));
            } else {
                cLive.add(this.mockContainer(appAttId, cAlloc, unit, priority.CONTAINER.getValue()));
            }
            ++cAlloc;
            ++i;
            Resources.addTo((Resource)usedIter, (Resource)gran);
        }
        Mockito.when((Object)app.getLiveContainers()).thenReturn(cLive);
        return app;
    }

    RMContainer mockContainer(ApplicationAttemptId appAttId, int id, Resource r, int cpriority) {
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)appAttId, (long)id);
        Container c = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)c.getResource()).thenReturn((Object)r);
        Mockito.when((Object)c.getPriority()).thenReturn((Object)Priority.newInstance((int)cpriority));
        SchedulerRequestKey sk = SchedulerRequestKey.extractFrom((Container)c);
        RMContainer mC = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)mC.getContainerId()).thenReturn((Object)cId);
        Mockito.when((Object)mC.getAllocatedSchedulerKey()).thenReturn((Object)sk);
        Mockito.when((Object)mC.getContainer()).thenReturn((Object)c);
        Mockito.when((Object)mC.getApplicationAttemptId()).thenReturn((Object)appAttId);
        Mockito.when((Object)mC.getAllocatedResource()).thenReturn((Object)r);
        if (priority.AMCONTAINER.getValue() == cpriority) {
            Mockito.when((Object)mC.isAMContainer()).thenReturn((Object)true);
        }
        if (priority.LABELEDCONTAINER.getValue() == cpriority) {
            Mockito.when((Object)mC.getAllocatedNode()).thenReturn((Object)NodeId.newInstance((String)"node1", (int)0));
        }
        return mC;
    }

    static int leafAbsCapacities(int[] abs, int[] subqueues) {
        int ret = 0;
        for (int i = 0; i < abs.length; ++i) {
            if (0 != subqueues[i]) continue;
            ret += abs[i];
        }
        return ret;
    }

    static Resource leafAbsCapacities(Resource[] abs, int[] subqueues) {
        Resource ret = Resource.newInstance((int)0, (int)0);
        for (int i = 0; i < abs.length; ++i) {
            if (0 != subqueues[i]) continue;
            Resources.addTo((Resource)ret, (Resource)abs[i]);
        }
        return ret;
    }

    static class IsPreemptionRequestFor
    extends ArgumentMatcher<ContainerPreemptEvent> {
        private final ApplicationAttemptId appAttId;
        private final SchedulerEventType type;

        IsPreemptionRequestFor(ApplicationAttemptId appAttId) {
            this(appAttId, SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION);
        }

        IsPreemptionRequestFor(ApplicationAttemptId appAttId, SchedulerEventType type) {
            this.appAttId = appAttId;
            this.type = type;
        }

        public boolean matches(Object o) {
            return this.appAttId.equals((Object)((ContainerPreemptEvent)o).getAppId()) && this.type.equals((Object)((ContainerPreemptEvent)o).getType());
        }

        public String toString() {
            return this.appAttId.toString();
        }
    }

    public static enum priority {
        AMCONTAINER(0),
        CONTAINER(1),
        LABELEDCONTAINER(2);

        int value;

        private priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

