/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicyMockFramework;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyIntraQueueUserLimit
extends ProportionalCapacityPreemptionPolicyMockFramework {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", true);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    @Test
    public void testSimpleIntraQueuePreemptionWithTwoUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 30 0]);-a(=[100 100 100 30 0])";
        String appsConfig = "a\t(1,1,n1,,100,false,0,user1);a\t(1,1,n1,,0,false,30,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testNoIntraQueuePreemptionWithSingleUser() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 30 0]);-a(=[100 100 100 30 0])";
        String appsConfig = "a\t(1,1,n1,,100,false,0,user1);a\t(1,1,n1,,0,false,30,user1)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testNoIntraQueuePreemptionWithTwoUserUnderUserLimit() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 30 0]);-a(=[100 100 80 30 0])";
        String appsConfig = "a\t(1,1,n1,,50,false,0,user1);a\t(1,1,n1,,30,false,30,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testSimpleIntraQueuePreemptionWithTwoUsersWithAppPriority() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 30 0]);-a(=[100 100 100 30 0])";
        String appsConfig = "a\t(2,1,n1,,100,false,0,user1);a\t(1,1,n1,,0,false,30,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionOfUserLimitWithMultipleApps() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 90 0]);-a(=[100 100 80 90 0])";
        String appsConfig = "a\t(1,1,n1,,30,false,30,user1);a\t(1,1,n1,,20,false,20,user2);a\t(1,1,n1,,30,false,30,user1);a\t(1,1,n1,,0,false,10,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNoPreemptionOfUserLimitWithMultipleAppsAndSameUser() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 90 0]);-a(=[100 100 80 90 0])";
        String appsConfig = "a\t(1,1,n1,,30,false,20,user1);a\t(1,1,n1,,20,false,20,user1);a\t(1,1,n1,,30,false,30,user1);a\t(1,1,n1,,0,false,10,user1)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
    }

    @Test
    public void testIntraQueuePreemptionOfUserLimitWitAppsOfDifferentPriority() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 80 60 0]);-a(=[100 100 80 60 0])";
        String appsConfig = "a\t(3,1,n1,,30,false,30,user1);a\t(1,1,n1,,20,false,20,user2);a\t(4,1,n1,,30,false,0,user1);a\t(1,1,n1,,0,false,10,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testIntraQueuePreemptionOfUserLimitInTwoQueues() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 90 80 0]);-a(=[60 100 55 60 0]);-b(=[40 100 35 20 0])";
        String appsConfig = "a\t(3,1,n1,,20,false,30,user1);a\t(1,1,n1,,20,false,20,user2);a\t(4,1,n1,,15,false,0,user1);a\t(1,1,n1,,0,false,10,user2);b\t(3,1,n1,,25,false,10,user1);b\t(1,1,n1,,10,false,10,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }

    @Test
    public void testIntraQueuePreemptionWithTwoRequestingUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 20 0]);-a(=[100 100 100 20 0])";
        String appsConfig = "a\t(1,1,n1,,60,false,10,user1);a\t(1,1,n1,,40,false,10,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNoIntraQueuePreemptionIfBelowUserLimitAndLowPriorityExtraUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.7f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 10 0]);-a(=[100 100 100 10 0])";
        String appsConfig = "a\t(1,1,n1,,50,false,0,user1)\t50;a\t(1,1,n1,,50,false,0,user2)\t50;a\t(0,1,n1,,0,false,10,user3)\t50";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNoIntraQueuePreemptionIfBelowUserLimitAndSamePriorityExtraUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.7f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 10 0]);-a(=[100 100 100 10 0])";
        String appsConfig = "a\t(1,1,n1,,50,false,0,user1)\t50;a\t(1,1,n1,,50,false,0,user2)\t50;a\t(1,1,n1,,0,false,10,user3)\t50";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNoIntraQueuePreemptionIfBelowUserLimitAndHighPriorityExtraUsers() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.7f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 10 0]);-a(=[100 100 100 10 0])";
        String appsConfig = "a\t(1,1,n1,,50,false,0,user1)\t50;a\t(1,1,n1,,50,false,0,user2)\t50;a\t(5,1,n1,,0,false,10,user3)\t50";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNoIntraQueuePreemptionWithUserLimitDeadzone() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 20 0]);-a(=[100 100 100 20 0])";
        String appsConfig = "a\t(1,3,n1,,20,false,10,user1);a\t(1,1,n1,,40,false,10,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testIntraQueuePreemptionWithUserLimitDeadzoneAndPriority() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 20 0]);-a(=[100 100 100 20 0])";
        String appsConfig = "a\t(1,3,n1,,20,false,10,user1);a\t(2,1,n1,,0,false,10,user1);a\t(1,1,n1,,40,false,20,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        appsConfig = "a\t(1,3,n1,,17,false,10,user1);a\t(2,1,n1,,0,false,10,user1);a\t(1,1,n1,,49,false,11,user2)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)3))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testSimpleIntraQueuePreemptionOneUserUnderOneUserAtOneUserAbove() throws IOException {
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.5f);
        String labelsConfig = "=100,true;";
        String nodesConfig = "n1= res=100";
        String queuesConfig = "root(=[100 100 100 1 0]);-a(=[100 100 100 1 0])";
        String appsConfig = "a\t(1,1,n1,,65,false,0,user1);a\t(1,1,n1,,35,false,0,user2);a\t(1,1,n1,,0,false,1,user3)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)1))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }
}

