/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.TestGroupsCaching;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueManagementChange;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.queuemanagement.GuaranteedOrZeroCapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class TestCapacitySchedulerAutoCreatedQueueBase {
    private static final Log LOG = LogFactory.getLog(TestCapacitySchedulerAutoCreatedQueueBase.class);
    public static final int GB = 1024;
    public static final ContainerUpdates NULL_UPDATE_REQUESTS = new ContainerUpdates();
    public static final String A = "root.a";
    public static final String B = "root.b";
    public static final String C = "root.c";
    public static final String D = "root.d";
    public static final String E = "root.e";
    public static final String A1 = "root.a.a1";
    public static final String A2 = "root.a.a2";
    public static final String B1 = "root.b.b1";
    public static final String B2 = "root.b.b2";
    public static final String B3 = "root.b.b3";
    public static final float A_CAPACITY = 20.0f;
    public static final float B_CAPACITY = 40.0f;
    public static final float C_CAPACITY = 20.0f;
    public static final float D_CAPACITY = 20.0f;
    public static final float A1_CAPACITY = 30.0f;
    public static final float A2_CAPACITY = 70.0f;
    public static final float B1_CAPACITY = 60.0f;
    public static final float B2_CAPACITY = 20.0f;
    public static final float B3_CAPACITY = 20.0f;
    public static final int NODE_MEMORY = 16;
    public static final int NODE1_VCORES = 16;
    public static final int NODE2_VCORES = 32;
    public static final int NODE3_VCORES = 48;
    public static final String TEST_GROUP = "testusergroup";
    public static final String TEST_GROUPUSER = "testuser";
    public static final String USER = "user_";
    public static final String USER0 = "user_0";
    public static final String USER1 = "user_1";
    public static final String USER2 = "user_2";
    public static final String USER3 = "user_3";
    public static final String PARENT_QUEUE = "c";
    public static final Set<String> accessibleNodeLabelsOnC = new HashSet<String>();
    public static final String NODEL_LABEL_GPU = "GPU";
    public static final String NODEL_LABEL_SSD = "SSD";
    public static final float NODE_LABEL_GPU_TEMPLATE_CAPACITY = 30.0f;
    public static final float NODEL_LABEL_SSD_TEMPLATE_CAPACITY = 40.0f;
    protected MockRM mockRM = null;
    protected MockNM nm1 = null;
    protected MockNM nm2 = null;
    protected MockNM nm3 = null;
    protected CapacityScheduler cs;
    protected SpyDispatcher dispatcher;
    private static EventHandler<Event> rmAppEventEventHandler;

    @Before
    public void setUp() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, PARENT_QUEUE, true, new int[]{0, 1, 2, 3});
        this.dispatcher = new SpyDispatcher();
        rmAppEventEventHandler = new SpyDispatcher.SpyRMAppEventHandler();
        this.dispatcher.register(RMAppEventType.class, rmAppEventEventHandler);
        final RMNodeLabelsManager mgr = this.setupNodeLabelManager(conf);
        this.mockRM = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        this.cs = (CapacityScheduler)this.mockRM.getResourceScheduler();
        this.cs.updatePlacementRules();
        this.mockRM.start();
        this.cs.start();
        this.setupNodes(this.mockRM);
    }

    protected void setupNodes(MockRM newMockRM) throws Exception {
        final NodeLabel ssdLabel = (NodeLabel)Records.newRecord(NodeLabel.class);
        ssdLabel.setName(NODEL_LABEL_SSD);
        ssdLabel.setExclusivity(true);
        this.nm1 = new MockNM("h1:1234", Resource.newInstance((int)16384, (int)16), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion(), (Set<NodeLabel>)new HashSet<NodeLabel>(){
            {
                this.add(ssdLabel);
            }
        });
        this.nm1.registerNode();
        final NodeLabel gpuLabel = (NodeLabel)Records.newRecord(NodeLabel.class);
        ssdLabel.setName(NODEL_LABEL_GPU);
        ssdLabel.setExclusivity(true);
        this.nm2 = new MockNM("h2:1234", Resource.newInstance((int)16384, (int)32), newMockRM.getResourceTrackerService(), YarnVersionInfo.getVersion(), (Set<NodeLabel>)new HashSet<NodeLabel>(){
            {
                this.add(gpuLabel);
            }
        });
        this.nm2.registerNode();
        this.nm3 = new MockNM("h3:1234", 16384, 48, newMockRM.getResourceTrackerService());
        this.nm3.registerNode();
    }

    public static CapacitySchedulerConfiguration setupQueueMappings(CapacitySchedulerConfiguration conf, String parentQueue, boolean overrideWithQueueMappings, int[] userIds) {
        ArrayList<String> queuePlacementRules = new ArrayList<String>();
        queuePlacementRules.add("user-group");
        conf.setQueuePlacementRules(queuePlacementRules);
        List existingMappings = conf.getQueueMappings();
        ArrayList<UserGroupMappingPlacementRule.QueueMapping> queueMappings = new ArrayList<UserGroupMappingPlacementRule.QueueMapping>();
        for (int i = 0; i < userIds.length; ++i) {
            UserGroupMappingPlacementRule.QueueMapping userQueueMapping = new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, USER + userIds[i], TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, USER + userIds[i]));
            queueMappings.add(userQueueMapping);
        }
        existingMappings.addAll(queueMappings);
        conf.setQueueMappings(existingMappings);
        conf.setOverrideWithQueueMappings(overrideWithQueueMappings);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupGroupQueueMappings(String parentQueue, CapacitySchedulerConfiguration conf, String leafQueueName) {
        List existingMappings = conf.getQueueMappings();
        ArrayList<UserGroupMappingPlacementRule.QueueMapping> queueMappings = new ArrayList<UserGroupMappingPlacementRule.QueueMapping>();
        conf.setClass("hadoop.security.group.mapping", TestGroupsCaching.FakeunPrivilegedGroupMapping.class, ShellBasedUnixGroupsMapping.class);
        conf.set("hadoop.user.group.static.mapping.overrides", "testuser=testusergroup;invalid_user=invalid_group");
        UserGroupMappingPlacementRule.QueueMapping userQueueMapping = new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.GROUP, TEST_GROUP, TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, leafQueueName));
        queueMappings.add(userQueueMapping);
        existingMappings.addAll(queueMappings);
        conf.setQueueMappings(existingMappings);
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b", PARENT_QUEUE, "d"});
        conf.setCapacity(A, 20.0f);
        conf.setCapacity(B, 40.0f);
        conf.setCapacity(C, 20.0f);
        conf.setCapacity(D, 20.0f);
        conf.setQueues(A, new String[]{"a1", "a2"});
        conf.setCapacity(A1, 30.0f);
        conf.setUserLimitFactor(A1, 100.0f);
        conf.setCapacity(A2, 70.0f);
        conf.setUserLimitFactor(A2, 100.0f);
        conf.setQueues(B, new String[]{"b1", "b2", "b3"});
        conf.setCapacity(B1, 60.0f);
        conf.setUserLimitFactor(B1, 100.0f);
        conf.setCapacity(B2, 20.0f);
        conf.setUserLimitFactor(B2, 100.0f);
        conf.setCapacity(B3, 20.0f);
        conf.setUserLimitFactor(B3, 100.0f);
        conf.setUserLimitFactor(C, 1.0f);
        conf.setAutoCreateChildQueueEnabled(C, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(C, 50.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(C, 3.0f);
        conf.setAutoCreatedLeafQueueTemplateCapacityByLabel(C, NODEL_LABEL_GPU, 30.0f);
        conf.setAutoCreatedLeafQueueTemplateMaxCapacity(C, NODEL_LABEL_GPU, 100.0f);
        conf.setAutoCreatedLeafQueueTemplateCapacityByLabel(C, NODEL_LABEL_SSD, 40.0f);
        conf.setAutoCreatedLeafQueueTemplateMaxCapacity(C, NODEL_LABEL_SSD, 100.0f);
        conf.setDefaultNodeLabelExpression(C, NODEL_LABEL_GPU);
        conf.setAutoCreatedLeafQueueConfigDefaultNodeLabelExpression(C, NODEL_LABEL_SSD);
        LOG.info((Object)"Setup root.c as an auto leaf creation enabled parent queue");
        conf.setUserLimitFactor(D, 1.0f);
        conf.setAutoCreateChildQueueEnabled(D, true);
        conf.setUserLimit(D, 100);
        conf.setUserLimitFactor(D, 3.0f);
        conf.setAutoCreatedLeafQueueConfigCapacity(D, 10.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(D, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(D, 3);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(D, 100.0f);
        conf.set("yarn.scheduler.capacity.root.c.leaf-queue-template.ordering-policy", "fair");
        accessibleNodeLabelsOnC.add(NODEL_LABEL_GPU);
        accessibleNodeLabelsOnC.add(NODEL_LABEL_SSD);
        accessibleNodeLabelsOnC.add("");
        conf.setAccessibleNodeLabels(C, accessibleNodeLabelsOnC);
        conf.setAccessibleNodeLabels("root", accessibleNodeLabelsOnC);
        conf.setCapacityByLabel("root", NODEL_LABEL_GPU, 100.0f);
        conf.setCapacityByLabel("root", NODEL_LABEL_SSD, 100.0f);
        conf.setAccessibleNodeLabels(C, accessibleNodeLabelsOnC);
        conf.setCapacityByLabel(C, NODEL_LABEL_GPU, 100.0f);
        conf.setCapacityByLabel(C, NODEL_LABEL_SSD, 100.0f);
        LOG.info((Object)"Setup root.d as an auto leaf creation enabled parent queue");
        return conf;
    }

    public static CapacitySchedulerConfiguration setupQueueConfigurationForSingleAutoCreatedLeafQueue(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{PARENT_QUEUE});
        conf.setCapacity(C, 100.0f);
        conf.setUserLimitFactor(C, 1.0f);
        conf.setAutoCreateChildQueueEnabled(C, true);
        conf.setAutoCreatedLeafQueueConfigCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigMaxCapacity(C, 100.0f);
        conf.setAutoCreatedLeafQueueConfigUserLimit(C, 100);
        conf.setAutoCreatedLeafQueueConfigUserLimitFactor(C, 3.0f);
        return conf;
    }

    @After
    public void tearDown() throws Exception {
        if (this.mockRM != null) {
            this.mockRM.stop();
        }
    }

    protected void validateCapacities(AutoCreatedLeafQueue autoCreatedLeafQueue, float capacity, float absCapacity, float maxCapacity, float absMaxCapacity) {
        Assert.assertEquals((float)capacity, (float)autoCreatedLeafQueue.getCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)absCapacity, (float)autoCreatedLeafQueue.getAbsoluteCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)maxCapacity, (float)autoCreatedLeafQueue.getMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)absMaxCapacity, (float)autoCreatedLeafQueue.getAbsoluteMaximumCapacity(), (float)1.0E-4f);
    }

    protected void cleanupQueue(String queueName) throws YarnException {
        AutoCreatedLeafQueue queue = (AutoCreatedLeafQueue)this.cs.getQueue(queueName);
        if (queue != null) {
            this.setEntitlement(queue, new QueueEntitlement(0.0f, 0.0f));
            ((ManagedParentQueue)queue.getParent()).removeChildQueue(queue.getQueueName());
            this.cs.getCapacitySchedulerQueueManager().removeQueue(queue.getQueueName());
        }
    }

    protected ApplicationId submitApp(MockRM rm, CSQueue parentQueue, String leafQueueName, String user, int expectedNumAppsInParentQueue, int expectedNumAppsInLeafQueue) throws Exception {
        CapacityScheduler capacityScheduler = (CapacityScheduler)rm.getResourceScheduler();
        RMApp rmApp = rm.submitApp(1024, "test-auto-queue-activation", user, null, leafQueueName);
        List appsInParentQueue = capacityScheduler.getAppsInQueue(parentQueue.getQueueName());
        Assert.assertEquals((long)expectedNumAppsInParentQueue, (long)appsInParentQueue.size());
        List appsInLeafQueue = capacityScheduler.getAppsInQueue(leafQueueName);
        Assert.assertEquals((long)expectedNumAppsInLeafQueue, (long)appsInLeafQueue.size());
        return rmApp.getApplicationId();
    }

    protected List<UserGroupMappingPlacementRule.QueueMapping> setupQueueMapping(CapacityScheduler newCS, String user, String parentQueue, String queue) {
        ArrayList<UserGroupMappingPlacementRule.QueueMapping> queueMappings = new ArrayList<UserGroupMappingPlacementRule.QueueMapping>();
        queueMappings.add(new UserGroupMappingPlacementRule.QueueMapping(UserGroupMappingPlacementRule.QueueMapping.MappingType.USER, user, TestCapacitySchedulerAutoCreatedQueueBase.getQueueMapping(parentQueue, queue)));
        newCS.getConfiguration().setQueueMappings(queueMappings);
        return queueMappings;
    }

    protected MockRM setupSchedulerInstance() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        TestCapacitySchedulerAutoCreatedQueueBase.setupQueueMappings(conf, PARENT_QUEUE, true, new int[]{0, 1, 2, 3});
        final RMNodeLabelsManager mgr = this.setupNodeLabelManager(conf);
        MockRM newMockRM = new MockRM((Configuration)conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        newMockRM.start();
        ((CapacityScheduler)newMockRM.getResourceScheduler()).start();
        this.setupNodes(newMockRM);
        return newMockRM;
    }

    static String getQueueMapping(String parentQueue, String leafQueue) {
        return parentQueue + "." + leafQueue;
    }

    protected RMNodeLabelsManager setupNodeLabelManager(CapacitySchedulerConfiguration conf) throws IOException {
        NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)NODEL_LABEL_SSD, (Object)NODEL_LABEL_GPU));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet(NODEL_LABEL_SSD)));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet(NODEL_LABEL_GPU)));
        return mgr;
    }

    protected ApplicationAttemptId submitApp(CapacityScheduler newCS, String user, String queue, String parentQueue) {
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appId, queue, user, new ApplicationPlacementContext(queue, parentQueue));
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        newCS.handle((SchedulerEvent)addAppEvent);
        newCS.handle((SchedulerEvent)addAttemptEvent);
        return appAttemptId;
    }

    protected RMApp submitApp(String user, String queue, String nodeLabel) throws Exception {
        RMApp app = this.mockRM.submitApp(1024, "test-auto-queue-creation" + RandomUtils.nextInt((int)100), user, null, queue, nodeLabel);
        Assert.assertEquals((Object)app.getAmNodeLabelExpression(), (Object)nodeLabel);
        List appsInC = this.cs.getAppsInQueue(PARENT_QUEUE);
        Assert.assertEquals((long)1L, (long)appsInC.size());
        Assert.assertNotNull((Object)this.cs.getQueue(queue));
        return app;
    }

    void setEntitlement(AutoCreatedLeafQueue queue, QueueEntitlement entitlement) {
        queue.setCapacity(entitlement.getCapacity());
        queue.setAbsoluteCapacity(queue.getParent().getAbsoluteCapacity() * entitlement.getCapacity());
        queue.setMaxCapacity(entitlement.getMaxCapacity());
    }

    protected void validateUserAndAppLimits(AutoCreatedLeafQueue autoCreatedLeafQueue, int maxApps, int maxAppsPerUser) {
        Assert.assertEquals((long)maxApps, (long)autoCreatedLeafQueue.getMaxApplications());
        Assert.assertEquals((long)maxAppsPerUser, (long)autoCreatedLeafQueue.getMaxApplicationsPerUser());
    }

    protected void validateInitialQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacityByLabel, Set<String> nodeLabels) throws SchedulerDynamicEditException, InterruptedException {
        this.validateInitialQueueEntitlement(this.cs, parentQueue, leafQueueName, expectedTotalChildQueueAbsCapacityByLabel, nodeLabels);
    }

    protected void validateInitialQueueEntitlement(CapacityScheduler capacityScheduler, CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacityByLabel, Set<String> nodeLabels) throws SchedulerDynamicEditException, InterruptedException {
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)capacityScheduler.getQueue(leafQueueName);
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        QueueCapacities cap = autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities();
        for (String label : nodeLabels) {
            this.validateCapacitiesByLabel(autoCreateEnabledParentQueue, leafQueue, label);
            Assert.assertEquals((Object)true, (Object)policy.isActive(leafQueue, label));
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacityByLabel.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)1.0E-4f);
            QueueEntitlement expectedEntitlement = new QueueEntitlement(cap.getCapacity(label), cap.getMaximumCapacity(label));
            expectedEntitlements.put(label, expectedEntitlement);
            this.validateEffectiveMinResource((CSQueue)leafQueue, label, expectedEntitlements);
        }
    }

    protected void validateCapacitiesByLabel(ManagedParentQueue autoCreateEnabledParentQueue, AutoCreatedLeafQueue leafQueue, String label) throws InterruptedException {
        Assert.assertEquals((float)autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities().getCapacity(label), (float)leafQueue.getQueueCapacities().getCapacity(label), (float)1.0E-4f);
        Assert.assertEquals((float)autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities().getMaximumCapacity(label), (float)leafQueue.getQueueCapacities().getMaximumCapacity(label), (float)1.0E-4f);
    }

    protected void validateEffectiveMinResource(CSQueue leafQueue, String label, Map<String, QueueEntitlement> expectedQueueEntitlements) {
        ManagedParentQueue parentQueue = (ManagedParentQueue)leafQueue.getParent();
        Resource resourceByLabel = this.mockRM.getRMContext().getNodeLabelManager().getResourceByLabel(label, this.cs.getClusterResource());
        Resource effMinCapacity = Resources.multiply((Resource)resourceByLabel, (double)(expectedQueueEntitlements.get(label).getCapacity() * parentQueue.getQueueCapacities().getAbsoluteCapacity(label)));
        Assert.assertEquals((Object)effMinCapacity, (Object)Resources.multiply((Resource)resourceByLabel, (double)leafQueue.getQueueCapacities().getAbsoluteCapacity(label)));
        Assert.assertEquals((Object)effMinCapacity, (Object)leafQueue.getEffectiveCapacity(label));
        if (leafQueue.getQueueCapacities().getAbsoluteCapacity(label) > 0.0f) {
            Assert.assertTrue((boolean)Resources.greaterThan((ResourceCalculator)this.cs.getResourceCalculator(), (Resource)this.cs.getClusterResource(), (Resource)effMinCapacity, (Resource)Resources.none()));
        } else {
            Assert.assertTrue((boolean)Resources.equals((Resource)effMinCapacity, (Resource)Resources.none()));
        }
    }

    protected void validateActivatedQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacity, List<QueueManagementChange> queueManagementChanges, Set<String> expectedNodeLabels) throws SchedulerDynamicEditException {
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        QueueCapacities cap = autoCreateEnabledParentQueue.getLeafQueueTemplate().getQueueCapacities();
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        for (String label : expectedNodeLabels) {
            Assert.assertEquals((Object)true, (Object)policy.isActive(leafQueue, label));
            QueueEntitlement expectedEntitlement = new QueueEntitlement(cap.getCapacity(label), cap.getMaximumCapacity(label));
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacity.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)1.0E-4f);
            expectedEntitlements.put(label, expectedEntitlement);
        }
        this.validateQueueEntitlements(leafQueueName, expectedEntitlements, queueManagementChanges, expectedNodeLabels);
    }

    protected void validateDeactivatedQueueEntitlement(CSQueue parentQueue, String leafQueueName, Map<String, Float> expectedTotalChildQueueAbsCapacity, List<QueueManagementChange> queueManagementChanges) throws SchedulerDynamicEditException {
        QueueEntitlement expectedEntitlement = new QueueEntitlement(0.0f, 1.0f);
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        GuaranteedOrZeroCapacityOverTimePolicy policy = (GuaranteedOrZeroCapacityOverTimePolicy)autoCreateEnabledParentQueue.getAutoCreatedQueueManagementPolicy();
        HashMap<String, QueueEntitlement> expectedEntitlements = new HashMap<String, QueueEntitlement>();
        for (String label : accessibleNodeLabelsOnC) {
            LOG.info((Object)("Validating label " + label));
            Assert.assertEquals((float)expectedTotalChildQueueAbsCapacity.get(label).floatValue(), (float)policy.getAbsoluteActivatedChildQueueCapacity(label), (float)1.0E-4f);
            Assert.assertEquals((Object)false, (Object)policy.isActive(leafQueue, label));
            expectedEntitlements.put(label, expectedEntitlement);
        }
        this.validateQueueEntitlements(leafQueueName, expectedEntitlements, queueManagementChanges, accessibleNodeLabelsOnC);
    }

    void validateQueueEntitlements(String leafQueueName, Map<String, QueueEntitlement> expectedEntitlements, List<QueueManagementChange> queueEntitlementChanges, Set<String> expectedNodeLabels) {
        AutoCreatedLeafQueue leafQueue = (AutoCreatedLeafQueue)this.cs.getQueue(leafQueueName);
        this.validateQueueEntitlementChanges(leafQueue, expectedEntitlements, queueEntitlementChanges, expectedNodeLabels);
    }

    private void validateQueueEntitlementChanges(AutoCreatedLeafQueue leafQueue, Map<String, QueueEntitlement> expectedQueueEntitlements, List<QueueManagementChange> queueEntitlementChanges, Set<String> expectedNodeLabels) {
        boolean found = false;
        for (QueueManagementChange entitlementChange : queueEntitlementChanges) {
            if (!leafQueue.getQueueName().equals(entitlementChange.getQueue().getQueueName())) continue;
            AutoCreatedLeafQueueConfig updatedQueueTemplate = entitlementChange.getUpdatedQueueTemplate();
            for (String label : expectedNodeLabels) {
                QueueEntitlement newEntitlement = new QueueEntitlement(updatedQueueTemplate.getQueueCapacities().getCapacity(label), updatedQueueTemplate.getQueueCapacities().getMaximumCapacity(label));
                Assert.assertEquals((Object)expectedQueueEntitlements.get(label), (Object)newEntitlement);
                this.validateEffectiveMinResource((CSQueue)leafQueue, label, expectedQueueEntitlements);
            }
            found = true;
            break;
        }
        if (!found) {
            Assert.fail((String)("Could not find the specified leaf queue in entitlement changes : " + leafQueue.getQueueName()));
        }
    }

    protected Map<String, Float> populateExpectedAbsCapacityByLabelForParentQueue(int numLeafQueues) {
        HashMap<String, Float> expectedChildQueueAbsCapacity = new HashMap<String, Float>();
        expectedChildQueueAbsCapacity.put(NODEL_LABEL_GPU, Float.valueOf(0.3f * (float)numLeafQueues));
        expectedChildQueueAbsCapacity.put(NODEL_LABEL_SSD, Float.valueOf(0.4f * (float)numLeafQueues));
        expectedChildQueueAbsCapacity.put("", Float.valueOf(0.1f * (float)numLeafQueues));
        return expectedChildQueueAbsCapacity;
    }

    public static class SpyDispatcher
    extends AsyncDispatcher {
        public static BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();

        protected void dispatch(Event event) {
            eventQueue.add(event);
        }

        public EventHandler<Event> getEventHandler() {
            return rmAppEventEventHandler;
        }

        void spyOnNextEvent(Event expectedEvent, long timeout) throws InterruptedException {
            Event event = eventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)expectedEvent.getType(), (Object)event.getType());
            Assert.assertEquals(expectedEvent.getClass(), event.getClass());
        }

        public static class SpyRMAppEventHandler
        implements EventHandler<Event> {
            public void handle(Event event) {
                eventQueue.add(event);
            }
        }
    }
}

