/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCapacitySchedulerWithMultiResourceTypes {
    private static String RESOURCE_1 = "res1";

    @Test
    public void testMaximumAllocationRefreshWithMultipleResourceTypes() throws Exception {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        riMap.put(RESOURCE_1, ResourceInformation.newInstance((String)RESOURCE_1, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)3333L));
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root", "", 100.0f);
        csconf.setMaximumApplicationMasterResourcePerQueuePercent("root.default", 100.0f);
        csconf.setMaximumAMResourcePercentPerPartition("root.default", "", 100.0f);
        csconf.setResourceComparator(DominantResourceCalculator.class);
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3333);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        conf.setBoolean("yarn.test.reset-resource-types", false);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((long)3333L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3332);
        boolean exception = false;
        try {
            cs.reinitialize((Configuration)csconf, rm.getRMContext());
        }
        catch (IOException e) {
            exception = true;
        }
        Assert.assertTrue((String)"Should have exception in CS", (boolean)exception);
        Assert.assertEquals((long)3333L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        csconf.set("yarn.resource-types", RESOURCE_1);
        csconf.setInt("yarn.resource-types." + RESOURCE_1 + ".maximum-allocation", 3334);
        cs.reinitialize((Configuration)csconf, rm.getRMContext());
        Assert.assertEquals((long)3334L, (long)cs.getMaximumResourceCapability().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)3333L, (long)cs.getMaximumAllocation().getResourceValue(RESOURCE_1));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumResourceCapability().getResourceValue("memory-mb"));
        Assert.assertEquals((long)8192L, (long)cs.getMaximumAllocation().getResourceValue("memory-mb"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumResourceCapability().getResourceValue("vcores"));
        Assert.assertEquals((long)4L, (long)cs.getMaximumAllocation().getResourceValue("vcores"));
        rm.close();
    }

    @Test
    public void testDefaultResourceCalculatorWithThirdResourceTypes() throws Exception {
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        csconf.setResourceComparator(DefaultResourceCalculator.class);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csconf);
        String[] res1 = new String[]{"resource1", "M"};
        String[] res2 = new String[]{"resource2", "G"};
        String[] res3 = new String[]{"resource3", "H"};
        String[][] test = new String[][]{res1, res2, res3};
        String resSt = "";
        for (String[] resources : test) {
            resSt = resSt + resources[0] + ",";
        }
        resSt = resSt.substring(0, resSt.length() - 1);
        conf.set("yarn.resource-types", resSt);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        boolean exception = false;
        try {
            MockRM mockRM = new MockRM((Configuration)conf);
        }
        catch (YarnRuntimeException e) {
            exception = true;
        }
        Assert.assertTrue((String)"Should have exception in CS", (boolean)exception);
    }
}

