/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueStateManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestQueueStateManager {
    private static final String Q1 = "q1";
    private static final String Q2 = "q2";
    private static final String Q3 = "q3";
    private static final String Q1_PATH = "root.q1";
    private static final String Q2_PATH = "root.q1.q2";
    private static final String Q3_PATH = "root.q1.q3";
    private CapacityScheduler cs;
    private YarnConfiguration conf;

    @Test
    public void testQueueStateManager() throws AccessControlException, YarnException {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{Q1});
        csConf.setQueues(Q1_PATH, new String[]{Q2, Q3});
        csConf.setCapacity(Q1_PATH, 100.0f);
        csConf.setCapacity(Q2_PATH, 50.0f);
        csConf.setCapacity(Q3_PATH, 50.0f);
        this.conf = new YarnConfiguration((Configuration)csConf);
        this.cs = new CapacityScheduler();
        RMContext rmContext = TestUtils.getMockRMContext();
        this.cs.setConf((Configuration)this.conf);
        this.cs.setRMContext(rmContext);
        this.cs.init((Configuration)this.conf);
        QueueStateManager stateManager = this.cs.getCapacitySchedulerQueueManager().getQueueStateManager();
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q3).getState());
        stateManager.stopQueue(Q2);
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        stateManager.stopQueue(Q1);
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q3).getState());
        Assert.assertTrue((boolean)stateManager.canDelete(Q1));
        Assert.assertTrue((boolean)stateManager.canDelete(Q2));
        Assert.assertTrue((boolean)stateManager.canDelete(Q3));
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        stateManager.activateQueue(Q1);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q3).getState());
        stateManager.activateQueue(Q2);
        stateManager.activateQueue(Q3);
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.RUNNING, (Object)this.cs.getQueue(Q3).getState());
        Assert.assertFalse((boolean)stateManager.canDelete(Q1));
        Assert.assertFalse((boolean)stateManager.canDelete(Q2));
        Assert.assertFalse((boolean)stateManager.canDelete(Q3));
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        String userName = "testUser";
        this.cs.getQueue(Q2).submitApplication(appId, userName, Q2);
        FiCaSchedulerApp app = this.getMockApplication(appId, userName, Resources.createResource((int)4, (int)0));
        this.cs.getQueue(Q2).submitApplicationAttempt(app, userName);
        stateManager.stopQueue(Q1);
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.DRAINING, (Object)this.cs.getQueue(Q2).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q3).getState());
        this.cs.getQueue(Q2).finishApplicationAttempt(app, Q2);
        this.cs.getQueue(Q2).finishApplication(appId, userName);
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q1).getState());
        Assert.assertEquals((Object)QueueState.STOPPED, (Object)this.cs.getQueue(Q2).getState());
    }

    private FiCaSchedulerApp getMockApplication(ApplicationId appId, String user, Resource amResource) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId.getApplicationId()).when((Object)application)).getApplicationId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)applicationAttemptId).when((Object)application)).getApplicationAttemptId();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Priority.newInstance((int)0)).when((Object)application)).getPriority();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)"").when((Object)application)).getAppAMNodePartitionName();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)amResource).when((Object)application)).getAMResource("");
        Mockito.when((Object)application.compareInputOrderTo((SchedulableEntity)Matchers.any(FiCaSchedulerApp.class))).thenCallRealMethod();
        return application;
    }
}

