/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ConfigurationStoreBaseTest {
    protected YarnConfigurationStore confStore = this.createConfStore();
    protected Configuration conf;
    protected Configuration schedConf;
    protected RMContext rmContext;
    protected static final String TEST_USER = "testUser";

    protected abstract YarnConfigurationStore createConfStore();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        this.schedConf = new Configuration(false);
    }

    @Test
    public void testConfigurationUpdate() throws Exception {
        this.schedConf.set("key1", "val1");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val1", (Object)this.confStore.retrieve().get("key1"));
        HashMap<String, String> update1 = new HashMap<String, String>();
        update1.put("keyUpdate1", "valUpdate1");
        YarnConfigurationStore.LogMutation mutation1 = new YarnConfigurationStore.LogMutation(update1, TEST_USER);
        this.confStore.logMutation(mutation1);
        this.confStore.confirmMutation(true);
        Assert.assertEquals((Object)"valUpdate1", (Object)this.confStore.retrieve().get("keyUpdate1"));
        HashMap<String, String> update2 = new HashMap<String, String>();
        update2.put("keyUpdate2", "valUpdate2");
        YarnConfigurationStore.LogMutation mutation2 = new YarnConfigurationStore.LogMutation(update2, TEST_USER);
        this.confStore.logMutation(mutation2);
        this.confStore.confirmMutation(false);
        Assert.assertNull((String)"Configuration should not be updated", (Object)this.confStore.retrieve().get("keyUpdate2"));
        this.confStore.close();
    }

    @Test
    public void testNullConfigurationUpdate() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("key", null);
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(update, TEST_USER);
        this.confStore.logMutation(mutation);
        this.confStore.confirmMutation(true);
        Assert.assertNull((Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }
}

