/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.LeveldbConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLeveldbConfigurationStore
extends ConfigurationStoreBaseTest {
    public static final Log LOG = LogFactory.getLog(TestLeveldbConfigurationStore.class);
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestLeveldbConfigurationStore.class.getName());
    private ResourceManager rm;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FileUtil.fullyDelete((File)TEST_DIR);
        this.conf.set("yarn.scheduler.configuration.store.class", "leveldb");
        this.conf.set("yarn.scheduler.configuration.leveldb-store.path", TEST_DIR.toString());
    }

    @Test
    public void testVersioning() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.getConfStoreVersion());
        this.confStore.checkVersion();
        Assert.assertEquals((Object)LeveldbConfigurationStore.CURRENT_VERSION_INFO, (Object)this.confStore.getConfStoreVersion());
        this.confStore.close();
    }

    @Test
    public void testPersistConfiguration() throws Exception {
        this.schedConf.set("key", "val");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }

    @Test
    public void testPersistUpdatedConfiguration() throws Exception {
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertNull((Object)this.confStore.retrieve().get("key"));
        HashMap<String, String> update = new HashMap<String, String>();
        update.put("key", "val");
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(update, "testUser");
        this.confStore.logMutation(mutation);
        this.confStore.confirmMutation(true);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
        this.confStore = this.createConfStore();
        this.schedConf.set("key", "badVal");
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        Assert.assertEquals((Object)"val", (Object)this.confStore.retrieve().get("key"));
        this.confStore.close();
    }

    @Test
    public void testMaxLogs() throws Exception {
        this.conf.setLong("yarn.scheduler.configuration.store.max-logs", 2L);
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        LinkedList logs = ((LeveldbConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)0L, (long)logs.size());
        HashMap<String, String> update1 = new HashMap<String, String>();
        update1.put("key1", "val1");
        YarnConfigurationStore.LogMutation mutation = new YarnConfigurationStore.LogMutation(update1, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((LeveldbConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)1L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        HashMap<String, String> update2 = new HashMap<String, String>();
        update2.put("key2", "val2");
        mutation = new YarnConfigurationStore.LogMutation(update2, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((LeveldbConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val1", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key1"));
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key2"));
        HashMap<String, String> update3 = new HashMap<String, String>();
        update3.put("key3", "val3");
        mutation = new YarnConfigurationStore.LogMutation(update3, "testUser");
        this.confStore.logMutation(mutation);
        logs = ((LeveldbConfigurationStore)this.confStore).getLogs();
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
        this.confStore.confirmMutation(true);
        Assert.assertEquals((long)2L, (long)logs.size());
        Assert.assertEquals((Object)"val2", ((YarnConfigurationStore.LogMutation)logs.get(0)).getUpdates().get("key2"));
        Assert.assertEquals((Object)"val3", ((YarnConfigurationStore.LogMutation)logs.get(1)).getUpdates().get("key3"));
        this.confStore.close();
    }

    @Test
    public void testRestartReadsFromUpdatedStore() throws Exception {
        MockRM rm1 = new MockRM(this.conf);
        rm1.start();
        Assert.assertNull((Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        schedConfUpdateInfo.getGlobalParams().put("key", "val");
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(this.conf, rm1.getRMContext());
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        confProvider.confirmPendingMutation(true);
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)confProvider).getConfStore().retrieve().get("key"));
        schedConfUpdateInfo.getGlobalParams().put("key", "badVal");
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.close();
        MockRM rm2 = new MockRM(this.conf);
        rm2.start();
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("key"));
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("key"));
        rm2.close();
    }

    @Override
    public YarnConfigurationStore createConfStore() {
        return new LeveldbConfigurationStore();
    }
}

