/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.RejectedSchedulingRequest;
import org.apache.hadoop.yarn.api.records.RejectionReason;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.AllocationTagsManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPlacementProcessor {
    private static final int GB = 1024;
    private static final Log LOG = LogFactory.getLog(TestPlacementProcessor.class);
    private MockRM rm;
    private DrainDispatcher dispatcher;

    @Before
    public void createAndStartRM() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "placement-processor");
        conf.setInt("yarn.resourcemanager.placement-constraints.retry-attempts", 1);
        this.startRM(conf);
    }

    private void startRM(YarnConfiguration conf) {
        this.dispatcher = new DrainDispatcher();
        this.rm = new MockRM((Configuration)conf){

            @Override
            protected Dispatcher createDispatcher() {
                return TestPlacementProcessor.this.dispatcher;
            }
        };
        this.rm.start();
    }

    @After
    public void stopRM() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test(timeout=300000L)
    public void testAntiAffinityPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 4);
        Assert.assertEquals((long)4L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)4L, (long)nodeIds.size());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 11264L, 11, 5120L, 5, 5);
    }

    @Test(timeout=300000L)
    public void testMutualAntiAffinityPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        MockNM nm5 = new MockNM("h5:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm5.getNodeId(), nm5);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        nm5.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        HashMap<Set<String>, PlacementConstraint> pcMap = new HashMap<Set<String>, PlacementConstraint>();
        pcMap.put(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})));
        pcMap.put(Collections.singleton("bar"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})));
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, pcMap);
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 5);
        Assert.assertEquals((long)5L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)5L, (long)nodeIds.size());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 14336L, 14, 6144L, 6, 6);
    }

    @Test(timeout=300000L)
    public void testCardinalityPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetCardinality((String)"node", (int)0, (int)3, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 6L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 7L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 8L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 8);
        Assert.assertEquals((long)8L, (long)allocatedContainers.size());
        Map<NodeId, Long> nodeIdContainerIdMap = allocatedContainers.stream().collect(Collectors.groupingBy(c -> c.getNodeId(), Collectors.counting()));
        for (NodeId n : nodeIdContainerIdMap.keySet()) {
            Assert.assertTrue((nodeIdContainerIdMap.get(n) < 5L ? 1 : 0) != 0);
        }
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 23552L, 23, 9216L, 9, 9);
    }

    @Test(timeout=300000L)
    public void testAffinityPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 5);
        Assert.assertEquals((long)5L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)1L, (long)nodeIds.size());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 26624L, 26, 6144L, 6, 6);
    }

    @Test(timeout=300000L)
    public void testComplexPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        HashMap<Set<String>, PlacementConstraint> constraintMap = new HashMap<Set<String>, PlacementConstraint>();
        constraintMap.put(Collections.singleton("bar"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})})));
        constraintMap.put(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})})));
        constraintMap.put(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetCardinality((String)"node", (int)0, (int)1, (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})));
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, constraintMap);
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 6L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 6);
        Assert.assertEquals((long)6L, (long)allocatedContainers.size());
        Map<NodeId, Long> nodeIdContainerIdMap = allocatedContainers.stream().collect(Collectors.groupingBy(c -> c.getNodeId(), Collectors.counting()));
        for (NodeId n : nodeIdContainerIdMap.keySet()) {
            Assert.assertTrue((nodeIdContainerIdMap.get(n) < 4L ? 1 : 0) != 0);
        }
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 9216L, 9, 7168L, 7, 7);
    }

    @Test(timeout=300000L)
    public void testSchedulerRejection() throws Exception {
        this.stopRM();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacity("root.a", 15.0f);
        csConf.setCapacity("root.b", 85.0f);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "placement-processor");
        this.startRM(conf);
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "a");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList allocatedContainers = new ArrayList();
        ArrayList rejectedReqs = new ArrayList();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
        for (int allocCount = 1; allocCount < 11; ++allocCount) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            nm3.nodeHeartbeat(true);
            nm4.nodeHeartbeat(true);
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            allocResponse = am1.schedule();
            allocatedContainers.addAll(allocResponse.getAllocatedContainers());
            rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
            if (rejectedReqs.size() <= 0 || allocatedContainers.size() <= 2) continue;
        }
        Assert.assertEquals((long)3L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)3L, (long)nodeIds.size());
        RejectedSchedulingRequest rej = (RejectedSchedulingRequest)rejectedReqs.get(0);
        Assert.assertEquals((long)4L, (long)rej.getRequest().getAllocationRequestId());
        Assert.assertEquals((Object)RejectionReason.COULD_NOT_SCHEDULE_ON_NODE, (Object)rej.getReason());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 12288L, 12, 4096L, 4, 4);
    }

    @Test(timeout=300000L)
    public void testNodeCapacityRejection() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 5120, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList allocatedContainers = new ArrayList();
        ArrayList rejectedReqs = new ArrayList();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
        for (int allocCount = 1; allocCount < 11; ++allocCount) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            nm3.nodeHeartbeat(true);
            nm4.nodeHeartbeat(true);
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            allocResponse = am1.schedule();
            allocatedContainers.addAll(allocResponse.getAllocatedContainers());
            rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
            if (rejectedReqs.size() <= 0 || allocatedContainers.size() <= 2) continue;
        }
        Assert.assertEquals((long)3L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)3L, (long)nodeIds.size());
        RejectedSchedulingRequest rej = (RejectedSchedulingRequest)rejectedReqs.get(0);
        Assert.assertEquals((long)4L, (long)rej.getRequest().getAllocationRequestId());
        Assert.assertEquals((Object)RejectionReason.COULD_NOT_PLACE_ON_NODE, (Object)rej.getReason());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 12288L, 12, 4096L, 4, 4);
    }

    @Test(timeout=300000L)
    public void testRePlacementAfterSchedulerRejection() throws Exception {
        this.stopRM();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "placement-processor");
        conf.setInt("yarn.resourcemanager.placement-constraints.retry-attempts", 2);
        this.startRM(conf);
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        MockNM nm5 = new MockNM("h5:1234", 8192, this.rm.getResourceTrackerService());
        nodes.put(nm5.getNodeId(), nm5);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 5120, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList allocatedContainers = new ArrayList();
        ArrayList rejectedReqs = new ArrayList();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
        nm5.registerNode();
        for (int allocCount = 1; allocCount < 11; ++allocCount) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            nm3.nodeHeartbeat(true);
            nm4.nodeHeartbeat(true);
            nm5.nodeHeartbeat(true);
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            allocResponse = am1.schedule();
            allocatedContainers.addAll(allocResponse.getAllocatedContainers());
            rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
            if (allocatedContainers.size() <= 3) continue;
        }
        Assert.assertEquals((long)4L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)4L, (long)nodeIds.size());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 15360L, 19, 9216L, 5, 5);
    }

    @Test(timeout=300000L)
    public void testPlacementRejection() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 4096, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, Collections.singletonMap(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}))));
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 5L, 1, 512, "foo")));
        AllocateResponse allocResponse = am1.schedule();
        ArrayList allocatedContainers = new ArrayList();
        ArrayList rejectedReqs = new ArrayList();
        allocatedContainers.addAll(allocResponse.getAllocatedContainers());
        rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
        for (int allocCount = 1; allocCount < 11; ++allocCount) {
            nm1.nodeHeartbeat(true);
            nm2.nodeHeartbeat(true);
            nm3.nodeHeartbeat(true);
            nm4.nodeHeartbeat(true);
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            allocResponse = am1.schedule();
            allocatedContainers.addAll(allocResponse.getAllocatedContainers());
            rejectedReqs.addAll(allocResponse.getRejectedSchedulingRequests());
            if (rejectedReqs.size() <= 0 || allocatedContainers.size() <= 3) continue;
        }
        Assert.assertEquals((long)4L, (long)allocatedContainers.size());
        Set nodeIds = allocatedContainers.stream().map(x -> x.getNodeId()).collect(Collectors.toSet());
        Assert.assertEquals((long)4L, (long)nodeIds.size());
        RejectedSchedulingRequest rej = (RejectedSchedulingRequest)rejectedReqs.get(0);
        Assert.assertEquals((Object)RejectionReason.COULD_NOT_PLACE_ON_NODE, (Object)rej.getReason());
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        TestPlacementProcessor.verifyMetrics(metrics, 11264L, 11, 5120L, 5, 5);
    }

    @Test(timeout=300000L)
    public void testAndOrPlacement() throws Exception {
        HashMap<NodeId, MockNM> nodes = new HashMap<NodeId, MockNM>();
        MockNM nm1 = new MockNM("h1:1234", 40960, 100, this.rm.getResourceTrackerService());
        nodes.put(nm1.getNodeId(), nm1);
        MockNM nm2 = new MockNM("h2:1234", 40960, 100, this.rm.getResourceTrackerService());
        nodes.put(nm2.getNodeId(), nm2);
        MockNM nm3 = new MockNM("h3:1234", 40960, 100, this.rm.getResourceTrackerService());
        nodes.put(nm3.getNodeId(), nm3);
        MockNM nm4 = new MockNM("h4:1234", 40960, 100, this.rm.getResourceTrackerService());
        nodes.put(nm4.getNodeId(), nm4);
        nm1.registerNode();
        nm2.registerNode();
        nm3.registerNode();
        nm4.registerNode();
        RMApp app1 = this.rm.submitApp(1024, "app", "user", null, "default");
        HashMap<Set<String>, PlacementConstraint> app1Constraints = new HashMap<Set<String>, PlacementConstraint>();
        app1Constraints.put(Collections.singleton("foo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})})));
        app1Constraints.put(Collections.singleton("bar"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.and((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetNotIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}), PlacementConstraints.maxCardinality((String)"node", (int)2, (String[])new String[]{"bar"})})));
        app1Constraints.put(Collections.singleton("moo"), PlacementConstraints.build((PlacementConstraint.AbstractConstraint)PlacementConstraints.or((PlacementConstraint.AbstractConstraint[])new PlacementConstraint.AbstractConstraint[]{PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})}), PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"bar"})})})));
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, nm2, app1Constraints);
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "foo"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "foo")));
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 3);
        TestPlacementProcessor.printTags(nodes.values(), this.rm.getRMContext().getAllocationTagsManager());
        Assert.assertEquals((long)3L, (long)allocatedContainers.size());
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 1L, 1, 512, "bar")));
        allocatedContainers.clear();
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 1);
        TestPlacementProcessor.printTags(nodes.values(), this.rm.getRMContext().getAllocationTagsManager());
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        NodeId barNode = ((Container)allocatedContainers.get(0)).getNodeId();
        allocatedContainers.clear();
        ArrayList<RejectedSchedulingRequest> rejectedContainers = new ArrayList<RejectedSchedulingRequest>();
        am1.addSchedulingRequest(Arrays.asList(TestPlacementProcessor.schedulingRequest(1, 2L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 3L, 1, 512, "bar"), TestPlacementProcessor.schedulingRequest(1, 4L, 1, 512, "bar")));
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, rejectedContainers, 2);
        TestPlacementProcessor.printTags(nodes.values(), this.rm.getRMContext().getAllocationTagsManager());
        Assert.assertEquals((long)2L, (long)allocatedContainers.size());
        Assert.assertTrue((boolean)allocatedContainers.stream().allMatch(container -> container.getNodeId().equals((Object)barNode)));
        Assert.assertEquals((long)1L, (long)rejectedContainers.size());
        Assert.assertEquals((Object)RejectionReason.COULD_NOT_PLACE_ON_NODE, (Object)((RejectedSchedulingRequest)rejectedContainers.get(0)).getReason());
        MockNM nm5 = new MockNM("h5:1234", 4096, 100, this.rm.getResourceTrackerService());
        nodes.put(nm5.getNodeId(), nm5);
        nm5.registerNode();
        nm5.nodeHeartbeat(true);
        ArrayList<SchedulingRequest> mooRequests = new ArrayList<SchedulingRequest>();
        for (int i = 5; i < 25; ++i) {
            mooRequests.add(TestPlacementProcessor.schedulingRequest(1, (long)i, 1, 100, "moo"));
        }
        am1.addSchedulingRequest(mooRequests);
        allocatedContainers.clear();
        TestPlacementProcessor.waitForContainerAllocation(nodes.values(), am1, allocatedContainers, new ArrayList<RejectedSchedulingRequest>(), 20);
        Assert.assertEquals((long)20L, (long)allocatedContainers.size());
        for (Container mooContainer : allocatedContainers) {
            Assert.assertFalse((boolean)mooContainer.getNodeId().equals((Object)nm5.getNodeId()));
        }
    }

    private static void printTags(Collection<MockNM> nodes, AllocationTagsManager atm) {
        for (MockNM nm : nodes) {
            Map nmTags = atm.getAllocationTagsWithCount(nm.getNodeId());
            StringBuffer sb = new StringBuffer();
            if (nmTags == null) continue;
            nmTags.forEach((tag, count) -> sb.append(tag + "(" + count + "),"));
            LOG.info((Object)("nm_" + nm.getNodeId() + ": " + sb.toString()));
        }
    }

    private static void waitForContainerAllocation(Collection<MockNM> nodes, MockAM am, List<Container> allocatedContainers, List<RejectedSchedulingRequest> rejectedRequests, int containerNum) throws Exception {
        for (int attemptCount = 10; allocatedContainers.size() < containerNum && attemptCount > 0; --attemptCount) {
            for (MockNM node : nodes) {
                node.nodeHeartbeat(true);
            }
            LOG.info((Object)("Waiting for containers to be created for " + am.getApplicationAttemptId().getApplicationId() + "..."));
            Thread.sleep(1000L);
            AllocateResponse allocResponse = am.schedule();
            allocatedContainers.addAll(allocResponse.getAllocatedContainers());
            rejectedRequests.addAll(allocResponse.getRejectedSchedulingRequests());
        }
    }

    protected static SchedulingRequest schedulingRequest(int priority2, long allocReqId, int cores, int mem, String ... tags) {
        return TestPlacementProcessor.schedulingRequest(priority2, allocReqId, cores, mem, ExecutionType.GUARANTEED, tags);
    }

    protected static SchedulingRequest schedulingRequest(int priority2, long allocReqId, int cores, int mem, ExecutionType execType, String ... tags) {
        return SchedulingRequest.newBuilder().priority(Priority.newInstance((int)priority2)).allocationRequestId(allocReqId).allocationTags(new HashSet<String>(Arrays.asList(tags))).executionType(ExecutionTypeRequest.newInstance((ExecutionType)execType, (boolean)true)).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)Resource.newInstance((int)mem, (int)cores))).build();
    }

    private static void verifyMetrics(QueueMetrics metrics, long availableMB, int availableVirtualCores, long allocatedMB, int allocatedVirtualCores, int allocatedContainers) {
        Assert.assertEquals((long)availableMB, (long)metrics.getAvailableMB());
        Assert.assertEquals((long)availableVirtualCores, (long)metrics.getAvailableVirtualCores());
        Assert.assertEquals((long)allocatedMB, (long)metrics.getAllocatedMB());
        Assert.assertEquals((long)allocatedVirtualCores, (long)metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)allocatedContainers, (long)metrics.getAllocatedContainers());
    }
}

