/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueManager {
    private FairSchedulerConfiguration conf;
    private QueueManager queueManager;
    private Set<FSQueue> notEmptyQueues;
    private FairScheduler scheduler;

    @Before
    public void setUp() throws Exception {
        this.conf = new FairSchedulerConfiguration();
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.test");
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.test.childA");
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.test.childB");
        Mockito.when((Object)this.scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        SystemClock clock = SystemClock.getInstance();
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)clock);
        this.notEmptyQueues = new HashSet<FSQueue>();
        this.queueManager = new QueueManager(this.scheduler){

            public boolean isEmpty(FSQueue queue) {
                return !TestQueueManager.this.notEmptyQueues.contains(queue);
            }
        };
        FSQueueMetrics.forQueue((String)"root", null, (boolean)true, (Configuration)this.conf);
        this.queueManager.initialize((Configuration)this.conf);
    }

    @Test
    public void testReloadTurnsLeafQueueIntoParent() throws Exception {
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.add((FSQueue)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.notEmptyQueues.clear();
        this.updateConfiguredLeafQueues(this.queueManager, "queue1.queue2");
        this.notEmptyQueues.add(this.queueManager.getQueue("root.queue1"));
        this.updateConfiguredLeafQueues(this.queueManager, "queue1");
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("queue1.queue2", false));
        Assert.assertNull((Object)this.queueManager.getLeafQueue("queue1", false));
        this.updateConfiguredLeafQueues(this.queueManager, "default.queue3");
        Assert.assertNull((Object)this.queueManager.getLeafQueue("default.queue3", false));
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("default", false));
    }

    @Test
    public void testReloadTurnsLeafToParentWithNoLeaf() {
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).add("root.queue1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        this.notEmptyQueues.add((FSQueue)this.queueManager.getLeafQueue("root.queue1", false));
        allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.PARENT)).add("root.queue1");
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNotNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertNull((Object)this.queueManager.getParentQueue("root.queue1", false));
        this.notEmptyQueues.clear();
        this.queueManager.updateAllocationConfiguration(allocConf);
        Assert.assertNull((Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertNotNull((Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertTrue((boolean)this.queueManager.getParentQueue("root.queue1", false).getChildQueues().isEmpty());
    }

    @Test
    public void testCheckQueueNodeName() {
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(""));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("  "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(" a"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("a "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid(" a "));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("\u00a0"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("a\u00a0"));
        Assert.assertFalse((boolean)this.queueManager.isQueueNameValid("\u00a0a\u00a0"));
        Assert.assertTrue((boolean)this.queueManager.isQueueNameValid("a b"));
        Assert.assertTrue((boolean)this.queueManager.isQueueNameValid("a"));
    }

    private void updateConfiguredLeafQueues(QueueManager queueMgr, String ... confLeafQueues) {
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)this.conf);
        ((Set)allocConf.configuredQueues.get(FSQueueType.LEAF)).addAll(Sets.newHashSet((Object[])confLeafQueues));
        queueMgr.updateAllocationConfiguration(allocConf);
    }

    @Test
    public void testCreateLeafQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.queue1 was not created", (Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
    }

    @Test
    public void testCreateLeafQueueAndParent() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q2 = this.queueManager.createQueue("root.queue1.queue2", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertNotNull((String)"Leaf queue root.queue1.queue2 was not created", (Object)this.queueManager.getLeafQueue("root.queue1.queue2", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1.queue2", (Object)q2.getName());
    }

    @Test
    public void testCreateQueueWithChildDefaults() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        this.queueManager.getQueue("root.test").setMaxChildQueueResource(new ConfigurableResource(Resources.createResource((int)8192, (int)256)));
        FSQueue q1 = this.queueManager.createQueue("root.test.childC", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.test.childC was not created", (Object)this.queueManager.getLeafQueue("root.test.childC", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childC", (Object)q1.getName());
        Assert.assertEquals((String)"Max resources for root.queue1 were not inherited from parent's max child resources", (Object)Resources.createResource((int)8192, (int)256), (Object)q1.getMaxShare());
        FSQueue q2 = this.queueManager.createQueue("root.test.childD", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Leaf queue root.test.childD was not created", (Object)this.queueManager.getParentQueue("root.test.childD", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.test.childD", (Object)q2.getName());
        Assert.assertEquals((String)"Max resources for root.test.childD were not inherited from parent's max child resources", (Object)Resources.createResource((int)8192, (int)256), (Object)q2.getMaxShare());
        Assert.assertNotNull((String)"Leaf queue root.test.childA was not created during setup", (Object)this.queueManager.getLeafQueue("root.test.childA", false));
        Assert.assertEquals((String)"Max resources for root.test.childA were inherited from parent's max child resources", (Object)Resources.unbounded(), (Object)this.queueManager.getLeafQueue("root.test.childA", false).getMaxShare());
        Assert.assertNotNull((String)"Leaf queue root.test.childB was not created during setup", (Object)this.queueManager.getParentQueue("root.test.childB", false));
        Assert.assertEquals((String)"Max resources for root.test.childB were inherited from parent's max child resources", (Object)Resources.unbounded(), (Object)this.queueManager.getParentQueue("root.test.childB", false).getMaxShare());
    }

    @Test
    public void testCreateLeafQueueWithDefaults() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.LEAF);
        Assert.assertNotNull((String)"Leaf queue root.queue1 was not created", (Object)this.queueManager.getLeafQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
        Assert.assertEquals((String)"Min resources were not set to default", (Object)Resources.createResource((int)0, (int)0), (Object)q1.getMinShare());
        Assert.assertEquals((String)"Max resources were not set to default", (Object)Resources.unbounded(), (Object)q1.getMaxShare());
    }

    @Test
    public void testCreateParentQueue() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q1 = this.queueManager.createQueue("root.queue1", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1", (Object)q1.getName());
    }

    @Test
    public void testCreateParentQueueAndParent() {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        this.queueManager.updateAllocationConfiguration(allocConf);
        FSQueue q2 = this.queueManager.createQueue("root.queue1.queue2", FSQueueType.PARENT);
        Assert.assertNotNull((String)"Parent queue root.queue1 was not created", (Object)this.queueManager.getParentQueue("root.queue1", false));
        Assert.assertNotNull((String)"Leaf queue root.queue1.queue2 was not created", (Object)this.queueManager.getParentQueue("root.queue1.queue2", false));
        Assert.assertEquals((String)"createQueue() returned wrong queue", (Object)"root.queue1.queue2", (Object)q2.getName());
    }
}

