/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileSimpleQueueBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.UserSettings;

public final class AllocationFileWriter {
    private Integer queueMaxAppsDefault;
    private String queueMaxResourcesDefault;
    private Integer userMaxAppsDefault;
    private Double queueMaxAMShareDefault;
    private Integer defaultMinSharePreemptionTimeout;
    private Integer defaultFairSharePreemptionTimeout;
    private Double defaultFairSharePreemptionThreshold;
    private String defaultQueueSchedulingPolicy;
    private List<AllocationFileQueue> queues = new ArrayList<AllocationFileQueue>();
    private UserSettings userSettings;

    private AllocationFileWriter() {
    }

    public static AllocationFileWriter create() {
        return new AllocationFileWriter();
    }

    public AllocationFileSimpleQueueBuilder queue(String queueName) {
        return new AllocationFileSimpleQueueBuilder(this, queueName);
    }

    public AllocationFileWriter queueMaxAppsDefault(int value) {
        this.queueMaxAppsDefault = value;
        return this;
    }

    public AllocationFileWriter queueMaxResourcesDefault(String value) {
        this.queueMaxResourcesDefault = value;
        return this;
    }

    public AllocationFileWriter userMaxAppsDefault(int value) {
        this.userMaxAppsDefault = value;
        return this;
    }

    public AllocationFileWriter queueMaxAMShareDefault(double value) {
        this.queueMaxAMShareDefault = value;
        return this;
    }

    public AllocationFileWriter defaultMinSharePreemptionTimeout(int value) {
        this.defaultMinSharePreemptionTimeout = value;
        return this;
    }

    public AllocationFileWriter defaultFairSharePreemptionTimeout(int value) {
        this.defaultFairSharePreemptionTimeout = value;
        return this;
    }

    public AllocationFileWriter defaultFairSharePreemptionThreshold(double value) {
        this.defaultFairSharePreemptionThreshold = value;
        return this;
    }

    public AllocationFileWriter defaultQueueSchedulingPolicy(String value) {
        this.defaultQueueSchedulingPolicy = value;
        return this;
    }

    public UserSettings.Builder userSettings(String username) {
        return new UserSettings.Builder(this, username);
    }

    void addQueue(AllocationFileQueue queue) {
        this.queues.add(queue);
    }

    void setUserSettings(UserSettings userSettings) {
        this.userSettings = userSettings;
    }

    static void printQueues(PrintWriter pw, List<AllocationFileQueue> queues) {
        for (AllocationFileQueue queue : queues) {
            pw.println(queue.render());
        }
    }

    private void printUserSettings(PrintWriter pw) {
        pw.println(this.userSettings.render());
    }

    static void addIfPresent(PrintWriter pw, String tag, Supplier<String> supplier) {
        if (supplier.get() != null) {
            pw.println("<" + tag + ">" + supplier.get() + "</" + tag + ">");
        }
    }

    static String createNumberSupplier(Object number) {
        if (number != null) {
            return number.toString();
        }
        return null;
    }

    private void writeHeader(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\"?>");
        pw.println("<allocations>");
    }

    private void writeFooter(PrintWriter pw) {
        pw.println("</allocations>");
    }

    public void writeToFile(String filename) {
        PrintWriter pw;
        try {
            pw = new PrintWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writeHeader(pw);
        if (!this.queues.isEmpty()) {
            AllocationFileWriter.printQueues(pw, this.queues);
        }
        if (this.userSettings != null) {
            this.printUserSettings(pw);
        }
        AllocationFileWriter.addIfPresent(pw, "queueMaxAppsDefault", () -> AllocationFileWriter.createNumberSupplier(this.queueMaxAppsDefault));
        AllocationFileWriter.addIfPresent(pw, "queueMaxResourcesDefault", () -> this.queueMaxResourcesDefault);
        AllocationFileWriter.addIfPresent(pw, "userMaxAppsDefault", () -> AllocationFileWriter.createNumberSupplier(this.userMaxAppsDefault));
        AllocationFileWriter.addIfPresent(pw, "queueMaxAMShareDefault", () -> AllocationFileWriter.createNumberSupplier(this.queueMaxAMShareDefault));
        AllocationFileWriter.addIfPresent(pw, "defaultMinSharePreemptionTimeout", () -> AllocationFileWriter.createNumberSupplier(this.defaultMinSharePreemptionTimeout));
        AllocationFileWriter.addIfPresent(pw, "defaultFairSharePreemptionTimeout", () -> AllocationFileWriter.createNumberSupplier(this.defaultFairSharePreemptionTimeout));
        AllocationFileWriter.addIfPresent(pw, "defaultFairSharePreemptionThreshold", () -> AllocationFileWriter.createNumberSupplier(this.defaultFairSharePreemptionThreshold));
        AllocationFileWriter.addIfPresent(pw, "defaultQueueSchedulingPolicy", () -> this.defaultQueueSchedulingPolicy);
        this.writeFooter(pw);
        pw.close();
    }
}

