/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Before;
import org.junit.Test;

public class TestEmptyQueues {
    private Collection<? extends Schedulable> schedulables;

    @Before
    public void setup() {
        this.schedulables = new ArrayList<Schedulable>();
    }

    private void testComputeShares(SchedulingPolicy policy) {
        policy.computeShares(this.schedulables, Resources.none());
    }

    @Test(timeout=10000L)
    public void testFifoPolicy() {
        this.testComputeShares(SchedulingPolicy.getInstance(FifoPolicy.class));
    }

    @Test(timeout=10000L)
    public void testFairSharePolicy() {
        this.testComputeShares(SchedulingPolicy.getInstance(FairSharePolicy.class));
    }

    @Test(timeout=10000L)
    public void testDRFPolicy() {
        this.testComputeShares(SchedulingPolicy.getInstance(DominantResourceFairnessPolicy.class));
    }
}

