/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DeSelectFields;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesApps
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestRMWebServicesApps() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testApps() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testAppsHelper("apps", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppsSlash() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testAppsHelper("apps/", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppsDefault() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testAppsHelper("apps/", app1, "");
        rm.stop();
    }

    @Test
    public void testAppsXML() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyAppsXML(nodes, app1, false);
        rm.stop();
    }

    @Test
    public void testRunningApp() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyAppsXML(nodes, app1, true);
        this.testAppsHelper("apps/", app1, "application/json", true);
        rm.stop();
    }

    @Test
    public void testAppsXMLMulti() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024, "testwordcount", "user1");
        rm.submitApp(2048, "testwordcount2", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodesApps = dom.getElementsByTagName("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodesApps.getLength());
        NodeList nodes = dom.getElementsByTagName("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        rm.stop();
    }

    public void testAppsHelper(String path, RMApp app, String media) throws JSONException, Exception {
        this.testAppsHelper(path, app, media, false);
    }

    public void testAppsHelper(String path, RMApp app, String media, boolean hasResourceReq) throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path(path).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        this.verifyAppInfo(array.getJSONObject(0), app, hasResourceReq);
    }

    @Test
    public void testAppsQueryState() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("state", YarnApplicationState.ACCEPTED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        this.verifyAppInfo(array.getJSONObject(0), app1, false);
        rm.stop();
    }

    @Test
    public void testAppsQueryStates() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        RMApp killedApp = rm.submitApp(1024);
        rm.killApp(killedApp.getApplicationId());
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("states", YarnApplicationState.ACCEPTED.toString());
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        Assert.assertEquals((String)"state not equal to ACCEPTED", (Object)"ACCEPTED", (Object)array.getJSONObject(0).getString("state"));
        r = this.resource();
        params = new MultivaluedMapImpl();
        params.add("states", YarnApplicationState.ACCEPTED.toString());
        params.add("states", YarnApplicationState.KILLED.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((String)"both app states of ACCEPTED and KILLED are not present", (array.getJSONObject(0).getString("state").equals("ACCEPTED") && array.getJSONObject(1).getString("state").equals("KILLED") || array.getJSONObject(0).getString("state").equals("KILLED") && array.getJSONObject(1).getString("state").equals("ACCEPTED") ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testAppsQueryStatesComma() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        RMApp killedApp = rm.submitApp(1024);
        rm.killApp(killedApp.getApplicationId());
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("states", YarnApplicationState.ACCEPTED.toString());
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        Assert.assertEquals((String)"state not equal to ACCEPTED", (Object)"ACCEPTED", (Object)array.getJSONObject(0).getString("state"));
        r = this.resource();
        params = new MultivaluedMapImpl();
        params.add("states", YarnApplicationState.ACCEPTED.toString() + "," + YarnApplicationState.KILLED.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((String)"both app states of ACCEPTED and KILLED are not present", (array.getJSONObject(0).getString("state").equals("ACCEPTED") && array.getJSONObject(1).getString("state").equals("KILLED") || array.getJSONObject(0).getString("state").equals("KILLED") && array.getJSONObject(1).getString("state").equals("ACCEPTED") ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testAppsQueryStatesNone() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("states", YarnApplicationState.RUNNING.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"apps is not empty", (Object)new JSONObject().toString(), (Object)json.get("apps").toString());
        rm.stop();
    }

    @Test
    public void testAppsQueryStateNone() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("state", YarnApplicationState.RUNNING.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"apps is not empty", (Object)new JSONObject().toString(), (Object)json.get("apps").toString());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppsQueryStatesInvalid() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").queryParam("states", "INVALID_test").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid state query");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"Invalid application-state INVALID_test", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppsQueryStateInvalid() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").queryParam("state", "INVALID_test").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid state query");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"Invalid application-state INVALID_test", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testAppsQueryFinalStatus() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("finalStatus", FinalApplicationStatus.UNDEFINED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        System.out.println(json.toString());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        this.verifyAppInfo(array.getJSONObject(0), app1, false);
        rm.stop();
    }

    @Test
    public void testAppsQueryFinalStatusNone() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("finalStatus", FinalApplicationStatus.KILLED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"apps is not null", (Object)new JSONObject().toString(), (Object)json.get("apps").toString());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppsQueryFinalStatusInvalid() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").queryParam("finalStatus", "INVALID_test").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid state query");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"org.apache.hadoop.yarn.api.records.FinalApplicationStatus.INVALID_test", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testAppsQueryUser() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("user", UserGroupInformation.getCurrentUser().getShortUserName()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryQueue() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("queue", "default").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryLimit() throws JSONException, Exception {
        rm.start();
        rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        rm.submitApp(1024);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("limit", "2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryStartBegin() throws JSONException, Exception {
        rm.start();
        long start = System.currentTimeMillis();
        Thread.sleep(1L);
        rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        rm.submitApp(1024);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("startedTimeBegin", String.valueOf(start)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryStartBeginSome() throws JSONException, Exception {
        rm.start();
        rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        rm.submitApp(1024);
        long start = System.currentTimeMillis();
        Thread.sleep(1L);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("startedTimeBegin", String.valueOf(start)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryStartEnd() throws JSONException, Exception {
        rm.start();
        rm.registerNode("127.0.0.1:1234", 2048);
        long end = System.currentTimeMillis();
        Thread.sleep(1L);
        rm.submitApp(1024);
        rm.submitApp(1024);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("startedTimeEnd", String.valueOf(end)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"apps is not empty", (Object)new JSONObject().toString(), (Object)json.get("apps").toString());
        rm.stop();
    }

    @Test
    public void testAppsQueryStartBeginEnd() throws JSONException, Exception {
        rm.start();
        rm.registerNode("127.0.0.1:1234", 2048);
        long start = System.currentTimeMillis();
        Thread.sleep(1L);
        rm.submitApp(1024);
        rm.submitApp(1024);
        long end = System.currentTimeMillis();
        Thread.sleep(1L);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("startedTimeBegin", String.valueOf(start)).queryParam("startedTimeEnd", String.valueOf(end)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryFinishBegin() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        long start = System.currentTimeMillis();
        Thread.sleep(1L);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        amNodeManager.nodeHeartbeat(app1.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.submitApp(1024);
        rm.submitApp(1024);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("finishedTimeBegin", String.valueOf(start)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryFinishEnd() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        amNodeManager.nodeHeartbeat(app1.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.submitApp(1024);
        rm.submitApp(1024);
        long end = System.currentTimeMillis();
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("finishedTimeEnd", String.valueOf(end)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryFinishBeginEnd() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        long start = System.currentTimeMillis();
        Thread.sleep(1L);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        amNodeManager.nodeHeartbeat(app1.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.submitApp(1024);
        rm.submitApp(1024);
        long end = System.currentTimeMillis();
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("finishedTimeBegin", String.valueOf(start)).queryParam("finishedTimeEnd", String.valueOf(end)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        rm.stop();
    }

    @Test
    public void testAppsQueryAppTypes() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        Thread.sleep(1L);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        amNodeManager.nodeHeartbeat(app1.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
        rm.submitApp(1024, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, 2, null, "MAPREDUCE");
        rm.submitApp(1024, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, 2, null, "NON-YARN");
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "MAPREDUCE").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        Assert.assertEquals((Object)"MAPREDUCE", (Object)array.getJSONObject(0).getString("applicationType"));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "YARN").queryParam("applicationTypes", "MAPREDUCE").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((array.getJSONObject(0).getString("applicationType").equals("YARN") && array.getJSONObject(1).getString("applicationType").equals("MAPREDUCE") || array.getJSONObject(1).getString("applicationType").equals("YARN") && array.getJSONObject(0).getString("applicationType").equals("MAPREDUCE") ? 1 : 0) != 0);
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "YARN,NON-YARN").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((array.getJSONObject(0).getString("applicationType").equals("YARN") && array.getJSONObject(1).getString("applicationType").equals("NON-YARN") || array.getJSONObject(1).getString("applicationType").equals("YARN") && array.getJSONObject(0).getString("applicationType").equals("NON-YARN") ? 1 : 0) != 0);
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)array.length());
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "YARN,NON-YARN").queryParam("applicationTypes", "MAPREDUCE").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)array.length());
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "YARN").queryParam("applicationTypes", "").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        Assert.assertEquals((Object)"YARN", (Object)array.getJSONObject(0).getString("applicationType"));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", ",,, ,, YARN ,, ,").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        Assert.assertEquals((Object)"YARN", (Object)array.getJSONObject(0).getString("applicationType"));
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", ",,, ,,  ,, ,").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)array.length());
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", "YARN, ,NON-YARN, ,,").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((array.getJSONObject(0).getString("applicationType").equals("YARN") && array.getJSONObject(1).getString("applicationType").equals("NON-YARN") || array.getJSONObject(1).getString("applicationType").equals("YARN") && array.getJSONObject(0).getString("applicationType").equals("NON-YARN") ? 1 : 0) != 0);
        r = this.resource();
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("applicationTypes", " YARN, ,  ,,,").queryParam("applicationTypes", "MAPREDUCE , ,, ,").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)array.length());
        Assert.assertTrue((array.getJSONObject(0).getString("applicationType").equals("YARN") && array.getJSONObject(1).getString("applicationType").equals("MAPREDUCE") || array.getJSONObject(1).getString("applicationType").equals("YARN") && array.getJSONObject(0).getString("applicationType").equals("MAPREDUCE") ? 1 : 0) != 0);
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppsQueryWithInvaildDeselects() throws JSONException, Exception {
        try {
            rm.start();
            MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
            rm.submitApp(1024);
            amNodeManager.nodeHeartbeat(true);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParam("deSelects", "INVALIED_deSelectsParam").accept(new String[]{"application/json"}).get(ClientResponse.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"java.lang.Exception: Invalid deSelects string INVALIED_deSelectsParam specified. It should be one of", (String)message);
            WebServicesTestUtils.checkStringEqual((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringEqual((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testAppsQueryWithDeselects() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("deSelects", DeSelectFields.DeSelectType.RESOURCE_REQUESTS.toString());
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        JSONObject app = array.getJSONObject(0);
        Assert.assertTrue((String)"resource requests shouldn't exist", (!app.has("resourceRequests") ? 1 : 0) != 0);
        params.clear();
        params.add("deSelects", DeSelectFields.DeSelectType.AM_NODE_LABEL_EXPRESSION.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        app = array.getJSONObject(0);
        Assert.assertTrue((String)"AMNodeLabelExpression shouldn't exist", (!app.has("amNodeLabelExpression") ? 1 : 0) != 0);
        params.clear();
        params.add("deSelects", DeSelectFields.DeSelectType.TIMEOUTS.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        app = array.getJSONObject(0);
        Assert.assertTrue((String)"Timeouts shouldn't exist", (!app.has("timeouts") ? 1 : 0) != 0);
        rm.stop();
        params.clear();
        params.add("deSelects", DeSelectFields.DeSelectType.APP_NODE_LABEL_EXPRESSION.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        app = array.getJSONObject(0);
        Assert.assertTrue((String)"AppNodeLabelExpression shouldn't exist", (!app.has("appNodeLabelExpression") ? 1 : 0) != 0);
        rm.stop();
        params.clear();
        params.add("deSelects", DeSelectFields.DeSelectType.RESOURCE_INFO.toString());
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)array.length());
        app = array.getJSONObject(0);
        Assert.assertTrue((String)"Resource info shouldn't exist", (!app.has("resourceInfo") ? 1 : 0) != 0);
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppStatistics() throws JSONException, Exception {
        try {
            int i;
            rm.start();
            MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 4096);
            Thread.sleep(1L);
            RMApp app1 = rm.submitApp(1024, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, 2, null, "MAPREDUCE");
            amNodeManager.nodeHeartbeat(true);
            MockAM am = rm.sendAMLaunched(app1.getCurrentAppAttempt().getAppAttemptId());
            am.registerAppAttempt();
            am.unregisterAppAttempt();
            amNodeManager.nodeHeartbeat(app1.getCurrentAppAttempt().getAppAttemptId(), 1L, ContainerState.COMPLETE);
            rm.submitApp(1024, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, 2, null, "MAPREDUCE");
            rm.submitApp(1024, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, 2, null, "OTHER");
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject appsStatInfo = json.getJSONObject("appStatInfo");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appsStatInfo.length());
            JSONArray statItems = appsStatInfo.getJSONArray("statItem");
            Assert.assertEquals((String)"incorrect number of elements", (long)YarnApplicationState.values().length, (long)statItems.length());
            for (i = 0; i < YarnApplicationState.values().length; ++i) {
                Assert.assertEquals((Object)"*", (Object)statItems.getJSONObject(0).getString("type"));
                if (statItems.getJSONObject(0).getString("state").equals("ACCEPTED")) {
                    Assert.assertEquals((Object)"2", (Object)statItems.getJSONObject(0).getString("count"));
                    continue;
                }
                if (statItems.getJSONObject(0).getString("state").equals("FINISHED")) {
                    Assert.assertEquals((Object)"1", (Object)statItems.getJSONObject(0).getString("count"));
                    continue;
                }
                Assert.assertEquals((Object)"0", (Object)statItems.getJSONObject(0).getString("count"));
            }
            r = this.resource();
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").queryParam("states", YarnApplicationState.ACCEPTED.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            appsStatInfo = json.getJSONObject("appStatInfo");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appsStatInfo.length());
            statItems = appsStatInfo.getJSONArray("statItem");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)statItems.length());
            Assert.assertEquals((Object)"ACCEPTED", (Object)statItems.getJSONObject(0).getString("state"));
            Assert.assertEquals((Object)"*", (Object)statItems.getJSONObject(0).getString("type"));
            Assert.assertEquals((Object)"2", (Object)statItems.getJSONObject(0).getString("count"));
            r = this.resource();
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").queryParam("applicationTypes", "MAPREDUCE").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            appsStatInfo = json.getJSONObject("appStatInfo");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appsStatInfo.length());
            statItems = appsStatInfo.getJSONArray("statItem");
            Assert.assertEquals((String)"incorrect number of elements", (long)YarnApplicationState.values().length, (long)statItems.length());
            for (i = 0; i < YarnApplicationState.values().length; ++i) {
                Assert.assertEquals((Object)"mapreduce", (Object)statItems.getJSONObject(0).getString("type"));
                if (statItems.getJSONObject(0).getString("state").equals("ACCEPTED")) {
                    Assert.assertEquals((Object)"1", (Object)statItems.getJSONObject(0).getString("count"));
                    continue;
                }
                if (statItems.getJSONObject(0).getString("state").equals("FINISHED")) {
                    Assert.assertEquals((Object)"1", (Object)statItems.getJSONObject(0).getString("count"));
                    continue;
                }
                Assert.assertEquals((Object)"0", (Object)statItems.getJSONObject(0).getString("count"));
            }
            r = this.resource();
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").queryParam("applicationTypes", "MAPREDUCE,OTHER").accept(new String[]{"application/json"}).get(ClientResponse.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject exception = json.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String className = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"we temporarily support at most one applicationType", (String)message);
            WebServicesTestUtils.checkStringEqual((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringEqual((String)"exception className", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)className);
            r = this.resource();
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").queryParam("states", YarnApplicationState.FINISHED.toString() + "," + YarnApplicationState.ACCEPTED.toString()).queryParam("applicationTypes", "MAPREDUCE").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            appsStatInfo = json.getJSONObject("appStatInfo");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appsStatInfo.length());
            statItems = appsStatInfo.getJSONArray("statItem");
            Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)statItems.length());
            JSONObject statItem1 = statItems.getJSONObject(0);
            JSONObject statItem2 = statItems.getJSONObject(1);
            Assert.assertTrue((statItem1.getString("state").equals("ACCEPTED") && statItem2.getString("state").equals("FINISHED") || statItem2.getString("state").equals("ACCEPTED") && statItem1.getString("state").equals("FINISHED") ? 1 : 0) != 0);
            Assert.assertEquals((Object)"mapreduce", (Object)statItem1.getString("type"));
            Assert.assertEquals((Object)"1", (Object)statItem1.getString("count"));
            Assert.assertEquals((Object)"mapreduce", (Object)statItem2.getString("type"));
            Assert.assertEquals((Object)"1", (Object)statItem2.getString("count"));
            r = this.resource();
            response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("appstatistics").queryParam("states", "wrong_state").accept(new String[]{"application/json"}).get(ClientResponse.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            exception = json.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            message = exception.getString("message");
            type = exception.getString("exception");
            className = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringContains((String)"exception message", (String)"Invalid application-state wrong_state", (String)message);
            WebServicesTestUtils.checkStringEqual((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringEqual((String)"exception className", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)className);
        }
        finally {
            rm.stop();
        }
    }

    @Test
    public void testSingleApp() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        this.testSingleAppsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test
    public void testUnmarshalAppInfo() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).accept(new String[]{"application/xml"}).get(ClientResponse.class);
        AppInfo appInfo = (AppInfo)response.getEntity(AppInfo.class);
        Assert.assertEquals((Object)app1.getApplicationId().toString(), (Object)appInfo.getAppId());
        Assert.assertEquals((Object)app1.getName(), (Object)appInfo.getName());
        Assert.assertEquals((Object)app1.createApplicationState(), (Object)appInfo.getState());
        Assert.assertEquals((long)((ResourceRequest)app1.getAMResourceRequests().get(0)).getCapability().getMemorySize(), (long)appInfo.getAllocatedMB());
        rm.stop();
    }

    @Test
    public void testSingleAppsSlash() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testSingleAppsHelper(app1.getApplicationId().toString() + "/", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testSingleAppsDefault() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testSingleAppsHelper(app1.getApplicationId().toString() + "/", app1, "");
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidApp() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_invalid_12").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.IllegalArgumentException: Invalid ApplicationId: application_invalid_12", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistApp() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_00000_0099").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: app with id: application_00000_0099 not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    public void testSingleAppsHelper(String path, RMApp app, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(path).accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAppInfo(json.getJSONObject("app"), app, false);
    }

    @Test
    public void testSingleAppsXML() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        this.verifyAppsXML(nodes, app1, false);
        rm.stop();
    }

    public void verifyAppsXML(NodeList nodes, RMApp app, boolean hasResourceReq) throws JSONException, Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAppInfoGeneric(app, WebServicesTestUtils.getXmlString((Element)element, (String)"id"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlString((Element)element, (String)"applicationType"), WebServicesTestUtils.getXmlString((Element)element, (String)"queue"), WebServicesTestUtils.getXmlInt((Element)element, (String)"priority"), WebServicesTestUtils.getXmlString((Element)element, (String)"state"), WebServicesTestUtils.getXmlString((Element)element, (String)"finalStatus"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"progress"), WebServicesTestUtils.getXmlString((Element)element, (String)"trackingUI"), WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), WebServicesTestUtils.getXmlLong((Element)element, (String)"clusterId"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"finishedTime"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"amHostHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"amContainerLogs"), WebServicesTestUtils.getXmlInt((Element)element, (String)"allocatedMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"allocatedVCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"runningContainers"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"queueUsagePercentage"), WebServicesTestUtils.getXmlFloat((Element)element, (String)"clusterUsagePercentage"), WebServicesTestUtils.getXmlInt((Element)element, (String)"preemptedResourceMB"), WebServicesTestUtils.getXmlInt((Element)element, (String)"preemptedResourceVCores"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numNonAMContainerPreempted"), WebServicesTestUtils.getXmlInt((Element)element, (String)"numAMContainerPreempted"), WebServicesTestUtils.getXmlString((Element)element, (String)"logAggregationStatus"), WebServicesTestUtils.getXmlBoolean((Element)element, (String)"unmanagedApplication"), WebServicesTestUtils.getXmlString((Element)element, (String)"appNodeLabelExpression"), WebServicesTestUtils.getXmlString((Element)element, (String)"amNodeLabelExpression"), WebServicesTestUtils.getXmlString((Element)element, (String)"amRPCAddress"));
            if (!hasResourceReq) continue;
            Assert.assertEquals((long)element.getElementsByTagName("resourceRequests").getLength(), (long)1L);
            Element resourceRequests = (Element)element.getElementsByTagName("resourceRequests").item(0);
            Element capability = (Element)resourceRequests.getElementsByTagName("capability").item(0);
            ResourceRequest rr = (ResourceRequest)((AbstractYarnScheduler)rm.getRMContext().getScheduler()).getApplicationAttempt(app.getCurrentAppAttempt().getAppAttemptId()).getAppSchedulingInfo().getAllResourceRequests().get(0);
            this.verifyResourceRequestsGeneric(rr, WebServicesTestUtils.getXmlString((Element)resourceRequests, (String)"nodeLabelExpression"), WebServicesTestUtils.getXmlInt((Element)resourceRequests, (String)"numContainers"), WebServicesTestUtils.getXmlBoolean((Element)resourceRequests, (String)"relaxLocality"), WebServicesTestUtils.getXmlInt((Element)resourceRequests, (String)"priority"), WebServicesTestUtils.getXmlString((Element)resourceRequests, (String)"resourceName"), WebServicesTestUtils.getXmlLong((Element)capability, (String)"memory"), WebServicesTestUtils.getXmlLong((Element)capability, (String)"vCores"), WebServicesTestUtils.getXmlString((Element)resourceRequests, (String)"executionType"), WebServicesTestUtils.getXmlBoolean((Element)resourceRequests, (String)"enforceExecutionType"));
        }
    }

    public void verifyAppInfo(JSONObject info, RMApp app, boolean hasResourceReqs) throws JSONException, Exception {
        int expectedNumberOfElements = 39 + (hasResourceReqs ? 2 : 0);
        String appNodeLabelExpression = null;
        String amNodeLabelExpression = null;
        if (app.getApplicationSubmissionContext().getNodeLabelExpression() != null) {
            ++expectedNumberOfElements;
            appNodeLabelExpression = info.getString("appNodeLabelExpression");
        }
        if (((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression() != null) {
            ++expectedNumberOfElements;
            amNodeLabelExpression = info.getString("amNodeLabelExpression");
        }
        String amRPCAddress = null;
        if (AppInfo.getAmRPCAddressFromRMAppAttempt((RMAppAttempt)app.getCurrentAppAttempt()) != null) {
            ++expectedNumberOfElements;
            amRPCAddress = info.getString("amRPCAddress");
        }
        Assert.assertEquals((String)"incorrect number of elements", (long)expectedNumberOfElements, (long)info.length());
        this.verifyAppInfoGeneric(app, info.getString("id"), info.getString("user"), info.getString("name"), info.getString("applicationType"), info.getString("queue"), info.getInt("priority"), info.getString("state"), info.getString("finalStatus"), (float)info.getDouble("progress"), info.getString("trackingUI"), info.getString("diagnostics"), info.getLong("clusterId"), info.getLong("startedTime"), info.getLong("finishedTime"), info.getLong("elapsedTime"), info.getString("amHostHttpAddress"), info.getString("amContainerLogs"), info.getInt("allocatedMB"), info.getInt("allocatedVCores"), info.getInt("runningContainers"), (float)info.getDouble("queueUsagePercentage"), (float)info.getDouble("clusterUsagePercentage"), info.getInt("preemptedResourceMB"), info.getInt("preemptedResourceVCores"), info.getInt("numNonAMContainerPreempted"), info.getInt("numAMContainerPreempted"), info.getString("logAggregationStatus"), info.getBoolean("unmanagedApplication"), appNodeLabelExpression, amNodeLabelExpression, amRPCAddress);
        if (hasResourceReqs) {
            this.verifyResourceRequests(info.getJSONArray("resourceRequests"), app);
        }
    }

    public void verifyAppInfoGeneric(RMApp app, String id, String user, String name, String applicationType, String queue, int prioirty, String state, String finalStatus, float progress, String trackingUI, String diagnostics, long clusterId, long startedTime, long finishedTime, long elapsedTime, String amHostHttpAddress, String amContainerLogs, int allocatedMB, int allocatedVCores, int numContainers, float queueUsagePerc, float clusterUsagePerc, int preemptedResourceMB, int preemptedResourceVCores, int numNonAMContainerPreempted, int numAMContainerPreempted, String logAggregationStatus, boolean unmanagedApplication, String appNodeLabelExpression, String amNodeLabelExpression, String amRPCAddress) throws JSONException, Exception {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)app.getApplicationId().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)app.getUser(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)app.getName(), (String)name);
        WebServicesTestUtils.checkStringMatch((String)"applicationType", (String)app.getApplicationType(), (String)applicationType);
        WebServicesTestUtils.checkStringMatch((String)"queue", (String)app.getQueue(), (String)queue);
        Assert.assertEquals((String)"priority doesn't match", (long)0L, (long)prioirty);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)app.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"finalStatus", (String)app.getFinalApplicationStatus().toString(), (String)finalStatus);
        Assert.assertEquals((String)"progress doesn't match", (double)0.0, (double)progress, (double)0.0);
        if ("UNASSIGNED".equals(trackingUI)) {
            WebServicesTestUtils.checkStringMatch((String)"trackingUI", (String)"UNASSIGNED", (String)trackingUI);
        }
        WebServicesTestUtils.checkStringEqual((String)"diagnostics", (String)app.getDiagnostics().toString(), (String)diagnostics);
        Assert.assertEquals((String)"clusterId doesn't match", (long)ResourceManager.getClusterTimeStamp(), (long)clusterId);
        Assert.assertEquals((String)"startedTime doesn't match", (long)app.getStartTime(), (long)startedTime);
        Assert.assertEquals((String)"finishedTime doesn't match", (long)app.getFinishTime(), (long)finishedTime);
        Assert.assertTrue((String)"elapsed time not greater than 0", (elapsedTime > 0L ? 1 : 0) != 0);
        WebServicesTestUtils.checkStringMatch((String)"amHostHttpAddress", (String)app.getCurrentAppAttempt().getMasterContainer().getNodeHttpAddress(), (String)amHostHttpAddress);
        Assert.assertTrue((String)"amContainerLogs doesn't match", (boolean)amContainerLogs.startsWith("http://"));
        Assert.assertTrue((String)"amContainerLogs doesn't contain user info", (boolean)amContainerLogs.endsWith("/" + app.getUser()));
        Assert.assertEquals((String)"allocatedMB doesn't match", (long)1024L, (long)allocatedMB);
        Assert.assertEquals((String)"allocatedVCores doesn't match", (long)1L, (long)allocatedVCores);
        Assert.assertEquals((String)"queueUsagePerc doesn't match", (float)50.0f, (float)queueUsagePerc, (float)0.01f);
        Assert.assertEquals((String)"clusterUsagePerc doesn't match", (float)50.0f, (float)clusterUsagePerc, (float)0.01f);
        Assert.assertEquals((String)"numContainers doesn't match", (long)1L, (long)numContainers);
        Assert.assertEquals((String)"preemptedResourceMB doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getMemorySize(), (long)preemptedResourceMB);
        Assert.assertEquals((String)"preemptedResourceVCores doesn't match", (long)app.getRMAppMetrics().getResourcePreempted().getVirtualCores(), (long)preemptedResourceVCores);
        Assert.assertEquals((String)"numNonAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumNonAMContainersPreempted(), (long)numNonAMContainerPreempted);
        Assert.assertEquals((String)"numAMContainerPreempted doesn't match", (long)app.getRMAppMetrics().getNumAMContainersPreempted(), (long)numAMContainerPreempted);
        Assert.assertEquals((String)"Log aggregation Status doesn't match", (Object)app.getLogAggregationStatusForAppReport().toString(), (Object)logAggregationStatus);
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)app.getApplicationSubmissionContext().getUnmanagedAM(), (Object)unmanagedApplication);
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)app.getApplicationSubmissionContext().getNodeLabelExpression(), (Object)appNodeLabelExpression);
        Assert.assertEquals((String)"unmanagedApplication doesn't match", (Object)((ResourceRequest)app.getAMResourceRequests().get(0)).getNodeLabelExpression(), (Object)amNodeLabelExpression);
        Assert.assertEquals((String)"amRPCAddress", (Object)AppInfo.getAmRPCAddressFromRMAppAttempt((RMAppAttempt)app.getCurrentAppAttempt()), (Object)amRPCAddress);
    }

    public void verifyResourceRequests(JSONArray resourceRequest, RMApp app) throws JSONException {
        JSONObject requestInfo = resourceRequest.getJSONObject(0);
        ResourceRequest rr = (ResourceRequest)((AbstractYarnScheduler)rm.getRMContext().getScheduler()).getApplicationAttempt(app.getCurrentAppAttempt().getAppAttemptId()).getAppSchedulingInfo().getAllResourceRequests().get(0);
        this.verifyResourceRequestsGeneric(rr, requestInfo.getString("nodeLabelExpression"), requestInfo.getInt("numContainers"), requestInfo.getBoolean("relaxLocality"), requestInfo.getInt("priority"), requestInfo.getString("resourceName"), requestInfo.getJSONObject("capability").getLong("memory"), requestInfo.getJSONObject("capability").getLong("vCores"), requestInfo.getJSONObject("executionTypeRequest").getString("executionType"), requestInfo.getJSONObject("executionTypeRequest").getBoolean("enforceExecutionType"));
    }

    public void verifyResourceRequestsGeneric(ResourceRequest request, String nodeLabelExpression, int numContainers, boolean relaxLocality, int priority2, String resourceName, long memory, long vCores, String executionType, boolean enforceExecutionType) {
        Assert.assertEquals((String)"nodeLabelExpression doesn't match", (Object)request.getNodeLabelExpression(), (Object)nodeLabelExpression);
        Assert.assertEquals((String)"numContainers doesn't match", (long)request.getNumContainers(), (long)numContainers);
        Assert.assertEquals((String)"relaxLocality doesn't match", (Object)request.getRelaxLocality(), (Object)relaxLocality);
        Assert.assertEquals((String)"priority does not match", (long)request.getPriority().getPriority(), (long)priority2);
        Assert.assertEquals((String)"resourceName does not match", (Object)request.getResourceName(), (Object)resourceName);
        Assert.assertEquals((String)"memory does not match", (long)request.getCapability().getMemorySize(), (long)memory);
        Assert.assertEquals((String)"vCores does not match", (long)request.getCapability().getVirtualCores(), (long)vCores);
        Assert.assertEquals((String)"executionType does not match", (Object)request.getExecutionTypeRequest().getExecutionType().name(), (Object)executionType);
        Assert.assertEquals((String)"enforceExecutionType does not match", (Object)request.getExecutionTypeRequest().getEnforceExecutionType(), (Object)enforceExecutionType);
    }

    @Test
    public void testAppAttempts() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test(timeout=20000L)
    public void testMultipleAppAttempts() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 8192);
        RMApp app1 = rm.submitApp(1024, "testwordcount", "user1");
        MockAM am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
        int maxAppAttempts = rm.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        int numAttempt = 1;
        while (true) {
            amNodeManager.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
            rm.waitForState(am.getApplicationAttemptId(), RMAppAttemptState.FAILED);
            if (numAttempt == maxAppAttempts) break;
            rm.waitForState(app1.getApplicationId(), RMAppState.ACCEPTED);
            am = MockRM.launchAndRegisterAM(app1, rm, amNodeManager);
            ++numAttempt;
        }
        rm.waitForState(app1.getApplicationId(), RMAppState.FAILED);
        Assert.assertEquals((String)"incorrect number of attempts", (long)maxAppAttempts, (long)app1.getAppAttempts().values().size());
        this.testAppAttemptsHelper(app1.getApplicationId().toString(), app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemptsSlash() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "application/json");
        rm.stop();
    }

    @Test
    public void testAppAttemtpsDefault() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        this.testAppAttemptsHelper(app1.getApplicationId().toString() + "/", app1, "");
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppIdGetAttempts() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_invalid_12").path("appattempts").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appAttempt");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.IllegalArgumentException: Invalid ApplicationId: application_invalid_12", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppAttemptId() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app = rm.submitApp(1024);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path(app.getApplicationId().toString()).path("appattempts").path("appattempt_invalid_12_000001").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appAttempt");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.IllegalArgumentException: Invalid AppAttemptId: appattempt_invalid_12_000001", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonexistAppAttempts() throws JSONException, Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        rm.submitApp(1024, "testwordcount", "user1");
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("cluster").path("apps").path("application_00000_0099").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid appid");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: app with id: application_00000_0099 not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
        finally {
            rm.stop();
        }
    }

    public void testAppAttemptsHelper(String path, RMApp app, String media) throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(path).path("appattempts").accept(new String[]{media}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jsonAppAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jsonAppAttempts.length());
        JSONArray jsonArray = jsonAppAttempts.getJSONArray("appAttempt");
        Collection attempts = app.getAppAttempts().values();
        Assert.assertEquals((String)"incorrect number of elements", (long)attempts.size(), (long)jsonArray.length());
        int i = 0;
        for (RMAppAttempt attempt : attempts) {
            this.verifyAppAttemptsInfo(jsonArray.getJSONObject(i), attempt, app.getUser());
            ++i;
        }
    }

    @Test
    public void testAppAttemptsXML() throws JSONException, Exception {
        rm.start();
        String user = "user1";
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        RMApp app1 = rm.submitApp(1024, "testwordcount", user);
        amNodeManager.nodeHeartbeat(true);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("apps").path(app1.getApplicationId().toString()).path("appattempts").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        NodeList attempt = dom.getElementsByTagName("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempt.getLength());
        this.verifyAppAttemptsXML(attempt, app1.getCurrentAppAttempt(), user);
        rm.stop();
    }

    public void verifyAppAttemptsXML(NodeList nodes, RMAppAttempt appAttempt, String user) throws JSONException, Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAppAttemptInfoGeneric(appAttempt, WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"), user);
        }
    }

    public void verifyAppAttemptsInfo(JSONObject info, RMAppAttempt appAttempt, String user) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)10L, (long)info.length());
        this.verifyAppAttemptInfoGeneric(appAttempt, info.getInt("id"), info.getLong("startTime"), info.getString("containerId"), info.getString("nodeHttpAddress"), info.getString("nodeId"), info.getString("logsLink"), user);
    }

    public void verifyAppAttemptInfoGeneric(RMAppAttempt appAttempt, int id, long startTime, String containerId, String nodeHttpAddress, String nodeId, String logsLink, String user) throws JSONException, Exception {
        Assert.assertEquals((String)"id doesn't match", (long)appAttempt.getAppAttemptId().getAttemptId(), (long)id);
        Assert.assertEquals((String)"startedTime doesn't match", (long)appAttempt.getStartTime(), (long)startTime);
        WebServicesTestUtils.checkStringMatch((String)"containerId", (String)appAttempt.getMasterContainer().getId().toString(), (String)containerId);
        WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)appAttempt.getMasterContainer().getNodeHttpAddress(), (String)nodeHttpAddress);
        WebServicesTestUtils.checkStringMatch((String)"nodeId", (String)appAttempt.getMasterContainer().getNodeId().toString(), (String)nodeId);
        Assert.assertTrue((String)"logsLink doesn't match ", (boolean)logsLink.startsWith("http://"));
        Assert.assertTrue((String)"logsLink doesn't contain user info", (boolean)logsLink.endsWith("/" + user));
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration conf = new Configuration();
            conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rm = new MockRM(conf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

