/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerNode
extends SchedulerNode {
    private static final Log LOG = LogFactory.getLog(FSSchedulerNode.class);
    private FSAppAttempt reservedAppSchedulable;
    @VisibleForTesting
    final Set<RMContainer> containersForPreemption = new ConcurrentSkipListSet<RMContainer>();
    @VisibleForTesting
    final Map<FSAppAttempt, Resource> resourcesPreemptedForApp = new LinkedHashMap<FSAppAttempt, Resource>();
    private final Map<ApplicationAttemptId, FSAppAttempt> appIdToAppMap = new HashMap<ApplicationAttemptId, FSAppAttempt>();
    private Resource totalResourcesPreempted = Resource.newInstance((int)0, (int)0);

    public FSSchedulerNode(RMNode node, boolean usePortForNodeName) {
        super(node, usePortForNodeName);
    }

    Resource getTotalReserved() {
        Resource totalReserved = Resources.clone((Resource)(this.getReservedContainer() != null ? this.getReservedContainer().getAllocatedResource() : Resource.newInstance((int)0, (int)0)));
        Resources.addTo((Resource)totalReserved, (Resource)this.totalResourcesPreempted);
        return totalReserved;
    }

    @Override
    public synchronized void reserveResource(SchedulerApplicationAttempt application, SchedulerRequestKey schedulerKey, RMContainer container) {
        RMContainer reservedContainer = this.getReservedContainer();
        if (reservedContainer != null) {
            if (!container.getContainer().getNodeId().equals((Object)this.getNodeID())) {
                throw new IllegalStateException("Trying to reserve container " + container + " on node " + container.getReservedNode() + " when currently" + " reserved resource " + reservedContainer + " on node " + reservedContainer.getReservedNode());
            }
            if (!reservedContainer.getContainer().getId().getApplicationAttemptId().equals((Object)container.getContainer().getId().getApplicationAttemptId())) {
                throw new IllegalStateException("Trying to reserve container " + container + " for application " + application.getApplicationId() + " when currently" + " reserved container " + reservedContainer + " on node " + this);
            }
            LOG.info((Object)("Updated reserved container " + container.getContainer().getId() + " on node " + this + " for application " + application.getApplicationId()));
        } else {
            LOG.info((Object)("Reserved container " + container.getContainer().getId() + " on node " + this + " for application " + application.getApplicationId()));
        }
        this.setReservedContainer(container);
        this.reservedAppSchedulable = (FSAppAttempt)application;
    }

    @Override
    public synchronized void unreserveResource(SchedulerApplicationAttempt application) {
        ApplicationAttemptId reservedApplication = this.getReservedContainer().getContainer().getId().getApplicationAttemptId();
        if (!reservedApplication.equals((Object)application.getApplicationAttemptId())) {
            throw new IllegalStateException("Trying to unreserve  for application " + application.getApplicationId() + " when currently reserved " + " for application " + reservedApplication.getApplicationId() + " on node " + this);
        }
        this.setReservedContainer(null);
        this.reservedAppSchedulable = null;
    }

    synchronized FSAppAttempt getReservedAppSchedulable() {
        return this.reservedAppSchedulable;
    }

    @VisibleForTesting
    synchronized LinkedHashMap<FSAppAttempt, Resource> getPreemptionList() {
        this.cleanupPreemptionList();
        return new LinkedHashMap<FSAppAttempt, Resource>(this.resourcesPreemptedForApp);
    }

    synchronized boolean isPreemptedForApp(FSAppAttempt app) {
        return this.resourcesPreemptedForApp.containsKey(app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupPreemptionList() {
        LinkedList candidates;
        FSSchedulerNode fSSchedulerNode = this;
        synchronized (fSSchedulerNode) {
            candidates = Lists.newLinkedList(this.resourcesPreemptedForApp.keySet());
        }
        for (FSAppAttempt app : candidates) {
            if (!app.isStopped() && app.isStarved() && (!Resources.isNone((Resource)app.getFairshareStarvation()) || !Resources.isNone((Resource)app.getMinshareStarvation()))) continue;
            FSSchedulerNode fSSchedulerNode2 = this;
            synchronized (fSSchedulerNode2) {
                Resource removed = this.resourcesPreemptedForApp.remove(app);
                if (removed != null) {
                    Resources.subtractFrom((Resource)this.totalResourcesPreempted, (Resource)removed);
                    this.appIdToAppMap.remove(app.getApplicationAttemptId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContainersForPreemption(Collection<RMContainer> containers, FSAppAttempt app) {
        Resource appReserved = Resources.createResource((int)0);
        for (RMContainer container : containers) {
            if (!this.containersForPreemption.add(container)) continue;
            Resources.addTo((Resource)appReserved, (Resource)container.getAllocatedResource());
        }
        FSSchedulerNode fSSchedulerNode = this;
        synchronized (fSSchedulerNode) {
            if (!Resources.isNone((Resource)appReserved)) {
                Resources.addTo((Resource)this.totalResourcesPreempted, (Resource)appReserved);
                this.appIdToAppMap.putIfAbsent(app.getApplicationAttemptId(), app);
                this.resourcesPreemptedForApp.putIfAbsent(app, Resource.newInstance((int)0, (int)0));
                Resources.addTo((Resource)this.resourcesPreemptedForApp.get(app), (Resource)appReserved);
            }
        }
    }

    Set<RMContainer> getContainersForPreemption() {
        return this.containersForPreemption;
    }

    @Override
    protected synchronized void allocateContainer(RMContainer rmContainer, boolean launchedOnNode) {
        Resource allocated;
        super.allocateContainer(rmContainer, launchedOnNode);
        if (LOG.isDebugEnabled()) {
            Container container = rmContainer.getContainer();
            LOG.debug((Object)("Assigned container " + container.getId() + " of capacity " + container.getResource() + " on host " + this.getRMNode().getNodeAddress() + ", which has " + this.getNumContainers() + " containers, " + this.getAllocatedResource() + " used and " + this.getUnallocatedResource() + " available after allocation"));
        }
        if (!Resources.isNone((Resource)(allocated = rmContainer.getAllocatedResource()))) {
            FSAppAttempt app = this.appIdToAppMap.get(rmContainer.getApplicationAttemptId());
            if (app != null) {
                Resource reserved = this.resourcesPreemptedForApp.get(app);
                Resource fulfilled = Resources.componentwiseMin((Resource)reserved, (Resource)allocated);
                Resources.subtractFrom((Resource)reserved, (Resource)fulfilled);
                Resources.subtractFrom((Resource)this.totalResourcesPreempted, (Resource)fulfilled);
                if (Resources.isNone((Resource)reserved)) {
                    this.resourcesPreemptedForApp.remove(app);
                    this.appIdToAppMap.remove(rmContainer.getApplicationAttemptId());
                }
            }
        } else {
            LOG.error((Object)("Allocated empty container" + rmContainer.getContainerId()));
        }
    }

    @Override
    public synchronized void releaseContainer(ContainerId containerId, boolean releasedByNode) {
        RMContainer container = this.getContainer(containerId);
        super.releaseContainer(containerId, releasedByNode);
        if (container != null) {
            this.containersForPreemption.remove(container);
        }
    }
}

