/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

public class RMAppManager
implements EventHandler<RMAppManagerEvent>,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppManager.class);
    private int maxCompletedAppsInMemory;
    private int maxCompletedAppsInStateStore;
    protected int completedAppsInStateStore = 0;
    protected LinkedList<ApplicationId> completedApps = new LinkedList();
    private final RMContext rmContext;
    private final ApplicationMasterService masterService;
    private final YarnScheduler scheduler;
    private final ApplicationACLsManager applicationACLsManager;
    private Configuration conf;
    private YarnAuthorizationProvider authorizer;

    public RMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
        this.rmContext = context;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.applicationACLsManager = applicationACLsManager;
        this.conf = conf;
        this.maxCompletedAppsInMemory = conf.getInt("yarn.resourcemanager.max-completed-applications", 1000);
        this.maxCompletedAppsInStateStore = conf.getInt("yarn.resourcemanager.state-store.max-completed-applications", this.maxCompletedAppsInMemory);
        if (this.maxCompletedAppsInStateStore > this.maxCompletedAppsInMemory) {
            this.maxCompletedAppsInStateStore = this.maxCompletedAppsInMemory;
        }
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
    }

    @VisibleForTesting
    public void logApplicationSummary(ApplicationId appId) {
        ApplicationSummary.logAppSummary((RMApp)this.rmContext.getRMApps().get(appId));
    }

    private static <V> V getChecked(Future<V> future) throws YarnException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new YarnException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected synchronized int getCompletedAppsListSize() {
        return this.completedApps.size();
    }

    protected synchronized void finishApplication(ApplicationId applicationId) {
        if (applicationId == null) {
            LOG.error((Object)"RMAppManager received completed appId of null, skipping");
        } else {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.rmContext.getDelegationTokenRenewer().applicationFinished(applicationId);
            }
            this.completedApps.add(applicationId);
            ++this.completedAppsInStateStore;
            this.writeAuditLog(applicationId);
        }
    }

    protected void writeAuditLog(ApplicationId appId) {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        String operation = "UNKONWN";
        boolean success = false;
        switch (app.getState()) {
            case FAILED: {
                operation = "Application Finished - Failed";
                break;
            }
            case FINISHED: {
                operation = "Application Finished - Succeeded";
                success = true;
                break;
            }
            case KILLED: {
                operation = "Application Finished - Killed";
                success = true;
                break;
            }
        }
        if (success) {
            RMAuditLogger.logSuccess(app.getUser(), operation, "RMAppManager", app.getApplicationId());
        } else {
            StringBuilder diag = app.getDiagnostics();
            String msg = diag == null ? null : diag.toString();
            RMAuditLogger.logFailure(app.getUser(), operation, msg, "RMAppManager", "App failed with state: " + (Object)((Object)app.getState()), appId);
        }
    }

    protected synchronized void checkAppNumCompletedLimit() {
        if (this.completedAppsInStateStore > this.maxCompletedAppsInStateStore) {
            this.removeCompletedAppsFromStateStore();
        }
        if (this.completedApps.size() > this.maxCompletedAppsInMemory) {
            this.removeCompletedAppsFromMemory();
        }
    }

    private void removeCompletedAppsFromStateStore() {
        int numDelete = this.completedAppsInStateStore - this.maxCompletedAppsInStateStore;
        for (int i = 0; i < numDelete; ++i) {
            ApplicationId removeId = this.completedApps.get(i);
            RMApp removeApp = (RMApp)this.rmContext.getRMApps().get(removeId);
            boolean deleteApp = this.shouldDeleteApp(removeApp);
            if (deleteApp) {
                LOG.info((Object)("Max number of completed apps kept in state store met: maxCompletedAppsInStateStore = " + this.maxCompletedAppsInStateStore + ", removing app " + removeId + " from state store."));
                this.rmContext.getStateStore().removeApplication(removeApp);
                --this.completedAppsInStateStore;
                continue;
            }
            LOG.info((Object)("Max number of completed apps kept in state store met: maxCompletedAppsInStateStore = " + this.maxCompletedAppsInStateStore + ", but not removing app " + removeId + " from state store as log aggregation have not finished yet."));
        }
    }

    private void removeCompletedAppsFromMemory() {
        int numDelete = this.completedApps.size() - this.maxCompletedAppsInMemory;
        int offset = 0;
        for (int i = 0; i < numDelete; ++i) {
            int deletionIdx = i - offset;
            ApplicationId removeId = this.completedApps.get(deletionIdx);
            RMApp removeApp = (RMApp)this.rmContext.getRMApps().get(removeId);
            boolean deleteApp = this.shouldDeleteApp(removeApp);
            if (deleteApp) {
                ++offset;
                LOG.info((Object)("Application should be expired, max number of completed apps kept in memory met: maxCompletedAppsInMemory = " + this.maxCompletedAppsInMemory + ", removing app " + removeId + " from memory: "));
                this.completedApps.remove(deletionIdx);
                this.rmContext.getRMApps().remove(removeId);
                this.applicationACLsManager.removeApplication(removeId);
                continue;
            }
            LOG.info((Object)("Application should be expired, max number of completed apps kept in memory met: maxCompletedAppsInMemory = " + this.maxCompletedAppsInMemory + ", but not removing app " + removeId + " from memory as log aggregation have not finished yet."));
        }
    }

    private boolean shouldDeleteApp(RMApp app) {
        return !app.isLogAggregationEnabled() || app.isLogAggregationFinished();
    }

    protected void submitApplication(ApplicationSubmissionContext submissionContext, long submitTime, String user) throws YarnException {
        ApplicationId applicationId = submissionContext.getApplicationId();
        RMAppImpl application = this.createAndPopulateNewRMApp(submissionContext, submitTime, user, false, -1L);
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.rmContext.getDelegationTokenRenewer().addApplicationAsync(applicationId, BuilderUtils.parseCredentials((ApplicationSubmissionContext)submissionContext), submissionContext.getCancelTokensWhenComplete(), application.getUser(), BuilderUtils.parseTokensConf((ApplicationSubmissionContext)submissionContext));
            } else {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to parse credentials for " + applicationId), (Throwable)e);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, e.getMessage()));
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    protected void recoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext appContext = appState.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        RMAppImpl application = this.createAndPopulateNewRMApp(appContext, appState.getSubmitTime(), appState.getUser(), true, appState.getStartTime());
        application.handle(new RMAppRecoverEvent(appId, rmState));
    }

    private RMAppImpl createAndPopulateNewRMApp(ApplicationSubmissionContext submissionContext, long submitTime, String user, boolean isRecovery, long startTime) throws YarnException {
        ApplicationPlacementContext placementContext = this.placeApplication(this.rmContext.getQueuePlacementManager(), submissionContext, user, isRecovery);
        if (!isRecovery) {
            this.replaceQueueFromPlacementContext(placementContext, submissionContext);
            RMServerUtils.validateApplicationTimeouts(submissionContext.getApplicationTimeouts());
        }
        ApplicationId applicationId = submissionContext.getApplicationId();
        List<ResourceRequest> amReqs = this.validateAndCreateResourceRequest(submissionContext, isRecovery);
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!isRecovery) {
            Priority appPriority = this.scheduler.checkAndGetApplicationPriority(submissionContext.getPriority(), userUgi, submissionContext.getQueue(), applicationId);
            submissionContext.setPriority(appPriority);
        }
        if (!isRecovery && YarnConfiguration.isAclEnabled((Configuration)this.conf) && this.scheduler instanceof CapacityScheduler) {
            String queueName = submissionContext.getQueue();
            String appName = submissionContext.getApplicationName();
            CSQueue csqueue = ((CapacityScheduler)this.scheduler).getQueue(queueName);
            if (csqueue == null && placementContext != null) {
                String parentQueueName = placementContext.getParentQueue();
                csqueue = ((CapacityScheduler)this.scheduler).getQueue(parentQueueName);
            }
            if (csqueue != null && !this.authorizer.checkPermission(new AccessRequest(csqueue.getPrivilegedEntity(), userUgi, SchedulerUtils.toAccessType(QueueACL.SUBMIT_APPLICATIONS), applicationId.toString(), appName, Server.getRemoteAddress(), null)) && !this.authorizer.checkPermission(new AccessRequest(csqueue.getPrivilegedEntity(), userUgi, SchedulerUtils.toAccessType(QueueACL.ADMINISTER_QUEUE), applicationId.toString(), appName, Server.getRemoteAddress(), null))) {
                throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + user + " does not have permission to submit " + applicationId + " to queue " + submissionContext.getQueue()));
            }
        }
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, submissionContext.getApplicationName(), user, submissionContext.getQueue(), submissionContext, this.scheduler, this.masterService, submitTime, submissionContext.getApplicationType(), submissionContext.getApplicationTags(), amReqs, placementContext, startTime);
        if (this.rmContext.getRMApps().putIfAbsent(applicationId, application) != null) {
            String message = "Application with id " + applicationId + " is already present! Cannot add a duplicate!";
            LOG.warn((Object)message);
            throw new YarnException(message);
        }
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.conf)) {
            application.startTimelineCollector();
        }
        this.applicationACLsManager.addApplication(applicationId, submissionContext.getAMContainerSpec().getApplicationACLs());
        return application;
    }

    private List<ResourceRequest> validateAndCreateResourceRequest(ApplicationSubmissionContext submissionContext, boolean isRecovery) throws InvalidResourceRequestException {
        if (!submissionContext.getUnmanagedAM()) {
            List<ResourceRequest> amReqs = submissionContext.getAMContainerResourceRequests();
            if (amReqs == null || amReqs.isEmpty()) {
                if (submissionContext.getResource() != null) {
                    amReqs = Collections.singletonList(BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)submissionContext.getResource(), (int)1));
                } else {
                    throw new InvalidResourceRequestException("Invalid resource request, no resources requested");
                }
            }
            try {
                ResourceRequest anyReq = null;
                for (ResourceRequest amReq : amReqs) {
                    if (!amReq.getResourceName().equals("*")) continue;
                    if (anyReq == null) {
                        anyReq = amReq;
                        continue;
                    }
                    throw new InvalidResourceRequestException("Invalid resource request, only one resource request with * is allowed");
                }
                if (anyReq == null) {
                    throw new InvalidResourceRequestException("Invalid resource request, no resource request specified with *");
                }
                for (ResourceRequest amReq : amReqs) {
                    amReq.setCapability(anyReq.getCapability());
                    amReq.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.GUARANTEED));
                    amReq.setNumContainers(1);
                    amReq.setPriority(RMAppAttemptImpl.AM_CONTAINER_PRIORITY);
                }
                if (null == anyReq.getNodeLabelExpression()) {
                    anyReq.setNodeLabelExpression(submissionContext.getNodeLabelExpression());
                }
                if (!amReqs.get(0).equals((Object)anyReq)) {
                    amReqs.remove(anyReq);
                    amReqs.add(0, anyReq);
                }
                String queue = submissionContext.getQueue();
                Resource maxAllocation = this.scheduler.getMaximumResourceCapability(queue);
                for (ResourceRequest amReq : amReqs) {
                    SchedulerUtils.normalizeAndValidateRequest(amReq, maxAllocation, queue, this.scheduler, isRecovery, this.rmContext, null);
                    amReq.setCapability(this.scheduler.getNormalizedResource(amReq.getCapability(), maxAllocation));
                }
                return amReqs;
            }
            catch (InvalidResourceRequestException e) {
                LOG.warn((Object)("RM app submission failed in validating AM resource request for application " + submissionContext.getApplicationId()), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore store = this.rmContext.getStateStore();
        assert (store != null);
        Map<ApplicationId, ApplicationStateData> appStates = state.getApplicationState();
        LOG.info((Object)("Recovering " + appStates.size() + " applications"));
        int count = 0;
        try {
            for (ApplicationStateData appState : appStates.values()) {
                this.recoverApplication(appState, state);
                ++count;
            }
        }
        finally {
            LOG.info((Object)("Successfully recovered " + count + " out of " + appStates.size() + " applications"));
        }
    }

    public void handle(RMAppManagerEvent event) {
        ApplicationId applicationId = event.getApplicationId();
        LOG.debug((Object)("RMAppManager processing event for " + applicationId + " of type " + event.getType()));
        switch ((RMAppManagerEventType)event.getType()) {
            case APP_COMPLETED: {
                this.finishApplication(applicationId);
                this.logApplicationSummary(applicationId);
                this.checkAppNumCompletedLimit();
                break;
            }
            case APP_MOVE: {
                try {
                    this.moveApplicationAcrossQueue(applicationId, event.getTargetQueueForMove());
                }
                catch (YarnException e) {
                    LOG.warn((Object)("Move Application has failed: " + e.getMessage()));
                }
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ApplicationTimeoutType, String> updateApplicationTimeout(RMApp app, Map<ApplicationTimeoutType, String> newTimeoutInISO8601Format) throws YarnException {
        ApplicationId applicationId;
        ApplicationId applicationId2 = applicationId = app.getApplicationId();
        synchronized (applicationId2) {
            long queueMaxLifetimeInSec;
            if (app.isAppInCompletedStates()) {
                return newTimeoutInISO8601Format;
            }
            Map<ApplicationTimeoutType, Long> newExpireTime = RMServerUtils.validateISO8601AndConvertToLocalTimeEpoch(newTimeoutInISO8601Format);
            Long updatedlifetimeInMillis = newExpireTime.get(ApplicationTimeoutType.LIFETIME);
            if (updatedlifetimeInMillis != null && (queueMaxLifetimeInSec = this.scheduler.getMaximumApplicationLifetime(app.getQueue())) > 0L && updatedlifetimeInMillis > app.getSubmitTime() + queueMaxLifetimeInSec * 1000L) {
                updatedlifetimeInMillis = app.getSubmitTime() + queueMaxLifetimeInSec * 1000L;
                newExpireTime.put(ApplicationTimeoutType.LIFETIME, updatedlifetimeInMillis);
                newTimeoutInISO8601Format.put(ApplicationTimeoutType.LIFETIME, Times.formatISO8601((long)updatedlifetimeInMillis));
            }
            SettableFuture future = SettableFuture.create();
            Map<ApplicationTimeoutType, Long> currentExpireTimeouts = app.getApplicationTimeouts();
            currentExpireTimeouts.putAll(newExpireTime);
            ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), app.getCallerContext());
            appState.setApplicationTimeouts(currentExpireTimeouts);
            this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, (SettableFuture<Object>)future);
            RMAppManager.getChecked(future);
            ((RMAppImpl)app).updateApplicationTimeout(newExpireTime);
            return newTimeoutInISO8601Format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplicationPriority(UserGroupInformation callerUGI, ApplicationId applicationId, Priority newAppPriority) throws YarnException {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
        ApplicationId applicationId2 = applicationId;
        synchronized (applicationId2) {
            if (app == null || app.isAppInCompletedStates()) {
                return;
            }
            SettableFuture future = SettableFuture.create();
            Priority appPriority = this.rmContext.getScheduler().updateApplicationPriority(newAppPriority, applicationId, (SettableFuture<Object>)future, callerUGI);
            if (app.getApplicationPriority().equals((Object)appPriority)) {
                return;
            }
            RMAppManager.getChecked(future);
            ((RMAppImpl)app).setApplicationPriority(appPriority);
        }
        this.rmContext.getSystemMetricsPublisher().appUpdated(app, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveApplicationAcrossQueue(ApplicationId applicationId, String targetQueue) throws YarnException {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
        ApplicationId applicationId2 = applicationId;
        synchronized (applicationId2) {
            if (app == null || app.isAppInCompletedStates()) {
                return;
            }
            String sourceQueue = app.getQueue();
            this.rmContext.getScheduler().preValidateMoveApplication(applicationId, targetQueue);
            this.updateAppDataToStateStore(targetQueue, app, false);
            String queue = "";
            try {
                queue = this.rmContext.getScheduler().moveApplication(applicationId, targetQueue);
            }
            catch (YarnException e) {
                this.updateAppDataToStateStore(sourceQueue, app, true);
                throw e;
            }
            if (queue != null && !queue.isEmpty()) {
                app.setQueue(queue);
            }
        }
        this.rmContext.getSystemMetricsPublisher().appUpdated(app, System.currentTimeMillis());
    }

    private void updateAppDataToStateStore(String queue, RMApp app, boolean toSuppressException) throws YarnException {
        SettableFuture future = SettableFuture.create();
        app.getApplicationSubmissionContext().setQueue(queue);
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), app.getCallerContext());
        appState.setApplicationTimeouts(app.getApplicationTimeouts());
        this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, (SettableFuture<Object>)future);
        try {
            RMAppManager.getChecked(future);
        }
        catch (YarnException ex) {
            if (!toSuppressException) {
                throw ex;
            }
            LOG.error((Object)("Statestore update failed for move application '" + app.getApplicationId() + "' to queue '" + queue + "' with below exception:" + ex.getMessage()));
        }
    }

    @VisibleForTesting
    ApplicationPlacementContext placeApplication(PlacementManager placementManager, ApplicationSubmissionContext context, String user, boolean isRecovery) throws YarnException {
        ApplicationPlacementContext placementContext = null;
        if (placementManager != null) {
            try {
                placementContext = placementManager.placeApplication(context, user);
            }
            catch (YarnException e) {
                if (isRecovery) {
                    LOG.warn((Object)"PlaceApplication failed,skipping on recovery of rm");
                    return placementContext;
                }
                throw e;
            }
        }
        if (placementContext == null && context.getQueue() == null || context.getQueue().isEmpty()) {
            String msg = "Failed to place application " + context.getApplicationId() + " to queue and specified queue is invalid : " + context.getQueue();
            LOG.error((Object)msg);
            throw new YarnException(msg);
        }
        return placementContext;
    }

    void replaceQueueFromPlacementContext(ApplicationPlacementContext placementContext, ApplicationSubmissionContext context) {
        if (placementContext != null && !StringUtils.equalsIgnoreCase((String)context.getQueue(), (String)placementContext.getQueue())) {
            LOG.info((Object)("Placed application=" + context.getApplicationId() + " to queue=" + placementContext.getQueue() + ", original queue=" + context.getQueue()));
            context.setQueue(placementContext.getQueue());
        }
    }

    static class ApplicationSummary {
        static final Log LOG = LogFactory.getLog(ApplicationSummary.class);
        static final char EQUALS = '=';
        static final char[] charsToEscape = new char[]{',', '=', '\\'};

        ApplicationSummary() {
        }

        public static SummaryBuilder createAppSummary(RMApp app) {
            String trackingUrl = "N/A";
            String host = "N/A";
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            if (attempt != null) {
                trackingUrl = attempt.getTrackingUrl();
                host = attempt.getHost();
            }
            RMAppMetrics metrics = app.getRMAppMetrics();
            SummaryBuilder summary = new SummaryBuilder().add("appId", app.getApplicationId()).add("name", app.getName()).add("user", app.getUser()).add("queue", app.getQueue()).add("state", app.getState()).add("trackingUrl", trackingUrl).add("appMasterHost", host).add("submitTime", app.getSubmitTime()).add("startTime", app.getStartTime()).add("finishTime", app.getFinishTime()).add("finalStatus", app.getFinalApplicationStatus()).add("memorySeconds", metrics.getMemorySeconds()).add("vcoreSeconds", metrics.getVcoreSeconds()).add("preemptedMemorySeconds", metrics.getPreemptedMemorySeconds()).add("preemptedVcoreSeconds", metrics.getPreemptedVcoreSeconds()).add("preemptedAMContainers", metrics.getNumAMContainersPreempted()).add("preemptedNonAMContainers", metrics.getNumNonAMContainersPreempted()).add("preemptedResources", metrics.getResourcePreempted()).add("applicationType", app.getApplicationType()).add("resourceSeconds", StringHelper.getResourceSecondsString(metrics.getResourceSecondsMap())).add("preemptedResourceSeconds", StringHelper.getResourceSecondsString(metrics.getPreemptedResourceSecondsMap()));
            return summary;
        }

        public static void logAppSummary(RMApp app) {
            if (app != null) {
                LOG.info((Object)ApplicationSummary.createAppSummary(app));
            }
        }

        static class SummaryBuilder {
            final StringBuilder buffer = new StringBuilder();

            SummaryBuilder() {
            }

            SummaryBuilder add(String key, long value) {
                return this._add(key, Long.toString(value));
            }

            <T> SummaryBuilder add(String key, T value) {
                String escapedString = StringUtils.escapeString((String)String.valueOf(value), (char)'\\', (char[])charsToEscape).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                return this._add(key, escapedString);
            }

            SummaryBuilder add(SummaryBuilder summary) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append((CharSequence)summary.buffer);
                return this;
            }

            SummaryBuilder _add(String key, String value) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append(key).append('=').append(value);
                return this;
            }

            public String toString() {
                return this.buffer.toString();
            }
        }
    }
}

