/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.FifoCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueueCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.QueuePriorityContainerCandidateSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ReservedContainerCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptableQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ProportionalCapacityPreemptionPolicy
implements SchedulingEditPolicy,
CapacitySchedulerPreemptionContext {
    private static final Log LOG = LogFactory.getLog(ProportionalCapacityPreemptionPolicy.class);
    private final Clock clock;
    private double maxIgnoredOverCapacity;
    private long maxWaitTime;
    private long monitoringInterval;
    private float percentageClusterPreemptionAllowed;
    private double naturalTerminationFactor;
    private boolean observeOnly;
    private boolean lazyPreempionEnabled;
    private float maxAllowableLimitForIntraQueuePreemption;
    private float minimumThresholdForIntraQueuePreemption;
    private IntraQueuePreemptionOrderPolicy intraQueuePreemptionOrderPolicy;
    private CapacitySchedulerConfiguration csConfig;
    private RMContext rmContext;
    private ResourceCalculator rc;
    private CapacityScheduler scheduler;
    private RMNodeLabelsManager nlm;
    private final Map<RMContainer, Long> preemptionCandidates = new HashMap<RMContainer, Long>();
    private Map<String, Map<String, TempQueuePerPartition>> queueToPartitions = new HashMap<String, Map<String, TempQueuePerPartition>>();
    private Map<String, LinkedHashSet<String>> partitionToUnderServedQueues = new HashMap<String, LinkedHashSet<String>>();
    private List<PreemptionCandidatesSelector> candidatesSelectionPolicies;
    private Set<String> allPartitions;
    private Set<String> leafQueueNames;
    Map<PreemptionCandidatesSelector, Map<ApplicationAttemptId, Set<RMContainer>>> pcsMap;
    private Map<String, PreemptableQueue> preemptableQueues;
    private Set<ContainerId> killableContainers;

    public ProportionalCapacityPreemptionPolicy() {
        this.clock = SystemClock.getInstance();
        this.allPartitions = Collections.emptySet();
        this.leafQueueNames = Collections.emptySet();
        this.preemptableQueues = Collections.emptyMap();
    }

    @VisibleForTesting
    public ProportionalCapacityPreemptionPolicy(RMContext context, CapacityScheduler scheduler, Clock clock) {
        this.init(context.getYarnConfiguration(), context, scheduler);
        this.clock = clock;
        this.allPartitions = Collections.emptySet();
        this.leafQueueNames = Collections.emptySet();
        this.preemptableQueues = Collections.emptyMap();
    }

    @Override
    public void init(Configuration config, RMContext context, ResourceScheduler sched) {
        LOG.info((Object)("Preemption monitor:" + this.getClass().getCanonicalName()));
        assert (null == this.scheduler) : "Unexpected duplicate call to init";
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("Class " + sched.getClass().getCanonicalName() + " not instance of " + CapacityScheduler.class.getCanonicalName());
        }
        this.rmContext = context;
        this.scheduler = (CapacityScheduler)sched;
        this.rc = this.scheduler.getResourceCalculator();
        this.nlm = this.scheduler.getRMContext().getNodeLabelManager();
        this.updateConfigIfNeeded();
    }

    private void updateConfigIfNeeded() {
        boolean isIntraQueuePreemptionEnabled;
        boolean selectCandidatesForResevedContainers;
        CapacitySchedulerConfiguration config = this.scheduler.getConfiguration();
        if (config == this.csConfig) {
            return;
        }
        this.maxIgnoredOverCapacity = config.getDouble("yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity", 0.1);
        this.naturalTerminationFactor = config.getDouble("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.2);
        this.maxWaitTime = config.getLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 15000L);
        this.monitoringInterval = config.getLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.percentageClusterPreemptionAllowed = config.getFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 0.1f);
        this.observeOnly = config.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", false);
        this.lazyPreempionEnabled = config.getBoolean("yarn.scheduler.capacity.lazy-preemption-enabled", false);
        this.maxAllowableLimitForIntraQueuePreemption = config.getFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.max-allowable-limit", 0.2f);
        this.minimumThresholdForIntraQueuePreemption = config.getFloat("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.minimum-threshold", 0.5f);
        this.intraQueuePreemptionOrderPolicy = IntraQueuePreemptionOrderPolicy.valueOf(config.get("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.preemption-order-policy", "userlimit_first").toUpperCase());
        this.candidatesSelectionPolicies = new ArrayList<PreemptionCandidatesSelector>();
        boolean isQueuePriorityPreemptionEnabled = config.getPUOrderingPolicyUnderUtilizedPreemptionEnabled();
        if (isQueuePriorityPreemptionEnabled) {
            this.candidatesSelectionPolicies.add(new QueuePriorityContainerCandidateSelector(this));
        }
        if (selectCandidatesForResevedContainers = config.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.select_based_on_reserved_containers", false)) {
            this.candidatesSelectionPolicies.add(new ReservedContainerCandidatesSelector(this));
        }
        boolean additionalPreemptionBasedOnReservedResource = config.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.additional_res_balance_based_on_reserved_containers", false);
        this.candidatesSelectionPolicies.add(new FifoCandidatesSelector(this, additionalPreemptionBasedOnReservedResource, false));
        boolean isPreemptionToBalanceRequired = config.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.enabled", false);
        long maximumKillWaitTimeForPreemptionToQueueBalance = config.getLong("yarn.resourcemanager.monitor.capacity.preemption.preemption-to-balance-queue-after-satisfied.max-wait-before-kill", 300000L);
        if (isPreemptionToBalanceRequired) {
            FifoCandidatesSelector selector = new FifoCandidatesSelector(this, false, true);
            selector.setMaximumKillWaitTime(maximumKillWaitTimeForPreemptionToQueueBalance);
            this.candidatesSelectionPolicies.add(selector);
        }
        if (isIntraQueuePreemptionEnabled = config.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", false)) {
            this.candidatesSelectionPolicies.add(new IntraQueueCandidatesSelector(this));
        }
        LOG.info((Object)("Capacity Scheduler configuration changed, updated preemption properties to:\nmax_ignored_over_capacity = " + this.maxIgnoredOverCapacity + "\nnatural_termination_factor = " + this.naturalTerminationFactor + "\nmax_wait_before_kill = " + this.maxWaitTime + "\nmonitoring_interval = " + this.monitoringInterval + "\ntotal_preemption_per_round = " + this.percentageClusterPreemptionAllowed + "\nobserve_only = " + this.observeOnly + "\nlazy-preemption-enabled = " + this.lazyPreempionEnabled + "\nintra-queue-preemption.enabled = " + isIntraQueuePreemptionEnabled + "\nintra-queue-preemption.max-allowable-limit = " + this.maxAllowableLimitForIntraQueuePreemption + "\nintra-queue-preemption.minimum-threshold = " + this.minimumThresholdForIntraQueuePreemption + "\nintra-queue-preemption.preemption-order-policy = " + (Object)((Object)this.intraQueuePreemptionOrderPolicy) + "\npriority-utilization.underutilized-preemption.enabled = " + isQueuePriorityPreemptionEnabled + "\nselect_based_on_reserved_containers = " + selectCandidatesForResevedContainers + "\nadditional_res_balance_based_on_reserved_containers = " + additionalPreemptionBasedOnReservedResource + "\nPreemption-to-balance-queue-enabled = " + isPreemptionToBalanceRequired));
        this.csConfig = config;
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.rc;
    }

    @Override
    public synchronized void editSchedule() {
        this.updateConfigIfNeeded();
        long startTs = this.clock.getTime();
        CSQueue root = this.scheduler.getRootQueue();
        Resource clusterResources = Resources.clone((Resource)this.scheduler.getClusterResource());
        this.containerBasedPreemptOrKill(root, clusterResources);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Total time used=" + (this.clock.getTime() - startTs) + " ms."));
        }
    }

    private void preemptOrkillSelectedContainerAfterWait(Map<PreemptionCandidatesSelector, Map<ApplicationAttemptId, Set<RMContainer>>> toPreemptPerSelector, long currentTime) {
        int toPreemptCount = 0;
        for (Map<ApplicationAttemptId, Set<RMContainer>> map : toPreemptPerSelector.values()) {
            toPreemptCount += map.size();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting to preempt containers for selectedCandidates and size:" + toPreemptCount));
        }
        for (Map.Entry entry : toPreemptPerSelector.entrySet()) {
            Map cMap = (Map)entry.getValue();
            if (cMap.size() <= 0) continue;
            for (Map.Entry e : cMap.entrySet()) {
                ApplicationAttemptId appAttemptId = (ApplicationAttemptId)e.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Send to scheduler: in app=" + appAttemptId + " #containers-to-be-preemptionCandidates=" + ((Set)e.getValue()).size()));
                }
                for (RMContainer container : (Set)e.getValue()) {
                    if (this.preemptionCandidates.get(container) != null && this.preemptionCandidates.get(container) + ((PreemptionCandidatesSelector)entry.getKey()).getMaximumKillWaitTimeMs() <= currentTime) {
                        this.rmContext.getDispatcher().getEventHandler().handle((Event)new ContainerPreemptEvent(appAttemptId, container, SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE));
                        this.preemptionCandidates.remove(container);
                        continue;
                    }
                    if (this.preemptionCandidates.get(container) != null) continue;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new ContainerPreemptEvent(appAttemptId, container, SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION));
                    this.preemptionCandidates.put(container, currentTime);
                }
            }
        }
    }

    private void syncKillableContainersFromScheduler() {
        this.preemptableQueues = this.scheduler.getPreemptionManager().getShallowCopyOfPreemptableQueues();
        this.killableContainers = new HashSet<ContainerId>();
        for (Map.Entry<String, PreemptableQueue> entry : this.preemptableQueues.entrySet()) {
            PreemptableQueue entity = entry.getValue();
            for (Map<ContainerId, RMContainer> map : entity.getKillableContainers().values()) {
                this.killableContainers.addAll(map.keySet());
            }
        }
    }

    private void cleanupStaledPreemptionCandidates(long currentTime) {
        this.preemptionCandidates.entrySet().removeIf(candidate -> (Long)candidate.getValue() + 2L * this.maxWaitTime < currentTime);
    }

    private Set<String> getLeafQueueNames(TempQueuePerPartition q) {
        if ((q.children == null || q.children.isEmpty()) && !(q.parentQueue instanceof ManagedParentQueue)) {
            return ImmutableSet.of((Object)q.queueName);
        }
        HashSet<String> leafQueueNames = new HashSet<String>();
        for (TempQueuePerPartition child : q.children) {
            leafQueueNames.addAll(this.getLeafQueueNames(child));
        }
        return leafQueueNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containerBasedPreemptOrKill(CSQueue root, Resource clusterResources) {
        if (this.lazyPreempionEnabled) {
            this.syncKillableContainersFromScheduler();
        }
        HashSet<String> partitions = new HashSet<String>();
        partitions.addAll(this.scheduler.getRMContext().getNodeLabelManager().getClusterNodeLabelNames());
        partitions.add("");
        this.allPartitions = ImmutableSet.copyOf(partitions);
        CapacityScheduler capacityScheduler = this.scheduler;
        synchronized (capacityScheduler) {
            this.queueToPartitions.clear();
            for (String partitionToLookAt : this.allPartitions) {
                this.cloneQueues(root, Resources.clone((Resource)this.nlm.getResourceByLabel(partitionToLookAt, clusterResources)), partitionToLookAt);
            }
        }
        this.leafQueueNames = ImmutableSet.copyOf(this.getLeafQueueNames(this.getQueueByPartition("root", "")));
        Resource totalPreemptionAllowed = Resources.multiply((Resource)clusterResources, (double)this.percentageClusterPreemptionAllowed);
        this.partitionToUnderServedQueues.clear();
        HashMap<ApplicationAttemptId, Set<RMContainer>> toPreempt = new HashMap<ApplicationAttemptId, Set<RMContainer>>();
        HashMap<PreemptionCandidatesSelector, Map<ApplicationAttemptId, Set<RMContainer>>> toPreemptPerSelector = new HashMap<PreemptionCandidatesSelector, Map<ApplicationAttemptId, Set<RMContainer>>>();
        for (PreemptionCandidatesSelector selector : this.candidatesSelectionPolicies) {
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)MessageFormat.format("Trying to use {0} to select preemption candidates", selector.getClass().getName()));
                startTime = this.clock.getTime();
            }
            Map<ApplicationAttemptId, Set<RMContainer>> curCandidates = selector.selectCandidates(toPreempt, clusterResources, totalPreemptionAllowed);
            toPreemptPerSelector.putIfAbsent(selector, curCandidates);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)MessageFormat.format("{0} uses {1} millisecond to run", selector.getClass().getName(), this.clock.getTime() - startTime));
            int totalSelected = 0;
            int curSelected = 0;
            for (Set set : toPreempt.values()) {
                totalSelected += set.size();
            }
            for (Set set : curCandidates.values()) {
                curSelected += set.size();
            }
            LOG.debug((Object)MessageFormat.format("So far, total {0} containers selected to be preempted, {1} containers selected this round\n", totalSelected, curSelected));
        }
        if (LOG.isDebugEnabled()) {
            this.logToCSV(new ArrayList<String>(this.leafQueueNames));
        }
        if (this.observeOnly) {
            return;
        }
        long currentTime = this.clock.getTime();
        this.pcsMap = toPreemptPerSelector;
        this.preemptOrkillSelectedContainerAfterWait(toPreemptPerSelector, currentTime);
        this.cleanupStaledPreemptionCandidates(currentTime);
    }

    @Override
    public long getMonitoringInterval() {
        return this.monitoringInterval;
    }

    @Override
    public String getPolicyName() {
        return "ProportionalCapacityPreemptionPolicy";
    }

    @VisibleForTesting
    public Map<RMContainer, Long> getToPreemptContainers() {
        return this.preemptionCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TempQueuePerPartition cloneQueues(CSQueue curQueue, Resource partitionResource, String partitionToLookAt) {
        TempQueuePerPartition ret;
        ReentrantReadWriteLock.ReadLock readLock = curQueue.getReadLock();
        try {
            readLock.lock();
            String queueName = curQueue.getQueueName();
            QueueCapacities qc = curQueue.getQueueCapacities();
            float absCap = qc.getAbsoluteCapacity(partitionToLookAt);
            float absMaxCap = qc.getAbsoluteMaximumCapacity(partitionToLookAt);
            boolean preemptionDisabled = curQueue.getPreemptionDisabled();
            QueueResourceQuotas queueResourceQuotas = curQueue.getQueueResourceQuotas();
            Resource effMinRes = queueResourceQuotas.getEffectiveMinResource(partitionToLookAt);
            Resource effMaxRes = queueResourceQuotas.getEffectiveMaxResource(partitionToLookAt);
            Resource current = Resources.clone((Resource)curQueue.getQueueResourceUsage().getUsed(partitionToLookAt));
            Resource killable = Resources.none();
            Resource reserved = Resources.clone((Resource)curQueue.getQueueResourceUsage().getReserved(partitionToLookAt));
            if (null != this.preemptableQueues.get(queueName)) {
                killable = Resources.clone((Resource)this.preemptableQueues.get(queueName).getKillableResource(partitionToLookAt));
            }
            try {
                if (!this.scheduler.getRMContext().getNodeLabelManager().isExclusiveNodeLabel(partitionToLookAt)) {
                    absMaxCap = 1.0f;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ret = new TempQueuePerPartition(queueName, current, preemptionDisabled, partitionToLookAt, killable, absCap, absMaxCap, partitionResource, reserved, curQueue, effMinRes, effMaxRes);
            if (curQueue instanceof ParentQueue) {
                String configuredOrderingPolicy = ((ParentQueue)curQueue).getQueueOrderingPolicy().getConfigName();
                for (CSQueue c : curQueue.getChildQueues()) {
                    TempQueuePerPartition subq = this.cloneQueues(c, partitionResource, partitionToLookAt);
                    if (StringUtils.equals((CharSequence)"priority-utilization", (CharSequence)configuredOrderingPolicy)) {
                        subq.relativePriority = c.getPriority().getPriority();
                    }
                    ret.addChild(subq);
                    subq.parent = ret;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        this.addTempQueuePartition(ret);
        return ret;
    }

    private void logToCSV(List<String> leafQueueNames) {
        Collections.sort(leafQueueNames);
        String queueState = " QUEUESTATE: " + this.clock.getTime();
        StringBuilder sb = new StringBuilder();
        sb.append(queueState);
        for (String queueName : leafQueueNames) {
            TempQueuePerPartition tq = this.getQueueByPartition(queueName, "");
            sb.append(", ");
            tq.appendLogString(sb);
        }
        LOG.debug((Object)sb.toString());
    }

    private void addTempQueuePartition(TempQueuePerPartition queuePartition) {
        String queueName = queuePartition.queueName;
        Map<String, TempQueuePerPartition> queuePartitions = this.queueToPartitions.get(queueName);
        if (null == queuePartitions) {
            queuePartitions = new HashMap<String, TempQueuePerPartition>();
            this.queueToPartitions.put(queueName, queuePartitions);
        }
        queuePartitions.put(queuePartition.partition, queuePartition);
    }

    @Override
    public TempQueuePerPartition getQueueByPartition(String queueName, String partition) {
        Map<String, TempQueuePerPartition> partitionToQueues = this.queueToPartitions.get(queueName);
        if (null == partitionToQueues) {
            throw new YarnRuntimeException("This shouldn't happen, cannot find TempQueuePerPartition for queueName=" + queueName);
        }
        return partitionToQueues.get(partition);
    }

    @Override
    public Collection<TempQueuePerPartition> getQueuePartitions(String queueName) {
        if (!this.queueToPartitions.containsKey(queueName)) {
            throw new YarnRuntimeException("This shouldn't happen, cannot find TempQueuePerPartition collection for queueName=" + queueName);
        }
        return this.queueToPartitions.get(queueName).values();
    }

    @Override
    public CapacityScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public RMContext getRMContext() {
        return this.rmContext;
    }

    @Override
    public boolean isObserveOnly() {
        return this.observeOnly;
    }

    @Override
    public Set<ContainerId> getKillableContainers() {
        return this.killableContainers;
    }

    @Override
    public double getMaxIgnoreOverCapacity() {
        return this.maxIgnoredOverCapacity;
    }

    @Override
    public double getNaturalTerminationFactor() {
        return this.naturalTerminationFactor;
    }

    @Override
    public Set<String> getLeafQueueNames() {
        return this.leafQueueNames;
    }

    @Override
    public Set<String> getAllPartitions() {
        return this.allPartitions;
    }

    @VisibleForTesting
    Map<String, Map<String, TempQueuePerPartition>> getQueuePartitions() {
        return this.queueToPartitions;
    }

    @VisibleForTesting
    Map<PreemptionCandidatesSelector, Map<ApplicationAttemptId, Set<RMContainer>>> getToPreemptCandidatesPerSelector() {
        return this.pcsMap;
    }

    @Override
    public int getClusterMaxApplicationPriority() {
        return this.scheduler.getMaxClusterLevelAppPriority().getPriority();
    }

    @Override
    public float getMaxAllowableLimitForIntraQueuePreemption() {
        return this.maxAllowableLimitForIntraQueuePreemption;
    }

    @Override
    public float getMinimumThresholdForIntraQueuePreemption() {
        return this.minimumThresholdForIntraQueuePreemption;
    }

    @Override
    public Resource getPartitionResource(String partition) {
        return Resources.clone((Resource)this.nlm.getResourceByLabel(partition, Resources.clone((Resource)this.scheduler.getClusterResource())));
    }

    @Override
    public LinkedHashSet<String> getUnderServedQueuesPerPartition(String partition) {
        return this.partitionToUnderServedQueues.get(partition);
    }

    @Override
    public void addPartitionToUnderServedQueues(String queueName, String partition) {
        LinkedHashSet<String> underServedQueues = this.partitionToUnderServedQueues.get(partition);
        if (null == underServedQueues) {
            underServedQueues = new LinkedHashSet();
            this.partitionToUnderServedQueues.put(partition, underServedQueues);
        }
        underServedQueues.add(queueName);
    }

    @Override
    public IntraQueuePreemptionOrderPolicy getIntraQueuePreemptionOrderPolicy() {
        return this.intraQueuePreemptionOrderPolicy;
    }

    @Override
    public long getDefaultMaximumKillWaitTimeout() {
        return this.maxWaitTime;
    }

    @InterfaceStability.Unstable
    public static enum IntraQueuePreemptionOrderPolicy {
        PRIORITY_FIRST,
        USERLIMIT_FIRST;

    }
}

