/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.FifoIntraQueuePreemptionPlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueuePreemptionComputePlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.AbstractComparatorOrderingPolicy;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntraQueueCandidatesSelector
extends PreemptionCandidatesSelector {
    IntraQueuePreemptionComputePlugin fifoPreemptionComputePlugin = null;
    final CapacitySchedulerPreemptionContext context;
    private static final Logger LOG = LoggerFactory.getLogger(IntraQueueCandidatesSelector.class);

    IntraQueueCandidatesSelector(CapacitySchedulerPreemptionContext preemptionContext) {
        super(preemptionContext);
        this.fifoPreemptionComputePlugin = new FifoIntraQueuePreemptionPlugin(this.rc, preemptionContext);
        this.context = preemptionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, Set<RMContainer>> selectCandidates(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource clusterResource, Resource totalPreemptedResourceAllowed) {
        HashMap<ApplicationAttemptId, Set<RMContainer>> curCandidates = new HashMap<ApplicationAttemptId, Set<RMContainer>>();
        this.computeIntraQueuePreemptionDemand(clusterResource, totalPreemptedResourceAllowed, selectedCandidates);
        CapacitySchedulerPreemptionUtils.deductPreemptableResourcesBasedSelectedCandidates(this.preemptionContext, selectedCandidates);
        for (String partition : this.preemptionContext.getAllPartitions()) {
            LinkedHashSet<String> queueNames = this.preemptionContext.getUnderServedQueuesPerPartition(partition);
            if (null == queueNames) continue;
            for (String queueName : queueNames) {
                LeafQueue leafQueue = this.preemptionContext.getQueueByPartition((String)queueName, (String)"").leafQueue;
                if (null == leafQueue || leafQueue.getIntraQueuePreemptionDisabled()) continue;
                Map<String, Resource> resToObtainByPartition = this.fifoPreemptionComputePlugin.getResourceDemandFromAppsPerQueue(queueName, partition);
                Collection<FiCaSchedulerApp> apps = this.fifoPreemptionComputePlugin.getPreemptableApps(queueName, partition);
                HashMap<String, Resource> rollingResourceUsagePerUser = new HashMap<String, Resource>();
                this.initializeUsageAndUserLimitForCompute(clusterResource, partition, leafQueue, rollingResourceUsagePerUser);
                try {
                    leafQueue.getReadLock().lock();
                    for (FiCaSchedulerApp app : apps) {
                        this.preemptFromLeastStarvedApp(leafQueue, app, selectedCandidates, curCandidates, clusterResource, totalPreemptedResourceAllowed, resToObtainByPartition, rollingResourceUsagePerUser);
                    }
                }
                finally {
                    leafQueue.getReadLock().unlock();
                }
            }
        }
        return curCandidates;
    }

    private void initializeUsageAndUserLimitForCompute(Resource clusterResource, String partition, LeafQueue leafQueue, Map<String, Resource> rollingResourceUsagePerUser) {
        for (String user : leafQueue.getAllUsers()) {
            rollingResourceUsagePerUser.put(user, Resources.clone((Resource)leafQueue.getUser(user).getResourceUsage().getUsed(partition)));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Rolling resource usage for user:" + user + " is : " + rollingResourceUsagePerUser.get(user));
        }
    }

    private void preemptFromLeastStarvedApp(LeafQueue leafQueue, FiCaSchedulerApp app, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Map<ApplicationAttemptId, Set<RMContainer>> curCandidates, Resource clusterResource, Resource totalPreemptedResourceAllowed, Map<String, Resource> resToObtainByPartition, Map<String, Resource> rollingResourceUsagePerUser) {
        ArrayList<RMContainer> liveContainers = new ArrayList<RMContainer>(app.getLiveContainers());
        IntraQueueCandidatesSelector.sortContainers(liveContainers);
        if (LOG.isDebugEnabled()) {
            LOG.debug("totalPreemptedResourceAllowed for preemption at this round is :" + totalPreemptedResourceAllowed);
        }
        Resource rollingUsedResourcePerUser = rollingResourceUsagePerUser.get(app.getUser());
        for (RMContainer c : liveContainers) {
            if (resToObtainByPartition.isEmpty()) {
                return;
            }
            if (CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedCandidates) || null != this.preemptionContext.getKillableContainers() && this.preemptionContext.getKillableContainers().contains(c.getContainerId()) || c.isAMContainer()) continue;
            if (this.fifoPreemptionComputePlugin.skipContainerBasedOnIntraQueuePolicy(app, clusterResource, rollingUsedResourcePerUser, c)) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Skipping container: " + c.getContainerId() + " with resource:" + c.getAllocatedResource() + " as UserLimit for user:" + app.getUser() + " with resource usage: " + rollingUsedResourcePerUser + " is going under UL");
                break;
            }
            boolean ret = CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, selectedCandidates, curCandidates, totalPreemptedResourceAllowed, true);
            if (!ret || !this.preemptionContext.getIntraQueuePreemptionOrderPolicy().equals((Object)ProportionalCapacityPreemptionPolicy.IntraQueuePreemptionOrderPolicy.USERLIMIT_FIRST)) continue;
            Resources.subtractFrom((Resource)rollingUsedResourcePerUser, (Resource)c.getAllocatedResource());
        }
    }

    private void computeIntraQueuePreemptionDemand(Resource clusterResource, Resource totalPreemptedResourceAllowed, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates) {
        for (String partition : this.context.getAllPartitions()) {
            LinkedHashSet<String> queueNames = this.context.getUnderServedQueuesPerPartition(partition);
            if (null == queueNames) continue;
            for (String queueName : queueNames) {
                TempQueuePerPartition tq = this.context.getQueueByPartition(queueName, partition);
                LeafQueue leafQueue = tq.leafQueue;
                if (null == leafQueue) continue;
                Resource queueReassignableResource = Resources.subtract((Resource)tq.getUsed(), (Resource)tq.getActuallyToBePreempted());
                if (leafQueue.getQueueCapacities().getUsedCapacity(partition) < this.context.getMinimumThresholdForIntraQueuePreemption()) continue;
                this.fifoPreemptionComputePlugin.computeAppsIdealAllocation(clusterResource, tq, selectedCandidates, totalPreemptedResourceAllowed, queueReassignableResource, this.context.getMaxAllowableLimitForIntraQueuePreemption());
            }
        }
    }

    static class TAFairOrderingComparator
    implements Comparator<TempAppPerPartition> {
        private ResourceCalculator rc;
        private Resource clusterRes;

        TAFairOrderingComparator(ResourceCalculator rc, Resource clusterRes) {
            this.rc = rc;
            this.clusterRes = clusterRes;
        }

        @Override
        public int compare(TempAppPerPartition ta1, TempAppPerPartition ta2) {
            Resource usedByUser2;
            if (ta1.getUser().equals(ta2.getUser())) {
                AbstractComparatorOrderingPolicy acop = (AbstractComparatorOrderingPolicy)ta1.getFiCaSchedulerApp().getCSLeafQueue().getOrderingPolicy();
                return acop.getComparator().compare(ta1.getFiCaSchedulerApp(), ta2.getFiCaSchedulerApp());
            }
            Resource usedByUser1 = ta1.getTempUserPerPartition().getUsedDeductAM();
            if (Resources.equals((Resource)usedByUser1, (Resource)(usedByUser2 = ta2.getTempUserPerPartition().getUsedDeductAM()))) {
                return ta1.getApplicationId().compareTo(ta2.getApplicationId());
            }
            if (Resources.lessThan((ResourceCalculator)this.rc, (Resource)this.clusterRes, (Resource)usedByUser1, (Resource)usedByUser2)) {
                return -1;
            }
            return 1;
        }
    }

    static class TAPriorityComparator
    implements Serializable,
    Comparator<TempAppPerPartition> {
        TAPriorityComparator() {
        }

        @Override
        public int compare(TempAppPerPartition ta1, TempAppPerPartition ta2) {
            Priority p2;
            Priority p1 = Priority.newInstance((int)ta1.getPriority());
            if (!p1.equals((Object)(p2 = Priority.newInstance((int)ta2.getPriority())))) {
                return p1.compareTo(p2);
            }
            return ta1.getApplicationId().compareTo(ta2.getApplicationId());
        }
    }
}

