/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueuePlacementRuleUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupMappingPlacementRule
extends PlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupMappingPlacementRule.class);
    public static final String CURRENT_USER_MAPPING = "%user";
    public static final String PRIMARY_GROUP_MAPPING = "%primary_group";
    private boolean overrideWithQueueMappings = false;
    private List<QueueMapping> mappings = null;
    private Groups groups;

    public UserGroupMappingPlacementRule() {
        this(false, null, null);
    }

    public UserGroupMappingPlacementRule(boolean overrideWithQueueMappings, List<QueueMapping> newMappings, Groups groups) {
        this.mappings = newMappings;
        this.overrideWithQueueMappings = overrideWithQueueMappings;
        this.groups = groups;
    }

    private ApplicationPlacementContext getPlacementForUser(String user) throws IOException {
        for (QueueMapping mapping : this.mappings) {
            if (mapping.getType() == QueueMapping.MappingType.USER) {
                if (mapping.getSource().equals(CURRENT_USER_MAPPING)) {
                    if (mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                        return this.getPlacementContext(mapping, user);
                    }
                    if (mapping.getQueue().equals(PRIMARY_GROUP_MAPPING)) {
                        return this.getPlacementContext(mapping, (String)this.groups.getGroups(user).get(0));
                    }
                    return this.getPlacementContext(mapping);
                }
                if (user.equals(mapping.getSource())) {
                    return this.getPlacementContext(mapping);
                }
            }
            if (mapping.getType() != QueueMapping.MappingType.GROUP) continue;
            for (String userGroups : this.groups.getGroups(user)) {
                if (!userGroups.equals(mapping.getSource())) continue;
                if (mapping.getQueue().equals(CURRENT_USER_MAPPING)) {
                    return this.getPlacementContext(mapping, user);
                }
                return this.getPlacementContext(mapping);
            }
        }
        return null;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        ApplicationId applicationId = asc.getApplicationId();
        if (this.mappings != null && this.mappings.size() > 0) {
            try {
                ApplicationPlacementContext mappedQueue = this.getPlacementForUser(user);
                if (mappedQueue != null && (queueName.equals("default") || queueName.equals(mappedQueue.getQueue()) || this.overrideWithQueueMappings)) {
                    LOG.info("Application " + applicationId + " user " + user + " mapping [" + queueName + "] to [" + mappedQueue + "] override " + this.overrideWithQueueMappings);
                    return mappedQueue;
                }
            }
            catch (IOException ioex) {
                String message = "Failed to submit application " + applicationId + " submitted by user " + user + " reason: " + ioex.getMessage();
                throw new YarnException(message);
            }
        }
        return null;
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping) {
        return this.getPlacementContext(mapping, mapping.getQueue());
    }

    private ApplicationPlacementContext getPlacementContext(QueueMapping mapping, String leafQueueName) {
        if (!StringUtils.isEmpty((CharSequence)mapping.getParentQueue())) {
            return new ApplicationPlacementContext(leafQueueName, mapping.getParentQueue());
        }
        return new ApplicationPlacementContext(leafQueueName);
    }

    @Override
    @VisibleForTesting
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        if (!(scheduler instanceof CapacityScheduler)) {
            throw new IOException("UserGroupMappingPlacementRule can be configured only for CapacityScheduler");
        }
        CapacitySchedulerContext schedulerContext = (CapacitySchedulerContext)((Object)scheduler);
        CapacitySchedulerConfiguration conf = schedulerContext.getConfiguration();
        boolean overrideWithQueueMappings = conf.getOverrideWithQueueMappings();
        LOG.info("Initialized queue mappings, override: " + overrideWithQueueMappings);
        List<QueueMapping> queueMappings = conf.getQueueMappings();
        ArrayList<QueueMapping> newMappings = new ArrayList<QueueMapping>();
        CapacitySchedulerQueueManager queueManager = schedulerContext.getCapacitySchedulerQueueManager();
        for (QueueMapping mapping : queueMappings) {
            QueuePath queuePath = QueuePlacementRuleUtils.extractQueuePath(mapping.getQueue());
            if (UserGroupMappingPlacementRule.isStaticQueueMapping(mapping)) {
                QueueMapping newMapping;
                CSQueue queue = queueManager.getQueue(mapping.getQueue());
                if (UserGroupMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                    queue = queueManager.getQueue(queuePath.getLeafQueue());
                    if (UserGroupMappingPlacementRule.ifQueueDoesNotExist(queue)) {
                        newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
                        if (newMapping == null) {
                            throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
                        }
                        newMappings.add(newMapping);
                        continue;
                    }
                    newMapping = UserGroupMappingPlacementRule.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                    newMappings.add(newMapping);
                    continue;
                }
                newMapping = UserGroupMappingPlacementRule.validateAndGetQueueMapping(queueManager, queue, mapping, queuePath);
                newMappings.add(newMapping);
                continue;
            }
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping != null) {
                newMappings.add(newMapping);
                continue;
            }
            newMappings.add(mapping);
        }
        if (newMappings.size() > 0) {
            this.mappings = newMappings;
            this.groups = Groups.getUserToGroupsMappingService((Configuration)((CapacityScheduler)scheduler).getConfig());
            this.overrideWithQueueMappings = overrideWithQueueMappings;
            return true;
        }
        return false;
    }

    private static QueueMapping validateAndGetQueueMapping(CapacitySchedulerQueueManager queueManager, CSQueue queue, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (!(queue instanceof LeafQueue)) {
            throw new IOException("mapping contains invalid or non-leaf queue : " + mapping.getQueue());
        }
        if (queue instanceof AutoCreatedLeafQueue && queue.getParent() instanceof ManagedParentQueue) {
            QueueMapping newMapping = UserGroupMappingPlacementRule.validateAndGetAutoCreatedQueueMapping(queueManager, mapping, queuePath);
            if (newMapping == null) {
                throw new IOException("mapping contains invalid or non-leaf queue " + mapping.getQueue());
            }
            return newMapping;
        }
        return mapping;
    }

    private static boolean ifQueueDoesNotExist(CSQueue queue) {
        return queue == null;
    }

    private static QueueMapping validateAndGetAutoCreatedQueueMapping(CapacitySchedulerQueueManager queueManager, QueueMapping mapping, QueuePath queuePath) throws IOException {
        if (queuePath.hasParentQueue()) {
            QueuePlacementRuleUtils.validateQueueMappingUnderParentQueue(queueManager.getQueue(queuePath.getParentQueue()), queuePath.getParentQueue(), queuePath.getLeafQueue());
            return QueueMapping.QueueMappingBuilder.create().type(mapping.getType()).source(mapping.getSource()).queue(queuePath.getLeafQueue()).parentQueue(queuePath.getParentQueue()).build();
        }
        return null;
    }

    private static boolean isStaticQueueMapping(QueueMapping mapping) {
        return !mapping.getQueue().contains(CURRENT_USER_MAPPING) && !mapping.getQueue().contains(PRIMARY_GROUP_MAPPING);
    }

    @VisibleForTesting
    public List<QueueMapping> getQueueMappings() {
        return this.mappings;
    }
}

