/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.NodeAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitiesManager
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(ActivitiesManager.class);
    private ConcurrentMap<NodeId, List<NodeAllocation>> recordingNodesAllocation = new ConcurrentHashMap<NodeId, List<NodeAllocation>>();
    private ConcurrentMap<NodeId, List<NodeAllocation>> completedNodeAllocations = new ConcurrentHashMap<NodeId, List<NodeAllocation>>();
    private Set<NodeId> activeRecordedNodes;
    private ConcurrentMap<ApplicationId, Long> recordingAppActivitiesUntilSpecifiedTime;
    private ConcurrentMap<ApplicationId, AppAllocation> appsAllocation = new ConcurrentHashMap<ApplicationId, AppAllocation>();
    private ConcurrentMap<ApplicationId, List<AppAllocation>> completedAppAllocations = new ConcurrentHashMap<ApplicationId, List<AppAllocation>>();
    private boolean recordNextAvailableNode = false;
    private List<NodeAllocation> lastAvailableNodeActivities = null;
    private Thread cleanUpThread;
    private int timeThreshold = 600000;
    private final RMContext rmContext;
    private volatile boolean stopped;

    public ActivitiesManager(RMContext rmContext) {
        super(ActivitiesManager.class.getName());
        this.activeRecordedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
        this.recordingAppActivitiesUntilSpecifiedTime = new ConcurrentHashMap<ApplicationId, Long>();
        this.rmContext = rmContext;
    }

    public AppActivitiesInfo getAppActivitiesInfo(ApplicationId applicationId) {
        if (((RMApp)this.rmContext.getRMApps().get(applicationId)).getFinalApplicationStatus() == FinalApplicationStatus.UNDEFINED) {
            List allocations = (List)this.completedAppAllocations.get(applicationId);
            return new AppActivitiesInfo(allocations, applicationId);
        }
        return new AppActivitiesInfo("fail to get application activities after finished", applicationId.toString());
    }

    public ActivitiesInfo getActivitiesInfo(String nodeId) {
        List allocations = nodeId == null ? this.lastAvailableNodeActivities : (List)this.completedNodeAllocations.get(NodeId.fromString((String)nodeId));
        return new ActivitiesInfo(allocations, nodeId);
    }

    public void recordNextNodeUpdateActivities(String nodeId) {
        if (nodeId == null) {
            this.recordNextAvailableNode = true;
        } else {
            this.activeRecordedNodes.add(NodeId.fromString((String)nodeId));
        }
    }

    public void turnOnAppActivitiesRecording(ApplicationId applicationId, double maxTime) {
        long startTS = SystemClock.getInstance().getTime();
        long endTS = startTS + (long)(maxTime * 1000.0);
        this.recordingAppActivitiesUntilSpecifiedTime.put(applicationId, endTS);
    }

    protected void serviceStart() throws Exception {
        this.cleanUpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ActivitiesManager.this.stopped && !Thread.currentThread().isInterrupted()) {
                    Iterator ite = ActivitiesManager.this.completedNodeAllocations.entrySet().iterator();
                    while (ite.hasNext()) {
                        Map.Entry nodeAllocation = ite.next();
                        List allocations = (List)nodeAllocation.getValue();
                        long currTS = SystemClock.getInstance().getTime();
                        if (allocations.size() <= 0 || ((NodeAllocation)allocations.get(0)).getTimeStamp() - currTS <= (long)ActivitiesManager.this.timeThreshold) continue;
                        ite.remove();
                    }
                    Iterator iteApp = ActivitiesManager.this.completedAppAllocations.entrySet().iterator();
                    while (iteApp.hasNext()) {
                        Map.Entry appAllocation = iteApp.next();
                        if (((RMApp)ActivitiesManager.this.rmContext.getRMApps().get(appAllocation.getKey())).getFinalApplicationStatus() == FinalApplicationStatus.UNDEFINED) continue;
                        iteApp.remove();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        LOG.info(ActivitiesManager.this.getName() + " thread interrupted");
                        break;
                    }
                }
            }
        });
        this.cleanUpThread.setName("ActivitiesManager thread.");
        this.cleanUpThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.cleanUpThread != null) {
            this.cleanUpThread.interrupt();
            try {
                this.cleanUpThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", (Throwable)ie);
            }
        }
        super.serviceStop();
    }

    void startNodeUpdateRecording(NodeId nodeID) {
        if (this.recordNextAvailableNode) {
            this.recordNextNodeUpdateActivities(nodeID.toString());
        }
        if (this.activeRecordedNodes.contains(nodeID)) {
            ArrayList nodeAllocation = new ArrayList();
            this.recordingNodesAllocation.put(nodeID, nodeAllocation);
        }
    }

    void startAppAllocationRecording(NodeId nodeID, long currTS, SchedulerApplicationAttempt application) {
        ApplicationId applicationId = application.getApplicationId();
        if (this.recordingAppActivitiesUntilSpecifiedTime.containsKey(applicationId) && (Long)this.recordingAppActivitiesUntilSpecifiedTime.get(applicationId) > currTS) {
            this.appsAllocation.put(applicationId, new AppAllocation(application.getPriority(), nodeID, application.getQueueName()));
        }
        if (this.recordingAppActivitiesUntilSpecifiedTime.containsKey(applicationId) && (Long)this.recordingAppActivitiesUntilSpecifiedTime.get(applicationId) <= currTS) {
            this.turnOffActivityMonitoringForApp(applicationId);
        }
    }

    void addSchedulingActivityForNode(SchedulerNode node, String parentName, String childName, String priority, ActivityState state, String diagnostic, String type) {
        if (this.shouldRecordThisNode(node.getNodeID())) {
            NodeAllocation nodeAllocation = this.getCurrentNodeAllocation(node.getNodeID());
            nodeAllocation.addAllocationActivity(parentName, childName, priority, state, diagnostic, type);
        }
    }

    void addSchedulingActivityForApp(ApplicationId applicationId, ContainerId containerId, String priority, ActivityState state, String diagnostic, String type) {
        if (this.shouldRecordThisApp(applicationId)) {
            AppAllocation appAllocation = (AppAllocation)this.appsAllocation.get(applicationId);
            appAllocation.addAppAllocationActivity(containerId == null ? "Container-Id-Not-Assigned" : containerId.toString(), priority, state, diagnostic, type);
        }
    }

    void updateAllocationFinalState(NodeId nodeID, ContainerId containerId, AllocationState containerState) {
        if (this.shouldRecordThisNode(nodeID)) {
            NodeAllocation nodeAllocation = this.getCurrentNodeAllocation(nodeID);
            nodeAllocation.updateContainerState(containerId, containerState);
        }
    }

    void finishAppAllocationRecording(ApplicationId applicationId, ContainerId containerId, ActivityState appState, String diagnostic) {
        if (this.shouldRecordThisApp(applicationId)) {
            List<AppAllocation> appAllocations;
            long currTS = SystemClock.getInstance().getTime();
            AppAllocation appAllocation = (AppAllocation)this.appsAllocation.remove(applicationId);
            appAllocation.updateAppContainerStateAndTime(containerId, appState, currTS, diagnostic);
            if (this.completedAppAllocations.containsKey(applicationId)) {
                appAllocations = (List)this.completedAppAllocations.get(applicationId);
            } else {
                appAllocations = new ArrayList();
                this.completedAppAllocations.put(applicationId, appAllocations);
            }
            if (appAllocations.size() == 1000) {
                appAllocations.remove(0);
            }
            appAllocations.add(appAllocation);
            if ((Long)this.recordingAppActivitiesUntilSpecifiedTime.get(applicationId) <= currTS) {
                this.turnOffActivityMonitoringForApp(applicationId);
            }
        }
    }

    void finishNodeUpdateRecording(NodeId nodeID) {
        List value = (List)this.recordingNodesAllocation.get(nodeID);
        long timeStamp = SystemClock.getInstance().getTime();
        if (value != null) {
            if (value.size() > 0) {
                this.lastAvailableNodeActivities = value;
                for (NodeAllocation allocation : this.lastAvailableNodeActivities) {
                    allocation.transformToTree();
                    allocation.setTimeStamp(timeStamp);
                }
                if (this.recordNextAvailableNode) {
                    this.recordNextAvailableNode = false;
                }
            }
            if (this.shouldRecordThisNode(nodeID)) {
                this.recordingNodesAllocation.remove(nodeID);
                this.completedNodeAllocations.put(nodeID, value);
                this.stopRecordNodeUpdateActivities(nodeID);
            }
        }
    }

    boolean shouldRecordThisApp(ApplicationId applicationId) {
        return this.recordingAppActivitiesUntilSpecifiedTime.containsKey(applicationId) && this.appsAllocation.containsKey(applicationId);
    }

    boolean shouldRecordThisNode(NodeId nodeID) {
        return this.activeRecordedNodes.contains(nodeID) && this.recordingNodesAllocation.containsKey(nodeID);
    }

    private NodeAllocation getCurrentNodeAllocation(NodeId nodeID) {
        NodeAllocation nodeAllocation;
        List nodeAllocations = (List)this.recordingNodesAllocation.get(nodeID);
        if (nodeAllocations.size() != 0) {
            nodeAllocation = (NodeAllocation)nodeAllocations.get(nodeAllocations.size() - 1);
            if (nodeAllocation.getFinalAllocationState() != AllocationState.DEFAULT) {
                nodeAllocation = new NodeAllocation(nodeID);
                nodeAllocations.add(nodeAllocation);
            }
        } else {
            nodeAllocation = new NodeAllocation(nodeID);
            nodeAllocations.add(nodeAllocation);
        }
        return nodeAllocation;
    }

    private void stopRecordNodeUpdateActivities(NodeId nodeId) {
        this.activeRecordedNodes.remove(nodeId);
    }

    private void turnOffActivityMonitoringForApp(ApplicationId applicationId) {
        this.recordingAppActivitiesUntilSpecifiedTime.remove(applicationId);
    }
}

