/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueuePlacementPolicy {
    private static final Map<String, Class<? extends QueuePlacementRule>> ruleClasses;
    private final List<QueuePlacementRule> rules;
    private final Map<FSQueueType, Set<String>> configuredQueues;
    private final Groups groups;

    public QueuePlacementPolicy(List<QueuePlacementRule> rules, Map<FSQueueType, Set<String>> configuredQueues, Configuration conf) throws AllocationConfigurationException {
        for (int i = 0; i < rules.size() - 1; ++i) {
            if (!rules.get(i).isTerminal()) continue;
            throw new AllocationConfigurationException("Rules after rule " + i + " in queue placement policy can never be reached");
        }
        if (!rules.get(rules.size() - 1).isTerminal()) {
            throw new AllocationConfigurationException("Could get past last queue placement rule without assigning");
        }
        this.rules = rules;
        this.configuredQueues = configuredQueues;
        this.groups = Groups.getUserToGroupsMappingService((Configuration)conf);
    }

    public static QueuePlacementPolicy fromXml(Element el, Map<FSQueueType, Set<String>> configuredQueues, Configuration conf) throws AllocationConfigurationException {
        ArrayList<QueuePlacementRule> rules = new ArrayList<QueuePlacementRule>();
        NodeList elements = el.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            QueuePlacementRule rule = QueuePlacementPolicy.createAndInitializeRule(node);
            rules.add(rule);
        }
        return new QueuePlacementPolicy(rules, configuredQueues, conf);
    }

    public static QueuePlacementRule createAndInitializeRule(Node node) throws AllocationConfigurationException {
        Element element = (Element)node;
        String ruleName = element.getAttribute("name");
        if ("".equals(ruleName)) {
            throw new AllocationConfigurationException("No name provided for a rule element");
        }
        Class<? extends QueuePlacementRule> clazz = ruleClasses.get(ruleName);
        if (clazz == null) {
            throw new AllocationConfigurationException("No rule class found for " + ruleName);
        }
        QueuePlacementRule rule = (QueuePlacementRule)ReflectionUtils.newInstance(clazz, null);
        rule.initializeFromXml(element);
        return rule;
    }

    public static QueuePlacementPolicy fromConfiguration(Configuration conf, Map<FSQueueType, Set<String>> configuredQueues) {
        boolean create = conf.getBoolean("yarn.scheduler.fair.allow-undeclared-pools", true);
        boolean userAsDefaultQueue = conf.getBoolean("yarn.scheduler.fair.user-as-default-queue", true);
        ArrayList<QueuePlacementRule> rules = new ArrayList<QueuePlacementRule>();
        rules.add(new QueuePlacementRule.Specified().initialize(create, null));
        if (userAsDefaultQueue) {
            rules.add(new QueuePlacementRule.User().initialize(create, null));
        }
        if (!userAsDefaultQueue || !create) {
            rules.add(new QueuePlacementRule.Default().initialize(true, null));
        }
        try {
            return new QueuePlacementPolicy(rules, configuredQueues, conf);
        }
        catch (AllocationConfigurationException ex) {
            throw new RuntimeException("Should never hit exception when loadingplacement policy from conf", ex);
        }
    }

    public String assignAppToQueue(String requestedQueue, String user) throws IOException {
        for (QueuePlacementRule rule : this.rules) {
            String queue = rule.assignAppToQueue(requestedQueue, user, this.groups, this.configuredQueues);
            if (queue != null && queue.isEmpty()) continue;
            return queue;
        }
        throw new IllegalStateException("Should have applied a rule before reaching here");
    }

    public List<QueuePlacementRule> getRules() {
        return this.rules;
    }

    static {
        HashMap<String, Class<QueuePlacementRule.Reject>> map = new HashMap<String, Class<QueuePlacementRule.Reject>>();
        map.put("user", QueuePlacementRule.User.class);
        map.put("primaryGroup", QueuePlacementRule.PrimaryGroup.class);
        map.put("secondaryGroupExistingQueue", QueuePlacementRule.SecondaryGroupExistingQueue.class);
        map.put("specified", QueuePlacementRule.Specified.class);
        map.put("nestedUserQueue", QueuePlacementRule.NestedUserQueue.class);
        map.put("default", QueuePlacementRule.Default.class);
        map.put("reject", QueuePlacementRule.Reject.class);
        ruleClasses = Collections.unmodifiableMap(map);
    }
}

