/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AppAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivityNodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppAllocationInfo {
    protected String nodeId;
    protected String queueName;
    protected String appPriority;
    protected String allocatedContainerId;
    protected String allocationState;
    protected String diagnostic;
    protected String timeStamp;
    protected List<ActivityNodeInfo> allocationAttempt;
    private static final Logger LOG = LoggerFactory.getLogger(AppAllocationInfo.class);

    AppAllocationInfo() {
    }

    AppAllocationInfo(AppAllocation allocation) {
        this.allocationAttempt = new ArrayList<ActivityNodeInfo>();
        this.nodeId = allocation.getNodeId();
        this.queueName = allocation.getQueueName();
        this.appPriority = allocation.getPriority();
        this.allocatedContainerId = allocation.getContainerId();
        this.allocationState = allocation.getAppState().name();
        this.diagnostic = allocation.getDiagnostic();
        Date date = new Date();
        date.setTime(allocation.getTime());
        this.timeStamp = date.toString();
        for (ActivityNode attempt : allocation.getAllocationAttempts()) {
            ActivityNodeInfo containerInfo = new ActivityNodeInfo(attempt);
            this.allocationAttempt.add(containerInfo);
        }
    }
}

