/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class ClusterMetrics {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Metric(value={"# of active NMs"})
    MutableGaugeInt numActiveNMs;
    @Metric(value={"# of decommissioning NMs"})
    MutableGaugeInt numDecommissioningNMs;
    @Metric(value={"# of decommissioned NMs"})
    MutableGaugeInt numDecommissionedNMs;
    @Metric(value={"# of lost NMs"})
    MutableGaugeInt numLostNMs;
    @Metric(value={"# of unhealthy NMs"})
    MutableGaugeInt numUnhealthyNMs;
    @Metric(value={"# of Rebooted NMs"})
    MutableGaugeInt numRebootedNMs;
    @Metric(value={"# of Shutdown NMs"})
    MutableGaugeInt numShutdownNMs;
    @Metric(value={"AM container launch delay"})
    MutableRate aMLaunchDelay;
    @Metric(value={"AM register delay"})
    MutableRate aMRegisterDelay;
    @Metric(value={"AM container allocation delay"})
    private MutableRate aMContainerAllocationDelay;
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"ClusterMetrics", (String)"Metrics for the Yarn Cluster");
    private static volatile ClusterMetrics INSTANCE = null;
    private static MetricsRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<ClusterMetrics> clazz = ClusterMetrics.class;
        synchronized (ClusterMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ClusterMetrics();
            ClusterMetrics.registerMetrics();
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void registerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "ResourceManager");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register("ClusterMetrics", "Metrics for the Yarn Cluster", (Object)INSTANCE);
        }
    }

    @VisibleForTesting
    static synchronized void destroy() {
        isInitialized.set(false);
        INSTANCE = null;
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs.value();
    }

    public int getNumDecommissioningNMs() {
        return this.numDecommissioningNMs.value();
    }

    public void incrDecommissioningNMs() {
        this.numDecommissioningNMs.incr();
    }

    public void setDecommissioningNMs(int num) {
        this.numDecommissioningNMs.set(num);
    }

    public void decrDecommissioningNMs() {
        this.numDecommissioningNMs.decr();
    }

    public int getNumDecommisionedNMs() {
        return this.numDecommissionedNMs.value();
    }

    public void incrDecommisionedNMs() {
        this.numDecommissionedNMs.incr();
    }

    public void setDecommisionedNMs(int num) {
        this.numDecommissionedNMs.set(num);
    }

    public void decrDecommisionedNMs() {
        this.numDecommissionedNMs.decr();
    }

    public int getNumLostNMs() {
        return this.numLostNMs.value();
    }

    public void incrNumLostNMs() {
        this.numLostNMs.incr();
    }

    public void decrNumLostNMs() {
        this.numLostNMs.decr();
    }

    public int getUnhealthyNMs() {
        return this.numUnhealthyNMs.value();
    }

    public void incrNumUnhealthyNMs() {
        this.numUnhealthyNMs.incr();
    }

    public void decrNumUnhealthyNMs() {
        this.numUnhealthyNMs.decr();
    }

    public int getNumRebootedNMs() {
        return this.numRebootedNMs.value();
    }

    public void incrNumRebootedNMs() {
        this.numRebootedNMs.incr();
    }

    public void decrNumRebootedNMs() {
        this.numRebootedNMs.decr();
    }

    public int getNumShutdownNMs() {
        return this.numShutdownNMs.value();
    }

    public void incrNumShutdownNMs() {
        this.numShutdownNMs.incr();
    }

    public void decrNumShutdownNMs() {
        this.numShutdownNMs.decr();
    }

    public void incrNumActiveNodes() {
        this.numActiveNMs.incr();
    }

    public void decrNumActiveNodes() {
        this.numActiveNMs.decr();
    }

    public void addAMLaunchDelay(long delay) {
        this.aMLaunchDelay.add(delay);
    }

    public void addAMRegisterDelay(long delay) {
        this.aMRegisterDelay.add(delay);
    }

    public void addAMContainerAllocationDelay(long delay) {
        this.aMContainerAllocationDelay.add(delay);
    }

    public MutableRate getAMContainerAllocationDelay() {
        return this.aMContainerAllocationDelay;
    }
}

