/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ConcurrentHashMultiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerUpdatesAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeUpdateContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplicationAttempt
implements SchedulableEntity {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerApplicationAttempt.class);
    private FastDateFormat fdf = FastDateFormat.getInstance((String)"EEE MMM dd HH:mm:ss Z yyyy");
    private static final long MEM_AGGREGATE_ALLOCATION_CACHE_MSECS = 3000L;
    protected long lastMemoryAggregateAllocationUpdateTime = 0L;
    private Map<String, Long> lastResourceSecondsMap = new HashMap<String, Long>();
    protected final AppSchedulingInfo appSchedulingInfo;
    protected ApplicationAttemptId attemptId;
    protected Map<ContainerId, RMContainer> liveContainers = new ConcurrentHashMap<ContainerId, RMContainer>();
    protected final Map<SchedulerRequestKey, Map<NodeId, RMContainer>> reservedContainers = new HashMap<SchedulerRequestKey, Map<NodeId, RMContainer>>();
    private final ConcurrentHashMultiset<SchedulerRequestKey> reReservations = ConcurrentHashMultiset.create();
    private volatile Resource resourceLimit = Resource.newInstance((int)0, (int)0);
    private boolean unmanagedAM = true;
    private boolean amRunning = false;
    private LogAggregationContext logAggregationContext;
    private volatile Priority appPriority = null;
    private boolean isAttemptRecovering;
    protected ResourceUsage attemptResourceUsage = new ResourceUsage();
    protected ResourceUsage attemptOpportunisticResourceUsage = new ResourceUsage();
    protected ResourceUsage attemptResourceUsageAllocatedRemotely = new ResourceUsage();
    private AtomicLong firstAllocationRequestSentTime = new AtomicLong(0L);
    private AtomicLong firstContainerAllocatedTime = new AtomicLong(0L);
    protected List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    protected List<RMContainer> tempContainerToKill = new ArrayList<RMContainer>();
    protected Map<ContainerId, RMContainer> newlyPromotedContainers = new HashMap<ContainerId, RMContainer>();
    protected Map<ContainerId, RMContainer> newlyDemotedContainers = new HashMap<ContainerId, RMContainer>();
    protected Map<ContainerId, RMContainer> newlyDecreasedContainers = new HashMap<ContainerId, RMContainer>();
    protected Map<ContainerId, RMContainer> newlyIncreasedContainers = new HashMap<ContainerId, RMContainer>();
    protected Set<NMToken> updatedNMTokens = new HashSet<NMToken>();
    protected List<UpdateContainerError> updateContainerErrors = new ArrayList<UpdateContainerError>();
    private List<Container> recoveredPreviousAttemptContainers = new ArrayList<Container>();
    private Set<ContainerId> pendingRelease = null;
    private OpportunisticContainerContext oppContainerContext;
    private ConcurrentHashMultiset<SchedulerRequestKey> schedulingOpportunities = ConcurrentHashMultiset.create();
    private ConcurrentHashMultiset<SchedulerRequestKey> missedNonPartitionedReqSchedulingOpportunity = ConcurrentHashMultiset.create();
    protected Map<SchedulerRequestKey, Long> lastScheduledContainer = new ConcurrentHashMap<SchedulerRequestKey, Long>();
    protected volatile Queue queue;
    protected volatile boolean isStopped = false;
    protected String appAMNodePartitionName = "";
    protected final RMContext rmContext;
    private RMAppAttempt appAttempt;
    protected ReentrantReadWriteLock.ReadLock readLock;
    protected ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, String> applicationSchedulingEnvs = new HashMap<String, String>();
    private AtomicLong unconfirmedAllocatedMem = new AtomicLong();
    private AtomicInteger unconfirmedAllocatedVcores = new AtomicInteger();
    private String nodeLabelExpression;
    private final long startTime;

    public SchedulerApplicationAttempt(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext) {
        Preconditions.checkNotNull((Object)rmContext, (Object)"RMContext should not be null");
        this.rmContext = rmContext;
        this.queue = queue;
        this.pendingRelease = Collections.newSetFromMap(new ConcurrentHashMap());
        this.attemptId = applicationAttemptId;
        if (rmContext.getRMApps() != null && rmContext.getRMApps().containsKey(applicationAttemptId.getApplicationId())) {
            RMApp rmApp = (RMApp)rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
            ApplicationSubmissionContext appSubmissionContext = rmApp.getApplicationSubmissionContext();
            this.appAttempt = rmApp.getCurrentAppAttempt();
            if (appSubmissionContext != null) {
                this.unmanagedAM = appSubmissionContext.getUnmanagedAM();
                this.logAggregationContext = appSubmissionContext.getLogAggregationContext();
                this.nodeLabelExpression = appSubmissionContext.getNodeLabelExpression();
            }
            this.applicationSchedulingEnvs = rmApp.getApplicationSchedulingEnvs();
        }
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, abstractUsersManager, rmContext.getEpoch(), this.attemptResourceUsage, this.applicationSchedulingEnvs, rmContext);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.startTime = SystemClock.getInstance().getTime();
    }

    public void setOpportunisticContainerContext(OpportunisticContainerContext oppContext) {
        this.oppContainerContext = oppContext;
    }

    public OpportunisticContainerContext getOpportunisticContainerContext() {
        return this.oppContainerContext;
    }

    public Collection<RMContainer> getLiveContainers() {
        this.readLock.lock();
        try {
            ArrayList<RMContainer> arrayList = new ArrayList<RMContainer>(this.liveContainers.values());
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AppSchedulingInfo getAppSchedulingInfo() {
        return this.appSchedulingInfo;
    }

    public ContainerUpdateContext getUpdateContext() {
        return this.appSchedulingInfo.getUpdateContext();
    }

    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public Set<ContainerId> getPendingRelease() {
        return this.pendingRelease;
    }

    public long getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<SchedulerRequestKey> getSchedulerKeys() {
        return this.appSchedulingInfo.getSchedulerKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PendingAsk getPendingAsk(SchedulerRequestKey schedulerKey, String resourceName) {
        this.readLock.lock();
        try {
            PendingAsk pendingAsk = this.appSchedulingInfo.getPendingAsk(schedulerKey, resourceName);
            return pendingAsk;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOutstandingAsksCount(SchedulerRequestKey schedulerKey) {
        return this.getOutstandingAsksCount(schedulerKey, "*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingAsksCount(SchedulerRequestKey schedulerKey, String resourceName) {
        this.readLock.lock();
        try {
            AppPlacementAllocator ap = this.appSchedulingInfo.getAppPlacementAllocator(schedulerKey);
            int n = ap == null ? 0 : ap.getOutstandingAsksCount(resourceName);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    public Resource getAMResource() {
        return this.attemptResourceUsage.getAMUsed();
    }

    public Resource getAMResource(String label) {
        return this.attemptResourceUsage.getAMUsed(label);
    }

    public void setAMResource(Resource amResource) {
        this.attemptResourceUsage.setAMUsed(amResource);
    }

    public void setAMResource(String label, Resource amResource) {
        this.attemptResourceUsage.setAMUsed(label, amResource);
    }

    public boolean isAmRunning() {
        return this.amRunning;
    }

    public void setAmRunning(boolean bool) {
        this.amRunning = bool;
    }

    public boolean getUnmanagedAM() {
        return this.unmanagedAM;
    }

    public RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    public void addRMContainer(ContainerId id, RMContainer rmContainer) {
        this.writeLock.lock();
        try {
            if (!this.getApplicationAttemptId().equals((Object)rmContainer.getApplicationAttemptId()) && !this.liveContainers.containsKey(id)) {
                LOG.info("recovered container " + id + " from previous attempt " + rmContainer.getApplicationAttemptId());
                this.recoveredPreviousAttemptContainers.add(rmContainer.getContainer());
            }
            this.liveContainers.put(id, rmContainer);
            if (rmContainer.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                this.attemptOpportunisticResourceUsage.incUsed(rmContainer.getAllocatedResource());
            }
            if (rmContainer.isRemotelyAllocated()) {
                this.attemptResourceUsageAllocatedRemotely.incUsed(rmContainer.getAllocatedResource());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeRMContainer(ContainerId containerId) {
        this.writeLock.lock();
        try {
            RMContainer rmContainer = this.liveContainers.remove(containerId);
            if (rmContainer != null) {
                if (rmContainer.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                    this.attemptOpportunisticResourceUsage.decUsed(rmContainer.getAllocatedResource());
                }
                if (rmContainer.isRemotelyAllocated()) {
                    this.attemptResourceUsageAllocatedRemotely.decUsed(rmContainer.getAllocatedResource());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void resetReReservations(SchedulerRequestKey schedulerKey) {
        this.reReservations.setCount((Object)schedulerKey, 0);
    }

    protected void addReReservation(SchedulerRequestKey schedulerKey) {
        try {
            this.reReservations.add((Object)schedulerKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public int getReReservations(SchedulerRequestKey schedulerKey) {
        return this.reReservations.count((Object)schedulerKey);
    }

    @InterfaceStability.Stable
    @InterfaceAudience.Private
    public Resource getCurrentReservation() {
        return this.attemptResourceUsage.getReserved();
    }

    public Queue getQueue() {
        return this.queue;
    }

    public boolean updateResourceRequests(List<ResourceRequest> requests) {
        this.writeLock.lock();
        try {
            if (!this.isStopped) {
                boolean bl = this.appSchedulingInfo.updateResourceRequests(requests, false);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean updateSchedulingRequests(List<SchedulingRequest> requests) {
        if (requests == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            if (!this.isStopped) {
                boolean bl = this.appSchedulingInfo.updateSchedulingRequests(requests, false);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void recoverResourceRequestsForContainer(ContainerRequest containerRequest) {
        this.writeLock.lock();
        try {
            if (!this.isStopped) {
                this.appSchedulingInfo.updateResourceRequests(containerRequest.getResourceRequests(), true);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.writeLock.lock();
        try {
            this.isStopped = true;
            this.appSchedulingInfo.stop();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> list = new ArrayList<RMContainer>();
        this.readLock.lock();
        try {
            for (Map.Entry<SchedulerRequestKey, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
                list.addAll(e.getValue().values());
            }
            ArrayList<RMContainer> arrayList = list;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveIncreasedContainer(SchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer rmContainer, Resource reservedResource) {
        this.writeLock.lock();
        try {
            if (this.commonReserve(node, schedulerKey, rmContainer, reservedResource)) {
                this.attemptResourceUsage.incReserved(node.getPartition(), reservedResource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean commonReserve(SchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer rmContainer, Resource reservedResource) {
        try {
            rmContainer.handle((Event)new RMContainerReservedEvent(rmContainer.getContainerId(), reservedResource, node.getNodeID(), schedulerKey));
        }
        catch (InvalidStateTransitionException e) {
            return false;
        }
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(schedulerKey);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(schedulerKey, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Application attempt " + this.getApplicationAttemptId() + " reserved container " + rmContainer + " on node " + node + ". This attempt currently has " + reservedContainers.size() + " reserved containers at priority " + schedulerKey.getPriority() + "; currentReservation " + reservedResource);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainer reserve(SchedulerNode node, SchedulerRequestKey schedulerKey, RMContainer rmContainer, Container container) {
        this.writeLock.lock();
        try {
            if (rmContainer == null) {
                rmContainer = new RMContainerImpl(container, schedulerKey, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
            }
            if (rmContainer.getState() == RMContainerState.NEW) {
                this.attemptResourceUsage.incReserved(node.getPartition(), container.getResource());
                ResourceScheduler scheduler = this.rmContext.getScheduler();
                String qn = this.getQueueName();
                if (scheduler instanceof CapacityScheduler) {
                    qn = ((CapacityScheduler)scheduler).normalizeQueueName(qn);
                }
                ((RMContainerImpl)rmContainer).setQueueName(qn);
                this.resetReReservations(schedulerKey);
            } else {
                this.addReReservation(schedulerKey);
            }
            this.commonReserve(node, schedulerKey, rmContainer, container.getResource());
            RMContainer rMContainer = rmContainer;
            return rMContainer;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setHeadroom(Resource globalLimit) {
        this.resourceLimit = Resources.componentwiseMax((Resource)globalLimit, (Resource)Resources.none());
    }

    public Resource getHeadroom() {
        return this.resourceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumReservedContainers(SchedulerRequestKey schedulerKey) {
        this.readLock.lock();
        try {
            Map<NodeId, RMContainer> map = this.reservedContainers.get(schedulerKey);
            int n = map == null ? 0 : map.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void containerLaunchedOnNode(ContainerId containerId, NodeId nodeId) {
        this.writeLock.lock();
        try {
            RMContainer rmContainer = this.getRMContainer(containerId);
            if (rmContainer == null) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(nodeId, containerId));
                return;
            }
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showRequests() {
        if (LOG.isDebugEnabled()) {
            this.readLock.lock();
            try {
                for (SchedulerRequestKey schedulerKey : this.getSchedulerKeys()) {
                    AppPlacementAllocator ap = this.getAppPlacementAllocator(schedulerKey);
                    if (ap == null || ap.getOutstandingAsksCount("*") <= 0) continue;
                    LOG.debug("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.attemptResourceUsage.getUsed().getMemorySize());
                    ap.showRequests();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    public Resource getCurrentConsumption() {
        return this.attemptResourceUsage.getUsed();
    }

    private Container updateContainerAndNMToken(RMContainer rmContainer, ContainerUpdateType updateType) {
        Container container = rmContainer.getContainer();
        ContainerType containerType = ContainerType.TASK;
        if (updateType != null) {
            container.setVersion(container.getVersion() + 1);
        }
        if (this.isWaitingForAMContainer()) {
            containerType = ContainerType.APPLICATION_MASTER;
        }
        try {
            container.setContainerToken(this.rmContext.getContainerTokenSecretManager().createContainerToken(container.getId(), container.getVersion(), container.getNodeId(), this.getUser(), container.getResource(), container.getPriority(), rmContainer.getCreationTime(), this.logAggregationContext, rmContainer.getNodeLabelExpression(), containerType, container.getExecutionType(), container.getAllocationRequestId(), rmContainer.getAllocationTags()));
            container.setAllocationTags(rmContainer.getAllocationTags());
            this.updateNMToken(container);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error trying to assign container token and NM token to an updated container " + container.getId(), (Throwable)e);
            return null;
        }
        if (updateType == null) {
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
        } else {
            boolean autoUpdate;
            boolean bl = autoUpdate = ContainerUpdateType.DECREASE_RESOURCE == updateType || ((AbstractYarnScheduler)this.rmContext.getScheduler()).shouldContainersBeAutoUpdated();
            if (autoUpdate) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeUpdateContainerEvent(rmContainer.getNodeId(), Collections.singletonMap(rmContainer.getContainer(), updateType)));
            } else {
                rmContainer.handle((Event)new RMContainerUpdatesAcquiredEvent(rmContainer.getContainerId(), ContainerUpdateType.INCREASE_RESOURCE == updateType));
            }
        }
        return container;
    }

    public void updateNMTokens(Collection<Container> containers) {
        for (Container container : containers) {
            this.updateNMToken(container);
        }
    }

    private void updateNMToken(Container container) {
        NMToken nmToken = this.rmContext.getNMTokenSecretManager().createAndGetNMToken(this.getUser(), this.getApplicationAttemptId(), container);
        if (nmToken != null) {
            this.updatedNMTokens.add(nmToken);
        }
    }

    List<RMContainer> pullContainersToTransfer() {
        this.writeLock.lock();
        try {
            this.recoveredPreviousAttemptContainers.clear();
            ArrayList<RMContainer> arrayList = new ArrayList<RMContainer>(this.liveContainers.values());
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<Container> pullPreviousAttemptContainers() {
        this.writeLock.lock();
        try {
            if (this.recoveredPreviousAttemptContainers.isEmpty()) {
                List<Container> list = null;
                return list;
            }
            ArrayList<Container> returnContainerList = new ArrayList<Container>(this.recoveredPreviousAttemptContainers);
            this.recoveredPreviousAttemptContainers.clear();
            this.updateNMTokens(returnContainerList);
            ArrayList<Container> arrayList = returnContainerList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Container> pullNewlyAllocatedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
            Iterator<RMContainer> i = this.newlyAllocatedContainers.iterator();
            while (i.hasNext()) {
                RMContainer rmContainer = i.next();
                Container updatedContainer = this.updateContainerAndNMToken(rmContainer, null);
                if (updatedContainer == null) continue;
                returnContainerList.add(updatedContainer);
                i.remove();
            }
            ArrayList<Container> arrayList = returnContainerList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized void addToNewlyDemotedContainers(ContainerId containerId, RMContainer rmContainer) {
        this.newlyDemotedContainers.put(containerId, rmContainer);
    }

    public synchronized void addToNewlyDecreasedContainers(ContainerId containerId, RMContainer rmContainer) {
        this.newlyDecreasedContainers.put(containerId, rmContainer);
    }

    protected synchronized void addToUpdateContainerErrors(UpdateContainerError error) {
        this.updateContainerErrors.add(error);
    }

    protected synchronized void addToNewlyAllocatedContainers(SchedulerNode node, RMContainer rmContainer) {
        ContainerId matchedContainerId = this.getUpdateContext().matchContainerToOutstandingIncreaseReq(node, rmContainer.getAllocatedSchedulerKey(), rmContainer);
        if (matchedContainerId != null) {
            if (ContainerUpdateContext.UNDEFINED == matchedContainerId) {
                this.tempContainerToKill.add(rmContainer);
            } else {
                RMContainer existingContainer = this.getRMContainer(matchedContainerId);
                if (existingContainer == null || EnumSet.of(RMContainerState.COMPLETED, RMContainerState.KILLED, RMContainerState.EXPIRED, RMContainerState.RELEASED).contains((Object)existingContainer.getState())) {
                    this.tempContainerToKill.add(rmContainer);
                } else if (ExecutionType.GUARANTEED == existingContainer.getExecutionType()) {
                    this.newlyIncreasedContainers.put(matchedContainerId, rmContainer);
                } else {
                    this.newlyPromotedContainers.put(matchedContainerId, rmContainer);
                }
            }
        } else {
            this.newlyAllocatedContainers.add(rmContainer);
        }
    }

    public List<Container> pullNewlyPromotedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyPromotedContainers, ContainerUpdateType.PROMOTE_EXECUTION_TYPE);
    }

    public List<Container> pullNewlyDemotedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyDemotedContainers, ContainerUpdateType.DEMOTE_EXECUTION_TYPE);
    }

    public List<Container> pullNewlyIncreasedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyIncreasedContainers, ContainerUpdateType.INCREASE_RESOURCE);
    }

    public List<Container> pullNewlyDecreasedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyDecreasedContainers, ContainerUpdateType.DECREASE_RESOURCE);
    }

    public List<UpdateContainerError> pullUpdateContainerErrors() {
        ArrayList<UpdateContainerError> errors = new ArrayList<UpdateContainerError>(this.updateContainerErrors);
        this.updateContainerErrors.clear();
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Container> pullNewlyUpdatedContainers(Map<ContainerId, RMContainer> newlyUpdatedContainers, ContainerUpdateType updateTpe) {
        ArrayList<Container> updatedContainers = new ArrayList<Container>();
        if (this.oppContainerContext == null && (ContainerUpdateType.DEMOTE_EXECUTION_TYPE == updateTpe || ContainerUpdateType.PROMOTE_EXECUTION_TYPE == updateTpe)) {
            return updatedContainers;
        }
        this.writeLock.lock();
        try {
            Iterator<Map.Entry<ContainerId, RMContainer>> i = newlyUpdatedContainers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<ContainerId, RMContainer> entry = i.next();
                ContainerId matchedContainerId = entry.getKey();
                RMContainer tempRMContainer = entry.getValue();
                RMContainer existingRMContainer = this.getRMContainer(matchedContainerId);
                if (existingRMContainer != null) {
                    existingRMContainer = this.getUpdateContext().swapContainer(tempRMContainer, existingRMContainer, updateTpe);
                    this.getUpdateContext().removeFromOutstandingUpdate(tempRMContainer.getAllocatedSchedulerKey(), existingRMContainer.getContainer());
                    Container updatedContainer = this.updateContainerAndNMToken(existingRMContainer, updateTpe);
                    updatedContainers.add(updatedContainer);
                }
                this.tempContainerToKill.add(tempRMContainer);
                i.remove();
            }
            Iterator<RMContainer> tempIter = this.tempContainerToKill.iterator();
            while (tempIter.hasNext()) {
                RMContainer c = tempIter.next();
                ((RMContainerImpl)c).setContainerRequest(null);
                ((AbstractYarnScheduler)this.rmContext.getScheduler()).asyncContainerRelease(c);
                tempIter.remove();
            }
            ArrayList<Container> arrayList = updatedContainers;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<NMToken> pullUpdatedNMTokens() {
        this.writeLock.lock();
        try {
            ArrayList<NMToken> returnList = new ArrayList<NMToken>(this.updatedNMTokens);
            this.updatedNMTokens.clear();
            ArrayList<NMToken> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isWaitingForAMContainer() {
        return !this.unmanagedAM && this.appAttempt.getMasterContainer() == null;
    }

    public void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        this.writeLock.lock();
        try {
            if (!this.isStopped) {
                if (this.isWaitingForAMContainer()) {
                    this.appSchedulingInfo.updatePlacesBlacklistedBySystem(blacklistAdditions, blacklistRemovals);
                } else {
                    this.appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, blacklistRemovals);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaceBlacklisted(String resourceName) {
        this.readLock.lock();
        try {
            boolean forAMContainer = this.isWaitingForAMContainer();
            boolean bl = this.appSchedulingInfo.isPlaceBlacklisted(resourceName, forAMContainer);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int addMissedNonPartitionedRequestSchedulingOpportunity(SchedulerRequestKey schedulerKey) {
        try {
            return this.missedNonPartitionedReqSchedulingOpportunity.add((Object)schedulerKey, 1) + 1;
        }
        catch (IllegalArgumentException e) {
            return Integer.MAX_VALUE;
        }
    }

    public void resetMissedNonPartitionedRequestSchedulingOpportunity(SchedulerRequestKey schedulerKey) {
        this.missedNonPartitionedReqSchedulingOpportunity.setCount((Object)schedulerKey, 0);
    }

    public void addSchedulingOpportunity(SchedulerRequestKey schedulerKey) {
        try {
            this.schedulingOpportunities.add((Object)schedulerKey, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void subtractSchedulingOpportunity(SchedulerRequestKey schedulerKey) {
        this.schedulingOpportunities.removeExactly((Object)schedulerKey, 1);
    }

    public int getSchedulingOpportunities(SchedulerRequestKey schedulerKey) {
        return this.schedulingOpportunities.count((Object)schedulerKey);
    }

    public void resetSchedulingOpportunities(SchedulerRequestKey schedulerKey) {
        this.resetSchedulingOpportunities(schedulerKey, System.currentTimeMillis());
    }

    public void resetSchedulingOpportunities(SchedulerRequestKey schedulerKey, long currentTimeMs) {
        this.lastScheduledContainer.put(schedulerKey, currentTimeMs);
        this.schedulingOpportunities.setCount((Object)schedulerKey, 0);
    }

    @VisibleForTesting
    void setSchedulingOpportunities(SchedulerRequestKey schedulerKey, int count) {
        this.schedulingOpportunities.setCount((Object)schedulerKey, count);
    }

    private AggregateAppResourceUsage getRunningAggregateAppResourceUsage() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastMemoryAggregateAllocationUpdateTime > 3000L) {
            HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
            for (RMContainer rmContainer : this.liveContainers.values()) {
                long usedMillis = currentTimeMillis - rmContainer.getCreationTime();
                Resource resource = rmContainer.getContainer().getResource();
                for (ResourceInformation entry : resource.getResources()) {
                    long value = RMServerUtils.getOrDefault(resourceSecondsMap, entry.getName(), 0L);
                    resourceSecondsMap.put(entry.getName(), value += entry.getValue() * usedMillis / 1000L);
                }
            }
            this.lastMemoryAggregateAllocationUpdateTime = currentTimeMillis;
            this.lastResourceSecondsMap = resourceSecondsMap;
        }
        return new AggregateAppResourceUsage(this.lastResourceSecondsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationResourceUsageReport getResourceUsageReport() {
        this.writeLock.lock();
        try {
            AggregateAppResourceUsage runningResourceUsage = this.getRunningAggregateAppResourceUsage();
            Resource usedResourceClone = Resources.clone((Resource)this.attemptResourceUsage.getAllUsed());
            Resource reservedResourceClone = Resources.clone((Resource)this.attemptResourceUsage.getReserved());
            Resource cluster = this.rmContext.getScheduler().getClusterResource();
            ResourceCalculator calc = this.rmContext.getScheduler().getResourceCalculator();
            HashMap<String, Long> preemptedResourceSecondsMaps = new HashMap<String, Long>();
            preemptedResourceSecondsMaps.put(ResourceInformation.MEMORY_MB.getName(), 0L);
            preemptedResourceSecondsMaps.put(ResourceInformation.VCORES.getName(), 0L);
            float queueUsagePerc = 0.0f;
            float clusterUsagePerc = 0.0f;
            if (!calc.isInvalidDivisor(cluster)) {
                float queueCapacityPerc = this.queue.getQueueInfo(false, false).getCapacity();
                queueUsagePerc = calc.divide(cluster, usedResourceClone, Resources.multiply((Resource)cluster, (double)queueCapacityPerc)) * 100.0f;
                if (Float.isNaN(queueUsagePerc) || Float.isInfinite(queueUsagePerc)) {
                    queueUsagePerc = 0.0f;
                }
                clusterUsagePerc = calc.divide(cluster, usedResourceClone, cluster) * 100.0f;
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = ApplicationResourceUsageReport.newInstance((int)this.liveContainers.size(), (int)this.reservedContainers.size(), (Resource)usedResourceClone, (Resource)reservedResourceClone, (Resource)Resources.add((Resource)usedResourceClone, (Resource)reservedResourceClone), runningResourceUsage.getResourceUsageSecondsMap(), (float)queueUsagePerc, (float)clusterUsagePerc, preemptedResourceSecondsMaps);
            return applicationResourceUsageReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public Map<ContainerId, RMContainer> getLiveContainersMap() {
        return this.liveContainers;
    }

    public Map<SchedulerRequestKey, Long> getLastScheduledContainer() {
        return this.lastScheduledContainer;
    }

    public void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        this.writeLock.lock();
        try {
            this.liveContainers = appAttempt.getLiveContainersMap();
            this.attemptResourceUsage.copyAllUsed(appAttempt.attemptResourceUsage);
            this.setHeadroom(appAttempt.resourceLimit);
            this.lastScheduledContainer = appAttempt.getLastScheduledContainer();
            this.appSchedulingInfo.transferStateFromPreviousAppSchedulingInfo(appAttempt.appSchedulingInfo);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Queue newQueue) {
        this.writeLock.lock();
        try {
            QueueMetrics oldMetrics = this.queue.getMetrics();
            QueueMetrics newMetrics = newQueue.getMetrics();
            String newQueueName = newQueue instanceof CSQueue ? ((CSQueue)newQueue).getQueuePath() : newQueue.getQueueName();
            String user = this.getUser();
            for (RMContainer rMContainer : this.liveContainers.values()) {
                Resource resource = rMContainer.getContainer().getResource();
                ((RMContainerImpl)rMContainer).setQueueName(newQueueName);
                oldMetrics.releaseResources(rMContainer.getNodeLabelExpression(), user, 1, resource);
                newMetrics.allocateResources(rMContainer.getNodeLabelExpression(), user, 1, resource, false);
            }
            for (Map map : this.reservedContainers.values()) {
                for (RMContainer reservedContainer : map.values()) {
                    ((RMContainerImpl)reservedContainer).setQueueName(newQueueName);
                    Resource resource = reservedContainer.getReservedResource();
                    oldMetrics.unreserveResource(reservedContainer.getNodeLabelExpression(), user, resource);
                    newMetrics.reserveResource(reservedContainer.getNodeLabelExpression(), user, resource);
                }
            }
            if (!this.isStopped) {
                this.appSchedulingInfo.move(newQueue);
            }
            this.queue = newQueue;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void recoverContainer(SchedulerNode node, RMContainer rmContainer) {
        this.writeLock.lock();
        try {
            this.appSchedulingInfo.recoverContainer(rmContainer, node.getPartition());
            if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
                return;
            }
            LOG.info("SchedulerAttempt " + this.getApplicationAttemptId() + " is recovering container " + rmContainer.getContainerId());
            this.addRMContainer(rmContainer.getContainerId(), rmContainer);
            if (rmContainer.getExecutionType() == ExecutionType.GUARANTEED) {
                this.attemptResourceUsage.incUsed(node.getPartition(), rmContainer.getContainer().getResource());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void incNumAllocatedContainers(NodeType containerType, NodeType requestType) {
        RMAppAttempt attempt;
        if (containerType == null || requestType == null) {
            return;
        }
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId());
        if (app != null && (attempt = app.getCurrentAppAttempt()) != null) {
            attempt.getRMAppAttemptMetrics().incNumAllocatedContainers(containerType, requestType);
        }
    }

    public void setApplicationHeadroomForMetrics(Resource headroom) {
        RMAppAttempt attempt = ((RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
        if (attempt != null) {
            attempt.getRMAppAttemptMetrics().setApplicationAttemptHeadRoom(Resources.clone((Resource)headroom));
        }
    }

    public void recordContainerRequestTime(long value) {
        this.firstAllocationRequestSentTime.compareAndSet(0L, value);
    }

    public void recordContainerAllocationTime(long value) {
        long timediff;
        if (this.firstContainerAllocatedTime.compareAndSet(0L, value) && (timediff = this.firstContainerAllocatedTime.longValue() - this.firstAllocationRequestSentTime.longValue()) > 0L) {
            this.queue.getMetrics().addAppAttemptFirstContainerAllocationDelay(timediff);
        }
    }

    public Set<String> getBlacklistedNodes() {
        return this.appSchedulingInfo.getBlackListCopy();
    }

    @InterfaceAudience.Private
    public boolean hasPendingResourceRequest(String nodePartition, SchedulingMode schedulingMode) {
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            nodePartition = "";
        }
        Resource pending = this.attemptResourceUsage.getPending(nodePartition);
        if (StringUtils.equals((CharSequence)nodePartition, (CharSequence)"")) {
            pending = Resources.subtractNonNegative((Resource)pending, (Resource)Resources.createResource((long)this.unconfirmedAllocatedMem.get(), (int)this.unconfirmedAllocatedVcores.get()));
        }
        return !Resources.isNone((Resource)pending);
    }

    @VisibleForTesting
    public ResourceUsage getAppAttemptResourceUsage() {
        return this.attemptResourceUsage;
    }

    @Override
    public Priority getPriority() {
        return this.appPriority;
    }

    public void setPriority(Priority appPriority) {
        this.appPriority = appPriority;
    }

    @Override
    public String getId() {
        return this.getApplicationId().toString();
    }

    @Override
    public int compareInputOrderTo(SchedulableEntity other) {
        if (other instanceof SchedulerApplicationAttempt) {
            return this.getApplicationId().compareTo(((SchedulerApplicationAttempt)other).getApplicationId());
        }
        return 1;
    }

    @Override
    public ResourceUsage getSchedulingResourceUsage() {
        return this.attemptResourceUsage;
    }

    public void setAppAMNodePartitionName(String partitionName) {
        this.appAMNodePartitionName = partitionName;
    }

    public String getAppAMNodePartitionName() {
        return this.appAMNodePartitionName;
    }

    public void updateAMContainerDiagnostics(AMState state, String diagnosticMessage) {
        if (!this.isWaitingForAMContainer()) {
            return;
        }
        StringBuilder diagnosticMessageBldr = new StringBuilder();
        diagnosticMessageBldr.append("[").append(this.fdf.format(System.currentTimeMillis())).append("] ");
        switch (state) {
            case INACTIVATED: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
                if (diagnosticMessage != null) {
                    diagnosticMessageBldr.append(diagnosticMessage);
                }
                this.getPendingAppDiagnosticMessage(diagnosticMessageBldr);
                break;
            }
            case ACTIVATED: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
                if (diagnosticMessage != null) {
                    diagnosticMessageBldr.append(diagnosticMessage);
                }
                this.getActivedAppDiagnosticMessage(diagnosticMessageBldr);
                break;
            }
            default: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
            }
        }
        this.appAttempt.updateAMLaunchDiagnostics(diagnosticMessageBldr.toString());
    }

    protected void getPendingAppDiagnosticMessage(StringBuilder diagnosticMessage) {
    }

    protected void getActivedAppDiagnosticMessage(StringBuilder diagnosticMessage) {
    }

    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean isRecovering() {
        return this.isAttemptRecovering;
    }

    protected void setAttemptRecovering(boolean isRecovering) {
        this.isAttemptRecovering = isRecovering;
    }

    public <N extends SchedulerNode> AppPlacementAllocator<N> getAppPlacementAllocator(SchedulerRequestKey schedulerRequestKey) {
        return this.appSchedulingInfo.getAppPlacementAllocator(schedulerRequestKey);
    }

    public void incUnconfirmedRes(Resource res) {
        this.unconfirmedAllocatedMem.addAndGet(res.getMemorySize());
        this.unconfirmedAllocatedVcores.addAndGet(res.getVirtualCores());
    }

    public void decUnconfirmedRes(Resource res) {
        this.unconfirmedAllocatedMem.addAndGet(-res.getMemorySize());
        this.unconfirmedAllocatedVcores.addAndGet(-res.getVirtualCores());
    }

    public int hashCode() {
        return this.getApplicationAttemptId().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SchedulerApplicationAttempt)) {
            return false;
        }
        SchedulerApplicationAttempt other = (SchedulerApplicationAttempt)o;
        return this == other || this.getApplicationAttemptId().equals((Object)other.getApplicationAttemptId());
    }

    public Map<String, String> getApplicationSchedulingEnvs() {
        return this.applicationSchedulingEnvs;
    }

    @Override
    public String getPartition() {
        return this.nodeLabelExpression == null ? "" : this.nodeLabelExpression;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public static enum AMState {
        UNMANAGED("User launched the Application Master, since it's unmanaged. "),
        INACTIVATED("Application is added to the scheduler and is not yet activated. "),
        ACTIVATED("Application is Activated, waiting for resources to be assigned for AM. "),
        ASSIGNED("Scheduler has assigned a container for AM, waiting for AM container to be launched"),
        LAUNCHED("AM container is launched, waiting for AM container to Register with RM");

        private String diagnosticMessage;

        private AMState(String diagnosticMessage) {
            this.diagnosticMessage = diagnosticMessage;
        }

        public String getDiagnosticMessage() {
            return this.diagnosticMessage;
        }
    }
}

