/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigArgumentHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.PreconditionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.slf4j.Logger;

public class ConversionOptions {
    private DryRunResultHolder dryRunResultHolder;
    private boolean dryRun;
    private boolean noTerminalRuleCheck;

    public ConversionOptions(DryRunResultHolder dryRunResultHolder, boolean dryRun) {
        this.dryRunResultHolder = dryRunResultHolder;
        this.dryRun = dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setNoTerminalRuleCheck(boolean ruleTerminalCheck) {
        this.noTerminalRuleCheck = ruleTerminalCheck;
    }

    public boolean isNoRuleTerminalCheck() {
        return this.noTerminalRuleCheck;
    }

    public void handleWarning(String msg, Logger log) {
        if (this.dryRun) {
            this.dryRunResultHolder.addDryRunWarning(msg);
        } else {
            log.warn(msg);
        }
    }

    public void handleError(String msg) {
        if (!this.dryRun) {
            throw new UnsupportedPropertyException(msg);
        }
        this.dryRunResultHolder.addDryRunError(msg);
    }

    public void handleConversionError(String msg) {
        if (!this.dryRun) {
            throw new ConversionException(msg);
        }
        this.dryRunResultHolder.addDryRunError(msg);
    }

    public void handlePreconditionError(String msg) {
        if (!this.dryRun) {
            throw new PreconditionException(msg);
        }
        this.dryRunResultHolder.addDryRunError(msg);
    }

    public void handleVerificationFailure(Throwable e, String msg) {
        FSConfigToCSConfigArgumentHandler.logAndStdErr(e, msg);
        if (this.dryRun) {
            this.dryRunResultHolder.setVerificationFailed();
        }
    }

    public void handleParsingFinished() {
        if (this.dryRun) {
            this.dryRunResultHolder.printDryRunResults();
        }
    }

    public void handleGenericException(Exception e, String msg) {
        if (this.dryRun) {
            this.dryRunResultHolder.addDryRunError(msg);
        } else {
            FSConfigToCSConfigArgumentHandler.logAndStdErr(e, msg);
        }
    }
}

